/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** PLKEYS.CC: This file is part of the BETATRON library and can be used
 **            and/or distributed only under the terms of the GNU Library
 **            General Public License. See doc/readme.1st for details.
 */



#include <dos.h>
#include <mem.h>
#include <go32.h>
#include "pldpmi.h"
#include <dpmi.h>
#include <string.h>
#include <time.h>

unsigned char volatile pl_KeysPressed[16]; // 128 bit poia pliktra einai patimena
static char keysinstalled = 0;

static __dpmi_paddr  oldint09;
extern "C" pl_int09handler();
extern "C" pl_int09handler_end();
extern "C" pl_keycondition();
extern "C" pl_int09handler_save_ds();



char pl_testkey(unsigned char makecode)
{
  unsigned char mdiv8,mmod8;

  mdiv8=makecode >> 3;
  mmod8=makecode & 7;
  return ( pl_KeysPressed[mdiv8] & (1<<mmod8) );
}


char pl_installkeys()
{
 __dpmi_paddr newint09;
 short dataseg;
 short alias_cs;
 short cs_sel,ds_sel;

 if (keysinstalled) return 0;

 // etoimasou na grapseis ton ds sto code segment tou handler

 dataseg=_go32_my_ds();
 if ( (alias_cs=__dpmi_create_alias_descriptor(_go32_my_cs())) == -1) return 0;
 movedata(dataseg,(long)&dataseg,alias_cs,(long)&pl_int09handler_save_ds,2);
 __dpmi_free_ldt_descriptor(alias_cs);

 //
 __dpmi_get_protected_mode_interrupt_vector(9,&oldint09);
 newint09.selector=_go32_my_cs();
 newint09.offset32=(long)pl_int09handler;

 asm("cli");
 if (__dpmi_set_protected_mode_interrupt_vector(9,&newint09) != 0)
 {
   asm("sti");
   return 0;
 }
 memset((void *)pl_KeysPressed,0,16);

 ds_sel=_go32_my_ds();
 cs_sel=_go32_my_cs();

 lock_region(ds_sel,(void *)pl_KeysPressed,16);
 lock_region(ds_sel,(void *)pl_keycondition,1);
 lock_region(cs_sel,(void *)pl_int09handler_save_ds,(long)pl_int09handler_end-(long)pl_int09handler_save_ds);

 asm("sti");
 keysinstalled=1;
 return 1;
}


char pl_keysdone()
{
  short cs_sel,ds_sel;

 if (!keysinstalled) return 0;

 asm("cli");
 ds_sel=_go32_my_ds();
 cs_sel=_go32_my_cs();

 unlock_region(ds_sel,(void *)pl_KeysPressed,16);
 unlock_region(ds_sel,(void *)pl_keycondition,1);
 unlock_region(cs_sel,(void *)pl_int09handler_save_ds,(long)pl_int09handler_end-(long)pl_int09handler_save_ds);

 if (__dpmi_set_protected_mode_interrupt_vector(9,&oldint09) != 0)
 {
  asm("sti");
  return 0;
 }

 keysinstalled=0;
 asm("sti");
 return 1;
}









