#ifndef disk_pane_header
#define disk_pane_header

#include "listpane.h"


#define PATH_LENGTH 1024
#define DIRSLASH '\\'
#define DEFAULT_PATH_COLOUR  white_bg + black_fg


class disk_pane : public screen_pane
{
public:
disk_pane();

int take_control();
int process_key( int keystroke );
int process_mouse();

int   cd( const char * new_dir );
String get_item( int index = cursor_location );
String path();

void   set_file_mask( const char * wildcard );
void   set_path_colour( char colour );

void resize( int new_width, int new_height );
void refresh();

screen_pane label;
list_pane   directory;

private:
void list_drives();
void get_file_list();
void update_directory_name();

bool   _looking_at_drive_list;
char   _path_colour;
String _file_mask;
String _path;
};

string_array get_file_list( const char * file_mask );

string_array available_drives();

bool drive_present( char drive_letter );
bool disk_ready( char drive_letter = '!' );

bool floppy( char drive_letter );
bool floppy_drive_present( char drive_letter );
bool floppy_disk_ready( char drive_letter );
int  number_of_floppy_drives();

bool is_a_file( const char * candidate );
bool is_root_directory( const char * dir_name );

String full_path( const char * file_name );
String current_directory();

#endif
