/*
 *    Chipset-specific SVGA video drivers for the Allegro library.
 *
 *    See vdrv.txt for copyright information.
 *
 *    This file contains some definitions intended for internal use only.
 */


#ifndef VINTERN_H
#define VINTERN_H


#include <stdlib.h>
#include <stdio.h>
#include <go32.h>
#include <sys/movedata.h>
#include <sys/farptr.h>

#include "vdrv.h"
#include "internal.h"


/* video mode description structure */
typedef struct _GFX_MODE_INFO
{
   int w, h;
   int bpp;
   int bios_num;
   int bios_int;
   int (*setter)(int w, int h, int bpp);
} _GFX_MODE_INFO;


/* helper routines */
BITMAP *_gfx_mode_set_helper(int w, int h, int v_w, int v_h, int color_depth, GFX_DRIVER *driver, int (*detect)(), _GFX_MODE_INFO *mode_list, void (*set_width)(int w, int bpp), int align);

void _vdrv_exit(BITMAP *b);

int _test_vga_register(int port, int index, int mask);
int _test_register(int port, int mask);

long _vesa_vidmem_check(long mem);


/* bank switching functions */
void _ati_bank();
void _ati_bank_end();

void _mach64_write_bank();
void _mach64_write_bank_end();
void _mach64_read_bank();
void _mach64_read_bank_end();

void _cirrus64_write_bank();
void _cirrus64_write_bank_end();
void _cirrus64_read_bank();
void _cirrus64_read_bank_end();

void _cirrus54_bank();
void _cirrus54_bank_end();

void _paradise_write_bank();
void _paradise_read_bank();
void _paradise_write_bank_end();
void _paradise_read_bank_end();

void _s3_bank();
void _s3_bank_end();

void _trident_bank();
void _trident_bank_end();
void _trident_read_bank();
void _trident_read_bank_end();
void _trident_write_bank();
void _trident_write_bank_end();

void _et3000_write_bank();
void _et3000_write_bank_end();
void _et3000_read_bank();
void _et3000_read_bank_end();

void _et4000_write_bank();
void _et4000_write_bank_end();
void _et4000_read_bank();
void _et4000_read_bank_end();

void _video7_bank();
void _video7_bank_end();


#endif          /* ifndef VINTERN_H */
