/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for starting up salad and things like that.

*/
#ifndef s_global_c
#define s_global_c

#include "s_global.h"

//#include "s_intern.h"
#include "s_defs.h"
#include "s_timer.h"

void (*exitfail)(uchar *message)=salad_exitfail;

uchar *salad_id="Salad " salad_version_string ", by Sven Sandberg, "
 salad_date_string;

int salad_inited=FALSE;



/************************
****                 ****
**** The Salad Timer ****
****                 ****
*************************
This must be here since it is locked by salad_init that is in this file.
*/
volatile int salad_timecount=0;
int salad_timeincrease=1;
void salad_timecallback(void)
{
salad_timecount+=salad_timeincrease;
}
END_OF_FUNCTION(salad_timecallback);





/***********************
****                ****
**** salad_exitfail ****
****                ****
************************
Exits the program and prints a message.*/
void salad_exitfail(uchar *message)
{
char *salad_exitfail_message="\n\rERROR (Printed by salad_exitfail()):\n\r";
allegro_exit();
if(message)
	message=mergestrs_new(salad_exitfail_message,message,
	 "\n\r\n\rError according to system",NULL);
else
	message=salad_exitfail_message;
perror(message);
exit(1);
}


void salad_atexit(void)
{
salad_exit();
}


int salad_init(void)
{
//Install the parts of Allegro that Salad uses.
/*
if(!allegro_inited)
	allegro_init();
if(!timer_installed)
	install_timer();
if(!keyboard_installed)
	install_keyboard();
*/

//Lock my counter, and then start it.
LOCK_FUNCTION(salad_timecallback);
LOCK_VARIABLE(salad_timecount);
LOCK_VARIABLE(salad_timeincrease);
if(i_love_bill)
	salad_timeincrease=5;
else
	salad_timeincrease=1;
salad_timecount=0;
install_int(salad_timecallback,salad_timeincrease);
//Finished!
atexit(salad_atexit);
salad_inited=TRUE;
return 0;
}

int salad_exit(void)
{
salad_inited=FALSE;
return 0;
}

#endif
