/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains some graphics routines.

*/
#ifndef s_gfx_h
#define s_gfx_h

#include "s_defs.h"
#include "s_math.h"
#include "s_rect.h"

//Allegro doesn't declare this external, so I have to do that.
extern BITMAP *_mouse_screen;

//Easier ways to blit.
extern void easy_blit(BITMAP *so,BITMAP *de);
extern void topcenter_blit(BITMAP *so,BITMAP *de);
extern void center_blit(BITMAP *so,BITMAP *de);
extern void position_blit(BITMAP *so,BITMAP *de,int x,int y);
#define _easyblit(so,de)      (blit((so),(de),0,0,0,0,((BITMAP*)(so))->w,((BITMAP*)(so))->h))
#define _topcenterblit(so,de) ( (de)==(screen) ? blit((so),(de),0,0,d2(SCREEN_W - ((BITMAP*)(so))->h),0,((BITMAP*)(so))->w,((BITMAP*)(so))->h)   :   blit((so),(de),0,0,d2(((BITMAP*)(de))->w - ((BITMAP*)(so))->h),0,((BITMAP*)(so))->w,((BITMAP*)(so))->h) )
#define _topcentreblit(so,de) (_topcenterblit(so,de))
#define _centerblit(so,de)    ( (de)==(screen) ? blit((so),(de),0,0,d2(SCREEN_W - ((BITMAP*)(so))->w),d2(SCREEN_H - ((BITMAP*)(so))->h ),((BITMAP*)(so))->w,((BITMAP*)(so))->h)   :   blit((so),(de),0,0,d2( ((BITMAP*)(de))->w - ((BITMAP*)(so))->w ),d2( ((BITMAP*)(de))->h - ((BITMAP*)(so))->h ),((BITMAP*)(so))->w,((BITMAP*)(so))->h) )
#define _centreblit(so,de)    (_centerblit(so,de))
#define topcentreblit(so,de)  (topcenterblit(so,de))
#define centreblit(so,de)     (centerblit(so,de))

extern void blit_rearrange(BITMAP *so,BITMAP *de,int x,int y,uchar *map);

//Width and height of bitmaps.
//#define bmpw(bmp)              (is_screen_bitmap(bmp) ? (is_sub_bitmap(bmp) ? (bmp)->w : SCREEN_W) : (bmp)->w)
//#define bmph(bmp)              (is_screen_bitmap(bmp) ? (is_sub_bitmap(bmp) ? (bmp)->h : SCREEN_H) : (bmp)->h)
//Selecting graphics mode.
#define gfxmode(w,h)          (set_gfx_mode(GFX_AUTODETECT,w,h,0,0))
//Compare rgb values.
#define _cmprgb(c1,c2)        ( ((c1).r == (c2).r) && ((c1).g == (c2).g) && ((c1).b == (c2).b) )
extern int cmprgb(RGB c1,RGB c2);
//Checking wether you could use _getpixel or _putpixel on the bitmap.
#define _is_fast_bitmap(bmp)  (is_memory_bitmap(bmp) && (bitmap_color_depth(bmp)==8))
extern int is_fast_bitmap(BITMAP *bmp);

/* Some color constants.
*/
extern RGB
	black,      white,
	greyxdark,  greydark,   grey,    greylight,  greyxlight,
	browndark,  brown,      brownlight,
	violetdark, violet,     violetlight,
	bluedark,   blue,       bluelight,
	cyandark,   cyan,       cyanlight,
	greendark,  green,      greenlight,
	yellowdark, yellow,     yellowlight,
	orangedark, orange,     orangelight,
	reddark,    red,        redlight;
#define grayxdark    greydark
#define graydark     greydark
#define gray         grey
#define graylight    greylight
#define grayxlight   greyxlight

/* Allegro's drawing functions with relative coordinates instead of absolute.
*/
extern void rel_vline(BITMAP *bmp, int x, int y, int h, int color);
extern void rel_hline(BITMAP *bmp, int x, int y, int w, int color);
extern void rel_do_line(BITMAP *bmp, int x, int y, int w, int h, int d, void (*proc)());
extern void rel_line(BITMAP *bmp, int x, int y, int w, int h, int color);
extern void rel_triangle(BITMAP *bmp, int x1, int y1, int x2, int y2, int x3, int y3, int color);
extern void rel_polygon(BITMAP *bmp, int vertices, int *points, int color);
extern void rel_rect(BITMAP *bmp, int x, int y, int w, int h, int color);
extern void rel_rectfill(BITMAP *bmp, int x, int y, int w, int h, int color);
/* Drawing with TRECTs and TPOINTs.
*/
#define _trect_rectfill(bmp,r,color)      (rectfill((bmp),(r).x,(r).y,(r).x+(r).w-1,(r).y+(r).h-1,(color)))
#define _trect_rect(bmp,r,color)          (rect    ((bmp),(r).x,(r).y,(r).x+(r).w-1,(r).y+(r).h-1,(color)))
#define _trect_line(bmp,r,color)          (line    ((bmp),(r).x,(r).y,(r).x+(r).w-1,(r).y+(r).h-1,(color)))
#define _trect_doline(bmp,r,color,proc)   (do_line ((bmp),(r).x,(r).y,(r).x+(r).w-1,(r).y+(r).h-1,(color),(proc)))
extern void trect_rectfill(BITMAP *bmp, TRECT r, int color);
extern void trect_rect(BITMAP *bmp, TRECT r, int color);
extern void trect_line(BITMAP *bmp, TRECT r, int color);
extern void trect_doline(BITMAP *bmp, TRECT r, int color, void (*proc)());

#define skip1600x1200      (16)
#define skip1024x768       (8)
#define skip800x600        (4)
#define skip640x480        (2)
#define skip320x240        (1)
extern ulonglong skip_gfx_modes;
/* Finds the biggest screen mode with square formed pixels that is available.
*/
extern int find_gfx_mode(void);
/* Sets the smallest screen mode that is bigger than or equal to w,h.
*/
extern int find_gfx_mode_size(int w, int h);

/* Converts to black and white.
*/
extern BITMAP *bmp_bw_color(BITMAP *bmp,PALETTE pal,RGB palcolor,
 uchar startindex,uchar numcolors);
#define bmp_bw(bmp,pal,startindex,numcolors) make_bw_color((bmp),(pal),black,(startindex),(numcolors))

/* Returns a newly allocated copy of a bitmap.
*/
extern BITMAP *bitmap_dup(BITMAP *bmp);



/* Rectangles with custom thickness and individual border colors.
*/
extern void rect_extended(BITMAP *bmp,TRECT r,int thickness,
 int topc,int bottomc,int leftc,int rightc);
extern void fillrect_extended(BITMAP *bmp,TRECT r,int thickness,
 int fillc,int topc,int bottomc,int leftc,int rightc);
extern inline void bevel(BITMAP *bmp,TRECT r,int thickness,int light,int shadow);
extern inline void fillbevel(BITMAP *bmp,TRECT r,int thickness,int fillc,int light,int shadow);
extern void doublebevel(BITMAP *bmp,TRECT r,int thickness,int light,int shadow);
//Buttons that look like those in windows, but a little better.
extern void draw_empty_button_frame(BITMAP *bmp,TRECT r,
 int face,int xlight,int light,int dark,int xdark);
#define  draw_empty_button_frame_down(bmp,r,face,xlight,light,dark,xdark)  (draw_empty_button_frame(bmp,r,face,xdark,dark,light,xlight))
extern void draw_empty_button(BITMAP *bmp,TRECT r,
 int face,int xlight,int light,int dark,int xdark);
#define        draw_empty_button_down(bmp,r,face,xlight,light,dark,xdark)        (draw_empty_button(bmp,r,face,xdark,dark,light,xlight))
extern void draw_text_button(BITMAP *bmp,TRECT r, int face, int textcolor,
 int xlight,int light, int dark,int xdark,FONT *f, uchar *text);
extern void draw_text_button_down(BITMAP *bmp,TRECT r, int face, int textcolor,
 int xlight,int light, int dark,int xdark,FONT *f, uchar *text);

extern void draw_picture_button(BITMAP *bmp,TRECT r, int face,
 int xlight,int light, int dark,int xdark,BITMAP *sprite);
extern void draw_picture_button_down(BITMAP *bmp,TRECT r, int face,
 int xlight,int light, int dark,int xdark,BITMAP *sprite);


/* Functions that store some things before you do drawing and reset them
	after it. If you use these functions, you can safely change clipping and
	text mode, and the mouse will be hidden if needed so that you can draw
	anywhere on the bitmap.
*/
extern void before_draw(BITMAP *bmp,TRECT area);
extern void after_draw(void);


extern void draw_sphere(BITMAP *bmp,
 int sphere_x,int sphere_y,int sphere_radius,
 int light_x,int light_y,int light_z,
 int first_color_index,int last_color_index,int darkness_color);

#endif
