/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains miscellaneous functions that don't belong anywhere else.

*/
#ifndef s_conv_h
#define s_conv_h
/*

	
	                                                                 ۰
	                                          ۰
	   ۰  ۰    ۰ ۰  ۰ ۰ ۰  ۰ ۰ ۰    ۰   ۰
	   ۰   ۰ ۰ ۰ ۰   ۰    ۰     ۰ ۰ ۰ ۰ ۰   ۰
	   ۰   ۰ ۰ ۰ ۰  ۰۰  ۰  ۰      ۰ ۰ ۰ ۰ ۰   ۰
	    ۰  ۰ ۰  ۰   ۰    ۰ ۰ ۰ ۰  ۰ ۰  ۰   ۰
	                                            ۰
	                                                                 ۰
	                                                                 ۰
	                                          ۰
	     ۰ ۰ ۰   ۰ ۰   ۰ ۰ ۰    ۰ ۰       ۰
	        ۰ ۰ ۰ ۰ ۰     ۰   ۰ ۰ ۰ ۰ ۰           ۰
	     ۰  ۰ ۰ ۰ ۰ ۰     ۰   ۰ ۰ ۰ ۰ ۰           ۰
	     ۰     ۰ ۰  ۰  ۰   ۰   ۰  ۰ ۰  ۰ ۰       ۰
	                                                 ۰
	                                                                 ۰
	۰
	 

									by Sven Sandberg



	 This header file contains external declarations for:

		  5 functions for converting from string to number
		  5 functions for converting from number to string
		 74 macros for converting from string to number
		154 macros for converting from number to string
	 +   4 other macros
	 ----------------------------------------------------
		242 macros or functions

	plus six constant macros.


*/


#include "s_defs.h"

//Constants for decimaltype parameter to d2str_extended function.
//*** NOTE THAT THESE MUST BE THE SAME AS THE CORRESPONDING ip_ CONSTANTS IN
//input.h ***.
#define ct_decimals     (-10)
#define ct_ifexponent   (-11)
#define ct_exponent     (-12)
#define ct_nodecimals   (-13)
#define ct_halves       (-14)
#define ct_quarters     (-15)




//Global options for numbers.
extern uchar char14, char12, char34, 
 minussign, zerosign, plussign, decimalsep, thousandsep;

extern uchar *exppositivestring, *expnegativestring;

extern int hexuppercase;

extern int hex_sep_distance, dec_sep_distance, oct_sep_distance, 
 bin_sep_distance;



/******************************
****                       ****
**** FUNCTION DECLARATIONS ****
****                       ****
******************************/

//Convert between uppercase unreadable text and binary data.
extern uchar *text2void_d(uchar *so,void *de,int length);
extern uchar *void2text_d(void *so,uchar *de,int length);

//Returns a string representation of a long.
extern uchar *l2str_extended(slong number,uchar *text,
 int minlength, int sepdistance, int base);
//Returns a string representation of an ulong.
extern uchar *ul2str_extended(ulong number,uchar *text,
 int minlength, int sepdistance, int base);
//Returns a string representation of a longlong.
extern uchar *ll2str_extended(slonglong number,uchar *text,
 int minlength, int sepdistance, int base);
//Returns a string representation of an ulonglong.
extern uchar *ull2str_extended(ulonglong number,uchar *text,
 int minlength, int sepdistance, int base);
//Returns a string representation of a double.
extern uchar *d2str_extended(double number,uchar *text,
 int decimaltype,ulong expifgreater,ulong expifsmaller,
 slong minlength,
 slong mindecimals, slong maxdecimals,
 slong expmindecimals, slong expmaxdecimals, ulong expminlength,
 uchar sepdistance,
 uchar base, uchar *decimaltypechosen);

//Returns a long found in a string.
extern signed long str2l_extended(uchar *text,int base, int *valid);
//Returns an unsigned long found in a string.
extern unsigned long str2ul_extended(uchar *text,int base, int *valid);
//Returns a longlong found in a string.
extern slonglong str2ll_extended(uchar *text, int base, int *valid);
//Returns an unsigned longlong found in a string.
extern ulonglong str2ull_extended(uchar *text,int base, int *valid);
//Returns a double found in a string.
extern double str2d_extended(uchar *text,int decimaltype,
 int base,int *valid);



/***************************
****                    ****
**** NUMBERS TO STRINGS ****
****                    ****
***************************/

////////
//LONG//
////////

#define l2str(number,text)       (l2str_extended(number,text,1,0,10))
#define l2dec(number,text)       (l2str(number,text))
#define l2hex(number,text)       (l2str_extended(number,text,1,0,16))
#define l2oct(number,text)       (l2str_extended(number,text,1,0,8))
#define l2bin(number,text)       (l2str_extended(number,text,1,0,2))
	//With thousand separators.
#define l2str_sep(number,text)   (l2str_extended(number,text,1,dec_sep_distance,10))
#define l2dec_sep(number,text)   (l2str_sep(number,text))
#define l2hex_sep(number,text)   (l2str_extended(number,text,1,hex_sep_distance,16))
#define l2oct_sep(number,text)   (l2str_extended(number,text,1,oct_sep_distance,8))
#define l2bin_sep(number,text)   (l2str_extended(number,text,1,bin_sep_distance,2))

/////////
//ULONG//
/////////

#define ul2str(number,text)      (ul2str_extended(number,text,1,0,10))
#define ul2dec(number,text)      (ul2str(number,text))
#define ul2hex(number,text)      (ul2str_extended(number,text,1,0,16))
#define ul2oct(number,text)      (ul2str_extended(number,text,1,0,8))
#define ul2bin(number,text)      (ul2str_extended(number,text,1,0,2))
	//With thousand separators.
#define ul2str_sep(number,text)  (ul2str_extended(number,text,1,dec_sep_distance,10))
#define ul2dec_sep(number,text)  (ul2str(number,text))
#define ul2hex_sep(number,text)  (ul2str_extended(number,text,1,hex_sep_distance,16))
#define ul2oct_sep(number,text)  (ul2str_extended(number,text,1,oct_sep_distance,8))
#define ul2bin_sep(number,text)  (ul2str_extended(number,text,1,bin_sep_distance,2))

////////////
//LONGLONG//
////////////

#define ll2str(number,text)      (ll2str_extended(number,text,1,0,10))
#define ll2dec(number,text)      (ll2str(number,text))
#define ll2hex(number,text)      (ll2str_extended(number,text,1,0,16))
#define ll2oct(number,text)      (ll2str_extended(number,text,1,0,8))
#define ll2bin(number,text)      (ll2str_extended(number,text,1,0,2))
	//With thousand separators.
#define ll2str_sep(number,text)  (ll2str_extended(number,text,1,dec_sep_distance,10))
#define ll2dec_sep(number,text)  (ll2str_sep(number,text))
#define ll2hex_sep(number,text)  (ll2str_extended(number,text,1,hex_sep_distance,16))
#define ll2oct_sep(number,text)  (ll2str_extended(number,text,1,oct_sep_distance,8))
#define ll2bin_sep(number,text)  (ll2str_extended(number,text,1,bin_sep_distance,2))

/////////////
//ULONGLONG//
/////////////

#define ull2str(number,text)     (ull2str_extended(number,text,1,0,10))
#define ull2dec(number,text)     (ull2str(number,text))
#define ull2hex(number,text)     (ull2str_extended(number,text,1,0,16))
#define ull2oct(number,text)     (ull2str_extended(number,text,1,0,8))
#define ull2bin(number,text)     (ull2str_extended(number,text,1,0,2))
	//With thousand separators.
#define ull2str_sep(number,text) (ull2str_extended(number,text,1,dec_sep_distance,10))
#define ull2dec_sep(number,text) (ull2str(number,text))
#define ull2hex_sep(number,text) (ull2str_extended(number,text,1,hex_sep_distance,16))
#define ull2oct_sep(number,text) (ull2str_extended(number,text,1,oct_sep_distance,8))
#define ull2bin_sep(number,text) (ull2str_extended(number,text,1,bin_sep_distance,2))

//////////
//DOUBLE//
//////////

	//Without separators.
		//Decimal.
			//Always normal, never exponent.
#define d2str_decimals(number,text,maxdecimals)                (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,0,10,NULL))
#define d2str(number,text,maxdecimals)                         (d2str_decimals(number,text,maxdecimals))
			//If # digits exceeds 9, number is with exponent, otherways normal.
#define d2str_ifexp(number,text,maxdecimals,decimaltypechosen) (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,0,10,decimaltypechosen))
			//Always exponent.
#define d2str_exp(number,text)                                 (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,0,10,NULL))
			//No decimals.
#define d2str_nodecimals(number,text)                          (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,0,10,NULL))
			//Halves.
#define d2str_halves(number,text)                              (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,0,10,NULL))
			//Quarters and halves.
#define d2str_quarters(number,text)                            (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,0,10,NULL))
//Defines so that you can use dec instead of str.
#define d2dec_decimals(number,text,maxdecimals)                (d2str_decimals(number,text,maxdecimals))
#define d2dec(number,text,maxdecimals)                         (d2str_decimals(number,text,maxdecimals))
#define d2dec_ifexp(number,text,maxdecimals,decimaltypechosen) (d2str_ifexp(number,text,maxdecimals,decimaltypechosen))
#define d2dec_exp(number,text)                                 (d2str_exp(number,text))
#define d2dec_nodecimals(number,text)                          (d2str_nodecimals(number,text))
#define d2dec_halves(number,text)                              (d2str_halves(number,text))
#define d2dec_quarters(number,text)                            (d2str_quarters(number,text))
		//Hex
#define d2hex_decimals(number,text,maxdecimals)                (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,0,16,NULL))
#define d2hex(number,text,maxdecimals)                         (d2str_decimals(number,text,maxdecimals))
#define d2hex_ifexp(number,text,maxdecimals,decimaltypechosen) (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,0,16,decimaltypechosen))
#define d2hex_exp(number,text)                                 (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,0,16,NULL))
#define d2hex_nodecimals(number,text)                          (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,0,16,NULL))
#define d2hex_halves(number,text)                              (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,0,16,NULL))
#define d2hex_quarters(number,text)                            (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,0,16,NULL))
		//Oct
#define d2oct_decimals(number,text,maxdecimals)                (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,0,8,NULL))
#define d2oct(number,text,maxdecimals)                         (d2str_decimals(number,text,maxdecimals))
#define d2oct_ifexp(number,text,maxdecimals,decimaltypechosen) (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,0,8,decimaltypechosen))
#define d2oct_exp(number,text)                                 (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,0,8,NULL))
#define d2oct_nodecimals(number,text)                          (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,0,8,NULL))
#define d2oct_halves(number,text)                              (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,0,8,NULL))
#define d2oct_quarters(number,text)                            (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,0,8,NULL))
		//Bin
#define d2bin_decimals(number,text,maxdecimals)                (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,0,2,NULL))
#define d2bin(number,text,maxdecimals)                         (d2str_decimals(number,text,maxdecimals))
#define d2bin_ifexp(number,text,maxdecimals,decimaltypechosen) (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,0,2,decimaltypechosen))
#define d2bin_exp(number,text)                                 (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,0,2,NULL))
#define d2bin_nodecimals(number,text)                          (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,0,2,NULL))
#define d2bin_halves(number,text)                              (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,0,2,NULL))
#define d2bin_quarters(number,text)                            (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,0,2,NULL))
	//With thousand separators.
		//Decimal.
#define d2str_decimals_sep(number,text,maxdecimals)                  (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,dec_sep_distance,10,NULL))
#define d2str_sep(number,text,maxdecimals)                           (d2str_decimals(number,text,maxdecimals))
			//If # digits exceeds 9, number is with exponent, otherways normal.
#define d2str_ifexp_sep(number,text,maxdecimals,decimaltypechosen)   (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,dec_sep_distance,10,decimaltypechosen))
			//Always exponent.
#define d2str_exp_sep(number,text)                                   (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,dec_sep_distance,10,NULL))
			//No decimals.
#define d2str_nodecimals_sep(number,text)                            (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,dec_sep_distance,10,NULL))
			//Halves.
#define d2str_halves_sep(number,text)                                (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,dec_sep_distance,10,NULL))
			//Quarters and halves.
#define d2str_quarters_sep(number,text)                              (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,dec_sep_distance,10,NULL))
//Defines so that you can use dec instead of str.
#define d2dec_decimals_sep(number,text,maxdecimals)                  (d2str_decimals(number,text,maxdecimals))
#define d2dec_sep(number,text,maxdecimals)                           (d2str_decimals(number,text,maxdecimals))
#define d2dec_ifexp_sep(number,text,maxdecimals,decimaltypechosen)   (d2str_ifexp(number,text,maxdecimals,decimaltypechosen))
#define d2dec_exp_sep(number,text)                                   (d2str_exp(number,text))
#define d2dec_nodecimals_sep(number,text)                            (d2str_nodecimals(number,text))
#define d2dec_halves_sep(number,text)                                (d2str_halves(number,text))
#define d2dec_quarters_sep(number,text)                              (d2str_quarters(number,text))
		//Hex
#define d2hex_decimals_sep(number,text,maxdecimals)                  (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,hex_sep_distance,16,NULL))
#define d2hex_sep(number,text,maxdecimals)                           (d2str_decimals(number,text,maxdecimals))
#define d2hex_ifexp_sep(number,text,maxdecimals,decimaltypechosen)   (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,hex_sep_distance,16,decimaltypechosen))
#define d2hex_exp_sep(number,text)                                   (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,hex_sep_distance,16,NULL))
#define d2hex_nodecimals_sep(number,text)                            (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,hex_sep_distance,16,NULL))
#define d2hex_halves_sep(number,text)                                (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,hex_sep_distance,16,NULL))
#define d2hex_quarters_sep(number,text)                              (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,hex_sep_distance,16,NULL))
		//Oct
#define d2oct_decimals_sep(number,text,maxdecimals)                  (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,oct_sep_distance,8,NULL))
#define d2oct_sep(number,text,maxdecimals)                           (d2str_decimals(number,text,maxdecimals))
#define d2oct_ifexp_sep(number,text,maxdecimals,decimaltypechosen)   (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,oct_sep_distance,8,decimaltypechosen))
#define d2oct_exp_sep(number,text)                                   (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,oct_sep_distance,8,NULL))
#define d2oct_nodecimals_sep(number,text)                            (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,oct_sep_distance,8,NULL))
#define d2oct_halves_sep(number,text)                                (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,oct_sep_distance,8,NULL))
#define d2oct_quarters_sep(number,text)                              (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,oct_sep_distance,8,NULL))
		//Bin
#define d2bin_decimals_sep(number,text,maxdecimals)                  (d2str_extended(number,text,ct_decimals,0,0,1,-1,maxdecimals,0,6,1,bin_sep_distance,2,NULL))
#define d2bin_sep(number,text,maxdecimals)                           (d2str_decimals(number,text,maxdecimals))
#define d2bin_ifexp_sep(number,text,maxdecimals,decimaltypechosen)   (d2str_extended(number,text,ct_ifexponent,9,5,1,-1,maxdecimals,0,6,1,bin_sep_distance,2,decimaltypechosen))
#define d2bin_exp_sep(number,text)                                   (d2str_extended(number,text,ct_exponent,0,0,1,-1,maxdecimals,0,6,1,bin_sep_distance,2,NULL))
#define d2bin_nodecimals_sep(number,text)                            (d2str_extended(number,text,ct_nodecimals,0,0,1,-1,0,0,6,1,bin_sep_distance,2,NULL))
#define d2bin_halves_sep(number,text)                                (d2str_extended(number,text,ct_halves,0,0,1,-1,0,0,6,1,bin_sep_distance,2,NULL))
#define d2bin_quarters_sep(number,text)                              (d2str_extended(number,text,ct_quarters,0,0,1,-1,0,0,6,1,bin_sep_distance,2,NULL))

//////////
//HALVES//
//////////

/* Here's some special functions that take a number in integer format,
	divide it by two and return a string that may contain halves.

	This is useful if you want to store numbers that can contain halves in
	integer numbers.

	Note that these functions cheats: They convert the number to a double and
	use d2str_extended. This makes the conversion much slower, but I
	don't need to write any special routines.

	An example: The number `12345' corresponds to the string "6172".
*/
#define l2str_halves_extended(number,text,minlength,sepdistance,base)   (d2str_extended(((double)(number))/2,text,ct_halves,0,0,minlength,0,0,0,0,0,sepdistance,base,NULL))
#define ul2str_halves_extended(number,text,minlength,sepdistance,base)  (d2str_extended(((double)(number))/2,text,ct_halves,0,0,minlength,0,0,0,0,0,sepdistance,base,NULL))
#define ll2str_halves_extended(number,text,minlength,sepdistance,base)  (d2str_extended(((double)(number))/2,text,ct_halves,0,0,minlength,0,0,0,0,0,sepdistance,base,NULL))
#define ull2str_halves_extended(number,text,minlength,sepdistance,base) (d2str_extended(((double)(number))/2,text,ct_halves,0,0,minlength,0,0,0,0,0,sepdistance,base,NULL))
//And of course a list of functions that use the _extended functions.
//Signed long.
#define l2str_halves(number,text)         (l2str_halves_extended(number,text,-1,0,10))
#define l2dec_halves(number,text)         (l2str_halves(number,text))
#define l2hex_halves(number,text)         (l2str_halves_extended(number,text,-1,0,16))
#define l2oct_halves(number,text)         (l2str_halves_extended(number,text,-1,0,8))
#define l2bin_halves(number,text)         (l2str_halves_extended(number,text,-1,0,2))
	//Separators.
#define l2str_halves_sep(number,text)     (l2str_halves_extended(number,text,-1,dec_sep_distance,10))
#define l2dec_halves_sep(number,text)     (l2str_halves_sep(number,text))
#define l2hex_halves_sep(number,text)     (l2str_halves_extended(number,text,-1,hex_sep_distance,16))
#define l2oct_halves_sep(number,text)     (l2str_halves_extended(number,text,-1,oct_sep_distance,8))
#define l2bin_halves_sep(number,text)     (l2str_halves_extended(number,text,-1,bin_sep_distance,2))
//Unsigned long.
#define ul2str_halves(number,text)        (ul2str_halves_extended(number,text,-1,0,10))
#define ul2dec_halves(number,text)        (ul2str_halves(number,text))
#define ul2hex_halves(number,text)        (ul2str_halves_extended(number,text,-1,0,16))
#define ul2oct_halves(number,text)        (ul2str_halves_extended(number,text,-1,0,8))
#define ul2bin_halves(number,text)        (ul2str_halves_extended(number,text,-1,0,2))
	//Separators.
#define ul2str_halves_sep(number,text)    (ul2str_halves_extended(number,text,-1,dec_sep_distance,10))
#define ul2dec_halves_sep(number,text)    (ul2str_halves_sep(number,text))
#define ul2hex_halves_sep(number,text)    (ul2str_halves_extended(number,text,-1,hex_sep_distance,16))
#define ul2oct_halves_sep(number,text)    (ul2str_halves_extended(number,text,-1,oct_sep_distance,8))
#define ul2bin_halves_sep(number,text)    (ul2str_halves_extended(number,text,-1,bin_sep_distance,2))

//Signed longlong.
#define ll2str_halves(number,text)        (ll2str_halves_extended(number,text,-1,0,10))
#define ll2dec_halves(number,text)        (ll2str_halves(number,text))
#define ll2hex_halves(number,text)        (ll2str_halves_extended(number,text,-1,0,16))
#define ll2oct_halves(number,text)        (ll2str_halves_extended(number,text,-1,0,8))
#define ll2bin_halves(number,text)        (ll2str_halves_extended(number,text,-1,0,2))
	//Separators.
#define ll2str_halves_sep(number,text)    (ll2str_halves_extended(number,text,-1,dec_sep_distance,10))
#define ll2dec_halves_sep(number,text)    (ll2str_halves_sep(number,text))
#define ll2hex_halves_sep(number,text)    (ll2str_halves_extended(number,text,-1,hex_sep_distance,16))
#define ll2oct_halves_sep(number,text)    (ll2str_halves_extended(number,text,-1,oct_sep_distance,8))
#define ll2bin_halves_sep(number,text)    (ll2str_halves_extended(number,text,-1,bin_sep_distance,2))
//Unsigned longlong.
#define ull2str_halves(number,text)       (ull2str_halves_extended(number,text,-1,0,10))
#define ull2dec_halves(number,text)       (ull2str_halves(number,text))
#define ull2hex_halves(number,text)       (ull2str_halves_extended(number,text,-1,0,16))
#define ull2oct_halves(number,text)       (ull2str_halves_extended(number,text,-1,0,8))
#define ull2bin_halves(number,text)       (ull2str_halves_extended(number,text,-1,0,2))
	//Separators.
#define ull2str_halves_sep(number,text)   (ull2str_halves_extended(number,text,-1,dec_sep_distance,10))
#define ull2dec_halves_sep(number,text)   (ull2str_halves_sep(number,text))
#define ull2hex_halves_sep(number,text)   (ull2str_halves_extended(number,text,-1,hex_sep_distance,16))
#define ull2oct_halves_sep(number,text)   (ull2str_halves_extended(number,text,-1,oct_sep_distance,8))
#define ull2bin_halves_sep(number,text)   (ull2str_halves_extended(number,text,-1,bin_sep_distance,2))



/***************************
****                    ****
**** STRINGS TO NUMBERS ****
****                    ****
***************************/

////////
//LONG//
////////

#define str2l(text)     (str2l_extended(text,10,NULL))
#define hex2l(text)     (str2l_extended(text,16,NULL))
#define oct2l(text)     (str2l_extended(text,8,NULL))
#define bin2l(text)     (str2l_extended(text,2,NULL))
#define dec2l(text)     (str2l(text))

/////////
//ULONG//
/////////

#define str2ul(text)    (str2ul_extended(text,10,NULL))
#define hex2ul(text)    (str2ul_extended(text,16,NULL))
#define oct2ul(text)    (str2ul_extended(text,8,NULL))
#define bin2ul(text)    (str2ul_extended(text,2,NULL))
#define dec2ul(text)    (str2ul(text))

////////////
//LONGLONG//
////////////

#define str2ll(text)    (str2ll_extended(text,10,NULL))
#define hex2ll(text)    (str2ll_extended(text,16,NULL))
#define oct2ll(text)    (str2ll_extended(text,8,NULL))
#define bin2ll(text)    (str2ll_extended(text,2,NULL))
#define dec2ll(text)    (str2ll(text))

/////////////
//ULONGLONG//
/////////////

#define str2ull(text)   (str2ull_extended(text,10,NULL))
#define hex2ull(text)   (str2ull_extended(text,16,NULL))
#define oct2ull(text)   (str2ull_extended(text,8,NULL))
#define bin2ull(text)   (str2ull_extended(text,2,NULL))
#define dec2ull(text)   (str2ull(text))

//////////
//DOUBLE//
//////////

#define str2d_decimals(text)     (str2d_extended(text,ct_decimals,10,NULL))
#define str2d(text)              (str2d_decimals(text))
#define str2d_exp(text)          (str2d_extended(text,ct_exponent,10,NULL))
#define str2d_nodecimals(text)   (str2d_extended(text,ct_nodecimals,10,NULL))
#define str2d_halves(text)       (str2d_extended(text,ct_halves,10,NULL))
#define str2d_quarters(text)     (str2d_extended(text,ct_quarters,10,NULL))

#define dec2d_decimals(text)     (str2d_decimals(text))
#define dec2d(text)              (dec2d_decimals(text))
#define dec2d_exp(text)          (str2d_exp(text))
#define dec2d_nodecimals(text)   (str2d_nodecimals(text))
#define dec2d_halves(text)       (str2d_halves(text))
#define dec2d_quarters(text)     (str2d_quarters(text))

#define hex2d_decimals(text)     (str2d_extended(text,ct_decimals,16,NULL))
#define hex2d(text)              (hex2d_decimals(text))
#define hex2d_exp(text)          (str2d_extended(text,ct_exponent,16,NULL))
#define hex2d_nodecimals(text)   (str2d_extended(text,ct_nodecimals,16,NULL))
#define hex2d_halves(text)       (str2d_extended(text,ct_halves,16,NULL))
#define hex2d_quarters(text)     (str2d_extended(text,ct_quarters,16,NULL))

#define oct2d_decimals(text)     (str2d_extended(text,ct_decimals,8,NULL))
#define oct2d(text)              (oct2d_decimals(text))
#define oct2d_exp(text)          (str2d_extended(text,ct_exponent,8,NULL))
#define oct2d_nodecimals(text)   (str2d_extended(text,ct_nodecimals,8,NULL))
#define oct2d_halves(text)       (str2d_extended(text,ct_halves,8,NULL))
#define oct2d_quarters(text)     (str2d_extended(text,ct_quarters,8,NULL))

#define bin2d_decimals(text)     (str2d_extended(text,ct_decimals,2,NULL))
#define bin2d(text)              (bin2d_decimals(text))
#define bin2d_exp(text)          (str2d_extended(text,ct_exponent,2,NULL))
#define bin2d_nodecimals(text)   (str2d_extended(text,ct_nodecimals,2,NULL))
#define bin2d_halves(text)       (str2d_extended(text,ct_halves,2,NULL))
#define bin2d_quarters(text)     (str2d_extended(text,ct_quarters,2,NULL))

//////////
//HALVES//
//////////

//Halves macros must become functions before implementing `valid' parameter.
#define str2l_halves_extended(text,base)     ((long)(str2d_extended(text,ct_halves,10,NULL) * 2 + .5))
#define str2ul_halves_extended(text,base)    ((ulong)(str2d_extended(text,ct_halves,10,NULL) * 2 + .5))
#define str2ll_halves_extended(text,base)    ((longlong)(str2d_extended(text,ct_halves,10,NULL) * 2 + .5))
#define str2ull_halves_extended(text,base)   ((ulonglong)(str2d_extended(text,ct_halves,10,NULL) * 2 + .5))

#define str2l_halves(text,char12)   (str2l_halves_extended(text,10))
#define dec2l_halves(text,char12)   (str2l_halves(text,char12))
#define hex2l_halves(text,char12)   (str2l_halves_extended(text,16))
#define oct2l_halves(text,char12)   (str2l_halves_extended(text,8))
#define bin2l_halves(text,char12)   (str2l_halves_extended(text,2))

#define str2ul_halves(text,char12)  (str2ul_halves_extended(text,10))
#define dec2ul_halves(text,char12)  (str2ul_halves(text,char12))
#define hex2ul_halves(text,char12)  (str2ul_halves_extended(text,16))
#define oct2ul_halves(text,char12)  (str2ul_halves_extended(text,8))
#define bin2ul_halves(text,char12)  (str2ul_halves_extended(text,2))

#define str2ll_halves(text,char12)  (str2ll_halves_extended(text,10))
#define dec2ll_halves(text,char12)  (str2ll_halves(text,char12))
#define hex2ll_halves(text,char12)  (str2ll_halves_extended(text,16))
#define oct2ll_halves(text,char12)  (str2ll_halves_extended(text,8))
#define bin2ll_halves(text,char12)  (str2ll_halves_extended(text,2))

#define str2ull_halves(text,char12) (str2ull_halves_extended(text,10))
#define dec2ull_halves(text,char12) (str2ull_halves(text,char12))
#define hex2ull_halves(text,char12) (str2ull_halves_extended(text,16))
#define oct2ull_halves(text,char12) (str2ull_halves_extended(text,8))
#define bin2ull_halves(text,char12) (str2ull_halves_extended(text,2))



/****************************************
****                                 ****
**** MISCELLANEOUS AND HELPER MACROS ****
****                                 ****
****************************************/

/* char2digit
	Converts the character to a number. All alphabetical characters (both
	lower- and uppercase) will be treated just like in hexadecimal numbers.
	NOTE: This function returns crazy things if the character doesn't contain
	a number or an alphabetical letter.
*/
#define _char2digit(ascii)             (  ((ascii)<='9') ? ((ascii)-'0') : ( ((ascii)<='Z') ? ((ascii)-55) : ((ascii)-87) )  )

/* digit2char
	Converts a number to a character. All numbers above 10 becomes
	alphabetical letters. They are uppercase if uppercase is `TRUE' and
	lowercase if it is `FALSE'.
*/
#define _digit2char(number,uppercase)  (  ((number)<10) ? ((number)+'0') : ( (uppercase) ? ((number)+55) : ((number)+87) )  )

/* getdigitwithbase
	With the binary number system, you can extract one of the bits by anding
	the number and a number with that bit set. But with any number system, for
	example with the base 10, you can't do that by anding. Instead, call this
	macro. NOTE: this is only for integer numbers. It won't work on floating
	point numbers. (This macro is not used by my functions.)
	Parameters:
	 n    The number.
	 b    The base (10 for decimal numbers, 16 for hex, 2 for binary and so on.
	 p    [The base] raised to [the position of the digit], i.e. if you want to
			extract the fourth digit from right, you pass base^4. Note: First
			digit is #1. For example, the 7 in 4711 is at position 3.
*/
#define _get_digit_with_base(number,base,position) ( ((number)%(position)) / ((position)/(base)) )

/* numseparators
	Returns the number of thousand separators needed in a number that has
	`length' digits and the distance `sepdistance' between separators.
*/
#define _num_separators(length,sepdistance)  (  ((length)>1) ? ( ((length)-1)/(sepdistance) ) : (0)  )

extern int char2digit(uchar ascii);
extern int digit2char(int number,int uppercase);
extern int get_digit_with_base(ulonglong number,int base,ulonglong position);
extern int num_separators(int length,int sepdistance);


#endif


