/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for changing case and some more for characters.

*/
#ifndef s_char_h
#define s_char_h


#ifndef __INLINE__
#define __INLINE__ extern inline
#endif


/************************************************************
****                                                     ****
**** Functions for getting information about a character ****
****                                                     ****
************************************************************/

//For uchar.
#include "s_defs.h"


extern uchar casetable[256];

//Any character (including national).
#define _charisalpha(ascii)      ( casetable[(uchar)ascii])
__INLINE__ int charisalpha(uchar ascii) {return _charisalpha(ascii);}
//Uppercase (including national).
#define _charisupper(ascii)      ( casetable[(uchar)ascii] > (ascii) )
__INLINE__ int charisupper(uchar ascii) {return _charisupper(ascii);}
//Lowercase (including national).
#define _charislower(ascii)      ( casetable[(uchar)ascii] &&              \
 (casetable[(uchar)ascii] <= (ascii)) )
__INLINE__ int charislower(uchar ascii) {return _charislower(ascii);}
//0..9.
#define _charisdigit(ascii)      ( ((ascii)>='0') && ((ascii)<='9') )
__INLINE__ int charisdigit(uchar ascii) {return _charisdigit(ascii);}
//Characters and digits.
#define _charisalnum(ascii)      ( _charisalpha(ascii) || _charisdigit(ascii) )
__INLINE__ int charisalnum(uchar ascii) {return _charisalnum(ascii);}
//Uppercase and digits.
#define _charisuppernum(ascii)   ( _charisupper(ascii) || _charisdigit(ascii))
extern int charisuppernum(uchar ascii);
//Lowercase and digits.
#define _charislowernum(ascii)   ( _charislower(ascii) || _charisdigit(ascii))
extern int charislowernum(uchar ascii);
//a..z.
#define _charislower_az(ascii)   ( ((ascii)>='a') && ((ascii)<='z') )
__INLINE__ int charislower_az(uchar ascii) {return _charislower_az(ascii);}
//A..Z.
#define _charisupper_az(ascii)   ( ((ascii)>='A') && ((ascii)<='Z') )
__INLINE__ int charisupper_az(uchar ascii) {return _charisupper_az(ascii);}
//Aa..Zz.
#define _charisalpha_az(ascii)                                             \
 ( _charisupper_az(ascii) && _charislower_az(ascii) )
extern int charisalpha_az(uchar ascii);
//Aa..Zz and digits.
#define _charisalnum_az(ascii)   ( _charisdigit(ascii) || _charisalpha_az(ascii) )
extern int charisalnum_az(uchar ascii);
//A..Z and digits.
#define _charisuppernum_az(ascii) ( _charisdigit(ascii) || _charisupper_az(ascii) )
extern int charisuppernum_az(uchar ascii);
//a..z and digits.
#define _charislowernum_az(ascii) ( _charisdigit(ascii) || _charislower_az(ascii) )
extern int charislowernum_az(uchar ascii);

//Space (32).
#define _charisspace(ascii)      ( (ascii)==' ' )
#define charisspace(ascii)       (_charisspace(ascii))
//Space, tab, return etc.
#define _charisempty(ascii)      ( (((ascii)>=9) && ((ascii)<=13)) ||      \
 ((ascii)==' ') )
extern int charisempty(uchar ascii);

//Anyting except numbers, characters and space.
#define _charissymbol(ascii)     ( ((ascii)>32) && (((ascii)<'0') ||       \
 ((ascii)>'9')) && !(casetable[(uchar)ascii]))
extern int charissymbol(uchar ascii);
//Anything except Aa..Zz, numbers and space.
#define _charissymbol_az(ascii)  ( (((ascii)>' ') && ((ascii)<'0'))  ||    \
 (((ascii)>'9') && ((ascii)<'A'))  ||  \
 (((ascii)>'Z') && ((ascii)<'a'))  ||  \
 ((ascii)>'z') )
extern int charissymbol_az(uchar ascii);

/* Returns nonzero if ascii is a character used by the number system with
	base `base'. For example, returns nonzero only for '1' and '0' if base is
	2 (binary numbers), while when base is 16 (hex numbers) the macro returns
	nonzero for '0'..'9', 'a'..'f' and 'A..F'.
*/
#define _charisdigit_base(ascii,base)                                      \
 ( ((base)<11) ?  (((ascii) >= '0') && ((ascii) < ('0'+(base)))) :         \
 ((((ascii) >= '0') && ((ascii) <= '9')) ||                                \
 ( ((ascii) >= 'a') && ((ascii) < ('a'+(base)-10))) ||                     \
 ( ((ascii) >= 'A') && ((ascii) < ('A'+(base)-10)))) )
extern int charisdigit_base(uchar ascii,int base);

#define _charicmp(c1,c2)         (_chartolower(c1)==_chartolower(c2))
extern int charicmp(uchar c1,uchar c2);
#define _charicmp_az(c1,c2)      (_chartolower_az(c1)==_chartolower_az(c2))
extern int charicmp_az(uchar c1,uchar c2);



/************************************
****                             ****
**** Functions for changing case ****
****                             ****
************************************/

//Converts to uppercase (including national).
#define _chartoupper(ascii)      (                                         \
 ((casetable[(uchar)ascii] <  (ascii)) && casetable[(uchar)ascii]) ?       \
 casetable[(uchar)ascii] : (ascii))
__INLINE__ uchar chartoupper(uchar ascii) {return _chartoupper(ascii);}
//Converts to lowercase (including national).
#define _chartolower(ascii)      ( (casetable[(uchar)ascii] >  (ascii)) ?  \
 casetable[(uchar)ascii] : (ascii))
__INLINE__ uchar chartolower(uchar ascii) {return _chartolower(ascii);}
//Changes case.
#define _charchangecase(ascii)   (  casetable[(uchar)ascii] ?              \
 casetable[(uchar)ascii] : (ascii))
__INLINE__ uchar charchangecase(uchar ascii){return _charchangecase(ascii);}
//Converts to uppercase, only for Aa-Zz (including national).
#define _chartoupper_az(ascii)   ( _charislower_az(ascii) ?                \
 ((ascii)-32) : (ascii) )
__INLINE__ uchar chartoupper_az(uchar ascii){return _chartoupper_az(ascii);}
//Converts to lowercase, only for Aa-Zz.
#define _chartolower_az(ascii)   ( _charisupper_az(ascii) ?                \
 ((ascii)+32) : (ascii) )
__INLINE__ uchar chartolower_az(uchar ascii){return _chartolower_az(ascii);}
//Changes case, only for Aa-Zz.
#define _charchangecase_az(ascii)   (_charisupper_az(ascii) ?              \
 ((ascii)+32) : _charislower_az(ascii) ? ((ascii)-32) : (ascii) )
__INLINE__ uchar charchangecase_az(uchar ascii){return _charchangecase_az(ascii);}

/* These four functions are the same as the ansi functions, but including
	national characters. Note that they're just copied from the djgpp lib and
	changed a little so that they use my tables.
*/
extern char *strlwr_nat(char *_s);
extern char *strupr_nat(char *_s);
/* These functions can't detect alphabetic order of characters yet, so it's
	not good to use them for that. If anyone knows how to do that, I'd be
	delighted to hear.

	NOTE: The return value is `TRUE' if the strings are the same, and `FALSE'
	if there is a difference.
*/
extern int stricmp_nat(const char *s1, const char *s2);
extern int strnicmp_nat(const char *s1, const char *s2, ulong n);



/* Table for converting from windows to dos. This is only for the Swedish
	character set. If you want to add for your country, just send me the table
	in the same format as this. I have a utility that generates the win2dos
	table from the dos2win table. I could send you that if you told me to.
*/
extern uchar swedish_win2dos_table[256];
extern uchar swedish_dos2win_table[256];

//Converts from windows character swedish dos to character.
#define swedish_win2dos(ascii)   (swedish_win2dos_table[ascii])
//Converts from swedish dos character to windows character.
#define swedish_dos2win(ascii)   (swedish_dos2win_table[ascii])
//Converts from windows string to swedish dos string.
extern uchar *str_swedish_win2dos_change(uchar *text);
//Converts from swedish dos string to windows string.
extern uchar *str_swedish_dos2win_change(uchar *text);
//Converts from windows string to swedish dos string, but as most length
//characters.
extern uchar *strn_swedish_win2dos_change(uchar *text,int length);
//Converts from swedish dos string to windows string, but as most length
//characters.
extern uchar *strn_swedish_dos2win_change(uchar *text,int length);


#endif
