/*
 * This file is part of Pallantir - events kernel for Allegro
 * Version : 0.5
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dztime.c
 *
 */

#include "palantir.h"
//#include "d:/djgpp/work/xfault/xfault.h"

odlist *scheduled_app_list;
int scheduler_handler(a_message code,int p1,int p2);
int clock_corrector_hnd(a_message code,int p1,int p2);
static int scheduler_init_=0;

//------------------------ SHEDULED INIT ---------------------------

int scheduler_init(void)
{ dz_app *scheduled_app;
//  dz_app *clock_corrector_app;
  int tmp;

  if (scheduler_init_) return(1); //already installed

  if ((scheduled_app_list=odlist_new())==NULL)
   {
     return(0);
   }

  if ((scheduled_app=dz_app_new("Scheduler daemon",16384,1,scheduler_handler))==NULL)
   { lwp_disable;
     free(scheduled_app_list);
     lwp_enable;
     return(0);
   }
/*
  clock_corrector_app=dz_app_new("Clock corrector",4096,1,clock_corrector_hnd);
  scheduled_app_add(2,clock_corrector_app);
*/

  scheduler_init_=1;
  return(1);
}

//-------------------------- SCHEDULERD ------------------------
//scheduler daemon
int scheduler_handler(a_message code,int p1,int p2)
{ odelement *cur;
  dz_msg msg;
  dz_app *app;
  fifo_queue *q;
  int tmp;

  switch (code)
   { case APP_START:
      app=app_(p1);
      q=app->msg_queue;
      while(1)
       { lwp_wait_false((int*)&(scheduled_app_list->status));
         lwp_lock(&(scheduled_app_list->status));
         cur=scheduled_app_list->first;
         while (cur!=NULL) //check installed app
          { time_t now=time(0);
            clock_corrector_hnd(E_TIMER_PERIOD,0,0);
            if (now>=schedapp_(cur->data)->time_of_next_call)
             { app_msg_put(schedapp_(cur->data)->app,E_TIMER_PERIOD,(int)schedapp_(cur->data)->period,(int)schedapp_(cur->data));
//               aa_printf(cur_cxt,AA_NORMAL,"%s\n",schedapp_(cur->data)->app->szName);
               schedapp_(cur->data)->time_of_next_call=now+schedapp_(cur->data)->period;
             }
            cur=cur->next;
          }
         if (q->empt)
          { app_msg_get(app,&msg);
            if (msg.code==APP_STOP)
             { lwp_disable;
               free(scheduled_app_list);
               lwp_enable;
               return(0);
             }
           }
//         lwp_sleep(1,0);
//         aa_putch(cur_cxt,AA_NORMAL,'@');
         lwp_unlock(&(scheduled_app_list->status));
         lwp_yield();
       }
      break;
     default:
      break;
   }
  return(0);
}

//----------------------- SHEDULED APP ADD -------------------------
// Add app to the sheduled_app_list to be notifyied with E_TIMER_PERIOD msg.
// Some computations may requerys periodical execution. This function allows
// to app know about some period of time have been turn off. You can
// schedule app with many various periods simultaneously. For example add
// 1 second period to check alarm, 10 min period to do autosave, etc.
// Parameters :
// time_t period - period in seconds.
// dz_app *app - app wich will be notifyied.
// Return value : NULL if failed ; pointer to scheduled_app structure on
// success.
// Example :
// int my_hnd(a_message code,int p1,int p2)
// {  int period;
//    swicth(code)
//     { case E_TIMER_PERIOD:
//         period=p1;
//         if (period==1) check_alarm();
//         else if (period==600) do_auto_save();
//         break;
//       case default:
//         break;
//     }
// }
// { dz_app *my_app;
//
//   my_app=dz_app_new("MY SCHEDULED APP",4096,1,my_hnd);
//   scheduled_app_add(1,my_app); //1 seconds period
//   scheduled_app_add(600,my_app); //10 minutes period
// }
scheduled_app *scheduled_app_add(time_t period,dz_app *app)
{ int tmp;

  if (app==NULL||period<=0) return(NULL);

  lwp_wait_false((int*)&(scheduled_app_list->status));
  lwp_lock(&(scheduled_app_list->status));

  { odelement *cur=scheduled_app_list->first;
    scheduled_app *schedapp;
    while (cur!=NULL) //check installed app
     { if (schedapp_(cur->data)->app==app&&schedapp_(cur->data)->period==period)
        { //app with period 'period' already scheduled
          lwp_unlock(&(scheduled_app_list->status));
          return(cur->data);
        }
       cur=cur->next;
     }
    lwp_disable;
    schedapp=schedapp_(malloc(sizeof(scheduled_app)));
    lwp_enable;

    if (schedapp==NULL)
     { lwp_unlock(&(scheduled_app_list->status));
       return(NULL);
     }
    schedapp->app=app;
    schedapp->period=period;
    schedapp->time_of_next_call=time(0)+period;

    if (odlist_insert(scheduled_app_list,schedapp)==NULL)
     { lwp_unlock(&(scheduled_app_list->status));
       lwp_disable;
       free(schedapp);
       lwp_enable;
       return(NULL);
     }
    lwp_unlock(&(scheduled_app_list->status));
    return(schedapp);
  }
}


//---------------------- SCHEDULED APP REMOVE ------------------------
// Remove app with given period from scheduled_app_list.
// Since you may schedules app with many periods you should specify wich
// period will be removed.
// Parameters :
// dz_app *app - scheduled app.
// time_t period - removing period.
// Example :
// int my_hnd(a_message code,int p1,int p2)
// {  int period;
//    static dz_app *my_app;
//    swicth(code)
//     { case APP_START:
//         my_app=app_(p1);
//         break;
//       case E_TIMER_PERIOD:
//         period=p1;
//         if (period==1)
//          { if (check_alarm()==ALARM_OK)
//             { scheduled_app_remove(my_app,1); //we don't need 1 period
//                                               //msg now
//             }
//          }
//         else if (period==600) do_auto_save();
//         break;
//       case default:
//         break;
//     }
// }
// { dz_app *my_app;
//
//   my_app=dz_app_new("MY SCHEDULED APP",4096,1,my_hnd);
//   scheduled_app_add(1,my_app); //1 seconds period
//   scheduled_app_add(600,my_app); //10 minutes period
// }
int scheduled_app_remove(dz_app *app,time_t period)
{ int tmp;
  odelement *cur;

  if (app==NULL||period<=0) return(0);

  lwp_wait_false((int*)&(scheduled_app_list->status));
  lwp_lock(&(scheduled_app_list->status));

  cur=scheduled_app_list->first;
  while (cur!=NULL) //check installed app
   { if ((schedapp_(cur->data)->app==app)&&schedapp_(cur->data)->period==period)
      { odlist_remove(scheduled_app_list,cur->data);
        lwp_unlock(&(scheduled_app_list->status));
        lwp_disable;
        free(cur->data);
        lwp_enable;
        return(1);
      }
     cur=cur->next;
   }
  lwp_unlock(&(scheduled_app_list->status));
  return(0);
}

//------------------ REAL TIME CLOCK ------------------

int real_time_clock(int cmd,struct time *real_time)
{ __dpmi_regs r;
  int tmp;

  lwp_disable;
  if (cmd==0) //read real time clock
   { r.h.ah = 0x2;
     __dpmi_int(0x1a, &r);
     real_time->ti_hour=bcd2bin(r.h.ch);
     real_time->ti_min=bcd2bin(r.h.cl);
     real_time->ti_sec=bcd2bin(r.h.dh);
     real_time->ti_hund=0;
   }
  else
   { r.h.ah = 0x3;
     bin2bcd(real_time->ti_hour,(char*)&(r.h.ch));
     bin2bcd(real_time->ti_min,(char*)&(r.h.cl));
     bin2bcd(real_time->ti_sec,(char*)&(r.h.dh));
     __dpmi_int(0x1a, &r);
   }
  lwp_enable;
  return (1);
}

//------------------ REAL TIME DATE ------------------

int real_time_date(int cmd,rdate *real_date)
{ __dpmi_regs r;
  int tmp;

  lwp_disable;
  if (cmd==0) //read real time date
   { r.h.ah = 0x4;
     __dpmi_int(0x1a, &r);
     real_date->da_cent=bcd2bin(r.h.ch);
     real_date->da_year=bcd2bin(r.h.cl);
     real_date->da_mon=bcd2bin(r.h.dh);
     real_date->da_day=bcd2bin(r.h.dl);
   }
  else
   { r.h.ah = 0x5;
     bin2bcd(real_date->da_cent,(char*)&(r.h.ch));
     bin2bcd(real_date->da_year,(char*)&(r.h.cl));
     bin2bcd(real_date->da_mon,(char*)&(r.h.dh));
     bin2bcd(real_date->da_day,(char*)&(r.h.dl));
     __dpmi_int(0x1a, &r);
   }
  lwp_enable;
  return (1);
}


//------------------------ CLOCK CORRECTOR ----------------------

int clock_corrector_hnd(a_message code,int p1,int p2)
{ struct time now;
  rdate nowd;
  struct date dos_nowd;

  switch (code)
   { case E_TIMER_PERIOD:
        real_time_clock(0,&now);
        biostime(1,(now.ti_hour*65543.33+now.ti_min*1092.38+now.ti_sec*18.21));
//        biostime(1,(now.ti_hour*65543+now.ti_min*1092+now.ti_sec*18));
        real_time_date(0,&nowd);
        getdate(&dos_nowd);

        if (nowd.da_day>dos_nowd.da_day&&nowd.da_mon==dos_nowd.da_mon&&now.ti_sec>2)
         { int n=1;
           dosmemput(&n,1,0x470);
         }
        else if (nowd.da_day<dos_nowd.da_day&&nowd.da_mon>dos_nowd.da_mon&&
                (nowd.da_year+nowd.da_cent*100)==dos_nowd.da_year&&now.ti_sec>2)
         { int n=1;
           dosmemput(&n,1,0x470);
         }
        else if (nowd.da_day<dos_nowd.da_day&&nowd.da_mon<dos_nowd.da_mon&&
                (nowd.da_year+nowd.da_cent*100)>dos_nowd.da_year&&now.ti_sec>2)
         { int n=1;
           dosmemput(&n,1,0x470);
         }
        break;
      case APP_STOP:
        return(0);
      default:
        break;
    }
  return(1);
}