/*
 * This file is part of Pallantir - events kernel for Allegro
 * Version : 0.5
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dzevents.c
 *
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include "palantir.h"
#include "internal.h"
//#include "d:/djgpp/work/xfault/xfault.h"

//#define device_(odelement) ((device*)((odelement)->data))
//#define odelist_(odelement) ((odlist*)((odelement)->data))

dz_app *system_app;
static int events_installed;
extern unsigned long tick_counter;
extern long bios_counter;
int exit_programm;
void queue_init(void);
extern int _lwp_enable;

//--------------------------- IDLED -------------------------

odlist *idle_proc;
typedef struct
{ int (*idle_handler)();
} idle_app;

void idled(void *args)
{
  odelement *cur,*old;
  idle_app *app;

  #ifdef __DZ_DEBUG__
  { int tmp;
  lwp_disable;
  #ifdef __GRX_MODE__
  { char s[25];
    sprintf(s,"IDLED : %i\n",lwp_getpid());
    textout(screen, font, s, 1, cur_y, 255);
    cur_y+=20;
  }
  #else
  printf("IDLED : %i\n",lwp_getpid());
  #endif
  lwp_enable;
  }
  #endif

  while (1)
   {  cur=idle_proc->first;
      if (cur==NULL) lwp_sleep(1,0);
      while (cur!=NULL)
       { app=(idle_app*)(cur->data);
         if (!app->idle_handler())
          { old=cur;
            cur=cur->next;
            odlist_remove(idle_proc,old);
          }
         else cur=cur->next;
       }
     lwp_yield();
   }
  return;
}


//--------------------------- HWRD -------------------------
// HardWare Read Daemon
// 'Listen' device read queue and post recieved data to clients apps (if any)
// Posted msg has the code as in device->read_code.
void hwrd(void *args)
{ int c,i;
  odelement *cur;
  device *dev;
  fifo_queue *q;
//  int tmp;
//  putch('C');

  dev=(device*)lwp_getusrptr();
  q=dev->clients_read_queue;
  if (q==NULL) return;

  #ifdef __DZ_DEBUG__
  { int tmp;
  lwp_disable;
  #ifdef __GRX_MODE__
  { char s[25];
    sprintf(s,"HWRD : %i\n",lwp_getpid());
    textout(screen, font, s, 1, cur_y, 255);
    cur_y+=20;
  }
  #else
  printf("HWRD : %d,%s\n",lwp_getpid(),dev->szName);
  #endif
  lwp_enable;
  }
  #endif

  while (1)
   { lwp_wait_true((int*)&(q->empt));
     c=queue_get(q);
     cur=(dev->read_client_tasks)->first;
//     printf("%c",c);
//     putch(c);
     i=0;
     while(cur!=NULL)
      { if (!app_msg_put(app_(ctask_(cur->data)->task),dev->read_code,c,(int)dev))
         { //if (!i) device_stop_recive(dev);//apps queue is near full
           device_stop_recive(dev,ctask_(cur->data)->task);//apps queue is near full
           i=1;
         }
        else if (ctask_(cur->data)->task->status==LWP_LOCKED)
         { device_resume_recive(dev,ctask_(cur->data)->task);
         }
//        else
        if (q->empt==EMPTY&&dev->device_empty_handler!=NULL)
         { //if (i) {device_resume_recive(dev,ctask_(cur->data)->task);i=0;}//
           dev->device_empty_handler(dev);
         }
        cur=cur->next;
      }
    if (q->empt==EMPTY||i) lwp_yield();
//lwp_yield();
   }
  return;
}

//--------------------------- HWWD -------------------------
// HardWare Write Daemon
// 'Listen' device write queue and post recieved data to clients apps (if any)
// Posted msg has the code as in device->write_code.
void hwwd(void *args)
{ int c;
  odelement *cur;
  device *dev;
  fifo_queue *q;
//  int tmp;
  dev=(device*)lwp_getusrptr();
  q=dev->clients_write_queue;

  if (q==NULL) return;

  #ifdef __DZ_DEBUG__
  { int tmp;
  lwp_disable;
  #ifdef __GRX_MODE__
  { char s[25];
    sprintf(s,"HWWD : %i\n",lwp_getpid());
    textout(screen, font, s, 1, cur_y, 255);
    cur_y+=20;
  }
  #else
  printf("HWWD : %i,%s\n",lwp_getpid(),dev->szName);
  #endif
  lwp_enable;
  }
  #endif

  while (1)
   { lwp_wait_true((int*)&(q->empt));
     c=queue_get(q);
     cur=(dev->write_client_tasks)->first;
     while(cur!=NULL)
      { app_msg_put(app_(ctask_(cur->data)->task),dev->write_code,c,(int)dev);
        cur=cur->next;
      }
     lwp_yield();
   }
  return;
}

//----------------------------- APP MSG GET -------------------------------
// Get msg from app->msg_queue.
// Return value: 1 if everything is Ok; 0 if queue near full,
// i.e. queue->tail>=queue->fill_level.
// By default fill_level=(2*queue->size)/3
// Zero means what msg geted successfuly, but, probably, some msgs may be
// lost in the future.
// Example:
// { dz_msg my_msg;
//   dz_app *my_app;
//
//   while (!app_msg_get(my_app,&msg)
//    { process msg stuff ...;
//      ...
//    }
// }
int app_msg_get(dz_app *app,dz_msg *msg)
{ int tmp;//,n=0;
  fifo_queue *q;

  if (app==NULL) return(-1);
  lwp_disable;
  q=app->msg_queue;
  if (q==NULL) return(-1);
  return(queue_get_(q,msg));
//  msg->code=queue_get(q);
//  msg->p1=queue_get(q);
//  msg->p2=queue_get(q);
//  putch(msg->p1);
/*
  msg->code=q->queue[q->head];
  msg->p1=q->queue[q->head+1];
  msg->p2=q->queue[q->head+2];
  q->head+=3;
  if (q->head>=q->tail) queue_reset(q);
//  lwp_enable;
*/
//  if (q->tail>=q->fill_level) return(0); //queue near full
//  if (abs(q->head-q->tail)>=q->fill_level) return(0);
//  n=0;
/*
  if (q->head<q->tail) {if (q->tail-q->head>=q->fill_level) n=1;}
  else
   if (q->head-q->tail<=q->size-q->fill_level) n=1;
*/
//  return(1);
}
END_OF_FUNCTION(app_msg_get);

//----------------------------- APP MSG PUT --------------------------------
// Put msg to the app->msq_queue.
// Return value: 1 if everything is Ok; 0 if queue near full,
// i.e. queue->tail>=queue->fill_level.
// By default fill_level=(2*queue->size)/3
// Zero means what msg puted successfuly, but, probably, some msgs may be
// lost in the future.
// Parameters :
// dz_app *app - app to wich msg posted.
// a_message code - on of the code listed in messages.h
// int p1 - msg parameter 1.
// int p2 - msg parameter 2.
// Note : usualy p1 and p2 are pointeres and it's meaning depend on msg type.
// Example:
// { dz_app *my_app;
//   app_msg_put(my_app,APP_HELLO_BUDY,0,0);
// }
int app_msg_put(dz_app *app,a_message code,int p1,int p2)
{ int tmp,i1;//,i2,i3;
  fifo_queue *q;
  dz_msg msg;

  lwp_disable;

  #ifdef __DZ_DEBUG__
  printf("#%s,%d,%d\n",app->szName,code,p1);
  #endif
  if (app==NULL) return(-1);
  q=app->msg_queue;
  if (q==NULL) return(-1);
  msg.code=code;
  msg.p1=p1;
  msg.p2=p2;

//  i1=queue_put(q,code);
//  i2=queue_put(q,p1);
//  i3=queue_put(q,p2);
//  putch(p1);
  i1=queue_put_(q,&msg);
  lwp_enable;
//  printf ("h-%d,t-%d,s-%d,f-%d\n",q->head,q->tail,abs(q->head-q->tail),q->fill_level);
  return(!i1);
}
END_OF_FUNCTION(app_msg_put);

//---------------------- SYSTEM HANDLER LWP------------------

int system_handler(a_message msg,int p1,int p2)
{ //dz_msg msg;
  char s[1024];
  char f[1024];
  char s1[255];
  int tmp;
//  queue_get_n(dev->write_queue,(int*)&msg,3,NORMAL);
//  msg_get(dev->write_queue,&msg);
  *s=0;
  *f=0;
  lwp_disable;
  switch (msg)
   { case SYS_STOP :
      palantir_deinit();
      lwp_enable;
      return(0);
      break;
//     case APP_START :
//      dz_app_unlock(app_(p1));
//      app_msg_put(app_(p1),APP_START,0,0);
//      app_(p1)->msg_handler(app_(p1)->dev);
//      break;
     case SYS_ERR_FOPEN :
      sprintf(s,"SYS_ERR_FOPEN : %s, errno %d\n",(char*)p1,p2);
      free((char*)p1);
      break;
     case  SYS_ERR_FWRITE :
      sprintf(s,"SYS_ERR_FWRITE : %s, errno %d\n",(char*)p1,p2);
      free((char*)p1);
      break;
     case  SYS_ERR_FREAD :
      sprintf(s,"SYS_ERR_FREAD : %s, errno %d\n",(char*)p1,p2);
      free((char*)p1);
      break;
     case  SYS_ERR_FCLOSE :
      sprintf(s,"SYS_ERR_FCLOSE : %s, errno %d\n",(char*)p1,p2);
      free((char*)p1);
      break;
     case  SYS_ERR_MKDIR :
      sprintf(s,"SYS_ERR_MKDIR : %s, errno %d\n",(char*)p1,p2);
      free((char*)p1);
      break;
     case  SYS_ERR_CHDIR :
      sprintf(s,"SYS_ERR_CHDIR : %s, errno %d\n",(char*)p1,p2);
      free((char*)p1);
      break;
     case  SYS_ERR_QUEUE_PUT_FAILED :
      sprintf(s,"SYS_ERR_QUEUE_PUT_FAILED : qsize %d,qhead %d\n",p1,p2);
      break;
     case  SYS_ERR_QUEUE_PUT_N_FAILED:
      sprintf(s,"SYS_ERR_QUEUE_PUT_N_FAILED : qsize %d,msg %d\n",p1,p2);
      break;
     case  SYS_QUEUE_PUT_RESET:
      sprintf(f,"SYS_QUEUE_PUT_RESET : qsize %d,qhead %d\n",p1,p2);
      break;
     case  SYS_QUEUE_PUT_N_RESET:
      sprintf(f,"SYS_QUEUE_PUT_N_RESET : qsize %d,qhead %d\n",p1,p2);
      break;
     case  SYS_QUEUE_PUT_RESIZE:
      sprintf(f,"SYS_QUEUE_PUT_RESIZE : qhead %d,qtail %d\n",p1,p2);
      break;
     case  SYS_QUEUE_PUT_N_RESIZE:
      sprintf(f,"SYS_QUEUE_PUT_N_RESIZE : qhead %d,qtail %d\n",p1,p2);
      break;
//     case  SYS_DEVICE_NEAR_FULL:
//      sprintf(f,"SYS_DEVICE_NEAR_FULL : dev %s,** %d\n",(char*)p1,p2);
//      break;
     default :
      break;
   }
  if (*s!=0||*f!=0)
   { FILE *ferr=fopen(wd_cat(s1,"error.log"),"at");
     if (ferr!=NULL)
      { if (*f) fprintf(ferr,"%s",f);
        if (*s) fprintf (ferr,"%s",s);
        fclose(ferr);
      }
     lwp_enable;
     if (*s) return(0);
   }
  lwp_disable;
  return(1);
}
//----------------------- DEVICE NEW  -------------------------
// Create new device structure. Size of read/write queues sets
// according to values read/size
device *device_new(char *szName,uint read_size,uint write_size)
{ return (device_new_(szName,read_size,write_size,4,4));
}
device *device_new_(char *szName,uint read_size,uint write_size,
                                 uint dread_size,uint dwrite_size)
{ int tmp;
  device *dev;
  odlist *wlist=odlist_new();
  odlist *rlist=odlist_new();

  lwp_disable;
  wlist=odlist_new();
  rlist=odlist_new();
  dev=(device*)malloc(sizeof(device));

  lwp_lock(&dev->status);
  //set device fields with default values
  if (dev==NULL||wlist==NULL||rlist==NULL)
   { free(dev);
     free(wlist);
     free(rlist);
     lwp_enable;
     return(NULL);
   }

  dev->write_client_tasks=wlist;
  dev->read_client_tasks=rlist;

  if (szName!=NULL)
   { strncpy(dev->szName,szName,64);
     dev->szName[63]=0;
   }
  dev->read_queue=NULL;
  dev->write_queue=NULL;
  dev->clients_read_queue=NULL;
  dev->clients_write_queue=NULL;
  dev->device_delete_handler=NULL;
  dev->device_read_handler=NULL;
  dev->device_write_handler=NULL;
  dev->device_put_handler=NULL;
  dev->device_empty_handler=NULL;
  dev->client_apps_status=0;
  dev->device_get_handler=NULL;
  dev->device_user_data=NULL;
  dev->read_code=M_VOID;
  dev->write_code=M_VOID;
  dev->stop_request=0;
  if (read_size!=0)
   { if ((dev->read_queue=queue_new_(read_size,dread_size))==NULL) return(NULL);
     dev->clients_read_queue=dev->read_queue;
   }
  if (write_size!=0)
   { if ((dev->write_queue=queue_new_(write_size,dwrite_size))==NULL)
      { queue_delete(dev->read_queue);
        return(NULL);
      }
     else dev->clients_write_queue=dev->write_queue;
   }

  _go32_dpmi_lock_data(dev,sizeof(device));

  lwp_unlock(&dev->status);
  lwp_enable;
  return(dev);
}

//---------------------- DEVICE DELETE -----------------------
// Delete device 'dev'
void device_delete(device *dev)
{ int tmp;

  lwp_disable;
  if (dev->device_delete_handler!=NULL) dev->device_delete_handler();
  queue_delete(dev->read_queue);
  queue_delete(dev->write_queue);
  free(dev);
  lwp_enable;
}

//------------------------ DEVICE PUT ------------------------------
/*
int device_put(device *dev,int c)
{ int r;
  if (dev->device_put_handler==NULL) return(-1);
  r=dev->device_put_handler(c);
  return(r);
}

//------------------------ DEVICE GET ------------------------------

int device_get(device *dev)
{ int r;
  if (dev->device_get_handler==NULL) return(-1);
  r=dev->device_get_handler();
  return(r);
}
*/
//----------------------- DEVICE CLIENT TASK ADD  ------------------------
// Add client app to the device. Currently Palantir defines such devices :
// keyboard_device,mouse_device,comm_port. First two devices hardcoded and
// you can use them directly. Since comm_port device defined by user via
// DZComm extencion, you should use your own definition of it. You may setup
// as many client apps for one device as you like. Not prohibited to
// install one client app to many devices.
// Parametrs :
// device *dev - device - source of data.
// dz_app *task - your app wich will recieve data from device
// client_status client - may take values READ,WRITE,BOTH
// READ means client needs only data what comes from device.
// For keyboard_device and mouse_device this is the only possible value.
// WRITE means client needs only data what writes to device.
// For comm_port this is more useful value.
// BOTH means client needs both read/write device data streams.
// Return values : NULL if failed; pointer to the struture client_task if
// successful.
// Example :
// {
// keyb_app=dz_app_new("KBD APP",16384,1,keyboard_handler);
// device_client_task_add(keyboard_device,keyb_app,READ);
// }
// Or :
// {
// common_app=dz_app_new("COMMON APP",16384,1,common_handler);
//
// device_client_task_add(keyboard_device,common_app,READ);
// device_client_task_add(mouse_device,common_app,READ);
// }

client_task *device_client_task_add(device *dev,dz_app *task,client_status client)
{ client_task *ctask;
  int tmp;
  int i=0;
//status may be on of READ, WRITE, BOTH
  lwp_disable;
  ctask=ctask_(malloc(sizeof(client_task)));
  lwp_enable;
  lwp_lock(&ctask->status);
  if(ctask==NULL||dev==NULL||task==NULL) return(NULL);

  ctask->client=client;
  ctask->task=task;

  if (client==READ||client==BOTH)
    if (odlist_data_check(dev->read_client_tasks,ctask)==0)
      if (odlist_insert(dev->read_client_tasks,ctask)==NULL)
       { free(ctask);
         lwp_unlock(&ctask->status);
         return(NULL);
       }
      else i=1;

  if (client==WRITE&&client==BOTH)
    if (odlist_data_check(dev->write_client_tasks,ctask)==0)
      if (odlist_insert(dev->write_client_tasks,ctask)==NULL)
       { free(ctask);
         lwp_unlock(&ctask->status);
         if (i)  odlist_remove(dev->read_client_tasks,ctask);
         return(NULL);
       }
  lwp_unlock(&ctask->status);
  return(ctask);
}

//------------------ DEVICE CLIENT TASK REMOVE  --------------------
// Removes given app from device clients list.
// Parameters :
// device *dev - device source of data
// dz_app *task - previously installed client app.
// client_status client - READ,WRITE,BOTH.
// Example :
// { dz_app *comm_app;
//   my_app=dz_app_new("COMM APP",16384,1,comm_handler);
//
//   device_client_task_add(comm_port,comm_app,BOTH);
//   ...
//   device_client_task_remove(comm_port,comm_app,READ);
//   ...
//   device_client_task_remove(comm_port,comm_app,WRITE);
// }

void device_client_task_remove(device *dev,dz_app *task,client_status client)
{ odelement *cur;
//status may be on of READ, WRITE, BOTH
  if (client==READ||client==BOTH)
   { lwp_lock(&(dev->read_client_tasks)->status);
     cur=(odelement*)(dev->read_client_tasks)->first;
     while (cur!=NULL);
      { if (ctask_(cur)->task==task)
         { lwp_unlock(&(dev->read_client_tasks)->status);
           odlist_remove(dev->read_client_tasks,cur);
           cur=NULL;
         }
        else cur=cur->next;
      }
   }
  lwp_unlock(&(dev->read_client_tasks)->status);

  if (client==WRITE||client==BOTH)
   { lwp_lock(&(dev->write_client_tasks)->status);
     cur=(odelement*)(dev->write_client_tasks)->first;
     while (cur!=NULL);
      { if (ctask_(cur)->task==task)
         { lwp_unlock(&(dev->write_client_tasks)->status);
           odlist_remove(dev->write_client_tasks,cur);
           cur=NULL;
         }
        else cur=cur->next;
      }
   }
  lwp_unlock(&(dev->write_client_tasks)->status);
}


//---------------------- WD CAT -----------------

char * wd_cat(char *buf,char *f_name)
{
  sprintf(buf,"%s%s",wd,f_name);
  return(buf);
}

//------------------------- ADD IDLE PROC --------------------
// Add function called by idled (idle daemon).
// If you have some function wich you wish to call periodicaly, but
// don't want spawn a whole app or lwp_thread and the purpose of
// this function just to do some computatios (for example clock), and it
// isolated from other apps and threads there is so-called idled
// (idle daemon) wich call it for you each time it gets CPU time slice.
// Parameters :
// int (*hnd)(void) - pointer to function wich you wish to be called by idled
// Return values : 1 if successful, 0 if failed.
// Example :
// int clock(void)
// { ...;
//   return(1);
// }
// {
//   if (!idle_proc_add(clock));
// }
// Note : if you return 0 from idle_proc, it will be removed from
// function list wich called by idled.
int idle_proc_add(int (*hnd)(void))
{ idle_app *app;
  odelement *cur;
  int tmp;

  lwp_disable;
  cur=idle_proc->first;
  while (cur!=NULL)
   { app=(idle_app*)(cur->data);
     if (app->idle_handler==hnd)
      { lwp_enable;
        return(1);
      }
     cur=cur->next;
   }
  if ((app=(idle_app*)malloc(sizeof(idle_app)))==NULL)
    { lwp_enable;
      return(0);
    }
  lwp_enable;
  app->idle_handler=hnd;
  if (odlist_insert(idle_proc,app)==NULL) return(0);
  return(1);
}
//-------------------- IDLE PROC REMOVE -----------------------
// Removes functions from idled list previously added by idle_proc_add
// Parameters :
// int (*hnd)(void) - pointer to function wich called by idled.
// Example :
// int clock(void)
// { ...;
//   return(1);
// }
// {
//   if (!idle_proc_add(clock));
//   ...
//   idle_proc_remove(clock);
// }
// Note : if you return 0 from idle_proc, it will be removed from
// function list wich called by idled,
// so you don't need call idel_proc_remove in such a case.
void idle_proc_remove(int (*hnd)(void))
{ odelement *cur;
  idle_app *app;
  int tmp;

  cur=idle_proc->first;
  if (cur==NULL) return;

  lwp_disable;
  while (cur!=NULL)
   { app=(idle_app*)(cur->data);
     if (app->idle_handler==hnd)
      { odlist_remove(idle_proc,app);
        lwp_enable;
        return;
      }
     cur=cur->next;
   }
  lwp_enable;
  return;
}

//--------------------- PALANTIR DEINIT --------------------
// Post APP_STOP to all running apps. Set global variable exit_program to 1.
// Call this function to terminate whole system.
// Example :
// Here is the minimal keyboard handler you will wish to have -
// int keyboard_handler(a_message code,int p1,int p2)
// { int c=p1;
//   char ch=ascii_(c);
//   switch(code)
//    { case H_KEYBOARD :
//        if (ctrl_(c,'Q'))
//         { palantir_deinit();
//           return(0);
//         }
//      default:
//       break;
//    }
//   return(1);
// }
void palantir_deinit()
{
  odelement *cur=(odelement*)palantir_app_list->first,*next=NULL;

  if (events_installed==0) return;
  events_installed=0;
  #ifdef __DZ_DEBUG__
  printf ("Palantir deinit...\n");
  #endif

  while(cur!=NULL)
   { next=cur->next;
     app_msg_put(app_(cur->data),APP_STOP,0,0);
     #ifdef __DZ_DEBUG__
     printf ("App killed : %s\n",app_(cur->data)->szName);
     #endif
     cur=next;
   }
  chdir(wd);
  lwp_stop=1;
//  exit_program=1;
  return;
}

static void dz_signal_handler(int num)
{
   static char msg[] = "Shutting down Allegro and Palantir\r\n";
   char msg1[64];

   sprintf(msg1,"\nAPP : %s, %d\r\n",app_(_lwp_cur->usrptr)->szName,_dummy_count);
   allegro_exit();
   palantir_deinit();

   _write(STDERR_FILENO, msg, sizeof(msg)-1);
   _write(STDERR_FILENO, msg1, sizeof(msg)-1);

   signal(num, SIG_DFL);
   raise(num);
}

//---------------------- PALANTIR INIT ---------------------
// Initialise Palantir kernel.
// Call this function before all other Palantir related stuff.
// palantir_init calls allegro_init,timer_init and lwp_init, so
// you don't need call this function by youself.
// Parameters :
// int devs - bit field indicates wich device you wish to install.
// use mix of DEV_KEYBOARD|DEV_MOUSE|DEV_COMMS to specify desired
// configuration.
// Return value : 1 if Ok, 0 if failed.
// Example :
// {
//   if (!palantir_init(DEV_KEYBOARD|DEV_COMMS)) abort(); // installs
//   // keyboard and comms without mice support.
// }
int palantir_init(int devs)
{
  palantir_app_list=odlist_new();
  if (palantir_app_list==NULL) return(0);

  allegro_init();
  queue_init();
  LOCK_FUNCTION(app_msg_put);
  LOCK_FUNCTION(app_msg_get);

  wd=(char*)malloc(PATH_MAX);
  LOCK_VARIABLE(wd);
  getwd(wd); //get working directory
  strcat(wd,"/");

  exit_programm=0;
//  cur_y=1;
  idle_proc=odlist_new();
  LOCK_VARIABLE(idle_proc);

  lwp_init(8,RTC512); //really RTC512 doesn't matter
  install_timer();

  mouse_device=NULL;
  LOCK_VARIABLE(mouse_device);
  if (devs&DEV_MOUSE)
   if (install_mouse()==-1) return(0);

  keyboard_device=NULL;
  LOCK_VARIABLE(keyboard_device);
  if (devs&DEV_KEYBOARD)
    if (install_keyboard()==-1) return(0);

  if (devs&DEV_COMMS) dzcomm_init();

  if (!scheduler_init()) return(0);

  if ((system_app=dz_app_new("SYSTEM APP",8192,1,system_handler))==NULL) return(0);
  lwp_spawn(idled,16384,1,NULL,NULL);

  signal(SIGFPE,  dz_signal_handler);
  signal(SIGSEGV,  dz_signal_handler);

  atexit(palantir_deinit);
  events_installed=1;
  _lwp_enable=0;
  return(1);
}

//----------------------- BLOCK_DEVICE --------------------------
void device_stop_recive(device *dev,dz_app *app)
{ odelement *cur;

  cur=(dev->read_client_tasks)->first;
  while(cur!=NULL)
   { if (ctask_(cur->data)->task==app)
      { dev->client_apps_status=1;
        lwp_lock(&app->status);
        return;
      }
     cur=cur->next;
   }
  return;
}

void device_stop(device *dev)
{
  dev->stop_request++;
  return;
}

//---------------------- RELEASE_DEVICE -------------------------
void device_resume_recive(device *dev,dz_app *app)
{ odelement *cur;
  int i=1;
  cur=(dev->read_client_tasks)->first;
  while(cur!=NULL)
   { if (ctask_(cur->data)->task==app)
      lwp_unlock(&app->status);
     if (ctask_(cur->data)->task->status==LWP_LOCKED) i=0;
     cur=cur->next;
   }
  if (i)
   { dev->client_apps_status=0;
     if (dev->read_queue->empt==EMPTY&&dev->device_empty_handler)
       dev->device_empty_handler(dev);
   }

  return;
}

void device_resume(device *dev)
{
  if (dev->stop_request) dev->stop_request--;
  if (dev->stop_request) return;
  if (dev->read_queue->empt==EMPTY&&dev->device_empty_handler)
   dev->device_empty_handler(dev);

  return;
}

