#include "mxwin.h"


/* main event loop variables */
BOOL main_loop = TRUE;
EVENT event;


/* root proc; it does not do anything special, it just draws a blue background */
int root_proc(WINDOW wnd, void *wnd_data, int msg, void *msg_data)
{
    RECT r;
    int bg_color;

    switch (msg) {

        /* the paint event; here is the drawing of the root window */
        case WE_PAINT:

            /* get the screen rectangle of the window; needed so as 
               we can draw with Allegro */
            GetWindowRect(wnd, &r);

            /* no need for patterned drawing */
            solid_mode();

            /* create the background color */
            bg_color = makecol(0, 0, 255);

            /* begin paint (FALSE means paint under children) */
            BEGIN_PAINT(wnd, msg_data, FALSE);

            /* paint a rectangle using the good old Allegro */
            rectfill(screen, r.left, r.top, r.right, r.bottom, bg_color);

            /* no more painting */
            END_PAINT();
    }
    return 0;
}


/* the hello world window proc */
int hello_world_proc(WINDOW wnd, void *wnd_data, int msg, void *msg_data)
{
    int bg_color, text_color, cx, cy;
    RECT r;

    switch (msg) {
        case WE_PAINT:

            /* setup phase */
            solid_mode();
            text_mode(-1);
            bg_color = makecol(255, 255, 255);
            text_color = makecol(0, 0, 0);
            GetWindowRect(wnd, &r);
            cx = r.left + ((GetWindowWidth(wnd)) >> 1);
            cy = r.top + ((GetWindowHeight(wnd) - text_height(font)) >> 1);

            /* drawing phase */
            BEGIN_PAINT(wnd, msg_data, FALSE);       
            rectfill(screen, r.left, r.top, r.right, r.bottom, bg_color);
            textout_centre(screen, font, "Hello World!", cx, cy, text_color);
            rect(screen, r.left, r.top, r.right, r.bottom, text_color);
            END_PAINT();
            return TRUE;

        case WE_LBUTTONDOWN:
            /* exit main loop when clicked */
            main_loop = FALSE;
            return TRUE;
            
    }
    return 0;
}


/* main */
int main(int argc, char *argv[])
{
    /* our windows */
    WINDOW root, hello1;

    /* install Allegro and set video mode */
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();
    set_color_depth(8);
    if (set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0) < 0) return -1;
    show_mouse(screen);

    /* create the root window */
    root = CreateWindow(root_proc, NULL, 0, 0, SCREEN_W, SCREEN_H, WF_MISC, NULL);

    /* create the hello world window as a child of root */
    hello1 = CreateWindow(hello_world_proc, root, 35, 30, 250, 150, WF_MISC, NULL);

    /* show all windows */
    ShowWindow(root);

    /* main loop; it can be stopped by pressing a key */
    while (main_loop && !keypressed()) {
        if (GetEvent(&event)) DispatchEvent(&event);
    }

    return 0;
}


