/* 
 *    Example program for the MDLib library, by Pedro Ramalhete
 *
 *    This is a very simple program for displaying a Q1 model
 */
#include "mdlib.h"

#define TICK 1


int main(void)
{
   mdl_t model;
   camera_t cam;
   BITMAP *dbuf;
   PALETTE pal;

   allegro_init();
   install_keyboard();

   set_gfx_mode( GFX_AUTODETECT, 320, 200, 0, 0 );

   // set the viewport (very important!)
   set_projection_viewport( 0, 0, SCREEN_W, SCREEN_H );

   // create a double buffer
   dbuf = create_bitmap(SCREEN_W, SCREEN_H);
   clear( dbuf );

   // load the Q1 palette
   destroy_bitmap( load_bitmap("models/quake1.pcx", pal) );
   set_palette( pal );

   // load the model
   model = MDLLoad("models/model.mdl");

   // init the camera
   cam = CameraFixed(0., -10., -60., 0., 0., 0.);

   while(!key[KEY_ESC])
   {
      MDLUpdateView( cam, &model );
      MDLDrawTexture( dbuf, &model );

      blit( dbuf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );
      clear( dbuf );

      if(key[KEY_UP]) cam.pitch += TICK;
      if(key[KEY_DOWN]) cam.pitch -= TICK;
      if(key[KEY_LEFT]) cam.roll += TICK;
      if(key[KEY_RIGHT]) cam.roll -= TICK;
      if(key[KEY_Z]) cam.z--;
      if(key[KEY_A]) cam.z++;
      if(key[KEY_S]) cam.head -= TICK;
      if(key[KEY_X]) cam.head += TICK;
      if(key[KEY_PLUS_PAD]) if(model.frameidx<model.numframes-1) model.frameidx++;
      if(key[KEY_MINUS_PAD]) if(model.frameidx>0) model.frameidx--;

   }


   remove_keyboard();
   destroy_bitmap(dbuf);

   return 0;
}
