#define VERSNR V3.01
#define MDK__
#include <allegro.h>
#include <stream.h>
#include <iostream.h>
#include <fstream.h>
#include <_string.h>
#include "pall.h"
#include <string.h>
#include "ids.h"
#include "setup.h"
#include "objhelp.h"
/*

*
* MICHIS DIALOGKISTE V3.01
*
* 1997 BY Michi Schuster
* 
* email: Schuster@eev.e-technik.uni-erlangen.de 

*/

/* 
 * number_Dialogs is for numbering Dialogs with comments in C outputfiles
 */

 int number_Dialogs=1;
int SoundCardPresent=-1;
extern "C"{
  char* allegro_grabber(int*,char **);
 }



/*
 * _W/_H is the draw area 
 * 
 * */


int _W= 600;
int _H= 480;
int LANGUAGE=0;
/*
 * These variables should be self explaining- the default sizes of the objects
 * If you change the options, a CONFIG.CFG - file will be created.
 * 
 * */
int max_clearobj=2;
int max_keyobj=30;
int max_boxobj=30;
int max_sboxobj=30;
int max_buttonobj=30;
int max_textobj=80;
int max_textboxobj=20;
int max_ctextobj=30;
int max_checkobj=30;
int max_listobj=30;
int max_editobj=50;
int max_bitmapobj=30;
int max_iconobj=30;
int max_radioobj=30;
int max_menobj=20;
int max_sliderobj=30;
int list_size=20;

int FG=251;
int BG=46;
int GRID=6;

int __W=800;
int __H=600;
int LEVELS=25;
int FUNC=30;

int COMMENTS=D_SELECTED;
int DEFINE=D_SELECTED;
int SAVE_32bit_COLOR=D_SELECTED;
int INITFUNCTION_COLOR=D_SELECTED;
int INITFUNCTIONS_BITMAP=D_SELECTED;
int INITFUNCTIONS_LISTBOXES=D_SELECTED;
int INIT_CHAR=D_SELECTED;
int INIT_GLOBAL=D_SELECTED;
int WRITE_COLORS_STATIC=0;

extern "C"
{
 #include "grabber.h"
 void mouse_position(void);
 }

#define STRINGLENGTH 60
#define WAIT 1

#define ITEMS 20
//Some Commands

#define BLIT show_mouse(NULL);blit(Gui_area,screen,0,0,X_GUI,Y_GUI,_W,_H);show_mouse(screen)
#define str input_string(X_GUI,Y_GUI+_H+20,string_helper,251,125)
#define stri input_(X_GUI,Y_GUI+_H+20,string_helper,251,125)

int X_GUI;
int Y_GUI;

#define OUTPUTFILE "output.c"
#define EXPORTFILE "export.mdk"
#define INPUTFILE "input.c"
char pal_file[256]="pall.dat";

DATAFILE* set_up;
DATAFILE* picture;
DATAFILE* bitmaps;
BITMAP* Gui_area;
BITMAP* temp_area;
BITMAP* MICHI;
BITMAP* Schrift;
BITMAP* Screen;

BITMAP* My_centre_pointer;
BITMAP* My_mouse_pointer;
BITMAP* My_mouse_pen;
BITMAP* My_move_pointer;
BITMAP* My_nothing_to_do_pointer;
BITMAP* My_busy_pointer;

PALETTE MDK_pal;

ofstream fout;
ifstream fin;
ofstream configout;
ifstream configin;

int color_depth=16;
char string_helper[180];
int *num_all;
char **str_all;
char RecentFile[256];//=(char*) malloc(sizeof(char)*256);;

#include "dialog.h"
#include "dbitmap.h"
#include "mdk_desk.h"
#include "li_tmpl.h"
#include "objhelp.h"

/* 
 * This is the error handler.
 * Mainly for loading and size errors. If you want to load more objects than you 
 * have enabled this will give a warning
 * */

char* grabber_call (int *number, char* file[])
{
   char ret[256];
   fout.close();
   strcpy(ret,allegro_grabber(number,file));
   set_color_depth(color_depth);
   set_gfx_mode(GFX_AUTODETECT,__W,__H, 0, 0);
   set_pallete(MDK_pal);
   rebuild_screen();
   gui_fg_color=palette_color[128];
   gui_bg_color=palette_color[37];
   return ret;
}


/*
 * 
 * The next definition is because of the behaviour of Allegros 
 * list selector- function. The Pointer to the dp field of a 
 * list-box seems to have to be defined globally 
 * 
 * */
char** listobjects;
char* Liste5 (int index, int* listsize) {
    if (index < 0)
	 { *listsize =list_size;
	   return NULL;}
         else return listobjects[index];}


class menu_item
/*
 * Allegro's MENUs items have a name, and are conntected to a
 * Function (function_name) or a Menu (connect_function) 
 *
 * clear() 
 *      clears the dependency and sets them to 0;
 * func_exe(char* func)
 *      connects to function_name
 * submenu(char* submen)
 *      connects to submenu
 * */


     {
	
      public:
	char name[STRINGLENGTH];
	char function_name[STRINGLENGTH];
	char connect_func[STRINGLENGTH];
	int connect;
	
      public:
	menu_item()
	  {
	     strcpy(name,"NULL");
	     strcpy(function_name,"NULL");
	     strcpy(connect_func,"NULL");
	     connect=0;
	     
	  }
	void clear()
	{
	     strcpy(function_name,"NULL");
	     strcpy(connect_func,"NULL");
	     connect=0;
	 }

	void name_item( char* title)
	{
	 strcpy(name,title);
	 }
	void func_exe( char* func)
	  {
	     strcpy(function_name,func);
	     connect=1;
	  }

	void submenu( char* menu_)
	  {
	     strcpy(connect_func,menu_);
	     connect=2;
	     }


	void save()
	  {
	     fout<<"\n { \""<<name<<"\"\t, "<<function_name<<" \t,"<<connect_func<<"},";
	  }

	void export()

	{
	     if (!strcmp(name," ")) strcpy(name,"@");
	     if (!strcmp(name,"")) strcpy(name,"@");

	     fout<<"\n "<<name<<"\n"<<function_name<<"\n"<<connect_func<<"\n"<<connect;
	  }
	void import()
	  {
	     fin>>name>>function_name>>connect_func>>connect;
	     if (!strcmp(name,"@")) strcpy(name,"");

	  }



      };
/*
 * Just like  textout
 * */

int text( char* s,int x, int y, int fg,int bg,int DRAW,BITMAP* b = Gui_area)

     {
	unsigned char tmp[160];
	int c;
	int len = 0;
	int pix_len;
	int hline_pos = -1;
	
	text_mode(bg);
	for (c=0; (s[c]) && (len<159); c++) {
	   if (s[c] == '&') {
	      if (s[c+1] != '&')
		hline_pos = len;
	      else {
		 tmp[len++] = '&';
		 c++;

     }
	   }
	   else
	     tmp[len++] = s[c];
	}
	
	tmp[len] = 0;
	pix_len = text_length(font, tmp);
	if (DRAW) {
	   textout(b, font,tmp, x, y, fg);
	   
	   if (hline_pos >= 0) {
	      c = tmp[hline_pos];
	      tmp[hline_pos] = 0;
	      hline_pos = text_length(font, tmp);
	      tmp[0] = c;
		   tmp[1] = 0;
	      c = text_length(font, tmp);
	      hline(b, x+hline_pos, y+text_height(font), x+hline_pos+c-1, fg);
	     
	   }
	    
	}
	return pix_len;
     }

#define MAXITEMS 20
class Menu
/* 
 * Holds a number of menus, declared in the constructor,
 * this number is the global sub_menobj and defines how many 
 * items a Menu can maximal contain
 *
 * _level() 
 *          is for giving default names of the menus (strored in 
 *          char level[]) like "Menu0" up to Menu25 (if the maxium 
 *          of Menus is 25). 
 * declare_main()
 *          declares the menu as the Main Menu,wich is pointed to 
 *          by the d_menu_proc dp-field
 * clear_main()
 * edit_item()
 * clear_item()
 *          These should explain themselves
 * 
 * *char show(int) 
 * *char type(int)
 *           These give back the type and the connections of the item[num]
 *      
 * draw()
 *          Draws the menu in Allegro v2.1 style
 *                                           
 * import()
 * export()
 * save()       
 *           The same as in dialog class
 * */

     {
	      private:
	menu_item* items;
	
      public:
	
	char level[STRINGLENGTH];
	int size;
	int main;
	int max;
	
	Menu(int num)
	  {
	     size=0;
	     main=FALSE;
	     items=new menu_item[num];
	     max=num;
        for (int a=0;a<max;a++) level_(a);
	     
	  }
	~Menu()
	{
      delete[] items;
	 }
	level_(int num)
	  {
	     char levelnumber[STRINGLENGTH];
	     strcpy(level,"Menu");
	     itoa(num,levelnumber,10);
	     strcat(level,levelnumber);
	  }
	
	void clear(int num)
	  {
	     items[num].clear();
	  }
	
	void declare_main(MainMenu& con)
	  {
	     main=TRUE;
	     con.dp=level;
	  }
	
	void clear_main()
	  {
	     main=FALSE;
	     
	  }
	void edit_item(int num,char* it)
	  {
	     if (num<size)
	       items[num].name_item(it);
	  }
	
	void add_item(char* it)
	  {
	     items[size].name_item(it);
	     size++;
	  }
	void del()
	  {
	     if (size>0)
	       {
		  size--;
		  items[size].name_item("NULL");
		  items[size].connect=0;
	       }
	     
	  }
	
	void submenu(char* menu,int num)
	  {
	     items[num].func_exe("NULL");
	     items[num].submenu(menu);
	  }
	void func_exe(char* func,int num)
	  {
	     items[num].submenu("NULL");
	     items[num].func_exe(func);
	  }
	char* show(int num)
	  {
	     int a=items[num].connect;
	     if (a)
	       {
		  if(a==1)  return items[num].function_name;
		  if (a==2) return items[num].connect_func;
		  
	       };
	     return "NULL";
	     
	  }
	char* type(int num)
	  {
	     int a=items[num].connect;
	     if (a)
	       {
		  if (a==1) return "Function";
		  if(a==2)  return "Menu";
	       };
	     return "undefined";	     
	  }
	void help()
       {
        set_object_help_menu();
        do_help();
         };
	String name(int order)
	  {
	     return String(items[order].name);
	  }
	
	
	void draw()
	  {
	     if (size>0)
	       {
		  show_mouse(NULL);
		  if(main==FALSE)
		    {
		       int x,y,w,h,bg,fg;
		       w=0;
		       y=50;
		       x=50;
		       fg=FG;
		       bg=BG;
		       for(int t=0;t<size;t++)
			 {
			    if (text( items[t].name,0,0,0,0,0)>w)
			      w=text( items[t].name,0,0,0,0,0);
			 }
		       
		       ;
		       h=text_height(font);
		       rectfill(Gui_area, x-1, y-1, x+w, y+h*size+1, bg);
		       rectfill(Gui_area, x-1, y-1, x+w, y+h*size+1, bg);
		       rect(Gui_area, x-1, y-1, x+w, y+h*size+2, fg);

		       for(int t=0;t<size;t++)
			 {
			    text(items[t].name,x,y+t*h,fg,bg,1);
			 }
		       
		       
		    }
		  else
	    {
		       int x,y,w,h,bg,fg;
		       w=0;
		       y=2;
		       x=2;
		       fg=FG;
		       h=text_height(font);
		       
		       bg=BG;
		       
		       for(int t=0;t<size;t++)
			 {
			    w=w+text(items[t].name,0,0,0,0,0);
			    
			 }
		       w=w+12*(size-1);
		       
		       rectfill(Gui_area, x-1, y-1, x+w+1, y+h+1, palette_color[bg]);
		       rect(Gui_area, x-1, y-1, x+w, y+h+2, palette_color[fg]);
		       
		       for(int t=0;t<size;t++)
			 {
			    x=x+text(items[t].name,x,y,fg,bg,1)+12;
			 }
		       
		       
		       
		    }
		  
		  show_mouse(screen);
	       }
	  }
	
	void save()
	  {
	     if (size)
	       {
		  fout<<"\n MENU "<<level<<"[] ={";
		  for ( char t=0;t<size;t++)
		    items[t].save();
		  fout<<"\n { NULL,\t NULL,\t NULL },\n };";
	       }
	  }
	void export()
	  {

	     fout<<"\n"<<size;
	     fout<<"\n"<<level;
	     for ( char t=0;t<size;t++)
	       items[t].export();
	     }
	
	void import()
	  {
	     
	     fin>>size;
           if (size>max) error(5);
           fin>>level;
	     for ( char t=0;t<size;t++)
	       items[t].import();

	  }
	
	
     };




/*
 * The next lists are for handling the different Listboxes
 * and should be seen as a perhaps not nice but a functional way to handle
 * dynamic listboxes in C++.
 * If someone can do it better, mail PLEASE
 * 
 * */

char** menustrings;

char* Liste2(int index, int* list_size)
     {
	if (index < 0)
	  { 
	     
	     *list_size = max_menobj;
	     return NULL;}
	else return menustrings[index];
     }

char** keystrings;

char* Liste1 (int index, int* list_size)
     {
	if (index < 0)
	  { 
	     *list_size =max_keyobj;
	     return NULL;}
	else return keystrings[index];
     }

char** functions;

int func_size=FUNC;

char* Liste3 (int index, int* list_size) {
   if (index < 0)
     {
	*list_size =func_size;
	return NULL;
     }
   else return functions[index];}

char** kids;

int kids_size=LEVELS;
char* Liste4 (int index, int* list_size) {
   if (index < 0)
     { *list_size =kids_size;
	return NULL;}
   else return kids[index];}



class gui_d_key_holder
/*
 * The key_holder is a container for the key_procs
 * methods (export,import...) have the same function as in the dialog class
 * 
 * */
     {
  gui_d_keyboard_proc* items;
	String* strings;
   int size;
	int mxs;
      public:
	
	gui_d_key_holder(int max)
	  {
	     items= new gui_d_keyboard_proc[max]("","");
	     strings=new String[max]("");
	     size=0;
	     mxs=max;
	  }
	
	~gui_d_key_holder()
	  {
	     delete[] items;
	     delete[] strings;
	  }
	run()
	  {
	     for (int zu=0;zu<mxs;zu++)
	       strcpy(keystrings[zu],strings[zu]);
// Allegro - C- code done with MichisDialogkiste
	     //                   MDK 3.0b
#define _KEY_DIA_LISTE1 1
#define _KEY_DIA_NEW 4
#define _KEY_DIA_DEL 5
#define _KEY_DIA_MORE 6
#define _KEY_DIA_HELP 7
#define _KEY_DIA_DONE 8
     char name[] = "Keyboard Shortcut";
     char header[20];
     if (size) strcpy(header,"Already defined");else strcpy(header,"none defined");
	     
DIALOG key_dia[]= {
   /* 0 */	{ d_shadow_box_proc ,	154 ,	90 ,	276 ,	168 ,	palette_color[5] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
   /* 1 */	{ d_list_proc ,	184 ,	132 ,	156 ,	108 ,	palette_color[5] ,	palette_color[28] ,	0 ,	D_EXIT,	0 ,	0 ,	Liste1},
   /* 2 */	{d_text_proc ,	166 ,	102 ,	180 ,	12 ,	palette_color[249] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 name },
   /* 3 */	{d_text_proc ,	184 ,	120 ,	144 ,	12 ,	palette_color[137] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 header },
   /* 4 */	{d_button_proc ,	358 ,	132 ,	54 ,	12 ,	palette_color[18] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "New" },
   /* 5 */	{d_button_proc ,	358 ,	156 ,	54 ,	12 ,	palette_color[18] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Del" },
   /* 6 */	{d_button_proc ,	358 ,	180 ,	54 ,	12 ,	palette_color[18] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
   /* 7 */	{d_button_proc ,	358 ,	228 ,	54 ,	12 ,	palette_color[18] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
   /* 8 */	{d_button_proc ,	358 ,	204 ,	54 ,	12 ,	palette_color[18] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Done" },
  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
     };

   do{
   		centre_dialog(key_dia);
	   	popup_dialog(key_dia,-1);
		 if (key_dia[_KEY_DIA_NEW].flags==MSG_DCLICK)
	        {
                strings[size]=items[size].input();
                strcpy(keystrings[size],strings[size]);
                items[size].dp=strings[size];
          	    size++;

               }
		
		if (key_dia[_KEY_DIA_DEL].flags==MSG_DCLICK)
        	  {
		  
        	   if (size>0)
		       {
			     strings[size-1]="";
   			  strcpy(keystrings[size-1],"");
              items[size-1].copy(items[size]);
              items[size].dp="func?";
		        size--;
		       }

		  }
		if (key_dia[_KEY_DIA_LISTE1].flags==MSG_DCLICK)
		  {
		     if (key_dia[_KEY_DIA_LISTE1].d1<size)
		       {
			  items[key_dia[_KEY_DIA_LISTE1].d1].input();
			  strings[key_dia[_KEY_DIA_LISTE1].d1]=items[key_dia[_KEY_DIA_LISTE1].d1].dp;
			  strcpy(keystrings[key_dia[_KEY_DIA_LISTE1].d1],strings[key_dia[_KEY_DIA_LISTE1].d1]);
		       }
		  }

		if (key_dia[_KEY_DIA_HELP].flags==MSG_DCLICK)
		  {
		   items[0].help();
		   }

        for (int zu=0;zu<mxs;zu++)
	          strcpy(keystrings[zu],strings[zu]);

	     }while (key_dia[_KEY_DIA_DONE].flags!=MSG_DCLICK);
	     
	  }
	export()
	  {
	     fout<<"\n "<<size;
	     for (int t=0;t<size;t++)
	     items[t].export();
	  }
	import()
	  {
	     fin>>size;
	     if (size>mxs) error(6);
	     for (int t=0;t<size;t++) strings[t]=items[t].import();
	  }
	save(int line_nr)
	  {
	     for (int t=0;t<size;t++)
	       items[t].save(line_nr+t);
	  }
     };

class menucontainer
/* 
 * This class holds the Menus and their handling
 * The number of *Menus is LEVEL (global), the depth of each Menu is 
 * sub_menobj (constructor num) the number of Functions is FUNCS
 * run() aktivates the do_levels() which is handles the Menus
 * 
 * do_dependencies()
 *         handels the connections inbetween the menus and functions
 * Again there is import(), export(), save()
 *
 * */
{
   MainMenu mm;
   Menu* menues;
   String name;
   String* select;
   int max;
   int level;
   int size;
   String* functs;
   String* functs_type;
   int func_counter;
   
   
 public:
   menucontainer(int num,char* tex):mm("MainLevel")
     {
	name=tex;
	level=0;
	size=0;
	max=num;
	
	select=new String[num]("**EMPTY**");
	menues=new Menu[LEVELS](num);
	functs=new String[FUNC]("**EMPTY**");
	functs_type=new String[FUNC]("none");
	func_counter=0;
	
	
	for (int t=0;t<LEVELS;t++) menues[t].level_(t);
	menues[0].declare_main(mm);
	
	
     }     
	~menucontainer()
     {
	delete[] select;
	delete[] menues;
	delete[] functs;
	delete[] functs_type;
     }
   int run()
     {
	int next=0;
	
	do
	  {
	     next=do_levels(next);
	  }
	while ((next>-1)& (next<LEVELS));
	
     }
   
   int draw()
     {
	//          if (size)
	menues[0].draw();
     }
   
   int do_levels(int num)
     
     {
	int next;
	/* Allegro - C- code done with MichisDialogkiste */
	
	level=num;
	char Menu_name[STRINGLENGTH];
	strcpy(Menu_name,menues[level].level);
	
	
#define NEW2 7
#define DEL2 8
#define EDIT2 9
#define EXIT2 12
#define LISTE 13
#define NEXT 10
#define PROCEED 11
#define DRAW2 14
#define HELP2 15
	DIALOG menu_dialog[]= {
	     { d_shadow_box_proc ,      208 ,   96 ,    420 ,   252 ,  palette_color[28],    palette_color[16] ,    0 ,     0 ,     0 ,     0 ,     NULL},
	     { d_shadow_box_proc ,      232 ,   132 ,   372 ,   180 ,   palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,     NULL},
	     { d_shadow_box_proc ,      400 ,   156 ,   168 ,   108 ,   palette_color[118] ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},
	     { d_text_proc ,    388 ,   108 ,   120 ,   12 ,   palette_color[9],     palette_color[16] ,    0 ,     0 ,     0 ,     0 ,     UserText[MENU_TREE_] },
	     { d_text_proc ,    244 ,   144 ,   108 ,   24 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[MENU_NAME_] },
	     { d_text_proc ,    412 ,   168 ,   132 ,   12 ,    palette_color[97] ,   palette_color[28],    0 ,     0 ,     0 ,     0 ,     UserText[CHANGING_THIS_MENU_] },
	     { d_text_proc ,    256 ,   288 ,   108 ,   24 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[DOUBLE_CLICK_ON_MENU_ITEM_FOR_DEPENDENCIES_] },
	     { d_button_proc ,  424 ,   192 ,   108 ,   12 ,    palette_color[118] ,  palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,     UserText[ADD_NEW_] },
	     { d_button_proc ,  424 ,   216 ,   108 ,   12 ,    palette_color[118] ,  palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,     UserText[DELETE_] },
	     { d_button_proc ,  424 ,   240 ,   108 ,   12 ,    palette_color[118] ,  palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,     UserText[EDIT_]},
	     { d_button_proc ,  256 ,   324 ,   84 ,    12 ,    palette_color[144] ,   palette_color[68] ,    0 ,     D_EXIT ,        0 ,     0 ,     UserText[NEXT_LEVEL_] },
	     { d_button_proc ,  352 ,   324 ,   132 ,   12 ,    palette_color[144] ,   palette_color[68] ,    0 ,     D_EXIT ,        0 ,     0 ,     UserText[PROCEEDING_LEVEL_] },
	     { d_button_proc ,  496 ,   324 ,   72 ,    12 ,    palette_color[144] ,   palette_color[68] ,    0 ,     D_EXIT ,        0 ,     0 ,     UserText[DONE_]},
	     { d_list_proc ,    244 ,   156 ,   144 ,   72 ,    palette_color[188] ,   palette_color[10] ,    0 ,     D_EXIT ,        0 ,     0 ,(char*) Liste2},
	     { d_button_proc ,  244 ,   252 ,   60 ,    12 ,    palette_color[188] ,   palette_color[10] ,    0 ,     D_EXIT ,        0 ,     0 ,        UserText[DRAW_] },
	     { d_button_proc ,  320 ,   252 ,   60 ,    12 ,    palette_color[188] ,   palette_color[10] ,    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
	     { d_edit_proc ,    340 ,   144 ,   228 ,   12 ,    palette_color[246] ,   palette_color[96],    0 ,     0 ,     180 ,   1 ,     Menu_name},
		 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	};
	do
	      {
		 size=menues[level].size;
		 for (int zu=0;zu<max;zu++) select[zu]="**EMPTY**";
		 for (int zu=0;zu<menues[level].size;zu++) select[zu]=menues[level].name(zu);
		 
		 for (int zu=0;zu<max;zu++) strcpy(menustrings[zu],select[zu]);
             centre_dialog(menu_dialog);
		 popup_dialog(menu_dialog,-1);
		 
		 strcpy(menues[level].level,Menu_name);
		 if (!level) menues[0].declare_main(mm);
		 
		 if (menu_dialog[NEW2].flags==MSG_DCLICK)
		   {
		      
		      
		      /* Allegro - C- code done with MichisDialogkiste */
		      
		      
		      char name[STRINGLENGTH]="&" ;
		      
		      DIALOG obj_dialog[]= {
			   { d_shadow_box_proc ,        136 ,   180 ,   216 ,   60 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},
			   { d_text_proc ,      148 ,   192 ,   156 ,   24 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      "Menu-object:" },
			   { d_text_proc ,      148 ,   204 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[NAME_] },
			   { d_button_proc ,    148 ,   216 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
			   { d_button_proc ,    292 ,   216 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
			   { d_button_proc ,    220 ,   216 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[CANCEL_] },
			   { d_edit_proc ,      196 ,   204 ,   150 ,   12 ,    palette_color[12] ,   palette_color[28],    0 ,     0 ,     28 ,    1 ,     name},
			   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		      };
                  centre_dialog(obj_dialog);
		      popup_dialog(obj_dialog,-1);
		      
		      if (obj_dialog[5].flags!=MSG_DCLICK)
			{
			   select[size]=name;
			   menues[level].add_item(name);
			   size++;
			}
		   }
		 if (menu_dialog[HELP2].flags==MSG_DCLICK)
		   menues[0].help();
		 if (menu_dialog[EDIT2].flags==MSG_DCLICK)
		   {
		      int dies=menu_dialog[LISTE].d1;
		      
		      if (dies<size)
			{
			   
			   char name[STRINGLENGTH];
			   strcpy(name,select[dies]);
			   
			   
			   DIALOG obj_dialog[]= {
				{ d_shadow_box_proc ,   136 ,   180 ,   216 ,   60 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},

				{ d_text_proc , 148 ,   192 ,   156 ,   24 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[MENU_OBJECT] },
				{ d_text_proc , 148 ,   204 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[NAME_] },
				{ d_button_proc ,       148 ,   216 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
				{ d_button_proc ,       292 ,   216 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
				{ d_button_proc ,       220 ,   216 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[CANCEL_] },
				{ d_edit_proc , 196 ,   204 ,   150 ,   12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     28 ,    1 ,     name},
				{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
			   };
                     centre_dialog(obj_dialog);
			   popup_dialog(obj_dialog,-1);
			   
			   if (obj_dialog[5].flags!=MSG_DCLICK)
			     {
				select[dies]=name;
				menues[level].edit_item(dies,name);
			     }

			}
		   }
		 
		 if (menu_dialog[DEL2].flags==MSG_DCLICK)
		   {
		    if (size)
			{
			   size--;
			   menues[level].del();
			   select[size]="**EMPTY**";
		      }
		   }
		 
		 if (menu_dialog[DRAW2].flags==MSG_DCLICK)
		   menues[level].draw();
		 
		 size=menues[0].size;
		 
		 if (menu_dialog[NEXT].flags==MSG_DCLICK)
		   {
		      next=level+1;
		      if (next==LEVELS) next=LEVELS-1;
		      return next;
		   }
		 if (menu_dialog[PROCEED].flags==MSG_DCLICK)
		   {
		      next=level-1;
		      if (next<0) next=0;
		      return next;
		      
		   }
		 if (menu_dialog[LISTE].flags==MSG_DCLICK)
		   do_dependencies(menu_dialog[LISTE].d1);
		 
		 
	      }while (menu_dialog[EXIT2].flags!=MSG_DCLICK);
	     return -1;
	     
	 }
	do_dependencies(int num)
	  {
	     String* temp=new String[LEVELS];
	     int c=0;
	     int dia_done;
	     for (int t=1;t<LEVELS;t++)
	       {
		  if (menues[t].size)
		    {
		       temp[c]=menues[t].level;
		       c++;
		    }
		  }
	     
	     do{
		
		for (int t=0;t<FUNC;t++)
		  strcpy(functions[t],functs[t]);
		for (int t=0;t<c;t++)
		  
		 {
		    strcpy(kids[t],temp[t]);
		 }
		
		kids_size=c;
		char id[STRINGLENGTH];
		strcpy(id,menues[level].name(num));
		
		/* Allegro - C- code done with MichisDialogkiste */
	#define CLEAR2 11
	#define CANCEL 13
	#define NEW_FUNC 14
	#define LIST_func 15
	#define LIST_menu 16
	#define HELP3 12
		DIALOG dep_dialog[]= {
		     { d_shadow_box_proc ,      88 ,    120 ,   384 ,   276 ,   palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,     NULL},
		     { d_text_proc ,    100 ,   132 ,   264 ,   12 ,    palette_color[144] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,  UserText[DEPENDENCIES_]},
		     { d_text_proc ,    112 ,   168 ,   108 ,   12 ,    palette_color[144] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,  UserText[FUNCTIONS_] },
		     { d_text_proc ,    292 ,   168 ,   132 ,   12 ,    palette_color[144] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,      "Submenues" },
		     { d_text_proc ,    112 ,   156 ,   240 ,   12 ,    palette_color[144] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,         UserText[DOUBLE_CLICK_ON_A_LIST_ITEM_TO_CONNECT_IT_] },
		     { d_text_proc ,    112 ,   324 ,   180 ,   12 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,         UserText[CURRENT_MENUOBJECT_] },
		     { d_text_proc ,    256 ,   324 ,   216 ,   12 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,      id },
		     { d_text_proc ,    112 ,   336 ,   168 ,   12 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,         UserText[CURRENT_CONNECTION_] },
		     { d_text_proc ,    268 ,   336 ,   192 ,   12 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,       menues[level].show(num)},
		     { d_text_proc ,    112 ,   348 ,   72 ,    12 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,         UserText[TYPE_] },
		     { d_text_proc ,    160 ,   348 ,   180 ,   12 ,    palette_color[128] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,       menues[level].type(num)},
		     { d_button_proc ,  256 ,   372 ,   192 ,   12 ,    palette_color[220] ,   palette_color[96],    0 ,     D_EXIT ,        0 ,     0 , UserText[CLEAR_ALL_DEPENDENCIES_]},
		     { d_button_proc ,  112 ,   372 ,   60 ,    12 ,    palette_color[220] ,   palette_color[96],    0 ,     D_EXIT ,        0 ,     0 , UserText[HELP_] },
		     { d_button_proc ,  184 ,   372 ,   60 ,    12 ,    palette_color[220] ,   palette_color[96],    0 ,     D_EXIT ,        0 ,     0 , UserText[DONE_] },
		     { d_button_proc ,  112 ,   300 ,   120 ,   12 ,    palette_color[227] ,   palette_color[100] ,   0 ,     D_EXIT ,        0 ,     0 ,       UserText[EDIT_FUNCTION_] },
		     { d_list_proc ,    112 ,   180 ,   144 ,   108 ,   palette_color[227] ,   palette_color[100] ,   0 ,     D_EXIT, func_counter ,  0 ,     Liste3},
		     { d_list_proc ,    292 ,   180 ,   156 ,   108 ,   palette_color[227] ,   palette_color[100] ,   0 ,     D_EXIT ,        0 ,     0 ,     Liste4},
		     { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		};
		
		
            centre_dialog(dep_dialog);
		popup_dialog (dep_dialog,-1);
		
		if (dep_dialog[LIST_func].flags==MSG_DCLICK)
		  {
		     menues[level].func_exe(functions[dep_dialog[LIST_func].d1],num);
		  }
		if (dep_dialog[CLEAR2].flags==MSG_DCLICK)
		  {
		     menues[level].clear(dep_dialog[LIST_func].d1);
		  }

		if (dep_dialog[HELP3].flags==MSG_DCLICK)
            /* HelpMenue einfuegen */
		  ;
		if (dep_dialog[NEW_FUNC].flags==MSG_DCLICK)
		  {
		     
		     
		     /* Allegro - C- code done with MichisDialogkiste */
		     
		     dep_dialog[LIST_func].d1;

		     char type[STRINGLENGTH];
		     strcpy(type,functs_type[dep_dialog[LIST_func].d1]);
		     
		     char name[STRINGLENGTH];
		     strcpy(name,functs[dep_dialog[LIST_func].d1]);


		     DIALOG func_dialog[]= {
			  { d_shadow_box_proc , 128 ,   180 ,   264 ,   72 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},
			  { d_text_proc ,       148 ,   192 ,   156 ,   24 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[FUNCTIONS_] },
			  { d_text_proc ,       148 ,   204 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,        UserText[TYPE_]},
			  { d_text_proc ,       148 ,   216 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[NAME_] },
			  { d_button_proc ,     152 ,   227 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
			  { d_button_proc ,     284 ,   227 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_]},
			  { d_button_proc ,     212 ,   227 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,       UserText[DELETE_]},
			  { d_edit_proc ,       196 ,   204 ,   160 ,   12 ,    palette_color[12] ,   palette_color[28],    0 ,     0 ,     28 ,    1 ,     type},
			  { d_edit_proc ,       196 ,   216 ,   160 ,   12 ,    palette_color[12] ,   palette_color[28],    0 ,     0 ,     28 ,    1 ,     name},
			  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		     };
	           centre_dialog(func_dialog);
		     popup_dialog(func_dialog,-1);
		     if (func_dialog[6].flags==MSG_DCLICK)
		       {
			functs_type[func_counter]="none";
			functs[func_counter]="**EMPTY**";
			if (func_counter>0) func_counter--;
			}
		     else {
			functs_type[func_counter]=type;
			functs[func_counter]=name;
			func_counter++;
			}
		  }
		
		if (dep_dialog[LIST_menu].flags==MSG_DCLICK)
		  {
		     menues[level].submenu(kids[dep_dialog[LIST_menu].d1],num);
		  }
		dia_done=dep_dialog[CANCEL].flags;
		
	     }while(dia_done!=MSG_DCLICK);
	     
	     
	     
	  }
	
	
	export()
	  {
	     fout<<"\n"<<func_counter;
	     fout<<"\n"<<max;
	      for (int t=0;t<max;t++)
	       menues[t].export();

	     for (int t=0;t<func_counter;t++)
	       {
		  fout<<"\n"<<functs[t];
		  fout<<"\n"<<functs_type[t];
	       }
	     
	  }
	import()
	  {
	     func_counter=0;//reload
	     fin>>func_counter;
	     fin>>max;
	     if (max>LEVELS) error(4); //too little size

	     for (int t=0;t<max;t++)
	       menues[t].import();

	     if (func_counter>FUNC) error(1);
	     for (int t=0;t<func_counter;t++)
	       {
		  fin>>functs[t];
		  fin>>functs_type[t];
	       }
	     menues[0].declare_main(mm);
	     
	     
	  }
	
	save(int line_nr)
	  {
	     if (size) mm.save(line_nr);
	  }
	
	void help_dep();
	save_menues()
	  {
        for (int t=0;t<func_counter;t++)
	       fout<<"\n"<<functs_type[t]<<" "<<functs[t]<<"() {};";
	     
	     for (int t=LEVELS;t>0;t--)
	       menues[t-1].save();
	  }
	
	
	
     };
char* Liste0 (int index, int* list_size) {
		char* strings[]={"640x480" , "800x600" , "1024x768" };
		if (index < 0) 
		  { *list_size =3;
		     return NULL;}
		else return strings[index];}


char name[STRINGLENGTH]="*.h";
char name2[STRINGLENGTH]="*.MDK";
int changes;
int About(...)
     {
      BITMAP* bitmap_no0;
      DATAFILE* TEMP;
	bitmap_no0=(BITMAP*) create_bitmap(368,208);
	TEMP =load_datafile("mdk30.dat");
	blit((BITMAP*) TEMP[0].dat,bitmap_no0,0,0,0,0,368,208);
      unload_datafile(TEMP);
      show_mouse(NULL);
      clear_to_color(screen,palette_color[0]);
      show_mouse(screen);
      #define _ABOUT_DIALOG_OK 1
      #define _ABOUT_DIALOG_MORE 2
      DIALOG About_Dialog[]= {
      /* 0 */	{ d_bitmap_proc ,	154 ,	120 ,	368 ,	208 ,	palette_color[251],	palette_color[46],	0 ,	0 ,	0 ,	0 ,	bitmap_no0},
      /* 1 */	{ d_button_proc ,	460 ,	306 ,	42 ,	18 ,	palette_color[224],	palette_color[104],	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
      /* 2 */	{ d_button_proc ,	380 ,	306 ,	52 ,	18 ,	palette_color[224],	palette_color[104],	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
       { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
        };
      centre_dialog(About_Dialog);
      popup_dialog(About_Dialog,-1);
      if (About_Dialog[_ABOUT_DIALOG_MORE].flags==MSG_DCLICK)
       {

            BITMAP* bitmap_no1;
            DATAFILE* TEMP2;
	      bitmap_no1=(BITMAP*) create_bitmap(469,312);
	      TEMP2 =load_datafile("mdk30.dat");
	      blit((BITMAP*) TEMP2[2].dat,bitmap_no1,0,0,0,0,469,312);
            unload_datafile(TEMP2);
            // Allegro - C- code done with MichisDialogkiste
            //                   MDK 3.0
            #define _FlyFlaps_DIALOG_PLAY__SEX_WITH_PAMELA_A__FROM_THE_ALBUM__LUNACY_ 2
            char TEXTBOX0[256] = "This pictures shows my Band \"The Fly Flaps\". It was taken in 10/97.";
            DIALOG FlyFlaps_Dialog[]= {
            /* 0 */	{ d_bitmap_proc ,	76 ,	96 ,	469 ,	312 ,	palette_color[251],	palette_color[46],	0 ,	0 ,	0 ,	0 ,	bitmap_no1},
            /* 1 */	{ d_textbox_proc ,	76 ,	402 ,	468 ,	18 ,	palette_color[224],	palette_color[104],	0 ,	0 ,	0 ,	0 ,	 TEXTBOX0 },
            /* 2 */	{ d_button_proc ,	148 ,	102 ,	396 ,	18 ,	palette_color[122],	palette_color[142],	0 ,	D_EXIT ,	0 ,	0 ,	 "Play \"Sex with Pamela A.\" from the album \"Lunacy\"" },
             { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
              };
            centre_dialog(FlyFlaps_Dialog);
            do
            {
              do_dialog(FlyFlaps_Dialog,-1);

            } while (FlyFlaps_Dialog[2].flags!=MSG_DCLICK);

            if (SoundCardPresent==0)
                      {
                        DATAFILE* TEMP2;
                        TEMP2 =load_datafile("mdk30.dat");
                        SAMPLE* SexWithPamelaA;
                        SexWithPamelaA=(SAMPLE*) TEMP2[1].dat;
                        play_sample(SexWithPamelaA,128,128,1000,0);
                        set_mouse_sprite(My_busy_pointer);
                        rest(2000);
                        show_mouse(NULL);
                        clear_to_color(screen,palette_color[0]);
                        show_mouse(screen);
                        set_mouse_sprite(My_mouse_pointer);
                        strcpy(TEXTBOX0,"Herbert's playing keyboard,Bello's singing and playing bass, I'm playing guitar and Volker plays the drums. \"LUNACY\" has 11 tracks, recorded 1997 in Zirndorf/Nuernberg");
                        DIALOG Sex_Dialog[]= {
                        /* 0 */	{ d_bitmap_proc ,	76 ,	60 ,	469 ,	312 ,	palette_color[251],	palette_color[46],	0 ,	0 ,	0 ,	0 ,	bitmap_no1},
                        /* 1 */	{ d_textbox_proc ,	76 ,	366 ,	468 ,	30 ,	palette_color[224],	palette_color[104],	0 ,	0 ,	0 ,	0 ,	 TEXTBOX0 },
                        /* 2 */	{ d_button_proc ,	148 ,	66 ,	396 ,	18 ,	palette_color[122],	palette_color[142],	0 ,	D_EXIT ,	0 ,	0 ,	 "Play \"Sex with Pamela A.\" from the album \"Lunacy\"" },
                        /* 3 */	{ d_button_proc ,	4 ,	462 ,	216 ,	12 ,	palette_color[112],	palette_color[208],	0 ,	D_EXIT ,	0 ,	0 ,	 "Stop it, I don't like it!" },
                        /* 4 */	{ d_button_proc ,	226 ,	450 ,	186 ,	24 ,	palette_color[112],	palette_color[208],	0 ,	D_EXIT ,	0 ,	0 ,	 "Wow, good stuff" },
                        /* 5 */	{ d_button_proc ,	424 ,	432 ,	198 ,	42 ,	palette_color[112],	palette_color[208],	0 ,	D_EXIT ,	0 ,	0 ,	 "I want to buy the CD" },
                        /* 6 */	{ d_text_proc ,	82 ,	408 ,	378 ,	18 ,	palette_color[142],	palette_color[0],	0 ,	0 ,	0 ,	0 ,	 "Now it's your choice (BE CAREFUL, cause I wrote the song)." },
                         { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
                          };
                        centre_dialog(Sex_Dialog);
                        popup_dialog(Sex_Dialog,-1);
                        if (Sex_Dialog[4].flags==MSG_DCLICK)
                          {
                            show_mouse(NULL);
                            clear_to_color(screen,palette_color[0]);
                            show_mouse(screen);
                             DIALOG Sex2_Dialog[]= {
                            /* 0 */	{ d_button_proc ,	148 ,	192 ,	366 ,	30 ,	palette_color[104],	palette_color[224],	0 ,	D_EXIT ,	0 ,	0 ,	 "***** Oh, thanks :)))) *****" },
                            { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
                            };
                            centre_dialog(Sex2_Dialog);
                            popup_dialog(Sex2_Dialog,-1);
                          }
                        if (Sex_Dialog[5].flags==MSG_DCLICK)
                          {
                            show_mouse(NULL);
                            clear_to_color(screen,palette_color[0]);
                            show_mouse(screen);
                            strcpy(TEXTBOX0,"Lunacy is 25 German Marks plus shipping/porto.\nContact:\n Michael Schuster\n Erlachstr. 13\n 91301 Forchheim\n Germany\nschuster@eev.e-technik.uni\n-erlangen.de");
                            DIALOG Sex3_Dialog[]= {
                            /* 0 */	{ d_button_proc ,	148 ,	348 ,	368 ,	30 ,	palette_color[104],	palette_color[224],	0 ,	D_EXIT ,	0 ,	0 ,	 "***** Thanks for your interest *****" },
                            /* 1 */	{ d_textbox_proc ,	208 ,	264 ,	222 ,	72 ,	palette_color[252],	palette_color[142],	0 ,	0 ,	0 ,	0 ,	 TEXTBOX0 },
                             { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
                             };
                            centre_dialog(Sex3_Dialog);
                            popup_dialog(Sex3_Dialog,-1);
                          }

                        if (Sex_Dialog[3].flags==MSG_DCLICK)
                          {
                             allegro_exit();
                             cout<<"\nYou're mean......";
                             rest(500);
                             cout<<"\n.... but me, too!";
                             rest(500);
                             cout<<"\n\n Be more careful next time...\n";
                             rest(500);
                             exit(1);
                           }
                        unload_datafile(TEMP2);
                        destroy_sample(SexWithPamelaA);
                      }
                   else
                     {
                       alert("Hm, too Bad...", "You've no soundcard","You'll perhaps never know the song...", "OK", NULL, 'o', 27);
                     }


            destroy_bitmap(bitmap_no1);
        }
      destroy_bitmap(bitmap_no0);
      BLIT;
     }



class holder
/*
 * This is the overall class, which handles all objects.
 *
 * */

     {
      private:
	int sele;
	int layer;
	int max_layers;
   int loadrecent;
	gui_d_key_holder* keys;
	dialog* anord;
	container<gui_d_clear_proc>* clear;
	container<gui_d_box_proc>* box;
 	container<gui_d_shadow_box_proc>* sbox;
      textcontainer<gui_d_text_proc>* text;
      listcontainer<gui_d_textbox_proc>* textbox;
	textcontainer<gui_d_ctext_proc>* ctextbox;
	textcontainer<gui_d_button_proc>* button;
	textcontainer<gui_d_check_button_proc>* check;
	textcontainer<gui_d_radio_proc>* radio;
	textcontainer<gui_d_edit_proc>* edit;
	listcontainer<gui_d_bitmap_proc>* bitmap;
	listcontainer<gui_d_icon_proc>* icon;
      listcontainer<gui_d_slider_proc>* slider;
      listcontainer<gui_d_listbox_proc>* liste;
	menucontainer* menus;
	option_holder opt;
	int obj_no;
	String DialogName;
	
	Ordnung order;
      public:
	holder()
	  {
	     sele=0;
	     changes=0;
	     layer=0;
	     max_layers=1;
           loadrecent=0;
	     obj_no=0;
           opt.readconfig();
	     initUserStrings();
	     keys= new gui_d_key_holder(max_keyobj);
	     clear=new  container<gui_d_clear_proc>(max_clearobj,"DUMMY");
	     box=new container<gui_d_box_proc>(max_boxobj,"DUMMY");
	     sbox=new container<gui_d_shadow_box_proc> (max_sboxobj,"DUMMY");
	     slider=new listcontainer<gui_d_slider_proc> (max_sliderobj,"DUMMY");
  	     text=new textcontainer<gui_d_text_proc> (max_textobj,"TEXT");
	     textbox=new listcontainer<gui_d_textbox_proc> (max_textboxobj,"TEXTBOX");
	     ctextbox=new textcontainer<gui_d_ctext_proc>(max_ctextobj,"CTEXT");
	     button=new textcontainer<gui_d_button_proc> (max_buttonobj,"Button");
	     radio =new textcontainer<gui_d_radio_proc> (max_radioobj,"Button");
	     check=new textcontainer<gui_d_check_button_proc> (max_checkobj,"Check");
	     edit=new  textcontainer<gui_d_edit_proc> (max_editobj,"EDIT");
	     bitmap=new  listcontainer<gui_d_bitmap_proc> (max_bitmapobj,"BITMAP_no");
	     icon=new  listcontainer<gui_d_icon_proc> (max_iconobj,"ICON_no");
	     liste=new  listcontainer<gui_d_listbox_proc> (max_listobj,"LIST_no");
    	     menus=new  menucontainer(max_menobj,"MENUS");
          DialogName="MDK30_Dialog";

	  }
	
	int saveCfile()
	  {
	     // Speichern des Hauptdialogs

// Allegro - C- code done with MichisDialogkiste
//                   MDK 3.0
#define _SAVE_DIALOG_WRITE_NUMBERED_DIALOG_OBJECTS_COMMENTS 3
#define _SAVE_DIALOG_WRITE_DEFINES_FOR_D_EXIT_OBJECTS 4
#define _SAVE_DIALOG_HELP 5
#define _SAVE_DIALOG_SAVE_DIALOG_COLORS_FOR_32_BIT_MODE 7
#define _SAVE_DIALOG_WRITE_INITFUNCTION_FOR_32_BIT_COLOR_DIALOGS 8
#define _SAVE_DIALOG_WRITE_INITFUNCTIONS_FOR_BITMAP_OBJECTS 9
#define _SAVE_DIALOG_WRITE_FUNCTIONS_FOR_LISTBOXES 10
#define _SAVE_DIALOG_WRITE_CHAR_INITS 11
#define _SAVE_DIALOG_WRITE_GLOBAL_INITFUNCTION 12
#define _SAVE_DIALOG_HELP2 15
#define _SAVE_DIALOG_SAVE 16
#define _SAVE_DIALOG_CANCEL 17
char dlg_name[256];
 strcpy(dlg_name,DialogName);

 DIALOG save_dialog[]= {
/* 0 */	{ d_shadow_box_proc ,	112 ,	90 ,	456 ,	348 ,	palette_color[128] ,	palette_color[1] ,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 1 */	{d_text_proc ,	148 ,	102 ,	270 ,	12 ,	palette_color[128] ,	palette_color[1] ,	0 ,	0 ,	0 ,	0 ,	 "MDK 3.0: Saving to C-File" },
/* 2 */	{ d_box_proc ,	142 ,	156 ,	378 ,	72 ,	palette_color[98] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 3 */	{d_check_proc ,	154 ,	174 ,	360 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	COMMENTS ,	0 ,	0 ,	 "Write numbered dialog objects (comments)" },
/* 4 */	{d_check_proc ,	154 ,	192 ,	360 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	DEFINE ,	0 ,	0 ,	 "Write Defines for D_EXIT objects" },
/* 5 */	{d_button_proc ,	454 ,	210 ,	54 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
/* 6 */	{ d_box_proc ,	142 ,	252 ,	384 ,	132 ,	palette_color[98] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 7 */	{d_check_proc ,	154 ,	262 ,	282 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	SAVE_32bit_COLOR ,	0 ,	0 ,	 "Save colors for 32 bit mode" },
/* 8 */	{d_radio_proc ,	154 ,	280 ,	282 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	INITFUNCTION_COLOR ,	1 ,	0 ,	 "Write Initfunction for 32 bit Color-Dialogs" },
/* 9 */	{d_check_proc ,	154 ,	312 ,	322 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	INITFUNCTIONS_BITMAP ,	0 ,	0 ,	 "Write Initfunctions for Bitmap objects" },
/* 10 */	{d_check_proc ,	154 ,	328 ,	282 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	INITFUNCTIONS_LISTBOXES,	0 ,	0 ,	 "Write Functions for Listboxes" },
/* 11 */	{d_check_proc ,	154 ,	346 ,	282 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	INIT_CHAR ,	0 ,	0 ,	 "Write char* inits" },
/* 12 */	{d_check_proc ,	154 ,	364 ,	282 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	INIT_GLOBAL ,	0 ,	0 ,	 "Write global initfunction" },
/* 13 */	{d_text_proc ,	166 ,	132 ,	90 ,	12 ,	palette_color[128] ,	palette_color[1] ,	0 ,	0 ,	0 ,	0 ,	 "C-Name of Dialog:" },
/* 14 */	{ d_edit_proc ,	316 ,	132 ,	114 ,	12 ,	palette_color[98] ,	palette_color[1] ,	0 ,	0 ,	8 ,	1 ,	dlg_name},
/* 15 */	{d_button_proc ,	454 ,	366 ,	54 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
/* 16 */	{d_button_proc ,	172 ,	408 ,	72 ,	18 ,	palette_color[128] ,	palette_color[1] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Save" },
/* 17 */	{d_button_proc ,	448 ,	408 ,	72 ,	18 ,	palette_color[128] ,	palette_color[1] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
/* 9 */	{d_radio_proc ,	154 ,	294 ,	282 ,	12 ,	palette_color[98] ,	palette_color[28] ,	0 ,	WRITE_COLORS_STATIC ,	1 ,	0 ,	 "Init 32 bit colors directly"},
 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
 };

 centre_dialog(save_dialog);

 do{
    popup_dialog(save_dialog,-1);
    DialogName=dlg_name;
    if (save_dialog[_SAVE_DIALOG_HELP].flags==MSG_DCLICK)
      {
        set_object_help_c_output_comments();
        do_help();
      }
    if (save_dialog[_SAVE_DIALOG_HELP2].flags==MSG_DCLICK)
      {
        set_object_help_c_output_globals();
        do_help();
      }
   }while ((save_dialog[_SAVE_DIALOG_SAVE].flags!=MSG_DCLICK)&(save_dialog[_SAVE_DIALOG_CANCEL].flags!=MSG_DCLICK));

 if (save_dialog[_SAVE_DIALOG_SAVE].flags==MSG_DCLICK)
   {
        INIT_GLOBAL=save_dialog[_SAVE_DIALOG_WRITE_GLOBAL_INITFUNCTION].flags;
        SAVE_32bit_COLOR=save_dialog[_SAVE_DIALOG_SAVE_DIALOG_COLORS_FOR_32_BIT_MODE].flags;
        INITFUNCTION_COLOR=save_dialog[ _SAVE_DIALOG_WRITE_INITFUNCTION_FOR_32_BIT_COLOR_DIALOGS ].flags;
        WRITE_COLORS_STATIC=save_dialog[18].flags;
	     fout.close();
	     if (file_select(  UserText[OUTPUTFILE_ALLEGRO_C_FORMAT],name,"C;H;CC"))
	       {
		  fout.open(name);
		  fout<<"// Allegro - C- code done with MichisDialogkiste";
		  fout<<"\n//                   MDK 3.01";
		  for (int j=0;j<order.count;j++)
		    {
		       if (order.Typus[j]=="clear") clear->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="bitmap") bitmap->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="icon")  icon->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="box")    box->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="sbox")   sbox->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="text") text->write_defines(DialogName,j,order.Member[j]);
                   if (order.Typus[j]=="textbox") textbox->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="ctextbox")ctextbox->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="edit")  edit->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="button") button->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="radio") radio->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="check") check->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="liste") liste->write_defines(DialogName,j,order.Member[j]);
		       if (order.Typus[j]=="slider") slider->write_defines(DialogName,j,order.Member[j]);
		    }
		  // Speichern der Listenobjekte
        if (save_dialog[_SAVE_DIALOG_WRITE_CHAR_INITS].flags==D_SELECTED)
          {
          	  text->save_lists();
              textbox->save_lists();
              ctextbox->save_lists();
              check->save_lists();
              button->save_lists();
           }
        if (save_dialog[_SAVE_DIALOG_WRITE_FUNCTIONS_FOR_LISTBOXES].flags==D_SELECTED)liste->save_lists();
 	  // Speichern des Defaultsstrings
		  int t=0;
		  while (edit->isvalid(t)>0)
		    {
		       edit->list[t].save_string();
		       t++;
		    }
		  menus->save_menues();
		  fout<<"\nDIALOG "<<DialogName<<"[]= { ";
		  for (int j=0;j<order.count;j++)
		    {
		       if (order.Typus[j]=="clear") clear->save(order.Member[j],j);
		       if (order.Typus[j]=="bitmap") bitmap->save(order.Member[j],j);
		       if (order.Typus[j]=="icon")  icon->save(order.Member[j],j);
		       if (order.Typus[j]=="box")    box->save(order.Member[j],j);
		       if (order.Typus[j]=="sbox")   sbox->save(order.Member[j],j);
		       if (order.Typus[j]=="text") text->save(order.Member[j],j);
                   if (order.Typus[j]=="textbox") textbox->save(order.Member[j],j);
      	       if (order.Typus[j]=="ctextbox")ctextbox->save(order.Member[j],j);
	             if (order.Typus[j]=="edit")  edit->save(order.Member[j],j);
		       if (order.Typus[j]=="button") button->save(order.Member[j],j);
		       if (order.Typus[j]=="radio") radio->save(order.Member[j],j);
		       if (order.Typus[j]=="check") check->save(order.Member[j],j);
		       if (order.Typus[j]=="liste") liste->save(order.Member[j],j);
		       if (order.Typus[j]=="slider") slider->save(order.Member[j],j);
	   	}
		  
		  menus->save(order.count);
              keys->save(order.count+1);
		  fout<<"\n { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }";
		  fout<<"\n };";
        if (save_dialog[_SAVE_DIALOG_WRITE_INITFUNCTIONS_FOR_BITMAP_OBJECTS].flags==D_SELECTED)
          {

           for (int j=0;j<order.count;j++)
           {
		       if (order.Typus[j]=="bitmap") bitmap->save_lists(j,DialogName,order.Member[j]);
		       if (order.Typus[j]=="icon")   icon->save_lists(j,DialogName,order.Member[j]);
   	       if (order.Typus[j]=="slider") slider->save_lists(j,DialogName,order.Member[j]);

           }

          }

        if (SAVE_32bit_COLOR==D_SELECTED)
          {
            fout<<"\nvoid MdkInitColor32(void) {   ";
		  for (int j=0;j<order.count;j++)
		    {
		       if (order.Typus[j]=="clear") clear->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="bitmap") bitmap->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="icon")  icon->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="box")    box->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="sbox")   sbox->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="text") text->saveColor32(order.Member[j],DialogName,j);
                   if (order.Typus[j]=="textbox") textbox->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="ctextbox")ctextbox->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="edit")  edit->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="button") button->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="radio") radio->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="check") check->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="liste") liste->saveColor32(order.Member[j],DialogName,j);
		       if (order.Typus[j]=="slider") slider->saveColor32(order.Member[j],DialogName,j);
	   	    }
          fout<<"\n};";

         }
       if (INITFUNCTION_COLOR==D_SELECTED)
         {
            fout<<"\nvoid MdkSetupColor(void) {\n";
            fout<<"\t DATAFILE *pal;\n";
            fout<<"\t pal=load_datafile(\"PALL.DAT\");\n";
            fout<<"\t set_palette(pal[0].dat);\n";
            if(SAVE_32bit_COLOR==D_SELECTED) fout<<"\t MdkInitColor32();";
            fout<<"\n}";
          }

       if (INIT_GLOBAL==D_SELECTED)
         {
           fout<<"\nvoid MdkInitGlobal(void) {\n";
           if(INITFUNCTION_COLOR) fout<<"\t MdkSetupColor();";
           icon->SaveInit();
           bitmap->SaveInit();
           slider->SaveInit();
           fout<<"\n}";
         }
       fout.close();

        redraw();
       }
     }
   }
   int save(...) {

    if (file_select("Outputfile (MDK-format)",name2,"MDK"))
	       {
		  fout.open(name2);
		  box->export();
		  sbox->export();
		  text->export();
		  ctextbox->export();
		  button->export();
		  check->export();
		  edit->export();
		  liste->export();
		  clear->export();
		  keys->export();
		  menus->export();
		  radio->export();
		  bitmap->export();
		  slider->export();
		  icon->export();
  		  textbox->export();
		  order.export();
		  fout.close();
		  changes=0;
	       }
	     redraw(1);
        strcpy(RecentFile,name2);
	  }

  	int loadr(...) //for c++ pointers
     {
       loadrecent=1;
       load();
     }
	int load(...) //for c++ pointers
	  {
	     fin.close();
	     order.count=0; // Reset the counter of Drawobjects
        if (!loadrecent)
          {
	       if (file_select("Inputfile (MDK-format)",name2,"MDK"))
	       {
            strcpy(RecentFile,name2);

           }
          else
            {
             redraw();
             loadrecent=0;
             return 0;
            }
          }
		  fin.open(RecentFile);
              loadrecent=0;
		  box->import();
		  sbox->import();
		  text->import();
		  ctextbox->import();
		  button->import();
		  check->import();
		  edit->import();
		  liste->import();
		  clear->import();
		  keys->import();
		  menus->import();
		  radio->import();
		  bitmap->import();
		  slider->import();
		  icon->import();
		  textbox->import();
		  if (!(order.import()))   /* If Mdk file V2.71*/
		    {
		       int j,jk;
		       slider->clear_container();
		       bitmap->clear_container();
		       textbox->clear_container();
		       icon->clear_container();
		       
		       for (j=0;j<clear->counter;j++)
			 {
			    order.neu("clear",j);
			 }
		       jk=j;
		       for (j;j<box->counter+jk;j++)
			 {
			    order.neu("box",j-jk);
			 }
		       jk=j;
		       for (j;j<sbox->counter+jk;j++)
			 {
			    order.neu("sbox",j-jk);
			 }
		       jk=j;
		       for (j;j<text->counter+jk;j++)
			 {
			    order.neu("text",j-jk);
			 }
		       jk=j;
		       for (j;j<ctextbox->counter+jk;j++)
			 {
			    order.neu("ctextbox",j-jk);
			 }
		       jk=j;
		       for (j;j<button->counter+jk;j++)
			 {
			    order.neu("button",j-jk);
			 }
		       jk=j;
		       for (j;j<radio->counter+jk;j++)
			 {
			    order.neu("radio",j-jk);
			 }
		       jk=j;
		       for (j;j<check->counter+jk;j++)
			 {
			    order.neu("check",j-jk);
			 }
		       jk=j;
		       for (j;j<edit->counter+jk;j++)
			 {
			    order.neu("edit",j-jk);
			 }
		       jk=j;
		       for (j;j<liste->counter+jk;j++)
			 {
			    order.neu("liste",j-jk);
			 }
		    }
		  
		  
		  redraw();
		  fin.close();
        unselect();
	  }
	int area(...)
	  {     
	     rect_preparer p;
	     p.run();
	     
	     for (int j=0;j<order.count;j++)
	       {
		  if (order.Typus[j]=="clear") order.gewaehlt[j]=clear->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="bitmap") order.gewaehlt[j]=bitmap->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="icon") order.gewaehlt[j]=icon->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="box") order.gewaehlt[j]=box->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="sbox")  order.gewaehlt[j]=sbox->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="textbox") order.gewaehlt[j]=textbox->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="text") order.gewaehlt[j]=text->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="ctextbox")order.gewaehlt[j]= ctextbox->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="edit") order.gewaehlt[j]=edit->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="button") order.gewaehlt[j]=button->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="radio") order.gewaehlt[j]=radio->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="check") order.gewaehlt[j]=check->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="liste") order.gewaehlt[j]=liste->area(p.x,p.y,p.w,p.h,order.Member[j]);
		  if (order.Typus[j]=="slider") order.gewaehlt[j]=slider->area(p.x,p.y,p.w,p.h,order.Member[j]);
	       }
	     
	     redraw(1);
	     changes=1;
	     sele=1;
	     
	  }
	
	int copy(...)
	  {
	     
	     for (int j=0;j<order.count;j++)
	       {
		  if (order.gewaehlt[j])
		    {
		       if (order.Typus[j]=="clear") order.neu("clear",clear->copy(order.Member[j]));
		       if (order.Typus[j]=="bitmap") order.neu("bitmap",bitmap->copy(order.Member[j]));
		       if (order.Typus[j]=="icon") order.neu("icon",bitmap->copy(order.Member[j]));
		       if (order.Typus[j]=="box") order.neu("box",box->copy(order.Member[j]));
		       if (order.Typus[j]=="sbox")  order.neu("sbox",sbox->copy(order.Member[j]));
   	       if (order.Typus[j]=="textbox") order.neu("textbox",textbox->copy(order.Member[j]));
             if (order.Typus[j]=="text") order.neu("text",text->copy(order.Member[j]));
		       if (order.Typus[j]=="ctextbox")order.neu("ctextbox",ctextbox->copy(order.Member[j]));					if (order.Typus[j]=="edit") order.neu("edit",edit->copy(order.Member[j]));
		       if (order.Typus[j]=="button") order.neu("button",button->copy(order.Member[j]));
		       if (order.Typus[j]=="radio") order.neu("radio",radio->copy(order.Member[j]));
		       if (order.Typus[j]=="check") order.neu("check",check->copy(order.Member[j]));
		       if (order.Typus[j]=="liste") order.neu("liste",liste->copy(order.Member[j]));
		       if (order.Typus[j]=="slider") order.neu("slider",slider->copy(order.Member[j]));
		       
		    }
	       }
	      redraw(1);
	     changes=1;
	     
	     
	  }
	
	
	int delet(...)
	  {
	     
	    if (!ask("Sure you want to delete selected items?"))
	       {
		  for (int t=0;t<order.count;t++)
		    {
             if ((order.Typus[t]=="clear")&(order.gewaehlt[t])) clear->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="bitmap")&(order.gewaehlt[t])) bitmap->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="icon")&(order.gewaehlt[t])) icon->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="box")&(order.gewaehlt[t])) box->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="sbox")&(order.gewaehlt[t])) sbox->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="textbox")&(order.gewaehlt[t])) textbox->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="text")&(order.gewaehlt[t])) text->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="box")&(order.gewaehlt[t])) box->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="ctextbox")&(order.gewaehlt[t])) ctextbox->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="edit")&(order.gewaehlt[t])) edit->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="button")&(order.gewaehlt[t])) button->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="radio")&(order.gewaehlt[t])) radio->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="check")&(order.gewaehlt[t])) check->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="liste")&(order.gewaehlt[t])) liste->ReplaceItem(order.Member[t]);
             if ((order.Typus[t]=="slider")&(order.gewaehlt[t])) slider->ReplaceItem(order.Member[t]);
		       if (order.gewaehlt[t]) order.del(t);
		    }
		  changes=1;
		  unselect();
		  redraw();
	       }
	  }
	
	int select(...)
	  {
	  }
	int select_desk(int mx, int my)
	  {
	     set_mouse_sprite_focus(0,0);
	     int change=-1;
	     for (int j=order.count;j>=0;j--) /* Select the object on the top */
	       {
		  change=order.gewaehlt[j];
		  if (order.Typus[j]=="clear") order.gewaehlt[j]=clear->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="bitmap") order.gewaehlt[j]=bitmap->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="icon") order.gewaehlt[j]=icon->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="box") order.gewaehlt[j]=box->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="sbox")  order.gewaehlt[j]=sbox->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="text") order.gewaehlt[j]=text->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="textbox") order.gewaehlt[j]=textbox->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="ctextbox")order.gewaehlt[j]= ctextbox->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="edit") order.gewaehlt[j]=edit->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="button") order.gewaehlt[j]=button->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="radio") order.gewaehlt[j]=radio->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="check") order.gewaehlt[j]=check->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="liste") order.gewaehlt[j]=liste->select_desk(mx,my,order.Member[j]);
		  if (order.Typus[j]=="slider") order.gewaehlt[j]=slider->select_desk(mx,my,order.Member[j]);
		  
		  if (change!=order.gewaehlt[j])
		    {
		       change=1;
		       break;
		    }
		  else change=-1;
		  
	       }
	     if (change==1) redraw(1);
	     sele=1;
	  }
	
	int select_all(...)
	  {
	     for (int j=0;j<order.count;j++) order.gewaehlt[j]=1;
	     for (int t=0;t<40;t++)
	       {
		  clear->select(t);
		  box->select(t);
		  sbox->select(t);
		  textbox->select(t);
		  text->select(t);
		  ctextbox->select(t);
		  edit->select(t);
		  button->select(t);
		  radio->select(t);
		  check->select(t);
		  bitmap->select(t);
		  icon->select(t);
		  liste->select(t);
		  slider->select(t);
	       }
	     sele=1;

	     redraw(2);
	  }
	int colors(...)
	  {
	     int x,y;
	     if (!sele)
	       {
		  rest(500);
             }
	     else
	       {
		       int fgc,bgc;
		       pall_obj te;
		       fgc=te.run("Foreground color",FG);
		       bgc=te.run("Background color",BG);
		       for (int t=0;t<40;t++)
			 {
			    if (!clear->isvalid(t)) clear->change_color(t,fgc,bgc);
			    if (!bitmap->isvalid(t)) bitmap->change_color(t,fgc,bgc);
			    if (!box->isvalid(t)) box->change_color(t,fgc,bgc);
			    if (!sbox->isvalid(t)) sbox->change_color(t,fgc,bgc);
			    if (!edit->isvalid(t)) edit->change_color(t,fgc,bgc);
			    if (!check->isvalid(t)) check->change_color(t,fgc,bgc);
			    if (!button->isvalid(t))  button->change_color(t,fgc,bgc);
			    if (!radio->isvalid(t))  radio->change_color(t,fgc,bgc);
			    if (!ctextbox->isvalid(t)) ctextbox->change_color(t,fgc,bgc);
			    if (!text->isvalid(t)) text->change_color(t,fgc,bgc);
                      if (!textbox->isvalid(t)) textbox->change_color(t,fgc,bgc);
			    if (!liste->isvalid(t)) liste->change_color(t,fgc,bgc);
			    if (!icon->isvalid(t)) icon->change_color(t,fgc,bgc);
			    if (!slider->isvalid(t)) slider->change_color(t,fgc,bgc);
			 }
		       
		       changes=1;
		       

		  
		  
	       }
	  }
	int properties(...)
	  {
	     if (!sele)
	       {
		  //		  status("SELECT Object before doing this!");
		  rest(1000);
		  //		  status("					");
	       }
	     else
	       {
		  clear->show_props();
		  box->show_props();
		  sbox->show_props();
		  text->show_props();
    		  textbox->show_props();
		  ctextbox->show_props();
		  edit->show_props();
		  button->show_props();
		  radio->show_props();
		  check->show_props();
		  liste->show_props();
		  slider->show_props();
		  icon->show_props();
  		  bitmap->show_props();
		  unselect();
		  redraw();
	       }
	  }
	int unselect(...)
	  {
	     for (int j=0;j<order.count;j++) order.gewaehlt[j]=0;
	     clear->unselect();
	     bitmap->unselect();
	     box->unselect();
	     sbox->unselect();
	     textbox->unselect();
  	     text->unselect();
	     ctextbox->unselect();
	     edit->unselect();
	     button->unselect();
	     radio->unselect();
	     check->unselect();
	     liste->unselect();
	     slider->unselect();
	     icon->unselect();
	     redraw(1);
	     sele=0;
	     
	  }
	int mover(...)
	  {
	     
	     int x,y,dx,dy;
	     x=grid(mouse_x);
	     y=grid(mouse_y);
	     int ret=0;
	     for (int j=0;j<order.count;j++)
	       {
		  if (order.gewaehlt[j]) ret++;
	       }
	     if (!ret) return -1;
	     set_mouse_sprite(My_move_pointer);
	     show_mouse(NULL);
	     set_mouse_sprite_focus(X_GUI, Y_GUI);
	     blit(Gui_area,temp_area,0,0,0,0,_W,_H);
	     while (mouse_b & 1)
	       {
		  dx=grid(mouse_x)-x;
     		  dy=grid(mouse_y)-y;
     		  x=grid(mouse_x);
		  y=grid(mouse_y);
		  clear->mover(dx,dy);
		  bitmap->mover(dx,dy);
    		  icon->mover(dx,dy);
		  box->mover(dx,dy);
		  sbox->mover(dx,dy);
     		  text->mover(dx,dy);
		  textbox->mover(dx,dy);
		  ctextbox->mover(dx,dy);
		  edit->mover(dx,dy);
		  button->mover(dx,dy);
		  radio->mover(dx,dy);
		  check->mover(dx,dy);
		  liste->mover(dx,dy);
   		  slider->mover(dx,dy);

		  show_mouse(temp_area);
		  blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
		  show_mouse(NULL);
        	  blit(Gui_area,temp_area,0,0,0,0,_W,_H);
	       }
	     set_mouse_sprite(My_mouse_pointer);
	     set_mouse_sprite_focus(0,0);
	     redraw(1);
	     
	  };
	int redraw(int t =0)
	  {
	     
	     setup_bitmap();
	     for (int j=0;j<order.count;j++)
	       {
		  if (order.Typus[j]=="clear") clear->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="bitmap") bitmap->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="icon") icon->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="box") box->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="sbox") sbox->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="text") text->draw_this(order.Member[j],t);
    		  if (order.Typus[j]=="textbox") textbox->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="ctextbox") ctextbox->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="edit") edit->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="button") button->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="radio") radio->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="check") check->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="liste") liste->draw_this(order.Member[j],t);
		  if (order.Typus[j]=="slider") slider->draw_this(order.Member[j],t);
	       }
	     menus->draw();
	     rebuild_screen();
	  }
	
	int opt_setup(){opt.setup();}
	int clears(...) {order.neu("clear",clear->item()); changes=1;}
	int key(...) { keys->run();changes=1;}
	int boxs(...) { order.neu("box",box->item()); changes=1;}
	int sboxs(...) {order.neu("sbox",sbox->item());changes=1;}
	int text_(...){  order.neu("text",text->item());changes=1;}
    	int textbox_(...){  order.neu("textbox",textbox->item());changes=1;}
	int ctext(){    order.neu("ctextbox",ctextbox->item());changes=1;}
	int buttons(...){order.neu("button",button->item()); changes=1;}
	int checks(...) {order.neu("check",check->item());changes=1;}
	int edits(...) { order.neu("edit",edit->item());changes=1;}
	int radios(...) {order.neu("radio",radio->item());changes=1;}
	int bitmapf(...){order.neu("bitmap",bitmap->item());changes=1;}
	int iconf(...){order.neu("icon",icon->item());changes=1;}
	int list(...) { order.neu("liste",liste->item());changes=1;}
	int slide(...) { order.neu("slider",slider->item());changes=1;}
	int menu(...) {changes=1; menus->run();}
	int behind(...)   {     order.behind_all(); redraw(1);}
	int before(...)   {     order.before_all(); redraw(1);}
	int orderback(...)
	  {
	     for (int j=1;j<order.count;j++)  order.backer(j);
	     redraw(1);
	  }
	int orderfore(...)
	  {
	     for (int j=order.count-1;j>-1;j--) order.fore(j);
	     redraw(1);
	  }
	

   int config()
   {
     opt.makeconfig();
     }
};

holder all;
int quit(...)
{     all.config();
   if (alert("Really want to quit?", NULL, NULL, UserText[YES_], UserText[CANCEL_], 'y', 27) == 1)
     {
	if (changes)
	  {
	     if (alert("Do you want to save changes?(y/N)", NULL, NULL, UserText[YES_], UserText[NO_], 'y', 27) == 1)
	       {
		  all.save();
		  //                        text_mode(-1);
		  //                       textout(screen,font,(unsigned char*) "Schoenen Tag noch!",X_GUI+_W/2-100,Y_GUI+_H/2-24,255);
		  //                       textout(screen,font,(unsigned char*) "Ade!",X_GUI+_W/2-100,Y_GUI+_H/2-0,255);
		  //                        rest(2000);
		  
	       }
	     
	  }
	return D_CLOSE;
	
     }
   else
     return D_O_K;

}

/*
 * There was no other way to handle the menus with an Allegro 
 * MENU- dialog in C++ than with extern "C". If you have a better C++
 * solution - tell me.
 * 
 * */
extern "C"{
   int all_load() {all.load();return 0;};
   int all_recent() {all.loadr();return 0;};
   int all_saveCfile() {all.saveCfile();return 0;};
   int all_back() {all.orderback();return 0;};
   int all_behind() {all.behind();return 0;};
   int all_before() {all.before();return 0;};
   int all_fore() {all.orderfore();return 0;};
   int all_save() {all.save();return 0;};
   int all_moves() {all.mover();return 0;};
   int all_delet() {all.delet();return 0;};
   int all_select_all() {all.select_all();return 0;};
   int all_draw() {clear(screen);all.redraw(1);;return 0;};
   int all_keys() {all.key();return 0;};
   int all_clear() {all.clears();return 0;};
   int all_box() {all.boxs();return 0;};
   int all_sbox() {all.sboxs();return 0;};
   int all_button() {all.buttons();return 0;};
   int all_check() {all.checks();return 0;};
   int all_edit() {all.edits();return 0;};
   int all_text() {all.text_();return 0;};
   int all_ctext() {all.ctext();return 0;};
   int all_textbox() {all.textbox_();return 0;};
   int all_list() {all.list();return 0;};
   int all_slide() {all.slide();return 0;};
   int all_properties() {all.properties();return 0;};
   int all_opt_setup() {all.opt_setup();return 0;};
   int all_radio() {all.radios();return 0;};
   int all_copy() {all.copy();return 0;};
   int all_colors() {all.colors();return 0;};
   int all_unselect() {all.unselect();return 0;};
   int all_area() {all.area();return 0;};
   int Menus_run() {all.menu();return 0;};
   int all_bitmap() {all.bitmapf(); return 0;};
   int all_icon() {all.iconf(); return 0;};
   int menues_defaults() {};
   int objecthelp() {};
   int copy() {all.copy();};
   int selectthis()
    {
       int mx=mouse_x;
       int my=mouse_y;
       set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
       all.select_desk(mx,my);
    };
   int redr() {all.redraw(1);};
   // If the screen would be clear from within the menu, the
   // Mainmenu would not be drawn

   MENU MenuDraw[] ={
	{ UserText[__CLEAR_BOX], all_clear     ,NULL},
	{   UserText[__SHORTCUT], all_keys     ,NULL},
	{ ""   , NULL  ,NULL},
	{ UserText[__BOX], all_box     ,NULL},
	{ UserText[__SHADOWBOX]        , all_sbox      ,NULL},
	{ ""   , NULL  ,NULL},
	{ UserText[__TEXT]     , all_text      ,NULL},
	{ UserText[C__ENTERD_TEXT], all_ctext  ,NULL},
	{ "Te&xtbox"     , all_textbox      ,NULL},
	{ UserText[__EDIT_PROC]        , all_edit      ,NULL},
	{ ""   , NULL  ,NULL},
	{ UserText[C__HECK_BOX], all_check     ,NULL},
	{ UserText[__BUTTON]   , all_button    ,NULL},
	{ UserText[__RADIO_BUTTON]     , all_radio     ,NULL},
	{ ""   , NULL  ,NULL},
	{ UserText[__LIST_BOX] , all_list      ,NULL},
      { ""   , NULL  ,NULL},
     	{ UserText[B__ITMAP], all_bitmap       ,NULL},
	{ UserText[__SLIDER]        , all_slide      ,NULL},
	{ "Ic&on_proc"        , all_icon     ,NULL},

	{ NULL,         NULL,   NULL },
   };
   MENU MenuOrder[]=
     {
	  { "One layer &back ('-')",all_back,NULL},
	  { "One layer  &fore ('+')",all_fore,NULL},
	  { "B&ehind all Objects",all_behind,NULL},
	  { "To the &Top",all_before,NULL},
	  { NULL,       NULL,   NULL },
     };
   
   
   MENU PULLUP_DESKTOP[] ={
	{ UserText[__DRAW]      , NULL  ,MenuDraw},
	{ "&Copy (CTRL+C)"   , copy  ,NULL},
	{ "D&elete (DEL)", all_delet      ,NULL},
	{ UserText[R__EDRAW]    , redr  ,NULL},
	{ ""    , NULL  ,NULL},
	{ "&Properties (CRTL+P)"     , all_properties        ,NULL},
	{ "" , NULL  ,NULL},
	{ "Select &All (CRTL+S)"   , all_select_all        ,NULL},
	{   UserText[S__ELECT_AREA_], all_area  ,NULL},
	{ "&Unselect all (CRTL+U)", all_unselect      ,NULL},
	{ "" , NULL  ,NULL},
	{ "Drawing &Order",NULL,MenuOrder},
	{ NULL,      NULL,   NULL },
      
   };

   int Zeit=0;
   void timer(...)
    {
     Zeit++;
     }
   END_OF_FUNCTION(timer);
   char my[6];
   char mx[6];

   DIALOG pos[]= {
   /* 0 */	{ d_shadow_box_proc ,	466 ,	0 ,	162 ,	18 ,	128,	96,	0 ,	0 ,	0 ,	0 ,	NULL},
   /* 1 */	{ d_text_proc ,	478 ,	6 ,	24 ,	12 ,	128,	96,	0 ,	0 ,	0 ,	0 ,	 "X:" },
   /* 2 */	{ d_text_proc ,	550 ,	6 ,	24 ,	12 ,	128,	96,	0 ,	0 ,	0 ,	0 ,	 "Y:" },
   /* 3 */	{ d_text_proc ,	502 ,	6 ,	24 ,	12 ,	138,	96,	0 ,	0 ,	0 ,	0 ,	 mx },
   /* 4 */	{ d_text_proc ,	580 ,	6 ,	24 ,	12 ,	138,	96,	0 ,	0 ,	0 ,	0 ,	 my },
    { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
    };

   void MdkInitColor32(void) {   
	pos[0].fg=palette_color[128];
	pos[0].bg=palette_color[96];
	pos[1].fg=palette_color[128];
	pos[1].bg=palette_color[96];
	pos[2].fg=palette_color[128];
	pos[2].bg=palette_color[96];
	pos[3].fg=palette_color[138];
	pos[3].bg=palette_color[96];
	pos[4].fg=palette_color[138];
	pos[4].bg=palette_color[96];

   };
   void mouse_position(void)
   {
      int *obj;
      if (Zeit)
        {
          itoa(grid(mouse_x-X_GUI),mx,10);
          itoa(grid(mouse_y-Y_GUI),my,10);
          pos[3].dp=mx;
          pos[4].dp=my;
          show_mouse(NULL);
          dialog_message(pos,MSG_DRAW, 0,obj);
          show_mouse(screen);
          Zeit=0;
        }

   };


   int d_desktop_proc(int msg, DIALOG *d, int c)
     {
	int mx,my;
	if (msg==MSG_DCLICK)
	  {
	     mx=mouse_x;
	     my=mouse_y;
	     set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
	     show_mouse(NULL);
	     all.select_desk(mx,my);
	     show_mouse(screen);
	     set_mouse_range(0,0,__W,__H);
	     return D_O_K;
	  }
	
	if (msg==MSG_CLICK)
	  {
	     
	     mx=mouse_x;
	     my=mouse_y;
	     if  (!(mouse_b & 1))
	       {
		  do_menu(PULLUP_DESKTOP,mx,my);
		  set_mouse_range(0,0,__W,__H);
		  rebuild_screen();
		  return D_O_K;
		  
	       }
	     rest(100);
	     if  (mouse_b & 1)
	       {
		  set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
		  if (all.mover()==-1)
		    {
		       set_mouse_sprite(My_nothing_to_do_pointer);
		       while (mouse_b & 1);
		       set_mouse_sprite(My_mouse_pointer);
		       
		    }
		  set_mouse_range(0,0,__W,__H);
	       }
	     return D_O_K;
	  }
	mouse_position();
      return D_O_K;
     }
   
   
   MENU MenuHelp[] ={
	{ "&Help (F1)"       , do_help  ,NULL},
	{ ""    , NULL  ,NULL},
	{ "&About"      , About         ,NULL},
	{ NULL,  NULL,   NULL },
   };
   MENU MenuSelect[] ={
	{ "Select-&All (CTRL+S)" , all_select_all        ,NULL},
	{ "Select-A&rea (CRTL+A)"        , all_area      ,NULL},
	{ ""    , NULL  ,NULL},
	{ "&Unselect-All (CTRL+U)"       , all_unselect  ,NULL},
	{ NULL,  NULL,   NULL },
   };
   MENU MenuEdit[] ={
	{ "&Select"     , NULL  ,MenuSelect},
	{ ""    , NULL  ,NULL},
	{ "&Copy (CTRL+C)"       , all_copy      ,NULL},
	{ "&Move"       , all_moves     ,NULL},
	{ "&Delete (DEL)"     , all_delet     ,NULL},
	{ ""    , NULL  ,NULL},
	{ "&Colors ('C')"     , all_colors    ,NULL},
	{ "&Properties (CRTL+P)" , all_properties        ,NULL},
	{ ""    , NULL  ,NULL},
	{ "&Redraw"     , all_draw      ,NULL},
	{ "Drawing &Order",NULL,MenuOrder},
	{ NULL,  NULL,   NULL },
   };
   MENU MenuFile[] ={
	{ "&Load"       , all_load      ,NULL},
	{ "&Write C File"       , all_saveCfile      ,NULL},
	{ "&Save MDK File"       , all_save      ,NULL},
 	{ ""    , NULL  ,NULL},
 	{ "RecentFile                                    ", all_recent      ,NULL},
  	{ ""    , NULL  ,NULL},
	{ "&Exit MDK"       , quit  ,NULL},
	{ NULL,  NULL,   NULL },
   };

   MENU MenuMain[] ={
	{ UserText[FILEMENU_]   , NULL  ,MenuFile},
	{ "&Draw"       , NULL  ,MenuDraw},
	{ "&Edit"       , NULL  ,MenuEdit},
	{ "&Menues"     , Menus_run  ,NULL},
	{ "&Setup"    , all_opt_setup  ,NULL},
	{ "&?"  , NULL  ,MenuHelp},
	{ NULL,  NULL,   NULL },
   };
   DIALOG main_dialog[]= {
         	{ d_menu_proc     ,     0 ,   0 ,   0 ,   0 ,     palette_color[128] , palette_color[37] ,    0 ,     0 ,     0 ,     0 ,     MenuMain},
/* 1 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	0 ,	0 ,	KEY_DEL,	0,	all_delet},
/* 2 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	3 ,	0 ,	0,	0,	 all_copy},
/* 3 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	19 ,	0 ,	0,	0,	 all_select_all},
/* 4 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	21 ,	0 ,	0,	0,	 all_unselect},
/* 5 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	'+' ,	0 ,	0,	0,	 all_fore},
/* 6 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	'-' ,	0 ,	0,	0,	 all_back},
/* 7 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	'C' ,	0 ,	0,	0,	all_colors},
/* 8 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	16 ,	0 ,	0,	0,	all_properties},
/* 9 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	0 ,	0 ,	KEY_F1,	0,	do_help},
/* 10 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	9 ,	0 ,	0,	0,	selectthis},
/* 11 */	{ d_keyboard_proc ,	0 ,	0 ,	0 ,	0 ,	251,	46,	1 ,	0 ,	0,	0,	all_area},
      	{ d_desktop_proc ,(__W-_W)/2, (__H-_H)/2 ,      _W ,    _H ,    0 ,     0 ,     0 ,     0 ,     0 ,     0 ,NULL},
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };


}

	 


int main()
  {
     MenuFile[4].text=(char*) RecentFile;
     allegro_init();
     install_keyboard();
     install_mouse();
     install_timer();
     set_color_depth(color_depth);
     set_gfx_mode(GFX_AUTODETECT,__W,__H, 0, 0);
     LOCK_VARIABLE(Zeit);
     LOCK_FUNCTION(timer);
     SoundCardPresent=install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL);
     if (SoundCardPresent==0)
       {
         if (strcmp(digi_driver->name,"No sound")==0)
          SoundCardPresent=-2;
       }

     set_volume(200,200);

     Setup();
     gui_fg_color=palette_color[128];
     gui_bg_color=palette_color[37];
     num_all= (int*) malloc(sizeof(int*));

     str_all=(char**) malloc(sizeof(char*)* 10);
     for (int t=0;t<10;t++)
       str_all[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);
     
     keystrings=(char**) malloc(sizeof(char*)* max_keyobj);
     for (int t=0;t<max_keyobj;t++)
       keystrings[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);
     
     
     menustrings=(char**) malloc(sizeof(char*)* max_menobj);
     for (int t=0;t<max_menobj;t++)
       menustrings[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);
     
     functions=(char**) malloc(sizeof(char*)* FUNC);
     for (int t=0;t<FUNC;t++)
       functions[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);
     
     
     kids=(char**) malloc(sizeof(char*)* LEVELS);
     for (int t=0;t<LEVELS;t++)
       kids[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);
     
     listobjects=(char**) malloc(sizeof(char*)* list_size);
     for (int t=0;t<LEVELS;t++)
       listobjects[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);

     option_holder New;
     if (!(New.CheckNewUser()))
     {
       MdkInitColor32();
       install_int(timer,400);
       popup_dialog(main_dialog,-1);
       delete[] keystrings;
       delete[] menustrings;
       delete[] functions;
       delete[] kids;
       allegro_exit();
       cout<<"\n** MDK 3.01 **\n\n* by Michi Schuster 1997/1998\n* If you use it, write postcard (see readme.txt)";
       exit(0);
       }
     else
      {
       delete[] keystrings;
       delete[] menustrings;
       delete[] functions;
       delete[] kids;
       allegro_exit();
       cout<<"\nYou've made a new setup.\nRestart MDK\n";
  }
}
/* 
 * By Michi Schuster 1997
 * If you use it, write postcard (see readme.txt)
 * */

