//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
//
// Some of this code was lifted from Allegros' gui.c, actually a lot of it...
//
//----------------------------------------------------------------------------
#include <stdio.h>
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// List object
//----------------------------------------------------------------------------
// Constructor
list_object::list_object (char*(*proc)(int,int*))
   :list_grabber_proc(proc),
   index(0)
   {
   if(proc==NULL) list_grabber_proc = default_list_object_procedure;

   // Setup the defaults
   set_x(100);
   set_y(100);
   set_h(100);
   set_w(100);

   demand_focus = true;
   }
//----------------------------------------------------------------------------
// Destructor
list_object::~list_object (void)
   {
   }

//----------------------------------------------------------------------------
// Default Callback function to specify the contents of a listbox
char *default_list_object_procedure (int index, int *list_size)
   {
   static char *strings[] = {"Zero","One","Two","Three","Four","Five","Six","Seven","Eight","Nine","Ten"};
   if(index<0)
      {
      *list_size = 11;
      return NULL;
      }
   else
      {
      return strings[index];
      }
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Do any startup stuff for the list
void list_object::msg_start (void)
   {
   list_grabber_proc(-1, &listsize);
   }
//----------------------------------------------------------------------------
// Tell the object to draw itself
void list_object::msg_draw (void)
   {
   height = (h()-4) / text_height(font);

   int bar = 0;
   if(listsize>height) bar = scrollable_object::width;
   if(bar==0) offset = 0;

   _draw_list_object(list_grabber_proc,
                     &listsize,
                     offset,
                     x(),y(),w()-bar,h(),
                     index,
                     disabled(),has_focus(),
                     color ? color->fore() : degui_fore_color,
                     color ? color->select() : degui_select_color,
                     color ? color->deselect() : degui_deselect_color,
                     color ? color->disable() : degui_disable_color,
                     color ? color->light_shad() : degui_light_shad_color,
                     color ? color->dark_shad() : degui_dark_shad_color);

   // Possibly draw the scrollbar
   if(bar) _draw_scrollbar(x2()-width,y(),width,h(),
                           listsize,
                           offset,
                           height,
                           has_focus(),
                           color ? color->mid() : degui_mid_color,
                           color ? color->back() : degui_back_color,
                           color ? color->deselect() : degui_deselect_color,
                           color ? color->light_shad() : degui_light_shad_color,
                           color ? color->dark_shad() : degui_dark_shad_color);
   _redraw = false;
   }
//----------------------------------------------------------------------------
// Tell the object that it was clicked
void list_object::msg_click (void)
   {
   bool bar = false;
   if(listsize>height) bar = true;

   // Check for a click on a scrollbar
   if((bar==true)&&(mouse_x>x2()-scrollable_object::width)) scrollable_object::handle_click();

   // We have been clicked in the selection area
   else while(mouse_b) handle_click();
   }
//----------------------------------------------------------------------------
// A helper function for dealing with clicks
void list_object::handle_click (void)
   {
   if(listsize<=0) return;

   int old_index = index;
   int old_offset = offset;

   int i = MID(0, ((mouse_y - y() - 2) / text_height(font)),((h()-4)/text_height(font) - 1));
   i += offset;

   if(i<0) i = 0;
   else if(i>=listsize) i = listsize-1;

   if(i!=index)
      {
      index = i;
      i = offset;

      // If we changed something, better redraw...
      if((offset!=old_offset)||(index!=old_index))
         {
         scroll(index);

         show_mouse(NULL);
         send_message(MSG_DRAW);
         show_mouse(screen);
         }
      }
   }
//----------------------------------------------------------------------------
// Tell the object to accept a charater
bool list_object::msg_char (const int c)
   {
   if(listsize>0)
      {
      int old_index = index;
      int old_offset = offset;

      int cc = c>>8;

      int top = 0;
      if(offset>0) top = offset+1;

      int bottom = offset + (h()-4)/text_height(font) - 1;

      if(bottom>=listsize-1) bottom = listsize-1;
      else bottom--;

      if(cc==KEY_UP) index--;
      else if(cc==KEY_DOWN) index++;
      else if(cc==KEY_HOME) index = 0;
      else if(cc==KEY_END) index = listsize-1;
      else if(cc==KEY_PGUP)
         {
         if(index>top) index = top;
         else index -= (bottom-top);
         }
      else if(cc==KEY_PGDN)
         {
         if(index<bottom) index = bottom;
         else index += (bottom-top);
         }
      else return false;

      // If we changed something, better redraw...
      if((offset!=old_offset)||(index!=old_index))
         {
         scroll(index);

         show_mouse(NULL);
         send_message(MSG_DRAW);
         show_mouse(screen);
         }

      // Indicate that we used the char
      return true;
      }
   // If we don't have a list then we can't accept chars
   return false;
   }
//----------------------------------------------------------------------------

