//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Editable text string object
//----------------------------------------------------------------------------
// Constructor
edittext_object::edittext_object (const char *tex, const int len)
   :text(NULL)
   {
   setup(tex,len);
   set_h(text_height(font)+5);
   }
//----------------------------------------------------------------------------
// Constructor
edittext_object::edittext_object (const int len)
   :text(NULL)
   {
   setup(NULL,len);
   set_h(text_height(font)+5);
   }
//----------------------------------------------------------------------------
// Destructor
edittext_object::~edittext_object (void)
   {
   delete text;
   }
//----------------------------------------------------------------------------
// Draw the editable text with a line under
void edittext_object::msg_draw (void)
   {
   offsetpos = _draw_edittext_object(text,
                                     cursorpos,
                                     offsetpos,
                                     x(),y(),w(),h(),
                                     disabled(),has_focus(),
                                     color ? color->fore() : degui_fore_color,
                                     color ? color->deselect() : degui_deselect_color,
                                     color ? color->disable() : degui_disable_color,
                                     color ? color->light_shad() : degui_light_shad_color,
                                     color ? color->dark_shad() : degui_dark_shad_color);
   _redraw = false;
   }
//----------------------------------------------------------------------------
// Move the cursor in response to a click
void edittext_object::msg_click (void)
   {
   int p;
   int x1 = x() + 4;
   char s[2]  = ".";
   int l = strlen(text);

	for(p=0; p<l; p++)
	   {
	   s[0] = text[p];
      x1 += text_length(font,(unsigned char*)s);
      if(x1>mouse_x) break;
      }
   int old_cursorpos = cursorpos;
   cursorpos = p;

   // If we changed something, redraw
   if(cursorpos!=old_cursorpos)
      {
      show_mouse(NULL);
	   msg_draw();
      show_mouse(screen);
      }
   }
//----------------------------------------------------------------------------
// Yes, we always want the focus
bool edittext_object::msg_char (const int c)
   {
   int l = strlen(text);

	if((c>>8)==KEY_LEFT)
	   {
	   if(cursorpos>0) cursorpos--;
      }
   else if((c>>8)==KEY_RIGHT)
      {
	   if(cursorpos<l) cursorpos++;
      }
   else if((c>>8)==KEY_HOME)
      {
      cursorpos = 0;
      }
   else if((c>>8)==KEY_END)
      {
      cursorpos = l;
      }
   else if((c>>8)==KEY_DEL)
      {
      if(cursorpos<l)
         for(int p=cursorpos;text[p];p++)
            text[p] = text[p+1];
      }
   else if((c>>8)==KEY_BACKSPACE)
      {
      if(cursorpos>0)
         {
         cursorpos--;
         for(int p=cursorpos;text[p];p++)
            text[p] = text[p+1];
         }
      }
   else
      {
      int cc = (c&0xff);

      if((cc>=32)&&(cc<=126))
         {
         if(l<max_length)
            {
            while(l>=cursorpos)
               {
               text[l+1] = text[l];
               l--;
               }
            text[cursorpos] = cc;
            cursorpos++;
            }
         }
      else return false;
      }
   // If we changed something, redraw
   show_mouse(NULL);
	msg_draw();
   show_mouse(screen);
	return true;
   }
//----------------------------------------------------------------------------
// Set and get the editable text
void edittext_object::set_text (const char *tex, const int len)
   {
   const char *atext = "";
   if(tex!=NULL) atext = tex;

   // Check if new length is longer than the old
   int l = strlen(tex) + 1;

   // User gave string but not length or length is not enough
   if((l>max_length)||(len<0))
      {
      // Expand the room for the new stuff
      text = new char[l];
      }
   // User gave string and length
   else if(len>0)
      {
      // Expand the room for the new stuff
      text = new char[len];
      }
   // Copy the stuff over
   strcpy(text,atext);
   cursorpos = l;

   offsetpos = 0;
   redraw();
   }
//----------------------------------------------------------------------------
// Setup the internal buffer if necessary
void edittext_object::setup (const char *tex, const int len)
   {
   bool have_example = true;
   if(tex==NULL) have_example = false;

   int example_len = -1;
   if(tex!=NULL) example_len = strlen(tex);

   // Find the minimum length
   int l = len;
   if(len<0) l = example_len;

   int l2 = l;
   if(l2<0) l2 = 14; // Set the default length

   // Make room and copy the text
   delete text;
   text = new char[l2];
   if(text==NULL) degui_no_memory();

   if(tex!=NULL) strcpy(text,tex);
   else strcpy(text,"");

   max_length = l2;

   cursorpos = strlen(text);
   offsetpos = 0;

   // Setup the defaults
   set_x(100);
   set_y(100);
   set_h(text_height(font)*3/2);
   set_w(text_length(font,(unsigned char*)"W") * (len+1));

   // This object tries to keep the focus
   demand_focus = true;
   }
//----------------------------------------------------------------------------

