//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "undefine.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Some helpful typedefines
typedef char *(*getfuncptr)(int, int *);

//----------------------------------------------------------------------------
// Draw the listbox in a degui style
int d_degui_list_proc (int msg, DIALOG *d, int c)
   {
   int listsize, height, bar;

   if(msg==MSG_DRAW)
      {
      listsize = 0;
      (*(getfuncptr)d->dp)(-1, &listsize);

      height = (d->h-3) / text_height(font);
      if(listsize > height) bar = 10;
      else bar = 0;
      if(bar==0) d->d2 = 0;

      _draw_list_object((getfuncptr)d->dp,
                        &listsize,
                        d->d2,
                        d->x,d->y,d->w-bar,d->h,
                        d->d1,
                        d->flags&D_DISABLED,
                        d->flags&D_GOTFOCUS,
                        degui_fore_color,
                        degui_select_color,degui_deselect_color,
                        degui_disable_color,
                        degui_light_shad_color,degui_dark_shad_color);

      // Possibly draw the scrollbar
      if(bar) _draw_scrollbar(d->x+d->w-10,d->y,10,d->h,listsize,d->d2,height,d->flags&D_GOTFOCUS,degui_mid_color,degui_back_color,degui_deselect_color,degui_light_shad_color,degui_dark_shad_color);

      return D_O_K;
      }
   else
      {
      return d_list_proc(msg,d,c);     /* call the parent procedure */
      }
   }
//----------------------------------------------------------------------------

