//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

Multiple window_object example

*/

#include "allegro.h"
#include "degui.h"

//----------------------------------------------------------------------------
int main(void)
   {
   // Initialise the Allegro stuff
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode and basic object colors
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Declare the objects
   clear_screen_object  clear_obj;

   // Make the first window
   window_object	win1("Window 1");

   button_object        butt1("test1");
   button_object        butt2("test2");
   win1.add(butt1,5,20);
   win1.add(butt2,5,40);

   // Make the second window
   window_object	win2("Window 2");

   button_object        butt3("test3");
   button_object        butt4("test4");
   win2.add(butt3,5,20);
   win2.add(butt4,5,40);

   // Declare the dialog
   dialog thedialog;

   // Add the objects to the dialog
   thedialog.add(clear_obj);
   thedialog.add(win1,100,100);
   thedialog.add(win2,250,100);

   // Now center everything and then do the dialog
   thedialog.center();
   thedialog.execute();

   // Close up and go home
   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------

