//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

Object change color_scheme example

*/

#include "allegro.h"
#include "degui.h"

// The alternate color scheme
color_scheme alternate;

//----------------------------------------------------------------------------
// Simple wrapper class for the button object to catch a 'S' passed to the
// object and toggle between the default and a custon color_scheme
class color_change_button
         // Derived from a button object
			:public button_object
			{
			public:
					// Constructors and destructors just apss stuff along
               // to the button_object constructor
					color_change_button (const char *s, const char c)
                  : button_object(s,c,false) { };
					virtual ~color_change_button (void) { };

               // Message functions
               // Catch a 'S' and change the color scheme
               virtual bool msg_char (const int c)
                  {
                  // Check if we got the switch key
                  if(((c>>8)==KEY_S)||((c>>8)==KEY_S))
                     {
                     // Switch to the new color scheme
                     if(color==NULL) color = &alternate;

                     // Or switch back to the default
                     else color = NULL;

                     // Redraw to make changes visible
                     redraw();

                     // We used the key
                     return true;
                     }
                  // We did not recognise the key
                  return false;
                  }
         };
//----------------------------------------------------------------------------
int main(void)
   {
   // Initialise the Allegro stuff
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode and basic object colors
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Choose color indexes for the alternate color scheme
   RGB newfore     = { 235/4, 235/4, 235/4 };
   RGB newselect   = { 255/4, 0,     0     };
   RGB newdeselect = { 0,     0,     255/4 };
   set_color(1,&newfore);
   set_color(2,&newselect);
   set_color(3,&newdeselect);

   // Setup the alternate color scheme
   alternate.reset();
   alternate.set_fore(1);
   alternate.set_select(2);
   alternate.set_deselect(3);

   // Declare the objects
   clear_screen_object  clear_obj;
   color_change_button	Hello("'S' to alternate color schemes",0);

   // Declare the dialog
   dialog thedialog;

   // Add the objects to the dialog
   thedialog.add(clear_obj);
   thedialog.add(Hello);

   // Now center everything and then do the dialog
   thedialog.center();
   thedialog.execute(&Hello);

   // Close up and go home
   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------

