//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

CALLBACK FUNCTION EXAMPLE

  Here is an example of using callback functions to interface with
  the dialog objects.  Just call the set_?????_callback function with
  the function you want called when the event occours.  In this example
  we catch the click of a button and use it to switch the fonts of the
  entire dialog.  In this case the line:

      toggle_button.set_click_callback(function);

  says that when the toggle button is clicked, call the function.  The
  object won't do it's normal behaviour for a click, such as selecting
  or deselecting itself.  You can ask the object to do it's default
  behaviour by calling the function:

      void default_behaviour (void);

  When the checkbox is unselected, that the button does not
  change color when clicked and does change color when the checkbox
  is selected.  This is because when the checkbox is selected the
  default behaviour of the object is done.  In this case the object
  is a button and it's default behaviour is to toggle on/off when
  clicked.

  This technique is generally most usefull for changing the behaviour
  of an object a little bit.
*/

#include <stdio.h>
#include "allegro.h"
#include "example.h"

// Include the dialog objects
#include "degui.h"

// Declare the dialog and the objects
dialog the_dialog;
clear_screen_object  clear_obj;
button_object			toggle_button("&Switch fonts",'s');
checkbox_object		check1("Also do default behaviour for button");
button_object        done_button("Done",0,true);

// We must load example.dat to access the big font
FONT *original_font = font;
DATAFILE *datafile;

// Here is the function to actually do the work of switching the fonts
int switch_fonts (void)
   {
	if(font==original_font) font = (FONT*)datafile[BIG_FONT].dat;
	else font = original_font;

   // Check if we are to do the default behaviour
   if(check1.selected()==true) dialog_object::default_behaviour();

   // Wait for the mouse button to go up
	while(mouse_b){};

   // Now we need to update the whole screen
   return D_REDRAW;
   }

//----------------------------------------------------------------------------
int main(void)
   {
   /* initialise everything */
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Load the data file to access the big font
   datafile = load_datafile("example.dat");
   if(!datafile)
      {
      allegro_exit();
      printf("Error loading example.dat!\n\n");
      exit(1);
      }

   // Set up the graphics mode
   set_gfx_mode(GFX_VESA1,640,480,0,0);
   set_pallete(desktop_pallete);

   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Declare and construct the dialog
   // The position, size and color arguments all have defaults
                               // (x)   (y)   (w)   (h)   (fg)  (bg)
   the_dialog.add(clear_obj);
   the_dialog.add(check1,         80,   320,  600,  15 );
   the_dialog.add(toggle_button,  80,   182,  160,  48 );
   the_dialog.add(done_button,    360,  400,  160,  48 );

   // Set the callback for clicking or keypress on the toggle button
   // so that we catch the click or keypress on the button and use
   // it to change the fonts
   toggle_button.set_key_callback(switch_fonts);
   toggle_button.set_click_callback(switch_fonts);

   // Do the dialog
   the_dialog.center();
   the_dialog.execute();

   // Free anything that we have allocated
   unload_datafile(datafile);

   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------
