//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

Simple use of a progress bar

*/

#include "allegro.h"
#include "degui.h"

//----------------------------------------------------------------------------
// The main timer variable and function
int slow_timer = 0;

void timer_function (...)
   {
   slow_timer++;
   if(slow_timer>100) slow_timer = 0;
   }

//----------------------------------------------------------------------------
// The definition of the progress bar object
progress_bar_object progress_bar;

// The progress bar grabs the timer info here with this callback
int progress_bar_idle_callback (void)
   {
   static int last_timer = 0;

   // Only update the progress bar if something has changed
   if(last_timer!=slow_timer) progress_bar.progress(slow_timer);
   last_timer = slow_timer;

   return D_O_K;
   }

//----------------------------------------------------------------------------
int main(void)
   {
   // Initialise the Allegro stuff
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode and basic object colors
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Declare the objects
   clear_screen_object  clear_obj;
   // The progress bar is alleady declared

   // Setup the timer and the callback
   install_int(timer_function,100);

   // Check if the progress bar has changed while the gui manager is bored
   progress_bar.set_idle_callback(progress_bar_idle_callback);

   // Declare the dialog
   dialog thedialog;

   // Add the objects to the dialog
   thedialog.add(clear_obj);
   thedialog.add(progress_bar);

   // Now center everything and then do the dialog
   thedialog.center();
   thedialog.execute();

   // Close up and go home
   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------

