//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

HELLO WORLD EXAMPLE

  Here is a simple hello world example in mixed
  C/C++ style and full C++ style

*/
#include "stdio.h"
#include "allegro.h"

// Include the dialog objects
#include "degui.h"

//----------------------------------------------------------------------------
int main(void)
   {
   // Initialise the Allegro stuff
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode and basic object colors
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_pallete(desktop_pallete);

   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Declare the C++ objects
   clear_screen_object  clear_obj;
   button_object			button("C++ button in C DIALOG",0,false);
   button_object        done("Done method 1",0,true);

//****************************************************************************
// First method - Mixed C/C++ objects, C dialog
//****************************************************************************

   DIALOG c_style[] =
      {
      /* (dialog proc)      (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */

      // Here are some normal C objects
      { d_clear_proc,       0,    0,    192,  172,  255,  0,    0,    0,       0,    0,    NULL },
      { d_button_proc,      50,   50,   250,  30,   255,  0,    0,    0,       0,    0,    "This is a C button" },

      // Here are some C++ objects in the middle of a C style dialog !!!
      button.create_DIALOG( 50,   10,   250,  30),  // There are defaults for fg and bg so we don't have to fill them in
      done  .create_DIALOG( 50,   100,  150,  30),

      // The terminating NULL dialog, dont forget this or there will be trouble
      { NULL,               0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
      };

      // Centre and do the dialog - C style
   centre_dialog(c_style);
   do_dialog(c_style,2);  // You have to count the DIALOGS to get the inital focus object index

//****************************************************************************
// Second method - Mixed C/C++ objects, C++ dialog
//****************************************************************************
   rest(100);

   // Declare the C++ dialog
   dialog cpp_style1;

   // Add the objects to the dialog
   // The color arguments have defaults so we don't have to fill then in
   // The size and position arguments default to 0,0 and 0,0 so we had
   // better fill them in if it's important
                           // (x)   (y)   (w)   (h)   (fg)         (bg)
   cpp_style1.add(clear_obj);
   cpp_style1.add(button,       50,  10,   250,  30);
   cpp_style1.add(d_button_proc,50,  50,   250,  30,  235, 236,    0,    0,       0,    0,    "C button in C++ dialog");
   cpp_style1.add(done,         50,  100,  150,  30);

   // Change the button text to something more suitable
   button.set_text("This is a C++ button");
   done.set_text("Done method 2");

   done.deselect();

   // Now center everything and then do the dialog - C++ style
   cpp_style1.center();
   cpp_style1.execute(&button);  // Give the inital focus to the button

//****************************************************************************
// Third method - Full C++
//****************************************************************************
   rest(100);

   // Declare the C++ dialog
   dialog cpp_style2;

   // Add the objects to the dialog
   // The color arguments have defaults so we don't have to fill then in
   // The size and position arguments default to 0,0 and 0,0 so we had
   // better fill them in if it's important
                           // (x)   (y)   (w)   (h)   (fg)  (bg)
   cpp_style2.add(clear_obj);
   cpp_style2.add(button,       50,  10,   250,  30);
   cpp_style2.add(done,         50,  100,  150,  30);

   // Change the button text to something more suitable
   button.set_text("Full C++ button and dialog");
   done.set_text("Done method 3");

   done.deselect();

   // Now center everything and then do the dialog - C++ style
   cpp_style2.center();
   cpp_style2.execute(&button);  // Give the inital focus to the button

   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------

