//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "backg.h"
#include "manipul.h"

//----------------------------------------------------------------------------
// Helper function for dialog to resize objects
void do_object_resize (DIALOG *pointed, DIALOG *current, const int gran)
   {
   int original_w, original_h;
   int last_mousex, last_mousey, this_mousex, this_mousey;
   int done_resize;
   BITMAP *bak;

   // Make sure that we pointed to an object
   if((pointed==NULL)||(current==NULL)) return;

   // The original object size
   original_w = pointed->w;
   original_h = pointed->h;

   // Move the mouse to the object
   position_mouse(pointed->x+pointed->w,pointed->y+pointed->h);
   last_mousex = (mouse_x/gran)*gran;
   last_mousey = (mouse_y/gran)*gran;
   this_mousex = (mouse_x/gran)*gran;
   this_mousey = (mouse_y/gran)*gran;
   set_mouse_range(pointed->x+1+gran,pointed->y+1+gran,SCREEN_W,SCREEN_H);

   // Get the object background
   bak = create_bitmap(pointed->w+1,pointed->h+1);
   get_object_background(bak,pointed);

   // Move the object where the user wants it
   done_resize = FALSE;
   while(done_resize==FALSE)
      {
      // Only redraw when the mouse has moved
      if((last_mousex!=this_mousex)||(last_mousey!=this_mousey))
         {
         // Replace with the background
         show_mouse(NULL);
         blit(bak,screen,0,0,pointed->x,pointed->y,pointed->w+1,pointed->h+1);

         // Resize the object
         pointed->w = this_mousex - pointed->x;
         pointed->h = this_mousey - pointed->y;

         // Resize the temporary bitmaps
         destroy_bitmap(bak);
         bak = create_bitmap(pointed->w+1,pointed->h+1);

         // Get the new background
         blit(screen,bak,pointed->x,pointed->y,0,0,pointed->w+1,pointed->h+1);

         // Draw the object
         pointed->proc(MSG_DRAW,pointed,0);
         rect(screen,pointed->x,pointed->y,pointed->x+pointed->w,pointed->y+pointed->h,gui_fg_color);
         show_mouse(screen);

         // Remember where the mouse was
         last_mousex = this_mousex;
         last_mousey = this_mousey;
         }
      this_mousex = (mouse_x/gran)*gran;
      this_mousey = (mouse_y/gran)*gran;

      // Check for user keys
      if(keypressed())
         {
         switch(readkey()>>8)
            {
            // Check for user escape
            case(KEY_ESC):
               {
               // Replace the old position and return
               pointed->w = original_w;
               pointed->h = original_h;
               done_resize = TRUE;
               break;
               }
            // Normal moving exit
            case(KEY_SPACE):
            case(KEY_ENTER):
               {
               done_resize = TRUE;
               break;
               }
            // Check if it was the invoking key
            default:
               {
               };
            }
         }
      // Pressing the mouse will also set the object down
      else if(mouse_b)
         {
         done_resize = TRUE;
         while(mouse_b) {};
         }
      }
   // Cleanup the keyboard buffer and the bitmaps
   destroy_bitmap(bak);

   set_mouse_range(0,0,SCREEN_W,SCREEN_H);
   }
//----------------------------------------------------------------------------

