//----------------------------------------------------------------------------
// Gui object descriptions class
//----------------------------------------------------------------------------
#ifndef DEGUI_OBJECT_DESCRIPTION
#define DEGUI_OBJECT_DESCRIPTION

//----------------------------------------------------------------------------
#include "degui.h"
#include "allegro.h"

//----------------------------------------------------------------------------
// A flag to identify description objects
//#define DEGUI_DESCRIPTION  128

//----------------------------------------------------------------------------
// Some constants used for encoding and decoding objects
extern const char *box_type;
extern const char *shadow_box_type;
extern const char *panel_raised_type;
extern const char *panel_sunken_type;
extern const char *panel_ridge_type;
extern const char *panel_groove_type;
extern const char *bitmap_type;
extern const char *text_type;
extern const char *centerd_text_type;
extern const char *button_type;
extern const char *checkbox_type;
extern const char *radio_button_type;
extern const char *edittext_type;
extern const char *list_type;
extern const char *progress_bar_type;
extern const char *window_type;
extern const char *textbox_type;
extern const char *hidden_list_type;

extern const char *illegal_type;

//----------------------------------------------------------------------------
// This class describes a dialog object
//----------------------------------------------------------------------------
class object_description
         :public dialog_object
         {
			private:
               // The index of the object
               // Which is used to build the default object variable name
               int index;

               // Data for names and declarations
               char *type;
               char *name;
               char *arguments;

               // Helper functions for decoding
               char *remove_quotes (char*);

			protected:

			public:
					// Constructors and destructors
					object_description (void);
					virtual ~object_description (void);

               // Name and type information
               void set_type      (const char*);
               void set_name      (const char*);
               void set_arguments (const char*);
               void set_index     (const int i) { index = i; };

               const char* get_type      (void) { if(type!=NULL) return type; else return "NULL"; };
               const char* get_name      (void);
               const char* get_arguments (void) { if(arguments!=NULL) return arguments; else return "NULL"; };

               // Create an object from a character stream
               void encode (char*);
               dialog_object* decode (char*);
			};

//----------------------------------------------------------------------------
// Helper user object for the builder
//----------------------------------------------------------------------------
class helper_object
			:public text_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_object (char*);
               virtual ~helper_object (void);

               // Message functions
               virtual void msg_draw (void);
			};

//----------------------------------------------------------------------------
// Helper bitmap object for the builder
//----------------------------------------------------------------------------
class helper_bitmap_object
			:public bitmap_object
			{
			private:
               // Text to write if the bitmap is null
               char *text;

         protected:

			public:
					// Constructors and destructors
               helper_bitmap_object (char*);
               virtual ~helper_bitmap_object (void);

               // Message functions
               virtual void msg_draw (void);
			};

//----------------------------------------------------------------------------
// Helper text object for the builder
//----------------------------------------------------------------------------
class helper_text_object
			:public text_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_text_object (char*);
               virtual ~helper_text_object (void);
			};

//----------------------------------------------------------------------------
// Helper centerd text object for the builder
//----------------------------------------------------------------------------
class helper_centerd_text_object
			:public centerd_text_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_centerd_text_object (char*);
               virtual ~helper_centerd_text_object (void);
			};

//----------------------------------------------------------------------------
// Helper button object for the builder
//----------------------------------------------------------------------------
class helper_button_object
			:public button_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_button_object (char*, const int, const bool);
               virtual ~helper_button_object (void);
			};

//----------------------------------------------------------------------------
// Helper checkbox object for the builder
//----------------------------------------------------------------------------
class helper_checkbox_object
			:public checkbox_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_checkbox_object (char*);
               virtual ~helper_checkbox_object (void);
			};

//----------------------------------------------------------------------------
// Helper radio button object for the builder
//----------------------------------------------------------------------------
class helper_radio_button_object
			:public radio_button_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_radio_button_object (char*, const int, const bool);
               virtual ~helper_radio_button_object (void);
			};

//----------------------------------------------------------------------------
// Helper window object for the builder
//----------------------------------------------------------------------------
class helper_window_object
			:public window_object
			{
			private:

         protected:

			public:
					// Constructors and destructors
               helper_window_object (char*, int n);
               virtual ~helper_window_object (void);

               // Overload a message for better handling
               virtual void msg_click (void) { };
			};
//----------------------------------------------------------------------------
#endif
