indexing
    description    : "Allegro con Eiffel: info_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : ace_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class INFO_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    do

--------------------------------------------------- ACE initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("ACE initialisation error: ")
        end  -- if


--------------------------------------------------- ACE information

        -- Retrieve the id of ACE
        io.put_character('%N')
        io.put_string(info.id)

        -- Retrieve the id of Allegro
        io.put_character('%N')
        io.put_string(info.allegro_id)

        -- Retrieve the windows version
        io.put_string("%NWindows version: ")
        io.put_integer(info.windows_version)
        io.put_character('.')
        io.put_integer(info.windows_sub_version)

        -- Retrieve the last Allegro error
        io.put_string("%NLast Allegro error: ")
        io.put_string(info.error_description)

    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1024


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the ace error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class INFO_TEST
