indexing
    description    : "18 bit rgb colour objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    names          : rgb18bit
    date_started   : "17th December, 1996"
    version        : "0.1"


class RGB18BIT


inherit
    RGB
        rename   make as rgb_make
        redefine make
    end  -- inherit RGB


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make(r, g, b : INTEGER) is
    -- Create a new rgb with the specified components
    require else
        red_is_valid   : r <= 63
        green_is_valid : g <= 63
        blue_is_valid  : b <= 63
    do
        rgb_make(r,g,b)
    end  -- feature make


------------------------------------------------------ Class invariant
invariant

    red_is_valid   : red   <= 63
    green_is_valid : green <= 63
    blue_is_valid  : blue  <= 63


end  -- class RGB18BIT


