/*
 * MSCD.C - Contains MSCDEX functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _MSCD_CC_

#include "mscd.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 int major, minor;
 __dpmi_regs regs;

 // Create output file.
 if ((fp = fopen("mscd.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 writestring("\nMSCDEX CDROM(s) :\n\n");
 // MSCDEX installation check.
 regs.x.ax = 0x150b;
 regs.x.cx = 0;
 __dpmi_int(0x2f, &regs);
 if (regs.x.bx != 0xadad) {
    writestring("\tMSCDEX not Installed.\n");
    fclose(fp);
    return 0;
 }
 else writestring("\tMSCDEX Installed                          : Yes\n");

 // Here we come if we have MSCDEX Installed.
 regs.x.ax = 0x150c;
 __dpmi_int(0x2f, &regs);
 major = regs.h.bh; minor = regs.h.bl;
 if (!regs.x.bx)
    writestring("\tMSCDEX Version                            : Prior to 2.0\n");
 else {
      sprintf(output, "\tMSCDEX Version                            : %d.%02d\n",
		 major, minor);
      writestring(output);
      regs.x.ax = 0x1500;
      regs.x.bx = 0;
      __dpmi_int(0x2f, &regs);
      sprintf(output, "\tNumber of CDROM drives                    : %d\n",
		      regs.x.bx);
      writestring(output);
      sprintf(output, "\tCDROM drive offset                        : %c\n",
		      regs.x.cx + 'A');
      writestring(output);
 }

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(&__dj_stdout);
	fclose(&__dj_stderr);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

// The main function.
int main()
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
