/*
 * HDD.C - Contains Hard Disk functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _HDD_CC_

#include "hdd.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 unsigned char lasthdd;
 __dpmi_regs regs;

 // Create output file.
 if ((fp = fopen("hdd.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 // Get HDD information.
 lasthdd = 0x80;
 writestring("\nHARD DISK(S) BIOS INFORMATION :\n\n");
 do {

    // Check if HDD present.
    regs.h.ah = 0x15;
    regs.h.dl = lasthdd; // Drive no.
    __dpmi_int(0x13, &regs);

    // Check if drive exists.
    if ((regs.x.flags & 1) || (regs.h.ah != 3)) {
       sprintf(output, "\tHard Disk %02d Installed            : No\n",
		       lasthdd - 0x7f);
       writestring(output);
       break;
    }
    else {
	 sprintf(output, "\tHard Disk %02d Installed            : Yes\n",
		       lasthdd - 0x7f);
	 writestring(output);

	 // Get HDD information.
	 regs.h.ah = 8;
	 regs.h.dl = lasthdd; // Drive no.
         __dpmi_int(0x13, &regs);

	 sprintf(output, "\tNumber of Cylinders               : %d\n",
			 ((regs.h.cl & 0xc0) << 2) + regs.h.ch + 1);
	 writestring(output);
	 sprintf(output, "\tNumber of Sectors                 : %d\n",
			 regs.h.cl & 0x3f);
	 writestring(output);
	 sprintf(output, "\tNumber of Heads                   : %d\n",
			 regs.h.dh + 1);
	 writestring(output);
    }
    lasthdd++;
 } while (1);

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(&__dj_stdout);
	fclose(&__dj_stderr);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

// The main function.
int main()
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
