/*
 * FDD.C - Contains Floppy Disk functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _FDD_CC_

#include "fdd.h"

int errflag = 0;
char cmdline[20];
FILE *fp;

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 unsigned char buffer[12];
 __dpmi_regs regs;

 // Create output file.
 if ((fp = fopen("fdd.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 // Get FDD information.
 writestring("\nFLOPPY DRIVE(S) INFORMATION :\n\n");

 // Get parameter table and other information.
 regs.h.ah = 8;
 regs.h.dl = 0; // Drive A:
 __dpmi_int(0x13, &regs);

 // Check if drive exists.
 if ((regs.x.flags & 1) || (regs.h.ah))
    writestring("\tFloppy Drive A: Installed           : No\n");
 else {
    writestring("\tFloppy Drive A: Installed           : Yes\n");
    sprintf(output, "\tFloppy Drive type                   : %s (type %d)\n",
		    (regs.h.bl == 1) ? "5 and 1/4 inch, 360K" :
		    (regs.h.bl == 2) ? "5 and 1/4 inch, 1.2M" :
		    (regs.h.bl == 3) ? "3 and 1/2 inch, 720K" :
		    (regs.h.bl == 4) ? "3 and 1/2 inch, 1.44M" :
		    (regs.h.bl == 5) ? "3 and 1/2 inch, 2.88M" :
		    (regs.h.bl == 6) ? "3 and 1/2 inch, 2.88M" :
		    "(Unknown)",
		    regs.h.bl);
    writestring(output);
    sprintf(output, "\tNumber of Cylinders                 : %d\n",
		    ((regs.h.cl & 0xc0) << 2) + regs.h.ch + 1);
    writestring(output);
    sprintf(output, "\tNumber of Sectors                   : %d\n",
		    regs.h.cl & 0x3f);
    writestring(output);
    sprintf(output, "\tNumber of Heads                     : %d\n",
		    regs.h.dh + 1);
    writestring(output);

    // Write out drive parameters.
    dosmemget(regs.x.es * 0x10 + regs.x.di, 11, buffer);

    // Check for change-line support.
    regs.h.ah = 0x15;
    regs.h.dl = 0;
    __dpmi_int(0x13, &regs);

    if (!(regs.x.flags & 1)) {
       sprintf(output, "\tCan detect Disk Change              : %s\n",
		       (!regs.h.ah) ? "No such Drive???!!!" :
		       (regs.h.ah == 1) ? "No" :
		       (regs.h.ah == 2) ? "Yes" :
		       "(Unknown)");
       writestring(output);
    }

    writestring("\n\tDEFAULT DRIVE PARAMETERS :\n\n");
    sprintf(output, "\tDrive Step Rate                     : %d\n",
		    buffer[0] >> 4);
    writestring(output);
    sprintf(output, "\tHead Unload time                    : %d milliseconds\n",
		    (buffer[0] & 0xf) * 16);
    writestring(output);
    sprintf(output, "\tHead Load time                      : %d milliseconds\n",
		    (buffer[1] >> 1) * 4);
    writestring(output);
    sprintf(output, "\tMotor turn-off delay                : %d clock ticks\n",
		    buffer[2]);
    writestring(output);
    sprintf(output, "\tBytes Per Sector                    : %d\n",
		    buffer[3]);
    writestring(output);
    sprintf(output, "\tLength of gap between Sectors       : %Xh units\n",
		    buffer[5]);
    writestring(output);
    sprintf(output, "\tGap length when Formatting          : %Xh\n",
		    buffer[7]);
    writestring(output);
    sprintf(output, "\tFormat filler byte                  : %Xh\n",
		    buffer[8]);
    writestring(output);
    sprintf(output, "\tHead Settle time                    : %d milliseconds\n",
		    buffer[9]);
    writestring(output);
    sprintf(output, "\tMotor Start time                    : %4.3f seconds\n",
		    buffer[10] / 8.0);
    writestring(output);
 }

 // Get the same for Drive B:
 writestring("\n");
 regs.h.ah = 8;
 regs.h.dl = 1; // Drive B:
 __dpmi_int(0x13, &regs);

 // Check if drive exists.
 if ((regs.x.flags & 1) || (regs.h.ah) || (regs.h.dl < 2))
    writestring("\tFloppy Drive B: Installed           : No\n");
 else {
    writestring("\tFloppy Drive B: Installed           : Yes\n");
    sprintf(output, "\tFloppy Drive type                   : %s (type %d)\n",
		    (regs.h.bl == 1) ? "5 and 1/4 inch, 360K" :
		    (regs.h.bl == 2) ? "5 and 1/4 inch, 1.2M" :
		    (regs.h.bl == 3) ? "3 and 1/2 inch, 720K" :
		    (regs.h.bl == 4) ? "3 and 1/2 inch, 1.44M" :
		    (regs.h.bl == 5) ? "3 and 1/2 inch, 2.88M" :
		    (regs.h.bl == 6) ? "3 and 1/2 inch, 2.88M" :
		    "(Unknown)",
		    regs.h.bl);
    writestring(output);
    sprintf(output, "\tNumber of Cylinders                 : %d\n",
		    ((regs.h.cl & 0xc0) << 2) + regs.h.ch + 1);
    writestring(output);
    sprintf(output, "\tNumber of Sectors                   : %d\n",
		    regs.h.cl & 0x3f);
    writestring(output);
    sprintf(output, "\tNumber of Heads                     : %d\n",
		    regs.h.dh + 1);
    writestring(output);

    // Write out drive parameters.
    dosmemget(regs.x.es * 0x10 + regs.x.di, 11, buffer);

    // Check for change-line support.
    regs.h.ah = 0x15;
    regs.h.dl = 1;
    __dpmi_int(0x13, &regs);

    if (!(regs.x.flags & 1)) {
       sprintf(output, "\tCan detect Disk Change              : %s\n",
		       (!regs.h.ah) ? "No such Drive???!!!" :
		       (regs.h.ah == 1) ? "No" :
		       (regs.h.ah == 2) ? "Yes" :
		       "(Unknown)");
       writestring(output);
    }

    writestring("\n\tDEFAULT DRIVE PARAMETERS :\n\n");
    sprintf(output, "\tDrive Step Rate                     : %d\n",
		    buffer[0] >> 4);
    writestring(output);
    sprintf(output, "\tHead Unload time                    : %d milliseconds\n",
		    (buffer[0] & 0xf) * 16);
    writestring(output);
    sprintf(output, "\tHead Load time                      : %d milliseconds\n",
		    (buffer[1] >> 1) * 4);
    writestring(output);
    sprintf(output, "\tMotor turn-off delay                : %d clock ticks\n",
		    buffer[2]);
    writestring(output);
    sprintf(output, "\tBytes Per Sector                    : %d\n",
		    buffer[3]);
    writestring(output);
    sprintf(output, "\tLength of gap between Sectors       : %Xh units\n",
		    buffer[5]);
    writestring(output);
    sprintf(output, "\tGap length when Formatting          : %Xh\n",
		    buffer[7]);
    writestring(output);
    sprintf(output, "\tFormat filler byte                  : %Xh\n",
		    buffer[8]);
    writestring(output);
    sprintf(output, "\tHead Settle time                    : %d milliseconds\n",
		    buffer[9]);
    writestring(output);
    sprintf(output, "\tMotor Start time                    : %4.3f seconds\n",
		    buffer[10] / 8.0);
    writestring(output);
 }

 // Write current parameter setup.
 dosmemget(_farpeekw(_dos_ds, 122) * 0x10 + _farpeekw(_dos_ds, 120),
                               11, buffer);
 writestring("\n\tCURRENT PARAMETER SETUP (IF FDD PRESENT) :\n\n");
 sprintf(output, "\tDrive Step Rate                     : %d\n",
		 buffer[0] >> 4);
 writestring(output);
 sprintf(output, "\tHead Unload time                    : %d milliseconds\n",
		 (buffer[0] & 0xf) * 16);
 writestring(output);
 sprintf(output, "\tHead Load time                      : %d milliseconds\n",
		 (buffer[1] >> 1) * 4);
 writestring(output);
 sprintf(output, "\tMotor turn-off delay                : %d clock ticks\n",
		 buffer[2]);
 writestring(output);
 sprintf(output, "\tBytes Per Sector                    : %d\n",
		 buffer[3]);
 writestring(output);
 sprintf(output, "\tLength of gap between Sectors       : %Xh units\n",
		 buffer[5]);
 writestring(output);
 sprintf(output, "\tGap length when Formatting          : %Xh\n",
		 buffer[7]);
 writestring(output);
 sprintf(output, "\tFormat filler byte                  : %Xh\n",
		 buffer[8]);
 writestring(output);
 sprintf(output, "\tHead Settle time                    : %d milliseconds\n",
		 buffer[9]);
 writestring(output);
 sprintf(output, "\tMotor Start time                    : %4.3f seconds\n",
		 buffer[10] / 8.0);
 writestring(output);

 fclose(fp);

 return 0;
}

void open_stderr()
{
	fclose(&__dj_stdout);
	fclose(&__dj_stderr);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

// The main function.
int main()
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return(sysinfo());

 return 0;
}
