/* ID for this file. */

#ifndef _EDITOR_H_

#define _EDITOR_H_

#include <ctype.h>
#include <time.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dpmi.h>
#include <go32.h>
#include <string.h>
#include <unistd.h>
#include <dir.h>
#include <bios.h>
#include <sys/nearptr.h>
#include <sys/farptr.h>
#include <sys/exceptn.h>

/* Definitions. */
#define MAXWINDOWS 10
#define YES 1
#define NO 0
#define TRUE 1
#define FALSE 0
#define ON 1
#define OFF 0

#define shiftstatus _farpeekb(_dos_ds, 0x417)
#define _setcursortype(X) setcursortype(X)
#define FP_SEG(X) _my_ds()
#define FP_OFF(X) (unsigned)X
#define setcursor\
	scrollbars();\
	if (!pref.scrltype) {\
                textcolor(pref.wincolor); textbackground(pref.winbkcolor);\
		gotoxy(win -> xbar, win -> y2); cprintf("**********");\
		gotoxy(win -> x2, win -> ybar); putch('*');\
		gotoxy(win -> x2, win -> ybar + 1); putch('*');\
		gotoxy(win -> x2, win -> ybar + 2); putch('*');\
		gotoxy(win -> x2, win -> ybar + 3); putch('*');\
		gotoxy(win -> x2, win -> ybar + 4); putch('*');\
		gotoxy(win -> x2, win -> ybar + 5); putch('*');\
	}\
	else {\
                textcolor(pref.wincolor); textbackground(pref.winbkcolor);\
		gotoxy(win -> xbar, win -> y2); putch('');\
		gotoxy(win -> x2, win -> ybar); putch('');\
	}\
        textcolor(pref.statusbarcolor); textbackground(pref.statusbarbkcolor);\
	gotoxy(65, 25); cprintf("%d:%d    ", \
		win -> logicalrow, win -> logicalcol);\
	gotoxy(win -> physicalcol, win -> physicalrow)


/* The editor data structure. */
typedef struct _TEXT_tag {
	struct _TEXT_tag	*next;
	struct _TEXT_tag	*prev;
	int 			valid;
	char 			text[256];
} TEXT;

/* The window handle structure. No C++, members defined separately. */
typedef struct _WINDOW_tag {
	unsigned short		x1;
	unsigned short		y1;
	unsigned short		x2;
	unsigned short		y2;
	unsigned short		logicalrow;
	unsigned short		logicalcol;
	unsigned short 		logicalcolstart;
	unsigned short		physicalrow;
	unsigned short		physicalcol;
	unsigned short		total_lines;
	unsigned short 		insert;
	unsigned short 		dirty;
	unsigned short		xbar;
	unsigned short		ybar;
	unsigned short		in_use;
	char 			filename[80];
	TEXT			*topline;
	TEXT			*scrline;
	TEXT			*currline;

	/* To store the blocks. */
	unsigned short		bx1;
	TEXT			*bl1;
	unsigned short		by1;
	unsigned short		bx2;
	TEXT			*bl2;
	unsigned short		by2;
	unsigned short		highlighted;
	TEXT			*clipboard;
} WINDOW;

/* The editor preferences. */
typedef struct _PREFERENCES_tag {
	/* Video. */
	unsigned short		mainmenucolor;
	unsigned short		mainmenubkcolor;
	unsigned short          statusbarcolor;
	unsigned short          statusbarbkcolor;
	unsigned short		pullmenucolor;
	unsigned short		pullmenubkcolor;
	unsigned short		menubarcolor;
	unsigned short		menubarbkcolor;
	unsigned short		textmode;
	unsigned short		intensecolors;
	unsigned short		wincolor;
	unsigned short		winbkcolor;
	unsigned short 		color;
	unsigned short		bkcolor;

	/* Other preferences. */
	unsigned short		tabsize;
	unsigned short		backupfiles;
	unsigned short		insertmode;
	unsigned short		initinsertmode;
	unsigned short		unixstyle;
	unsigned short		tabs;
	unsigned short		scrltype;
	char			deffilename[255];
} PREFERENCES;

/* Mouse registers. */
extern __dpmi_regs mregs;

int wait();				/* Wait for a key or mouse button. */
void cleanup();				/* Free buffers and destroy window. */
void intensevideo();			/* Video function. */
void mainmenubar();			/* Draw the main-menu bar. */
void setcursortype(int);		/* Our own _setcursortype function. */

/* Editor functions. */
void init_editor();
void sngbox_direct(int, int, int, int, int, int);

/* Mouse functions. */
void mouseinit();			/* Intialize mouse driver. */
void mousestat();			/* Get mouse status. */
void showmouse();			/* Show mouse cursor. */
void hidemouse();			/* Hide mouse cursor. */

/* Window functions. */
void drawwindow();
void redrawwindow();
void redrawline();
void open_save_dialog(char *fname);
void doscmd_dialog(char *doscmd);
void find_dialog(char *text);
void replace_dialog(char *text, char *newtext);

void send_message(int key);
void scrollbars();
void insert_char(int key);
void delete_char();
void backspace_char();
void append_line();
void append_line_for_delete();
void insert_line();
void delete_line();
void blockbegin();
void blockend();
void destroyblock();
TEXT *newnode();

/* Other functions. */
void processkey(int key);
int filemenu();
int editmenu();
int searchmenu();
int optionsmenu();
int windowmenu();
int helpmenu();

/* Menu functions. */
void File_New();
int File_Load(char *filename);
int File_Save(char *filename);
int File_SaveConfig();
int File_Print();
void File_DOSShell();
void File_ExecDOSCmd();
void File_Exit();
void Edit_Cut();
void Edit_Copy();
void Edit_Paste();
void Edit_Clear();
int Search_Find(char *text);
int Search_Replace(char *text, char *newtxt);
void Search_gotoline(unsigned short line_no);
void Options_Editor();
void Options_Desktop();
void Window_Size();
void Window_FullScreen();
void Window_NewWindow();
void Window_NextWindow();
void Window_CloseWindow();
void Window_CloseAll();
void Help_Contents();
void Help_About();

/* Common dialog functions. */
void sngbox_direct(int x1, int y1, int x2, int y2, int color, int bkcolor);
void dblbox_direct(int x1, int y1, int x2, int y2, int color, int bkcolor);
void drawdialog(char *title,
		int x1, int y1, int x2, int y2, int color,int bkcolor);
int editbox(char *buffer, int x, int y, int physical_length,
					int logical_length, char blankpad);
int editbox_special(char *buffer, int x, int y, int physical_length,
					int logical_length, char blankpad);
int wait_checkbox(int *checked);
int check(int x, int y, int checked);

#endif