/* lfnsrv.h -- constant definitions and function prototypes
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


#ifndef __lfnsrv_h
#define __lfnsrv_h

#define TESTING 	1
#ifdef WIN_32
#define WIN
#define FLAT_32
#define TRUE_IF_WIN32	1
#else
#define TRUE_IF_WIN32	0
#endif

#ifdef WIN
#define _WINDOWS
#include <windows.h>
#endif

#ifdef UNICODE
#error cannot handle UNICODE 
#endif

#include <vddsvc.h>		//mem buf translation

#define	MSG_BUF_SIZE				256
#define SMALL_BUF_SIZE				32
#define LARGE_BUF_SIZE				128
#define	MAX_PATHNAME_SIZE			255
#define	MAX_FILENAME_SIZE			260

#include "debug.h"
#define GET_DISK_FREE_SPACE			0x36
#define	SET_CURRENT_DIRECTORY     	     	0x3B  

#define W95_GET_COMPRESSED_FILE_SIZE		0x4302
#define W95_EXT_LENGTH_FILENAME_OPERATIONS	0x43FF	
#define W95_GET_CONFIG_DEVICE_INFO		0x4402 //not implemented
#define W95_SET_CONFIG_DEVICE_INFO           	0x4403 //not implemented
#define W95_LOCK_DRIVE_CALL			0x440D //not implemented
#define W95_SET_INTERNATIONAL_INFO_ALT		0x6500 //not implemented
#define W95_GET_XXX_INFO    			0x7000 //not implemented
#define W95_SET_XXX_INFO    			0x7001 //not implemented
#define W95_SET_INTERNATIONAL_INFO		0x7002 //not implemented
#define W95_FIND_CLOSE_BETA			0x7200 //not implemented
#define W95_GET_DRIVE_LOCKING_FLAG		0x7300 //not implemented
#define W95_SET_DRIVE_LOCKING_FLAG              0x7301 //not implemented
#define W95_GET_EXT_DPB				0x7302 //not implemented
#define W95_GET_EXT_FREE_DRIVE_SPACE            0x7303 //not implemented
#define W95_SET_DPB_FOR_FORMAT			0x7304 //not implemented
#define W95_EXT_ABSOLUTE_DISK_READ_WRITE        0x7305 //not implemented

#define	GET_LAST_WRITE_DATE			0x5700
#define	SET_LAST_WRITE_DATE			0x5701 
#define	GET_LAST_ACCESS_DATE			0x5704
#define	SET_LAST_ACCESS_DATE			0x5705
#define	GET_CREATION_DATE			0x5706
#define	SET_CREATION_DATE			0x5707

#define LONG_RESET_DRIVE			0x710D
#define LONG_CREATE_DIRECTORY                   0x7139
#define LONG_REMOVE_DIRECTORY                   0x713A
#define LONG_SET_CURRENT_DIRECTORY              0x713B
#define LONG_DELETE_FILE                        0x7141
#define LONG_GET_SET_FILE_ATTR                  0x7143
#define LONG_GET_CURRENT_DIRECTORY              0x7147
#define LONG_FIND_FIRST                         0x714E
#define LONG_FIND_NEXT                          0x714F
#define LONG_RENAME_FILE                        0x7156
#define LONG_TRUENAME                           0x7160
#define LONG_CREATE_FILE                        0x716C
#define LONG_GET_VOLUME_INFORMATION             0x71A0
#define LONG_FIND_CLOSE                		0x71A1
#define LONG_FIND_NEXT_EXT                      0x71A2
#define LONG_RESERVED_1				0x71A3
#define LONG_RESERVED_2				0x71A4
#define LONG_RESERVED_3				0x71A5
#define LONG_GET_FILE_INFORMATION               0x71A6
#define LONG_CONVERT_TIME    	                0x71A7
#define LONG_GENERATE_SHORT_NAME                0x71A8
#define LONG_SERVER_CREATE_FILE                 0x71A9
#define LONG_HANDLE_SUBST                       0x71AA

#define LFNSRV_API        			0x7171
#define LFNSRV_GET_VERSION_INFO			0x0001
#define LFNSRV_SET_SFT_INFO			0x0003

/* W95 LOCK DRIVE CALL SUBFUN*/
#define W95_LOCK_LOGICAL_VOLUME			0x084A
#define W95_LOCK_PHYSICAL_VOLUME                0x084B
#define W95_UNLOCK_LOGICAL_VOLUME               0x086A
#define W95_UNLOCK_PHYSICAL_VOLUME              0x086B
#define W95_GET_LOCK_FLAG_STATE                 0x086C
#define W95_ENUMERATE_OPEN_FILES                0x086D
#define W95_FIND_SWAP_FILE                      0x086E
#define W95_GET_CURRENT_LOCK_STATE              0x0870
#define W95_GET_FIRST_CLUSTER                   0x0871

/*	reset drive,	action			*/
#define LONG_RESET_DRIVE_FLUSH_FSBUFS		0x0000
#define LONG_RESET_DRIVE_FLUSH_FSBUFS_ABD_CACHE 0x0001
#define LONG_RESET_DRIVE_REMOUNT_DRIVESPACE	0x0002

/* get set file attributes action*/
#define LONG_GET_SET_FILE_ATTR_GET_ATTR			0	
#define LONG_GET_SET_FILE_ATTR_SET_ATTR         	1
#define LONG_GET_SET_FILE_ATTR_FILE_PHYS_SIZE  		2
#define LONG_GET_SET_FILE_ATTR_SET_WRITE_DATE   	3
#define LONG_GET_SET_FILE_ATTR_GET_WRITE_DATE   	4
#define LONG_GET_SET_FILE_ATTR_SET_ACCESS_DATE  	5
#define LONG_GET_SET_FILE_ATTR_GET_ACCESS_DATE  	6
#define LONG_GET_SET_FILE_ATTR_SET_CREATION_DATE 	7
#define LONG_GET_SET_FILE_ATTR_GET_CREATION_DATE 	8

/* delete files, match wildcard flags */
#define LONG_DELETE_FILE_NO_WILDCARDS		0x0000
#define LONG_DELETE_FILE_WILDCARDS            	0x0001

/* find first date type format*/
#define LONG_FIND_DATE_FILE			0x0000
#define LONG_FIND_DATE_DOS			0x0001

/* find first/next unicode problems */
#define LONG_FIND_UNICODE_NONE			0
#define LONG_FIND_UNICODE_LONG			1
#define LONG_FIND_UNICODE_SHORT			2

/* truenane  subst*/
#define LONG_TRUENAME_NO_SUBST			0x00
#define LONG_TRUENAME_SUBST			0x80

/* truename action*/
#define LONG_TRUENAME_CLASS_CANONICAL		0x00
#define LONG_TRUENAME_CLASS_SHORT		0x01
#define LONG_TRUENAME_CLASS_LONG		0x02

#define	LONG_CREATE_FILE_OPEN		  	1
#define	LONG_CREATE_FILE_TRUNCATE         	2
#define	LONG_CREATE_FILE_CREATE          	16
#define	LONG_CREATE_FILE_CREATE_OPEN 	 (LONG_CREATE_FILE_CREATE | LONG_CREATE_FILE_OPEN)
#define	LONG_CREATE_FILE_CREATE_TRUNCATE (LONG_CREATE_FILE_CREATE | LONG_CREATE_FILE_TRUNCATE)

/* create file result */
#define	LONG_CREATE_FILE_OPENED        		0x0001
#define	LONG_CREATE_FILE_CREATED_OPENED		0x0002
#define	LONG_CREATE_FILE_REPLACED_OPENED	0x0003

/* create file modes */
#define OPEN_ACCESS_READONLY        		0x0000
#define OPEN_ACCESS_WRITEONLY           	0x0001
#define OPEN_ACCESS_READWRITE           	0x0002
#define OPEN_ACCESS_RO_NOMODLASTACCESS	 	0x0004
#define	OPEN_SHARE_COMPATIBLE			0x0000
#define	OPEN_SHARE_DENYREADWRITE		0x0010
#define	OPEN_SHARE_DENYWRITE			0x0020
#define OPEN_SHARE_DENYREAD			0x0030
#define	OPEN_SHARE_DENYNONE	                0x0040
#define	OPEN_SHARE_NETWORK_FCB			0x0070
#define	OPEN_FLAGS_NOINHERIT                    0x0080
#define	OPEN_FLAGS_NO_BUFFERING                 0x0100
#define	OPEN_FLAGS_NO_COMPRESS                  0x0200
#define OPEN_FLAGS_ALIAS_HINT                   0x0400
#define	OPEN_FLAGS_NOCRTERR                     0x2000
#define	OPEN_FLAGS_COMMIT                       0x4000

/* create file attributes */
#define FILE_ATTR_NORMAL			  0
#define FILE_ATTR_READONLY              	  1
#define FILE_ATTR_HIDDEN                	  2
#define FILE_ATTR_SYSTEM                 	  4
#define FILE_ATTR_VOLUME_LABEL          	  8
#define FILE_ATTR_EXECUTE_ONLY         		  8	/*NOVELL*/
#define FILE_ATTR_DIRECTORY             	 16
#define FILE_ATTR_ARCHIVE               	 32
#define FILE_ATTR_UNUSED          	     	 64
#define	FILE_ATTR_SHAREABLE			128	/*NOVELL*/
#define FILE_ATTR_PENDING_DELETED       	128
#define FILE_ATTR_TEMPORARY			FILE_ATTR_PENDING_DELETED
#define FILE_ATTR_ALL						\
	 FILE_ATTR_NORMAL	|FILE_ATTR_READONLY	        \
	|FILE_ATTR_HIDDEN	|FILE_ATTR_SYSTEM      		\
	|FILE_ATTR_VOLUME_LABEL	|FILE_ATTR_EXECUTE_ONLY         \
	|FILE_ATTR_DIRECTORY 	|FILE_ATTR_ARCHIVE	      	\
	|FILE_ATTR_SHAREABLE	|FILE_ATTR_PENDING_DELETED

/* convert time action */
#define LONG_CONVERT_TIME_TO_DOS  		0
#define LONG_CONVERT_TIME_FROM_DOS              1

/* short name format */
#define LONG_GENERATE_SHORT_NAME_FCB		0x00
#define LONG_GENERATE_SHORT_NAME_DOS		0x01

/* short name charset */
#define CHARSET_WINDOWS_ANSI			0x00
#define CHARSET_CURRENT_OEM                    	0x01
#define CHARSET_UNICODE                        	0x02
#define LONG_GENERATE_SHORT_NAME_CHARSET(source, dest)  (((dest) << 4) |(source))

/* handle subst action */
#define LONG_HANDLE_SUBST_CREATE                0x00
#define LONG_HANDLE_SUBST_TERMINATE		0x01
#define LONG_HANDLE_SUBST_QUERY                 0x02

/* lseek positions*/
#define	LSEEK_START_FILE_POS			0
#define	LSEEK_CURRENT_FILE_POS                  1
#define	LSEEK_END_FILE_POS                      2	

/* get set drive serial number action*/
#define	GET_SERIAL_NUMBER			0
#define	SET_SERIAL_NUMBER       	        1

/* get volume attributes*/
#define	DOS_FS_CASE_SENSITIVE			0x0001
#define DOS_FS_CASE_IS_PRESERVED        	0x0002
#define DOS_FS_UNICODE_ON_DISK          	0x0004
#define DOS_FS_LFN_APIS                 	0x4000
#define	DOS_FS_VOLUME_COMPRESSED        	0x8000

#define	MAKEADDRESS(seg, ofs)	((ULONG)(((seg) << 16) | (ofs)))

typedef struct _VOLINFO {
	WORD volflags;
	WORD filename_maxlen;
	WORD pathname_naxlen;
} VOLINFO, *PVOLINFO, *LPVOLINFO;

#define MIN_HANDLES				 2
#define MAX_HANDLES 				64

#define	SFT_SIZE        0x21
#define	JFT_SIZE	20

extern 	HANDLE 	hFindFile[MAX_HANDLES];
extern 	BYTE   	nHandlesUsed;

WORD	process_get_date_time(
		IN  SHORT hFile,				
		IN  ULONG pPDB,					
		IN  PVOID * ppSFT,                     		
		IN  PVOID * ppJFT,				
		IN  WORD nAction,	
		OUT PWORD pDate,
		OUT PWORD pTime);

WORD	process_set_date_time(
		IN  SHORT hFile,				
		IN  ULONG pPDB,					
		IN  PVOID * ppSFT,                     		
		IN  PVOID * ppJFT,				
		IN  WORD nAction,	
		IN  WORD nDate,
		IN  WORD nTime);

WORD	process_create_directory(
		IN  LPCSTR lpPathName);

WORD	process_remove_directory(
		IN  LPCSTR lpPathName);

WORD	process_get_current_directory(
		IN OUT LPSTR lpPathName,
		IN  BYTE nDriveNum);

WORD	process_set_current_directory(
		IN OUT LPSTR lpPathName);

WORD	process_delete_file(
		IN LPCSTR lpFileName,
		IN WORD wWildcard,
		IN BYTE nSearchAttr,
		IN BYTE nMustMatchAttr);

WORD	process_get_set_file_attr(
		IN LPCSTR lpFileName,
		IN WORD nAction, 
		IN OUT PWORD nFileAttr, 
		IN OUT PDWORD nFileSize,
		IN OUT PWORD nDosDate,  
		IN OUT PWORD nDosTime, 
		IN OUT PWORD nDosMilisec);

WORD	process_find_first(
		IN  LPCSTR lpPathName,
		IN  BYTE nDosAttrAllowed,		
		IN  BYTE nDosAttrRequired,
		IN  WORD wDateType,
		OUT PWIN32_FIND_DATA pFindStruct,
		OUT PBYTE pnUnicode,
		OUT PWORD phandle);

WORD	process_find_next(
		IN  WORD wFind_org,
		IN  WORD wDateType,
		OUT PWIN32_FIND_DATA pFindStruct,
		OUT PBYTE pnUnicode);

WORD	process_rename_file(
		IN LPCSTR lpOldPathName,
		IN LPCSTR lpNewPathName);

WORD	process_truename(
		IN LPCSTR lpOldFileName,
                OUT LPSTR lpOrgNewFileName,
		IN BYTE nAction,
		IN BYTE nSubst);

WORD	process_create_file(
		IN OUT LPSTR lpFileName,	
		IN WORD nAttributes,		
		IN WORD nAction,		
		OUT PWORD pReturn);

WORD	process_get_volume_information(
		IN  LPCSTR lpPathName,
		OUT LPSTR pBBuffer,
		IN  WORD nBufSize,
		OUT PVOLINFO pVolInfo);

WORD	process_find_close(
		IN WORD wFind_org);

WORD	process_convert_time(
		IN     BYTE nAction,
		IN OUT PWORD pDosDate,
		IN OUT PWORD pDosTime,
		IN OUT PBYTE pDosMilisec,
		IN OUT PFILETIME pTime);
 
WORD	process_generate_short_filename(
		IN  LPCSTR lpOldFileName,
                OUT LPSTR lpNewFileName,
		IN BYTE nFormat,
		IN BYTE nCharset);

WORD	process_handle_subst(
                IN OUT LPSTR lpPathName,
		IN  BYTE nDrive,
		IN  BYTE nAction);
 
WORD	proces_lfnsrv_version_info(
		OUT PWORD pVersion);

WORD	process_get_file_information(
		IN  SHORT hFile,				
		IN  ULONG pPDB,					
		IN  PVOID * ppSFT,                     		
		IN  PVOID * ppJFT,				
		OUT PBY_HANDLE_FILE_INFORMATION pfileinfo);	

WORD	process_get_date_time_nt(
		IN  HANDLE handle,				
		IN  WORD nAction,	
		OUT PWORD pDate,
		OUT PWORD pTime);

WORD	process_set_date_time_nt(
		IN  HANDLE handle,				
		IN  WORD nAction,	
		IN  WORD nDate,
		IN  WORD nTime);

WORD	process_get_compressed_file_size(
		IN LPCSTR lpFileName,
		OUT PDWORD pdwSize);

WORD	process_get_disk_free_space(
		IN  BYTE  nDrive,				
		OUT PWORD wSectorsPerCluster,					
		OUT PWORD wBytesPerSector,
		OUT PWORD wFreeClusters,
		OUT PWORD wTotalClusters);

WORD 	GetShortPathName_(
		IN  LPCSTR  lpFileName,
		OUT LPSTR   lpShortName);

WORD 	GetLongPathName_(
		IN  LPCSTR  lpFileName,
		OUT LPSTR   lpLongName);

WORD 	FileExists(
		IN  LPCSTR  lpName);

WORD 	ValidDriveName(
		IN LPCSTR lpName,
		IN BYTE bFullCheck);


char ttoupper(char c);
char tisalpha(char c);
#endif
