/* fileattr.c -- get & set file attributes
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_get_set_file_attr(
		IN LPCSTR lpFileName,
		IN WORD nAction, 
		IN OUT PWORD pFileAttr, 
		IN OUT PDWORD pFileSize,
		IN OUT PWORD pDosDate,  
		IN OUT PWORD pDosTime, 
		IN OUT PWORD pDosMilisec)
{
#define	FAILED_CALL			0xFFFFFFFF
	HANDLE handle;
	WORD result;
	PROLOG(process_get_set_file_attr);
	IS_NULL(lpFileName, ERROR_FILE_NOT_FOUND);	//should be after checks of nAction
	IS_MAX_PATH_SIZE(lpFileName);
	ISNULL(pFileAttr);
	ISNULL(pFileSize);
	ISNULL(pDosDate);
       	ISNULL(pDosTime);
	ISNULL(pDosMilisec);

	DBGVALUE(lpFileName,"%s");
	DBGVALUE(nAction, "%d");
	DBGVALUE(*pFileAttr, "%d");
////	DBGVALUE(*pFileSize,"%ld");
////	DBGVALUE(*pDosDate,  "%d");
////	DBGVALUE(*pDosTime, "%d");
////	DBGVALUE(*pDosMilisec,"%d");

	switch (nAction)
	{
		case LONG_GET_SET_FILE_ATTR_FILE_PHYS_SIZE     :
		case LONG_GET_SET_FILE_ATTR_GET_WRITE_DATE      :
		case LONG_GET_SET_FILE_ATTR_GET_ACCESS_DATE     :
		case LONG_GET_SET_FILE_ATTR_GET_CREATION_DATE   :
			if ((handle = CreateFile(
				lpFileName, 
				GENERIC_READ, 
				FILE_SHARE_READ, NULL, 
				OPEN_EXISTING, 
				FILE_ATTRIBUTE_NORMAL|
				FILE_ATTRIBUTE_HIDDEN|
				FILE_ATTRIBUTE_SYSTEM|
				FILE_ATTRIBUTE_READONLY,
				NULL)) == INVALID_HANDLE_VALUE) {
				result = (WORD)GetLastError();					
				DBGMSG("Cannot touch file");
				EPILOG(process_get_set_file_attr,FALSE);
#if 0
				return ERROR_FILE_NOT_FOUND;
#else
    				return result;
#endif
			}
        		break;
		case LONG_GET_SET_FILE_ATTR_SET_WRITE_DATE      :
		case LONG_GET_SET_FILE_ATTR_SET_ACCESS_DATE     :
		case LONG_GET_SET_FILE_ATTR_SET_CREATION_DATE   :
			if ((handle = CreateFile(
				lpFileName, 
				GENERIC_READ|GENERIC_WRITE, 
				0, NULL, 
				OPEN_EXISTING, 
				FILE_ATTRIBUTE_NORMAL|
				FILE_ATTRIBUTE_HIDDEN|
				FILE_ATTRIBUTE_SYSTEM|
				FILE_ATTRIBUTE_READONLY,
				NULL)) == INVALID_HANDLE_VALUE) {
				result = (WORD)GetLastError();	
				DBGMSG("Cannot touch file");
				EPILOG(process_get_set_file_attr,FALSE);
#if 0
				return ERROR_FILE_NOT_FOUND;
#else
    				return result;
#endif
			}
			break;
		case LONG_GET_SET_FILE_ATTR_GET_ATTR		:
		case LONG_GET_SET_FILE_ATTR_SET_ATTR            :
			break;
		default:
			EPILOG(process_get_set_file_attr, TRUE);
			return ERROR_INVALID_FUNCTION;
	}

	switch (nAction)
	{
		case LONG_GET_SET_FILE_ATTR_FILE_PHYS_SIZE     :
                        if ((*pFileSize = GetFileSize(handle, NULL)) == FAILED_CALL) 
				result = (WORD)GetLastError();				
			else
				result = ERROR_SUCCESS;
			break;		
		case LONG_GET_SET_FILE_ATTR_GET_ATTR		:
		{
			DWORD dwFileAttr;
			if ((dwFileAttr = GetFileAttributes(lpFileName)) == FAILED_CALL) 
				result = (WORD)GetLastError();			
			else {
				result = ERROR_SUCCESS;
				*pFileAttr =  LOBYTE(LOWORD(dwFileAttr));
				*pFileAttr &= (FILE_ATTR_READONLY|FILE_ATTR_HIDDEN|
					    FILE_ATTR_SYSTEM|FILE_ATTR_ARCHIVE|
        	       		            FILE_ATTR_DIRECTORY);     
			}
			break;		
		}
		case LONG_GET_SET_FILE_ATTR_SET_ATTR            :
		{
			DWORD dwFileAttr;

			dwFileAttr = *pFileAttr;
			dwFileAttr  &= (FILE_ATTR_READONLY|FILE_ATTR_HIDDEN|
	  			        FILE_ATTR_SYSTEM|FILE_ATTR_ARCHIVE|
                                        FILE_ATTR_DIRECTORY);

			if (!SetFileAttributes(lpFileName, dwFileAttr)) 
				result = (WORD)GetLastError();				
			else	
				result = ERROR_SUCCESS;
			break;
		}
		case LONG_GET_SET_FILE_ATTR_GET_WRITE_DATE      :
			result = process_get_date_time_nt(
				handle, GET_LAST_WRITE_DATE, pDosDate, pDosTime); 
			break;
		case LONG_GET_SET_FILE_ATTR_GET_ACCESS_DATE     :
			result = process_get_date_time_nt(
				handle, GET_LAST_ACCESS_DATE, pDosDate, pDosTime); 
			break;
		case LONG_GET_SET_FILE_ATTR_GET_CREATION_DATE   :
			result = process_get_date_time_nt(
				handle, GET_CREATION_DATE, pDosDate, pDosTime); 
			break;
		case LONG_GET_SET_FILE_ATTR_SET_WRITE_DATE      :
			result = process_set_date_time_nt(
				handle, SET_LAST_WRITE_DATE, *pDosDate, *pDosTime);
			break;
		case LONG_GET_SET_FILE_ATTR_SET_ACCESS_DATE     :
			result = process_set_date_time_nt(
				handle, SET_LAST_ACCESS_DATE, *pDosDate, *pDosTime);
			break;
		case LONG_GET_SET_FILE_ATTR_SET_CREATION_DATE   :
			result = process_set_date_time_nt(
				handle, SET_CREATION_DATE, *pDosDate, *pDosTime);
			break;
                default:
			EPILOG(process_get_set_file_attr,FALSE);
			return ERROR_INVALID_FUNCTION;	
	}		

	if (nAction != LONG_GET_SET_FILE_ATTR_GET_ATTR	 &&	
	    nAction != LONG_GET_SET_FILE_ATTR_SET_ATTR   )
		CloseHandle(handle);

	if (result != ERROR_SUCCESS) {
		if (result == ERROR_NO_MORE_FILES ||
		    result == ERROR_PATH_NOT_FOUND ||
		    result == ERROR_FILE_NOT_FOUND)	
			EPILOG(process_get_set_file_attr,TRUE);			
		else		
			EPILOG(process_get_set_file_attr,FALSE);
		return result;	
	}

	DBGVALUE(*pFileAttr, "%d");
////	DBGVALUE(*pFileSize,"%ld");
////	DBGVALUE(*pDosDate, "%d");
////	DBGVALUE(*pDosTime, "%d");
////	DBGVALUE(*pDosMilisec,"%d");
	EPILOG(process_get_set_file_attr,TRUE);
	return ERROR_SUCCESS;
}
