# Generate a short man page from --help and --version output.
# Copyright  1997 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 5.001;

$PACKAGE = 'helptoman';
$VERSION = '0.0';

# FIXME: Currently, only applies to `tar'.
# FIXME: Next step is to apply to self! :-)

$version_string = <<EOT;
$PACKAGE $VERSION

Copyright (C) 1997 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

Original idea from Brendan O\'Dea <bod\@compusol.com.au>.
EOT

$help_string = <<EOT;
\`$PACKAGE\' generates a man page out of \`--help\' and \`--version\' output.

Usage: perl $0 [OPTION]... EXECUTABLE

  --help      print this help, then exit
  --version   print tar program version number, then exit

EXECUTABLE should accept \`--help\' and \`version\' options.
EOT

## ----------- ##
## Main code.  ##
## ----------- ##

# Decode options.
if ($ARGV[0] eq '--version')
{
    print $version_string;
    exit 0;
}
elsif ($ARGV[0] eq '--help')
{
    print $help_string;
    exit 0;
}
die $usage if @ARGV != 1;
$executable = shift;

# Turn off localisation.
$ENV{'LANGUAGE'} = 'C';
$ENV{'LANG'} = 'C';
$ENV{'LC_ALL'} = 'C';

# Read all paragraphs first.

$/ = '';

open (HELP, "$executable --help |")
    || die "Cannot fork for \`$executable --help'\n";
while (<HELP>)
{
    chomp;
    push (@help, $_);
}
close HELP || die "Could not execute \`$executable --help': $!\n";

open (VERSION, "$executable --version |")
    || die "Cannot fork for \`$executable --version'\n";
while (<VERSION>)
{
    chomp;
    push (@version, $_);
}
close VERSION || die "Could not execute \`$executable --version': $!\n";

# Output standard header.
print
    ".\\\" DO NOT MODIFY THIS FILE!  It was generated by $PACKAGE $VERSION.\n";

$program_version = shift @version;
($program, $version) = $program_version =~ /(.*)\s+(.*)/;
$program =~ s/^GNU\s+//;

use POSIX;
$date = strftime("%B %Y", gmtime);

print ".TH $program 1 \"$date\" \"$program $version\" \"GNU User's Manual\"\n";
print ".SH NAME\n";
print "$program \\- short documentation for $program_version\n";

$accumulate = 1;

# Output converted --help information.

foreach (@help)
{
    if (/^Usage: [^ \n]+ (.*)\n?/)
    {
	# Turn the usage clause into a synopsis.
	print ".SH SYNOPSIS\n.B $program\n";
	@synopsis = split (' ', $1);
	print '.RI ', shift @synopsis, "\n" while @synopsis;

	# Empty any accumulated description text.
	$accumulate = 0;
	print ".SH DESCRITION\n";
	print shift @body, "\n" while @body;
	$_ = $';
	next if ! $_;
    }

    # Accumulate any text if the synopsis has not been produced yet.
    if ($accumulate)
    {
	push (@body, '.PP') if @body;
	push (@body, $_);
	next;
    }

    # Catch bug report text.

    if (/^Report bugs /)
    {
	print ".SH BUGS\n$_\n";
	next;
    }

    # Special case for tar 1.12: --label=NAME\nPATTERN.
    s/(\n[ \t]*-V,[ \t]+--label=NAME.*\n[ \t]+)(PATTERN)([ \t])/$1\\&...=\\fI$2\\fR$3/;

    # Convert options.
    s/(\s)(-[][\w=-]+)/$1.convert_option ($2)/ge;

    # Option subsections have second line indented.
    print qq(.SS "$1"\n) if s/^(\S.*)\n(\s)/$2/;

    # Indented paragraph.
    if (/^\s/)
    {
	for (split /\n/)
	{
	    s/\s+//;
	    s/([^,])\s+/$1\n/;
	    print ".TP\n$_\n";
	}
    }
    # Anything else.
    else
    {
	print ".PP\n$_\n";
    }
}

# Refer to the real documentation.

print ".SH SEE ALSO
The full documentation for
.B $program
is maintained as a Texinfo manual.  If the
.B info
and
.B $program
programs are properly installed at your site, the command
.B info $program
should allow you to access the manual as an hypertext.\n";

# Output converted --version information.

foreach (@version)
{
    print (/^Copyright\s+\(C/ ? '.SH COPYRIGHT'
	   : /^Written\s+by/ ? '.SH AUTHOR'
	   : '.PP');
    print "\n", $_, "\n";
}

exit 0;

## ---------- ##
## Services.  ##
## ---------- ##

# Convert a Usage line into a synopsis.
sub produce_synopsis
{
    my @synopsis = split (' ');

}

# Convert option dashes to \- to stop nroff from hyphenating 'em, and
# embolden.  Option arguments get italicised.
sub convert_option
{
    my $option = '\fB' . shift;

    $option =~ s/-/\\-/g;
    unless ($option =~ s/\[=(.*)\]$/\\fR[=\\fI$1\\fR]/)
    {
	$option =~ s/=(.)/\\fR=\\fI$1/;
	$option .= '\fR';
    }

    $option;
}
