#! /bin/sh
#
# This scripts
# 1) unpacks MPC source archive (tar.gz or tar.bz2)
# 2) generates DJGPP source archive with configured sources
# 3) builds MPC and run tests
# 4) generates DJGPP binary package of MPC.
#
# It is not intended for building MPC from DJGPP source archive
# even when it is included there.
#
# How to use this script:
# - put MPC binary archive (mpc-X.Y.Z.tar.gz) downloaded from
#   http://www.multiprecision.org/index.php?prog=mpc
#   into the same directory as this script
# - edit version number and email address below
# - run the script. As result both source and binary
#   packages of MPC are generated
#
name=mpc
version=1.1.0
extra_ver=
email="Andris Pavenis <andris.pavenis@iki.fi>"

top=`pwd`

gcc_ver=$(gcc --version | head -1 | awk '{print $3}')

gcc -O2 -x c - -o gmpver__.exe -lgmp -lm <<'EOF'
#include <stdio.h>
#include <gmp.h>
int main(void) { printf("%s\n", gmp_version); return 0; }
EOF
test -f gmpver__.exe || exit 1
gmp_ver=$(./gmpver__.exe)
rm -f gmpver__.exe

gcc -O2 -x c - -o mpfrver__.exe -lmpfr -lgmp -lm <<'EOF'
#include <stdio.h>
#include <mpfr.h>
int main(void) { printf("%s\n", MPFR_VERSION_STRING); return 0; }
EOF
test -f mpfrver__.exe || exit 1
mpfr_ver=$(./mpfrver__.exe)
rm -f mpfrver__.exe

mkdir -p gnu || exit 1

rm -rf gnu/mpc-*

if [ -f $name-$version.tar.bz2 ] ; then
  bzip2 -cd $name-$version.tar.bz2 | ( cd gnu && tar x ) || exit 1
else
  if [ -f $name-$version.tar.gz ] ; then
     gzip -cd $name-$version.tar.gz | ( cd gnu && tar x ) || exit 1
  else
     echo MPC $version source archive is not found
  fi
fi

djver1=`echo $version | sed -e 's:\.::2g'`
djver2=`echo $version | sed -e 's:\.::g'`
srcdir=$top/gnu/$name-$djver1

if test x"$djver1" != x"$version"; then
  mv -v gnu/$name-$version $srcdir
fi

#( cd $srcdir && aclocal && autoconf || exit 1 )

# Workaround bug in autoconf-2.63
sed -e 's:\\\\r:\\r:g' $srcdir/configure >$srcdir/configure.new
diff -u $srcdir/configure $srcdir/configure.new
mv -fv $srcdir/configure.new $srcdir/configure

( cd $srcdir && ./configure i386-pc-msdosdjgpp )

# Copy this script into source directory
cat $0 >$srcdir/$(basename $0)

#
# Write README file for DJGPP to the source directory
#
cat >gnu/$name-$djver1/readme.djgpp <<EOF
This is DJGPP port of MPC-$version.

MPC is a library for multiprecision complex arithmetic with exact
rounding, based on the MPFR and GNU MP libraries.

See README and http://www.loria.fr/~zimmerma/software/mpc.html

Building from sources
=====================

LFN support is required for building MPC. for DJGPP.

I built MPC using GCC-$gcc_ver under Windows Vista Business SP2.

Using MPC library requires GMP and MPFR to be installed.
GMP-$gmp_ver and MPFR-$mpfr_ver were used for building DJGPP port of
MPC-$version. One may need to rebuild MPC if GMP and(or) MPFR versions
are different enough.

Sources in mpc${djver2}s.zip are preconfigured for target i386-pc-msdosdjgpp.
Simply running configure script with needed parameters should be enough
to reconfigure if needed.

To build MPC run 'make'.

To run tests of the MPC, run 'make check'

To install MPC run 'make install prefix=where_to_install' (replace
'where_to_install' with real value).

$email
EOF

#
# Write script for building binary packets for DJGPP to the source directory
#
sed -e "s:@NAME@:$name:" -e "s:@VERSION@:$version:g" >$srcdir/makepkg.sh <<'EOF'
#! /bin/sh

name=@NAME@
version=@VERSION@

djver1=`echo $version | sed -e 's:\.::2g'`
djver2=`echo $version | sed -e 's:\.::g'`
dname=$name-$djver1

rm -rf inst.djg
make all check
make check >check.log 2>&1
make install prefix=`pwd`/inst.djg
make check >check.log 2>&1

mkdir -p inst.djg/info
mkdir -p inst.djg/manifest
mkdir -p inst.djg/gnu/$dname

cp -v check.log inst.djg/gnu/$dname/

touch inst.djg/manifest/${name}${djver2}b.mft

cat >inst.djg/manifest/${name}${djver2}b.ver <<E2
${name}${djver2}b.zip: MPC - C library for multiple-precision complex computations (binaries)
E2

mv -v inst.djg/share/info/*.info inst.djg/info/
cp -v authors bugs COPYING* inst.djg/gnu/$dname/
cp -v news readme* todo inst.djg/gnu/$dname/
cp -vf check.log inst.djg/gnu/$dname/
rm -rf inst.djg/share

( cd inst.djg && find . -type f | sed -e 's:^\./::' | sort >manifest/${name}${djver2}b.mft )
( cd inst.djg && cat manifest/${name}${djver2}b.mft | zip -9@ ../${name}${djver2}b.zip )
EOF

# Write also this script to the source dircetory
cat $0 >$srcdir/`basename $0`

mkdir -p manifest

cat >manifest/${name}${djver2}s.ver <<EOF
${name}${djver2}s.zip: MPC - C library for multiple-precision complex computations (sources)
EOF

touch manifest/${name}${djver2}s.mft

(
  cd $top
  find gnu -type f
  find manifest -name ${name}${djver2}s'.*'
) | sort >manifest/${name}${djver2}s.mft

rm -f ${name}${djver2}s.zip
cat manifest/${name}${djver2}s.mft | zip -9q@ ${name}${djver2}s.zip

cd $srcdir && make all check || exit 1

cd $srcdir && ./makepkg.sh || exit 1

mv -v $srcdir/${name}${djver2}b.zip $top/
