/* Test of <errno.h> substitute.
   Copyright (C) 2008-2019 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2008.  */

#include <config.h>

#include <errno.h>

/* Verify that the POSIX mandated errno values exist and can be used as
   initializers outside of a function.
   The variable names happen to match the Linux/x86 error numbers.  */
int e1 = EPERM;
int e2 = ENOENT;
int e3 = ESRCH;
int e4 = EINTR;
int e5 = EIO;
int e6 = ENXIO;
int e7 = E2BIG;
int e8 = ENOEXEC;
int e9 = EBADF;
int e10 = ECHILD;
int e11 = EAGAIN;
int e11a = EWOULDBLOCK;
int e12 = ENOMEM;
int e13 = EACCES;
int e14 = EFAULT;
int e16 = EBUSY;
int e17 = EEXIST;
int e18 = EXDEV;
int e19 = ENODEV;
int e20 = ENOTDIR;
int e21 = EISDIR;
int e22 = EINVAL;
int e23 = ENFILE;
int e24 = EMFILE;
int e25 = ENOTTY;
#ifdef ETXTBSY
int e26 = ETXTBSY;
#endif
int e27 = EFBIG;
int e28 = ENOSPC;
int e29 = ESPIPE;
int e30 = EROFS;
int e31 = EMLINK;
int e32 = EPIPE;
int e33 = EDOM;
int e34 = ERANGE;
int e35 = EDEADLK;
int e36 = ENAMETOOLONG;
int e37 = ENOLCK;
int e38 = ENOSYS;
int e39 = ENOTEMPTY;
int e40 = ELOOP;
int e42 = ENOMSG;
int e43 = EIDRM;
int e67 = ENOLINK;
int e71 = EPROTO;
int e72 = EMULTIHOP;
int e74 = EBADMSG;
int e75 = EOVERFLOW;
int e84 = EILSEQ;
#ifdef ENOTSOCK
int e88 = ENOTSOCK;
#endif
#ifdef EDESTADDRREQ
int e89 = EDESTADDRREQ;
#endif
#ifdef EMSGSIZE
int e90 = EMSGSIZE;
#endif
#ifdef EPROTOTYPE
int e91 = EPROTOTYPE;
#endif
#ifdef ENOPROTOOPT
int e92 = ENOPROTOOPT;
#endif
#ifdef EPROTONOSUPPORT
int e93 = EPROTONOSUPPORT;
#endif
int e95 = EOPNOTSUPP;
int e95a = ENOTSUP;
int e97 = EAFNOSUPPORT;
#ifdef EADDRINUSE
int e98 = EADDRINUSE;
#endif
#ifdef EADDRNOTAVAIL
int e99 = EADDRNOTAVAIL;
#endif
#ifdef ENETDOWN
int e100 = ENETDOWN;
#endif
#ifdef ENETUNREACH
int e101 = ENETUNREACH;
#endif
int e102 = ENETRESET;
int e103 = ECONNABORTED;
#ifdef ECONNRESET
int e104 = ECONNRESET;
#endif
#ifdef ENOBUFS
int e105 = ENOBUFS;
#endif
#ifdef EISCONN
int e106 = EISCONN;
#endif
#ifdef ENOTCONN
int e107 = ENOTCONN;
#endif
#ifdef ETIMEDOUT
int e110 = ETIMEDOUT;
#endif
#ifdef ECONNREFUSED
int e111 = ECONNREFUSED;
#endif
#ifdef EHOSTUNREACH
int e113 = EHOSTUNREACH;
#endif
#ifdef EALREADY
int e114 = EALREADY;
#endif
#ifdef EINPROGRESS
int e115 = EINPROGRESS;
#endif
int e116 = ESTALE;
int e122 = EDQUOT;
int e125 = ECANCELED;
int e130 = EOWNERDEAD;
int e131 = ENOTRECOVERABLE;

/* Don't verify that these errno values are all different, except for possibly
   EWOULDBLOCK == EAGAIN.  Even Linux/x86 does not pass this check: it has
   ENOTSUP == EOPNOTSUPP.  */

int
main ()
{
  /* Verify that errno can be assigned.  */
  errno = EOVERFLOW;

  /* snprintf() callers want to distinguish EINVAL and EOVERFLOW.  */
  if (errno == EINVAL)
    return 1;

  return 0;
}
