Sat Jun 10 14:36:18 2000  Paolo Bonzini  (bonzini@gnu.org)

	* libgst/byte.c: fixed bug in optimizeByteCodes (|| was there
	instead of &&)
	* libgst/comp.c: if a method is a primitive return of a
	BlockClosure, initialize the BlockClosure in methodNew.

Tue Jun 1 20:11:28 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/callin.c: support losing systems which don't allow
	va_arg(..., char)

Tue May  9 20:23:59 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/comp.c: abort compilation if a method turns out to be too
	complex for the bytecode set (i.e. if it jumps too far).

Tue May  2 21:15:38 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/gst.y: fixed errors in parsing #( () ) and #[]; the
	former was parsed to (Array with: nil), the last crashed (!)

Tue Apr 27 11:32:14 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/register.h: issue the #warning only if using GCC

Thu Apr 12 17:06:32 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.4 released

Fri Mar 31 09:16:32 2000  Hideoki Saito (saito@densan.co.jp)

	* lib/comp.h: fixed bogus error on big-endian machines

Fri Mar 24 18:22:48 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.3 released (fixes packaging problem in 1.7.2)

Mon Mar 13 18:29:03 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.2 released

Thu Feb 24 10:25:16 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/cint.c: better output from badType.  Plus, ByteArrays
	passed as Strings are considered null-terminated, and Strings
	passed as ByteArrays are not.
	* lib/interp.c: showBacktrace not static anymore.  Fixed crash
	on sends to super from a block.
	* lib/interp.h: declare showBacktrace.

Tue Feb 22 18:29:03 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.1 released

Mon Feb 22 18:27:57 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/cint.c: added defineCFuncs to test file accessing modes.

Mon Feb 21 10:32:16 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/prims.inl: added time-zone primitives for Time
	* lib/sysdep.c: added currentTimeZoneName
	* lib/sysdep.h: added currentTimeZoneName

Thu Feb 17 11:00:55 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/bytecode.inl: fixed crash on blocks returning from non-existent
	method contexts; fixed bug in detecting overflows on bit shifts.
	* lib/prims.inl: fixed bug in detecting overflows on bit shifts.

Tue Feb 15 09:48:25 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7 released

Sun Feb 6  17:22:20 2000  Thorsten Klein <TK@Thorsten-Klein.de>

	* lib/dld_gst.c: missing asterisk in `i' for loop (second
	expression was `i', now is `*i').  Caused SIGSEGV when a missing
	library name was passed.

Tue Feb 1  09:17:43 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/byte.h: subsumed bytecodes 132 and 134 (a whole byte for
	the argument count is way too much, and it does not matter if
	it's a bit slower because these bytecodes are rare indeed).
	* lib/byte.c: print bytecode 132 according to the new coding
	* lib/bytecode.inl: interpret new coding for bytecode 132
	* lib/comp.c: emit new coding for bytecode 132

Mon Jan 31 14:48:04 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Sixth beta of 1.7 (labeled 1.6.85) released

Mon Jan 31 10:26:37 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/interp.c: worked out bugs in call-ins that were added
	after the introduction of the `terminate interpreter' bytecode
	(Jan 8th) and which prevented Blox from working.
	prepareExecutionEnvironment was stacking a context with an OOP
	from the main OOP table over some lifoContexts.
	* lib/oop.c: moved debug() to sysdep.c
	* lib/oop.h: moved debug() to sysdep.h
	* lib/sysdep.c: moved debug() here from oop.c
	* lib/sysdep.h: moved debug() here from oop.h

Fri Jan 28 09:07:18 2000  Paolo Bonzini (bonzini@gnu.org)

	* lib/comp.c: fixed bug with double-freeing of block bytecodes
	(this is also due to a very permissive allocator)
	* lib/lex.c: fixed bug in parsePrimitive (xfree without matching
	xmalloc) -- strangely enough, it didn't show up on all systems!
	* lib/prims.inl: fixed Memory primitives to return and accept
	LargeIntegers for addresses when needed.

Mon Jan 24 10:34:50 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: changed the clean block detection machinery to work
	with CompiledBlocks.  Previously, we emitted a fixed sequence of
	bytecodes for blocks, then we made a pass on the bytecodes before
	optimization patching already generated code in case we found the
	block to be clean.  Now, instead, we compute information on the
	block's cleanness before we create the CompiledBlock object, we
	embed the information in the CompiledBlock's header, and then use
	that information to directly emit optimized bytecodes in case the
	block is clean (instead of applying patches later).
	* lib/comp.c: moved `class' and `selector' fields to MethodInfo.
	Blocks are compiled to CompiledBlocks.
	* lib/comp.h: removed `class' and `selector' fields from [Compiled]Method
	* lib/dict.c: new definitions of MethodInfo, CompiledCode, CompiledMethod,
	CompiledBlock; declaration of compiledCodeClass and compiledBlockClass.
	* lib/dict.h: declaration of compiledCodeClass and compiledBlockClass
	* lib/interp.c: execute blocks from CompiledBlocks.
	* lib/lib.c: load CompildCode.st and CompiledBlk.st
	* lib/prims.inl: added primitive 68 to create CompiledBlocks.

Thu Jan 20 15:04:40 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: fixed crash on methods whose last act was
	returning a clean block.  It turned out that evaluating those
	blocks was GST's last act, either...
	* lib/cint.c: enable passing 32-bit LargeIntegers in C call-
	outs.  Looks like I had forgotten about it on Sep 10 1999.
	Also, introduced a `pVoidFunc' typedef to avoid Lisp-like
	abundance of parentheses when passing C function addresses.

Thu Jan 20 09:50:14 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: integerClass -> smallIntegerClass
	* lib/dict.c: integerClass -> smallIntegerClass, plus
	added definition of SmallInteger
	* lib/dict.h: added declaration of SmallInteger
	* lib/gst.h: integerClass -> smallIntegerClass
	* lib/interp.c: integerClass -> smallIntegerClass
	* lib/interp.inl: integerClass -> smallIntegerClass
	* lib/lib.c: load SmallInt.st too.
	* lib/prims.inl: integerClass -> smallIntegerClass

Sat Jan 15 10:05:26 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: adapted large integer compilation stuff in
	makeConstantOOP to compile ByteArrays too.
	* lib/gst.y: added rules for ByteArray literals and arrays
	like #(1 2 3 #(4 5 6)) -- i.e. with the sharp inside the
	parentheses
	* lib/lex.c: make parseNumber return BYTE_LITERAL for
	integers between 0 and 255
	* lib/tree.c: added makeByteArrayConstant

Sun Jan  9 20:46:06 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/lex.c: curStrBuf -> obstack_curStrBuf; plus, added
	the compilationObstack variable which is initialized in
	parseStream.
	* lib/lex.h: added declaration of compilationObstack
	* lib/str.c: added obstack_curStrBuf
	* lib/str.h: declared obstack_curStrBuf
	* lib/tree.c: heavily simplified destruction code by using
	obstacks

	* lib/lib.c: solved SIGSEGV when gst.im was not in the
	current directory and SMALLTALK_IMAGE was not set.

Sun Jan  9 14:35:27 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: added code to create Smalltalk LargeInteger
	objects from large integer ConstNodes in makeConstantOOP.
	* lib/gst.y: handle large integer literals in the grammar
	* lib/lex.c: added code to parse large integer literals
	* lib/tree.c: added code to create large integer ConstNodes
	* lib/tree.h: added declaration of the LargeInteger struct
	and of large integer ConstNodes

Sat Jan  8 08:47:20 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.h: added `exitInterpreter' bytecode.
	* lib/comp.h: declared `getTerminationMethod'.
	* lib/comp.c: implemented `getTerminationMethod', and added code
	to installInitialMethods which installs a termination method
	which executes the new bytecode above.
	* lib/bytecode.inl: implemented `exitInterpreter' bytecode.
	* lib/interp.c: contexts created by prepareExecutionEnvironment
	no longer have to be special cased in unwindLastContext.
	* lib/sym.c: added terminateSymbol.
	* lib/sym.h: added terminateSymbol.

Sun Jan  2 12:40:13 2000  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: gst enters the new millennium!!! (yeah, I know it
	actually starts in 2001 but I don't want to wait another year... ;-)
	and it does by getting rid of the free lists for contexts -- it is
	faster to use the memory chunks like a stack.
	Also, I replaced tests for `isNil(thisContextOOP)' with tests for
	`!ip'.
	
	* lib/strerror.c: added.
	* lib/sysdep.c: Win32 implementation of getMilliTime now more precise
	* lib/sysdep.h: added macros for frexp and ldexp where they aren't
	available
	 
Tue Dec 28 12:17:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Fifth beta of 1.7 (labeled 1.6.84) released

	* lib/byte.c: new functions checkKindOfBlock and patchCleanBlocks.
	* lib/byte.h: declaration of patchCleanBlocks.

Mon Dec 27 20:15:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: new function fixupBlockClosures.
	* lib/comp.c: new way of compiling blocks.
	* lib/bytecode.inl: bytecode 200 is now #blockCopy: (same as the Blue
	Book, but the primitive is implemented differently of course).
	* lib/prims.inl: new implementation of primitive 80 (blockCopy)
	* lib/sym.c: removed #blockCopy:temporaries: (replaced with #blockCopy:),
	added machinery to reveal `clean' blocks
	* lib/sym.h: removed #blockCopy:temporaries: (replaced with #blockCopy:)

Mon Dec 27 10:05:10 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: added method to BlockClosure, changed to new
	context structure (methodClass/selector retrieved from the
	compiledMethod, method only there for MethodContexts)
	* lib/interp.c: changed to new context and BlockClosure structure
	* lib/prims.inl: changed to new BlockClosure structure

Sun Dec 26 16:49:17 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: store the class and selector in the created
	CompiledMethods.  A first step towards leaner context objects
	(i.e. more speed when sending messages!) and more powerful
	constructs such as `clean' block closures (which do not need
	to be created at run-time because are isolated from the outer
	contexts).
	* lib/comp.h: added `class' and `selector' to struct Method.
	* lib/dict.c: added `class' and `selector' to CompiledMethod.
	* lib/prims.inl: pass class and selector to makeNewMethod.

Sun Dec 19 10:38:43 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: removed hasBlock (can be replaced with a
	test on whether the context lies in the main OOP table); this
	simplified both sends and returns.  I also made the structure
	of method and block context objects more similar, resulting
	in simpler and faster code (except for block returns), and
	opening doors to optimizations such as delayed filling of the
	`method' and `receiver' slots of context objects.  The overall 
	improvement obtained since the Dec 17 change amounts to 9-10%.
	* lib/dict.c: same as above
	* lib/interp.c: same as above
	* lib/interp.h: same as above
	* lib/prims.inl: same as above

Fri Dec 17 23:17:03 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: various changes, notably to getMethodContext and
	its users, to avoid using oopToObj more than once on the same
	object.

Fri Dec 17 16:38:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: nil is now 0L (used to be 0), which is better when
	used as a pointer.
	* lib/interp.c: as long as we're sure that the execution order is
	LIFO (i.e. as long as no blocks are involved), allocate OOPs for
	the contexts outside of the main OOP table; this is because
	allocOOP is slower than picking a pre-built OOP out of a stack.
	This partly resembles the design of 1.1.5 (introduced Jan 1, 1991
	and modified Oct 18, 1998), but has the advantage that when a
	BlockClosure is created we only have to allocate the OOPs that we
	tried to avoid -- 1.1.5 copied the whole objects to the main heap,
	causing way too many GCs.

Thu Dec 16 16:20:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: F_FAKE --> F_POOLED, isFake --> isPooled
	* lib/interp.h: resetFakeContexts --> emptyContextsPool
	* lib/interp.c: (de)allocFakeContext --> (de)allocPoolContext,
	fakeList --> contextPool, plus changes above
	* lib/oop.c: realizeOOPs --> sweepPooledObjects, plus changes above

Wed Dec 15 17:53:11 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/sym.c: modified hashString to reduce likeliness that
	hash be zero.

Tue Dec 14 21:16:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: use the new procedures below
	* lib/comp.c: allocated one more bit for the method flags.  If
	there is a primitive index, the flags are now 4 (used to be 0).
	* lib/interp.c: the old `returnWithValue' procedure was split in
	two, unwindToContext and unwindLastContext -- one is used upon an
	explicit `return from method', the other does less job and returns
	to the parent context upon a `return from context'

Sat Dec 11 23:11:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: moved findClassMethod here from lib/dict.inl
	* lib/dict.h: restored declaration of findClassMethod
	* lib/dict.inl: moved findClassMethod here to lib/dict.c -- it is
	used rarely (only for method cache misses) and was bloating
	sendMessageInternal's code.

	* lib/bytecode.inl: simple one-byte bytecodes prefetch the next
	address to jump to (hoping to save address generation interlocks)
	* lib/interp.c: support for prefetching

Mon Dec 6 18:00:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: hard-code register allocation of ivar2
	and tempOOP only where they are actually used
	* lib/dict.inl: hard-coded register allocation in nilFill
	* lib/interp.c: hard-coded register allocation now relies on
	register.h and is used in sendMessageInternal/sendBlockValue.
	* lib/register.h: created

Sun Dec 5 18:54:57 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: returnMethodStackTop became returnContextStackTop
	in isSimpleReturn.
	* lib/cint.c: declare the strerror C function.
	* lib/gst.h: ANSI asks for 65535 instance variables, so I shifted
	the instance specification's `number of instance vars' field
	right by three bits (now 262143 variables are possible).
	* lib/lex.c: parse stuff like 1.0d53 and 1.0q212 correctly even
	though FloatD/FloatE/FloatQ is not supported yet.

	* lib/memzero.h: removed a conditional by using LONG_SHIFT in the
	generic version of memzero.

Sat Dec 5 19:58:51 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: the `hasBlock' instance variable in a context
	is now an integer (0 or 1).  This eliminated several lookups for
	the `trueOOP' and `falseOOP' globals.
	* lib/interp.c: same as above
	* lib/prims.inl: same as above

Fri Nov 26 20:59:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Fourth beta of 1.7 (labeled 1.6.83) released

	* lib/bytecode.inl: added caching of primitive numbers for sends of
	#at:, #at:put: and #size
	* lib/interp.c: same as above
	* lib/prims.inl: same as above

Mon Nov 22 18:20:09 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: fixed floating-point exception on operations
	with infinity and NaN, under FreeBSD.

Sun Nov 21 11:51:27 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/alloc.c: use memzero instead of memset; also, xmalloc
	doesn't zero memory
	* lib/byte.c: use memzero instead of memset
	* lib/dict.inl: use memzero instead of memset
	* lib/dynamic.c: use memzero instead of memset
	* lib/gst.h: include memzero.h
	* lib/memzero.h: added

	* lib/oop.c: don't update numFreeOOPs on allocate/free oop.
	It is only used after a GC (to check whether the OOP table
	must be resized), so it is sufficient that it be correct
	after a GC.

Sat Nov 20 20:01:58 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: restoreCFuncDescriptor was called at the wrong
	time in save.c -- before the xxxClass variables were loaded
	(Oct 20 change).  So now it is called here.
	* lib/save.c: see above for lib/dict.c

Sat Nov 20 09:22:32 1999  P. Lecoanet

	* lib/bytecode.inl: special case #blockCopy:temporaries: for
	context objects and #value/#value: for BlockClosure objects.
	Also, no need to push and pop the object for the `return
	self/true/false/nil' bytecodes -- a simple assignment will do.

Fri Nov 19 19:46:50 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: removed initNilVec and nilVec
	* lib/dict.inl: implemented nilFill as an unrolled loop (memcpy
	is sloooow)
	* lib/interp.c: arguments are moved between contexts with an
	unrolled loop (memcpy is sloooow); pushNNils now sets up the
	whole context stack (arguments+temporaries) and is called
	prepareContext.  Another +10% for this on send-heavy benchmark!!!

Thu Nov 18 19:48:17 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.h: returnBlockStackTop became returnContextStackTop
	* lib/comp.c: compile returns from methods as returnContextStackTop
	(should be a bit faster)
	* lib/bytecode.inl: `return self' and other similar bytecodes
	fall into returnContextStackTop, not returnMethodStackTop.

Thu Nov 18 16:34:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: changed to account for removal of cacheHits and
	messagesSent.
	* lib/comp.h: removed messagesSent.
	* lib/interp.c: removed cacheHits and messagesSent, which 
	can be deducted from other statistics.
	* lib/interp.h: removed cacheHits.
	* lib/prims.inl: new implementation of mutation does not need
	primitive 263 (#specialBasicAt:).

Wed Nov 17 20:06:07 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.inl: access functions test subscript bounds -- this
	eliminates an instanceSpec lookup.
	* lib/prims.inl: no need to call checkIndexableBoundsOf on
	access primitives (#at:*, #basicAt:*)
	* lib/gst.y: Support for the #(1 2 3 #a #b #'cdef' 45) syntax
					     ^^ ^^ ^^^^^^^

Sun Nov 14 15:42:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: `return instance variable' stores index in the
	`primitive' field of the method header (allows more optimizations
	and better register allocation in sendMessageInternal)
	* lib/comp.h: move flag bits to high end of the methodHeader, so
	that there is place for two additional bits if needed
	* lib/dict.c: BlockContexts now hold the receiver and the
	BlockClosure instead of the number of arguments and temporaries.
	* lib/interp.c: same as comp.c and dict.c above; plus, removed
	code for ACCESSOR_DEBUGGING.
	* lib/interp.h: same as dict.c above

Sat Nov 13 11:57:39 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: nilVec contains now 128 OOPs
	* lib/dict.inl: nilVec contains now 128 OOPs
	* lib/interp.c: doc fixes; cleaned up unused variables in the code
	handling fake contexts; finally, the method cache now includes
	the method header (+5/10% performance).

Thu Nov 11 23:01:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dynamic.c: move method whose threaded code representation
	is requested to the head of the methodsTable.
	* lib/lex.c: USE_MONCONTROL only affects the interpreter, not the
	lexer.
	* lib/lib.c: disable execution tracing options when the dynamic
	translator is being used.
	* lib/oop.c: removed code for ACCESSOR_DEBUGGING, which I found
	more bug-prone than useful in more than a year; added lines
	explaining GC_TORTURE.
	* lib/oop.inl: removed the few lines that implemented the
	ACCESSOR_DEBUGGING preprocessor symbol and explained what it was
	for.

Wed Nov 10 17:36:03 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: in most bytecodes that are implemented with a
	switch statement, the switch statement is resolved at translation
	time.  Also, added `default' clauses to such switch statements so
	that the compiler can produce better code.
	* lib/dynamic.c: same as above
	* lib/dynamic.h: same as above
	* lib/interp.c: same as above

	* lib/gst.h: removed declarations of TreeNode, thisClass and
	regressionTesting, which are already declared elsewhere
	(respectively in tree.h, comp.h and lib.h).  Also removed
	declaration of Stream which is needed only in lex.c and is
	therefore moved there.
	* lib/lex.c: moved declaration of Stream from gst.h

Tue Nov  9 21:30:08 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dynamic.c: invalidating the macro opcode cache is now
	separated from invalidating the threaded code cache. Also,
	convert from threaded code ip to bytecode ip before 
	invalidating the threaded code cache; reload the methodBase 
	and the threaded ip after having invalidated it (in
	invalidateMethodCache). Everything works if no optimization 
	options are set when compiling.

Tue Nov  9 18:15:31 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/callin.c: selectorNumArgs used; in addition, the result
	is checked to be the `nil' object in msgSendf is checked and,
	if so, 0 (or some variation of it, like 0.0 and NULL) is
	returned.
	* lib/interp.c: added DEBUG_CODE_FLOW preprocessor symbol that
	prints every message that is sent in the same form used by
	backtraces (e.g. `Integer(Object)>>#retry:coercing:').
	* lib/prims.inl: selectorNumArgs used in implementation
	of #perform:...
	* lib/sym.c: added selectorNumArgs
	* lib/sym.h: added selectorNumArgs

Mon Nov  8 18:32:54 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: fixed bug in makeDestinationTable that caused
	macro-opcode inlining to lose as soon as a jump was found.
	* lib/dynamic.c: had mistyped an = for an == grrr... 2 days to
	find it! Now runs up to WeakObjects.st both with and without
	macro-opcode inlining, so macro opcodes should be reasonably
	bug-free (except for problems arising from inlining code
	optimized by GCC, which I have not tackled yet).

Sat Nov  6 11:16:49 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: jump bytecodes must be `PROTECT' bytecodes,
	isNil and notNil sends need not.  Found two unused variables.
	* lib/cint.c: moved `extern' declaration of enableGC into cint.h,
	the actual declaration of the variable came here from interp.c
	* lib/cint.h: moved `extern' declaration of enableGC from cint.c
	* lib/interp.c: moved getMethodLiterals to interp.inl and
	enableGC to cint.c
	* lib/interp.inl: moved getMethodLiterals from interp.c

Fri Nov  5 18:43:19 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: can print bytecodes without a vector of literals
	* lib/dynamic.c: added debugging support; offsetToFill was not reset
	when a non-inlinable opcode was found (fixed by setting it in
	newOpcodeEntry) -- now runs up to the first jump bytecode
	(#initialize in Character.st), or up to MethodDict.st
	with macro-opcode inlining disabled.

Tue Nov  2 17:50:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dynamic.c: work on the dynamic translator restarted. The first
	correct dynamically code was generated today: a small step for
	humanity, a big step for me (hmmm... maybe it was the other way
	round...) -- runs up to the first `inlined opcode-non inlined opcode-
	inlined opcode' pattern (line 1358 of Builtins.st)
	* lib/interp.c: work on the dynamic translator restarted

Sun Oct 31 13:44:52 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: fixed bug when compiling an integer constant
	that did not fit in the first 31 literals (`push instance
	variable[x]' was emitted instead of `push literal[x]')

Sun Oct 31 11:12:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Third beta of 1.7 (labeled 1.6.82) released

Sat Oct 30 12:31:58 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: a few bytecodes were still sending #booleanRequired
	instead of #mustBeBoolean (see May 3rd change).

Fri Oct 22 10:15:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/save.c: ensure that upon load the heap is at least 50% free.

Thu Oct 21 17:44:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: added characterArrayClass
	* lib/dict.h: added characterArrayClass
	* lib/lib.c: added CharArray.st

Wed Oct 20 20:00:37 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: the new startup sequence (Oct 9) allowed to
	make the dictInit function (now called initNilVec) static.
	So that has been done since dictInit was just a hack:
	it initialized variables in dict.c like initDictionary,
	but while the latter is called from lib.c, dictInit had to
	be called from initOOPTable and loadFromFile).
	* lib/dict.h: removed declaration of dictInit.
	* lib/oop.c: removed call to dictInit.

Tue Oct 12 11:47:25 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dld_hpux.c: `return 0' was missing in gst_dld_init
	* lib/lib.c: put the image in the local directory if the
	image directory is missing or not writeable.
	* lib/sysdep.c: added fileIsWriteable, plus usage of time_t;
	strdup was erroneously declared in getFullFileName.

Mon Oct 11 21:23:01 1999  Paolo Bonzini  (bonzini@gnu.org)
	
	* lib/comp.c: removed addForcedSelector (a copy of addForcedObject).
	Open coding of #whileTrue, #whileFalse, #repeat; removed open
	coding of #yourself.
	* lib/dict.c: restored lookupKeyClass and its definition as I
	finally understood what it was meant to do; modified Association's
	definition (doesn't include key instance variable anymore).
	* lib/dict.h: same as above

Sun Oct 10 15:32:48 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/oop.c: added reallocOOPTable.
	* lib/oop.inl: call reallocOOPTable instead of exiting when
	ran out of OOP table slots.
	* lib/save.c: fixupObject, restoreObject, restoreInstanceVars accept
	an mst_Object instead of an OOP; more coherent with their names and
	a bit more efficient too.  Also moved updating of CFunctionDescriptors
	from restoreInstanceVars to fixupOOPInstanceVars (it is not needed
	when saving, only when loading, and was the only part of the code
	that required the parameters to be OOPs).
	* lib/save.h: fixupObject and restoreObject are now public.

Sun Oct 10 13:53:09 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: define the `min' and `max' macros.
	* lib/lib.c: used oopTableSize instead of OOP_TABLE_SIZE;
	use additional parameter to initOOPTable.
	* lib/oop.c: added to initOOPTable a parameter to specify the
	table size; defined oopTableSize and used instead of
	OOP_TABLE_SIZE.
	* lib/oop.h: OOP_TABLE_SIZE became INITIAL_OOP_TABLE_SIZE;
	declared oopTableSize.
	* lib/oop.inl: used oopTableSize instead of OOP_TABLE_SIZE
	* lib/prims.inl: used oopTableSize instead of OOP_TABLE_SIZE
	* lib/save.c: used oopTableSize instead of OOP_TABLE_SIZE;
	use additional parameter to initOOPTable.

Sun Oct 10 10:57:37 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/oop.c: moved builtin objects at the front of the oop table;
	this is a first step towards a variable-sized oop table
	(believe it or not, I did it in less than half an hour!!).
	* lib/oop.h: same as above.
	* lib/oop.inl: same as above.
	* lib/prims.inl: same as above.
	* lib/save.c: same as above.
	* lib/sym.c: same as above.

Sat Oct 9 09:14:23 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Second beta of 1.7 (labeled 1.6.81) released

	* lib/bytecode.inl: added a few experimental branch labels
	for the dynamic translator.
	* lib/prims.inl: added primitive 90 to flush the dynamic
	translator's code cache.

	* lib/dict.c: added code to reinitialize the global OOPs (which
	are not saved anymore so that the image is more compatible). Also,
	the OOP indices associated to Smalltalk, Processor and the
	SymbolTable are fixed so that we know them without storing them
	in the image file. Finally, declare the `Undeclared' dictionary in
	initSmalltalkDictionary().
	* lib/oop.c: removed markGlobalOOPs (instead, just mark the
	`Smalltalk' dictionary).
	* lib/save.c: removed the global OOPs; they are reinitialized
	every time in dict.c.
	* lib/save.h: removed the global OOPs
	* lib/sym.c: added undeclaredSymbol, and used in findClassVariable.
	* lib/sym.h: added undeclaredSymbol.

Thu Oct 7 18:07:46 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: restored old MethodDictionary class (see
	March 29th, 1989 entry!) It was needed after all.
	* lib/dict.h: same as above
	* lib/lib.c: same as above
	* lib/save.c: same as above
	* lib/sysdep.c: fixed faked closePipe to return status of child
	process.

Sat Oct 2 18:26:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: was trimming the last character of the method's
	source code in FileSegments.
	* lib/lex.c: was trimming the last character of the method's
	source code when creating Strings from source code read from
	a file.
	* lib/lib.c: added -K option, don't crash on -I/-L/-K without
	mandatory argument.

Sun Sep 26 20:06:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: initProcessSystem removed the initial process from
	its own process list -- result: as soon as `Processor yield' was
	called, highestPriorityProcess did not know that the active process
	was active!
	* lib/prims.inl: relinquish control to other processes on #yield.
	* lib/lib.c: `gst -a' caused a segmentation violation
	* lib/sysdep.h: declaration of `relinquish'.
	* lib/sysdep.c: implemented `relinquish'.

Sat Sep 25 12:32:23 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** First beta of 1.7 (labeled 1.6.80) released

	* lib/bytecode.inl: use areInts in open-coded operators.
	* lib/gst.h: added areInts, removed F_FINALIZING.
	* lib/oop.c: store objects to be finalized in a buffer, to avoid
	an OOP table scan.
	* lib/str.h: added declaration of generic buffer functions
	* lib/str.c: added generic buffer functions (not limited to chars)
	* lib/dld_aix.c: added
	* lib/waitpid.c: added
	* lib/strtoul.c: added

Thu Sep 23 10:00:47 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dynamic.c: created.
	* lib/dynamic.h: created.
	* lib/obstack.c: added, fixed to use _obstack_memcpy.
	* lib/obstack.h: added.
	* lib/sysdep.h: added flushCode.
	* lib/sysdep.c: added flushCode & signalAfter implementation using
	fork()+getMilliTime().

Sun Sep 19 14:00:50 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: declare lookupTableClass
	* lib/dict.h: declare lookupTableClass
	* lib/lib.c: load LookupTbl.st and WeakObjects.st

Sat Sep 18 14:33:28 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.y: include "lib.h", define YYPRINT
	* lib/lex.c: define yyprint
	* lib/lex.h: declare yyprint
	* lib/lib.h: added declaration of "quietExecution", previously only
	in lib.c

Wed Sep 15 18:39:41 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: added mkdir declaration.

Tue Sep 14 10:02:55 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Added DefaultSortBlock to SortedCollection.
	* lib/lex.c: fixed bug; 8-bit characters *outside* string literals
	crashed the lexer.
	* lib/sysdep.c: use getcwd if HAVE_GETCWD (new symbol) is set and
	getwd otherwise.  Old behavior was to use getcwd if HAVE_UNISTD_H
	was set and getwd if HAVE_GETWD was set

Mon Sep 13 19:03:27 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: compile doits in UndefinedObject.

Sun Sep 12 17:20:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: moved variables from ClassDescription; instanceVariables to
	Behavior; name/comment/category/environment to Class (they make no sense
	in Metaclass!).
	* lib/dict.h: same as above.

Sat Sep 11 18:26:14 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: changes for namespaces (execute doits in the current namespace).
	* lib/dict.c: same as above (shared pool variable search algorithm,
	new `environment' variable, declaration of currentNamespace).
	* lib/dict.h: same as above (added `environment' variable to ClassDescription,
	declaration of currentNamespace).
	* lib/dict.inl: same as above (setClassEnvironment).
	* lib/prims.c: same as above (primitive 250 to tell the compiler about the
	current namespace).
	* lib/save.c: same as above (added uppercaseSuperSymbol, currentNamespace).
	* lib/sym.c: same as above (shared pool variable search algorithm).
	* lib/sym.h: same as above (added uppercaseSuperSymbol).

Fri Sep 10 13:29:48 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: variableWordSubclasses use accessors for 32-bit integers.
	BlockClosures are now variableWordSubclasses since the previous encoding
	was incompatible with the code to switch the endianness in a saved image.
	* lib/dict.inl: added accessors for 32-bit integers (64-bit on Alphas).
	* lib/gst.h: added warning that says Alphas are not ok yet.
	* lib/gst.y: shell was unusable after a parse error -- solved.
	* lib/interp.h: New encoding of BlockClosures (see above).
	* lib/prims.inl: C object and memory address primitives use the above
	accessors.

Wed Sep  8 16:45:28 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/prims.inl: flush the FileStream before reading its size.

Mon Sep  6 11:07:16 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: added idleTasks variable to ProcessorScheduler.
	* lib/interp.h: added idleTasks variable to ProcessorScheduler.
	* lib/lib.c: allowed -- to stop option parsing, to comply with getopt.
	* lib/sysdep.c: added POSIX interrupt handling (sigprocmask); Win32
	code for alarms now uses kill(2) instead of manually calling the
	handler.

Wed Sep  2 11:52:58 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.y: added support for [ :a :b || temp1 temp2 | ].
	* lib/lex.c: unreadChar not static anymore.  Also removed scanStringoid
	and moved its code to stringLiteral.  Parsing a comment does not
	actually require to store the whole comment in memory, so it is a
	conceptually different operation.  Fixed for the change to str.c below.
	Removed memory leak in printToken (not so important since it's just
	debugging code, but it's a bug).
	* lib/lex.h: unreadChar is now extern.
	* lib/lib.c: removed references to resizeString.
	* lib/str.c: removed resizeString, curStrBuf now returns a copy of the
	string (previously it was a chore left to its caller through strdup).

Tue Aug 31 11:27:31 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: registers where the interpreter's ip and sp stay are
	hard-coded for most architectures.  Added definitions for the high
	speed interpreter with dynamic translation.
	* lib/interp.inl: moved internal accessors to interp.c; moved object
	equality and hashing functions to dict.inl (the only places where they
	were actually used).

Mon Aug 30 11:09:27 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/bytecode.inl: created from part of interp.c
	* lib/gst.h: removed `extern' definition of the instruction pointer.
	* lib/interp.c: made the instruction pointer static; prepared for the
	new bytecode.inl file; relativeByteIndex is replaced by
	currentBytecodeIndex; added definitions of the latter macro.
	* lib/interp.inl: removed relativeByteIndex.
	* lib/prims.inl: relativeByteIndex is replaced by currentBytecodeIndex.

Sun Aug 29 11:23:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.6.2 released.

Fri Aug 27 18:29:52 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: always define DLD functions (at worst they're stubs)
	* lib/dld_none.c: created.
	* lib/lib.c: always load DLD.st (at worst it refers to C stubs)

Thu Aug 26 19:43:41 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: put CDoubleMin and CDoubleMax in the Smalltalk dictionary.
	* lib/interp.c: NEXT_BYTECODE was not defined for old (switch statement)
	dispatching.

Sun Aug 8 14:37:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: in initRuntimeObjects, define the ImageFileName global
	as equal to binaryImageName.
	* lib/lib.c: load .stpre only when creating local image files.  Removed
	findImageFile.  Option -v shows the hard-coded kernel and image paths.
	binaryImageName is not static anymore, defaultImageName is.
	* lib/lib.h: removed findImageFile.  binaryImageName is now declared
	here as an extern symbol, and defaultImageName is not.
	* lib/prims.inl: `Smalltalk snapshot' primitive (250) removed -- the
	new ImageFileName global makes it redundant.
	* lib/save.c: loadFromFile now expects a full path to the image just like
	saveToFile, does not call findImageFile.

Sat Aug 7 23:56:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: declare `unlink' (valid only for files) instead of `remove'
	(which nukes whole directories too) to be used to implement
	File class>>#primRemove:
	* lib/sysdep.c: added simulation of popen and pclose in openPipe
	and closePipe.

Sat Aug 7 11:26:38 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.h: initSTDIOObjects became initRuntimeObjects
	* lib/dict.c: initSTDIOObjects became initRuntimeObjects, and various
	initializations (Features, KernelPath, ImagePath) were moved here from
	initSmalltalkDictionary.  This completes the change made on July 14th.
	* lib/lib.c: initSTDIOObjects became initRuntimeObjects

Fri Aug 6 12:23:25 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.inl: relativeByteIndex now explicitly casts to int for
	Alpha compatibility.
	* lib/sym.c: switched from int to long when dealing with differences
	between addresses, for Alpha compatibility.
	* lib/dict.c: switched from int to long when dealing with differences
	between addresses, for Alpha compatibility.

Thu Jul 15 10:37:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dld_gnu.c: added gst_dld_exts (.o, .a)
	* lib/dld_gst.h: added gst_dld_exts
	* lib/dld_gst.c: added gst_dld_openext
	* lib/dld_hpux.c: added gst_dld_exts (.sl)
	* lib/dld_ltdl.c: added gst_dld_exts (dummy)
	* lib/dld_libdl.c: added gst_dld_exts (.so, .a)
	* lib/dld_win32.c: added gst_dld_exts (.dll, .exe)

Wed Jul 14 09:24:51 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: added F_BYTE, used while saving to ease reloading
	if the endianness changes.
	* lib/save.c: added ability to load images from machines with
	different endianness and to recognize (and reject) images from
	machines with different sizeof(long).  This change unveiled a bug
	in GNU C 2.7.2!!!
	* lib/dld_ltdl.c: created (thanks to Alexander Shinn for pointing
	me to libtool!)

Sat Jul 10 10:56:14 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: interruptHandler should set again the handler for SIGINT
	* lib/sysdep.c: fixed syntax error. Also, sigaction should use SA_RESETHAND
	if available because signal is supposed to work that way.
	* lib/sysdep.c: #define SIGALRM if not provided by C headers.

Mon Jul  5 21:27:31 1999  Paolo Bonzini  (bonzini@gnu.org)

	* gstconf.h.in: Changed USE_READLINE to HAVE_READLINE (more coherent)
	* gstconf.h: same as above
	* lib/comp.c: same as above
	* lib/lex.c: same as above
	* lib/lex.h: same as above
	* lib/lib.c: same as above

Sun Jul  4 16:09:23 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/sysdep.c: renamed dprintf to debugf. glibc 2.0 defines
	a different prototype for a function with the same name (glibc 2.1
	only defines it if __USE_GNU is defined and does not break gst).

Mon Jun 28 11:43:37 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/qsort.c: added standard stuff to make alloca work.
	* lib/gstpub.h: moved inclusion of gst.h *inside* `extern "C"'

Fri Jun 25 12:53:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Bug-fixing version 1.6.1 released.

Mon Jun 21 10:40:23 1999  Paolo Bonzini  (bonzini@gnu.org)

        * lib/alloc.c: in xrealloc, we must call malloc explicitly when
        the first argument is 0, since some reallocs don't do this.
        * lib/cint.c: Fix for Solaris' brokenness (in their stat.h, they use
        `#define st_atime st_atim.tv_sec')
        * lib/qsort.c: added (from GCC).

Thu Jun 17 11:38:53 1999  Mark Elbrecht  (snowball@bigfoot.com)

	*** Version 1.6 released.
        * lib/lex.c: Fix crash when using drive letters in isKernelFile.
        * lib/lib.c: For DOS, use '_stinit' and '_stpre' as init files since
        DOS doesn't allow a period to start a filename.

Wed Jun  9 12:48:21 1999  Pahi Andras  (pahi@mozart.eet.bme.hu)

	* lib/cint.c: defineCFunc makes a private copy with strdup of the
	C function's name. The problem is likely to root to the pre-DLD days
	(1989-1990) when only string constants were passed to defineCFunc, so
	strdup was unnecessary.

Thu Jun  3 13:33:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: added displayCompilationTrace
	* lib/comp.h: added declaration of displayCompilationTrace
	* lib/prims.inl: if declaration tracing is on, shows new
	categories as encountered.

Sun May 30 20:29:36 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: added default values for the definitions that used to
	be in gstpaths.h
	* lib/gstpaths.h: removed since configure did not create it properly
	after the installer was fixed
	* lib/Makefile.in: added definitions to be used in place of gstpaths.h
	* lib/lib.c: if the the paths cannot be located, try using the local
	directory
	* lib/lib.h: defaultImageName is now a variable
	* lib/str.c: added resizeString

Fri May 28 18:09:49 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: object passed as `unknown' or `self', whose class is not
	recognized, are now passed as an OOP (they used to be skipped).
	* lib/interp.c: the open-coded // was rounding like quo: does.
	* lib/prims.inl: the base date for secondClock was 2 Jan 2000 instead
	of 1 Jan 2000.  This was apparent after the fix above.

Thu May 20 12:28:23 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/alloc.c: moved platform-dependent definitions here.  Modified
	so that, if we replace libc's allocator, we define calloc too (see
	glibc's manual).  Also modified so that xmalloc exits if it fails.
	* lib/alloc.h: removed platform-dependent definitions.  Now this
	file only contains extern declarations (correctly).

Sat May 15 17:12:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: added code to #define `volatile' to nothing if it is
	not supported.
	* lib/interp.c: modified to pass through -Wall when optimization
	is on.  This highlighted a possible (although never observed) bug in
	sendMessageInternal: the setjmp/longjmps in executePrimitiveOperation
	could have clobbered methodOOP, which is now declared volatile.

Fri May 14 16:27:45 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: modified to (almost) pass through -Wall.
	* lib/cint.c: modified to pass through -Wall.
	* lib/comp.c: modified to pass through -Wall.
	* lib/dict.c: modified to pass through -Wall.
	* lib/dict.inl: modified to pass through -Wall.
	* lib/gstpub.h: added C++ `extern "C"' guard.
	* lib/interp.c: modified to pass through -Wall.
	* lib/interp.inl: modified to pass through -Wall.
	* lib/lex.c: modified to pass through -Wall.
	* lib/oop.c: modified to pass through -Wall.
	* lib/save.c: modified to pass through -Wall.
	* lib/sym.c: modified to pass through -Wall.

Thu May 13 11:11:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/callin.c: added objectAlloc.
	* lib/gst.h: added guards to avoid including heavily implementation
	dependent stuff when gst.h is included by gstpub.h
	* lib/gstpub.h: changed to use those guards.
	* lib/dld_hpux.c: created.
	* lib/dld_libdl.c: new name of dld_sun.c
	* lib/lex.c: stream description for readline streams is not
	`a Readline string' anymore, but `stdin' (since that's where we
	actually get the string).  Also, when readline is used I also
	include <readline/history.h> now; and I disable readline's auto-
	completion feature, not supported by gst (initializeReadline).


Tue May 11 21:14:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: various performance counters are now unsigned longs.
	* lib/comp.h: various performance counters are now unsigned longs.
	* lib/interp.c: #mustBeBoolean is now sent to the object that should
	have been a Boolean, as the Blue Book says.  Plus, same as above.
	* lib/interp.h: various performance counters are now unsigned longs.

Sun May  9 14:05:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/id.c: removed -- I'm very sorry to do it, since it was created
	10 1/2 years ago, but it was a copy of str.c
	* lib/id.h: removed -- I'm very sorry to do it, since it was created
	10 1/2 years ago, but it was a copy of str.h
	* lib/lex.c: removed references to function that used to be in poor id.c;
	changed references to copyStr to use strdup.
	* lib/prims.inl: added code to test for infinity, NaNs and other failures
	in mathematical functions (exp/ln/sqrt/trigonometry).
	* lib/str.c: removed copyStr.
	* lib/sysdep.h: added portable macros to test for nan and infinity.
	Not all libc's have isnan, isinfinity and the like.

Sat May  8 15:59:48 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: fixed bug when compiling to:do:/to:by:do: and the loop
	index temporary was in position 15 (a 2-byte push was erroneously
	compiled, since a 1-byte push can be used).
	* lib/interp.c: did not trap divides by zero on open-coded // messages.
	* lib/lib.c: added Transcript.st to the list of kernel files.
	* lib/oop.c: Character objects' objSize field was uninitialized. Fixed.
	* lib/prims.inl: fixed SIGSEGV on (IndexableClass new: aNegativeNumber).

Thu May  6 12:55:03 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: added exceptionHandlers variable to Process.
	* lib/gst.y: fixed bug with conditional compilation -- conditional
	exclusion was not disabled by the double bang sequence.
	* lib/interp.h: added exceptionHandlers variable to Process.

Mon May  3 19:36:45 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: changed the system message #booleanRequired to
	#mustBeBoolean for coherence with the Blue Book (I had not noted
	that passage).  Fixed async signals (actually, I just removed
	the error messages -- they seem to work as they are and their
	implementation is exactly the same as in the book...) and
	changed the signal handling routines to use them instead of
	separate variables.  Added asyncSignal().
	* lib/interp.h: added declarations for asyncSignal().
	* lib/interp.inl: fixed unparenthesized arguments in the `equal' macro.
	* lib/gstpub.h: added declarations for asyncSignal().
	* lib/lib.c: search for a local copy of the kernel files in the
	`kernel' subdirectory of the local directory; always save the
	kernel sources as FileSegments.  This way, GNU Smalltalk works
	both if a) it is installed and the kernel lies in /usr/local/share
	b) it is not installed and everything is done inside the
	user's home directory c) it is not installed, we are under Windows
	and everything is done inside the current directory (maybe I'll
	switch to the executable directory in the future...)

Thu Apr 29 20:01:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: now does compile correctly optimized selectors whose
	block arguments have arguments or temporaries.  In fact I simply
	don't optimize them -- but maybe I will sooner or later.  Also,
	#timesRepeat:, #to:do: and #to:by:do: are now open-coded.
	Finally, I fixed the fact that the bytecodes for an erroneous method
	were put at the beginning of the next syntactically valid method.
	* lib/lib.c: the `Smalltalk Ready' banner is now `GNU Smalltalk Ready'.
	* lib/save.c: added timesRepeatColonSymbol, toColonDoColonSymbol and
	toColonByColonDoColonSymbol.
	* lib/sym.c: same as above.
	* lib/sym.h: same as above.

Tue Apr 27 20:01:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.5.beta3 released.
	* lib/alloc.c: added inclusion of stdlib.h (or malloc.h for old C's)
	when the custom allocator is not used.
	* lib/byte.c: fixed optimization of pushIndexed.
	* lib/dld_sun.c: added missing semicolon.
	* lib/interp.c: finished new GCC implementation at last -- now we
	only have to do a single goto for EVERY bytecode.  Maybe something
	better could be done by caching dispatchVec in a register...  Auto-
	matic #undef-ining of USE_OLD_DISPATCH is now based on the new
	gstconf.h definition HAVE_GOTO_VOID_P (used to simply check __GNUC__).

Sun Apr 25 21:36:22 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: added optimization of nopBytecode.  Added `replace
	stack top' bytecodes 140-142 in optimizeBasicBlock.
	* lib/byte.h: added `replace stack top' bytecodes.
	* lib/comp.c: added yourselfSymbol in whichBuiltinSelector (yourself
	is now open-coded).
	* lib/interp.c: added `replace stack top' bytecodes.
	* lib/prims.inl: changed GC-tuning primitives (spaceGrowRate
	and growThreshold) to accept integers too.
	* lib/sym.h: added yourselfSymbol.
	* lib/sym.c: added yourselfSymbol.
	* lib/save.c: added yourselfSymbol.

Fri Apr 23 16:57:58 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: cleaned up some definitions for ANSI features which
	can be checked by autoconf -- the old #ifdef method only makes things
	cumbersome.  Also renamed config.h to gstconf.h, so that it can be
	installed without filename clashes.
	* lib/interp.c: changed verbose execution tracing to print the stack
	top *BEFORE* the bytecode -- the output is easier to follow.  Added
	jump lookahead (see definition of JUMP_LOOKAHEAD).
	* lib/oop.c: began switching to something resembling a generational
	collector.  Changed GC-tuning variables (spaceGrowRate/growThreshold)
	to be integers -- because they are now checked in allocObj and doubles
	are more expensive in busy code, I think.

Thu Apr 22 00:43:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.h: merged bytecodes 138-139 (push/store outer temp) into a
	single bytecode 138, which can also do a `pop and store outer temp'.
	* lib/byte.c: same as above. The new bytecode behaves much like bytecode
	126, so the code for that bytecode in the optimizer can be used by the
	new bytecode too.  Added more cases in the peephole optimizer.
	* lib/comp.c: same as above.
	* lib/interp.c: same as above. Moved various optimization #define's at
	the top of the file.

Tue Apr 20 18:45:38 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: optimizer in and working.  Fixed challenging cases in
	the flow analyzer which were apparent now because the peephole
	optimizer does some `interesting' changes to the bytecode -- previously
	the changes were not `interesting' enough for these bugs to show up.
	Performance +5-10%, but some interesting optimizations are not there
	yet (e.g. pop-store/push --> store, and push/push --> dup).

Mon Apr 19 23:44:57 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: added to the flow analysis some support for optimizing
	#ifTrue: and #ifFalse: in the common case where their result is
	discarded.  Added a first peephole optimizer in optimizeBasicBlock.
	* lib/byte.h: added nop bytecode 139
	* lib/comp.c: changed the compilatation of #ifTrue:/#ifFalse: to one
	which is more optimizable if the result is discarded.  #and:/#or: are
	left as they were because their result is usually kept.  Also ALWAYS
	put a pop bytecode at the end of a statement -- it makes flow analysis
	simpler and is removed by the peephole optimizer if unnecessary.
	* lib/interp.c: added nop bytecode 139

Sun Apr 18 21:17:13 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: the new optimization scheme proved to be easily
	extendable (which is what I wanted). I added jump optimization
	(10 lines of code) and unreachable code elimination (5 lines) -- no
	big speed improvements, but now I have moer experience with
	optimization and will approach peepholing.
	* lib/byte.c: modified various internal functions to avoid continuous
	reallocation of bytecodes.  For instance, reallocByteCodes uses
	xrealloc() -- it was always malloc-ing everything from scratch --
	and allocByteCodes and reallocByteCodes have a parameter with the
	amount of memory to be allocated.
	* lib/cint.c: call initDldLib if HAVE_DLD is defined.

Fri Apr 16 14:05:11 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dld_gst.c: created from old cxtnsn/dld.c
	* lib/dld_gst.h: created
	* lib/dld_gnu.c: created
	* lib/dld_sun.c: created
	* lib/dld_win32.c: created
	* lib/byte.c: changed the algorithm for optimizeByteCodes.  Instead of
	doing a single scan on the bytecodes and fixing up jumps the hard way,
	I'm now dividing the bytecodes into basic blocks, optimizing each of
	them one at a time in optimizeBasicBlock.
	* lib/dict.c: moved hasBlock to ContextPart, yanked it out from
	BlockContext and MethodContext.
	* lib/interp.c: moved hasBlock to the fourth position (inside
	MethodContexts and BlockContexts) so that we can put it in ContextPart.
	* lib/lib.c: load DLD.st from kernel if HAVE_DLD is defined.

Mon Apr 12 21:58:04 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/sysdep.c: functions handling time_t's now use signed longs.
	* lib/sysdep.c: stole more portable implementations of adjustTimeZone
	and currentTimeZoneBias from GNU Emacs.  Added support for broken
	versions of localTime(3) that cache the time zone.
	* lib/sysdep.h: functions handling time_t's now use signed longs.

Sat Apr 10 23:19:41 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.5.beta2 released.
	* lib/cint.c: my_stat now adjusts file times to local times.
	* lib/sysdep.c: added adjustTimeZone and currentTimeZoneBias.
	* lib/sysdep.h: added adjustTimeZone and currentTimeZoneBias.

Fri Apr 9 20:00:19 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: fixed my_stat to return times relative to 1/1/2000
	to avoid possible overflows (which would have happened around 2004
	on 32-bit machine, and around 8.000.000.000 AD on 64-bit ones...).

Thu Apr 8 10:06:59 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: fixed bug in sendMessageInternal and sendBlockValue.
	Basically, we now make sure that sp and thisContext->spOffset are
	consistent whenever a GC could happen; otherwise, fixupObjectPointers
	recomputes thisContext->spOffset from sp, storing an erroneous value
	into the former.

Mon Mar 29 23:29:01 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: added definition of WIN32 because Cygwin only defines
	_WIN32, but many programs rely on WIN32 instead.

Mon Mar 22 21:03:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/sysdep.c: fixed Win32 version of Delays, which was buggy if a
	delay had to cancel the previous one.  The new version is also much
	more precise.

Sun Mar 21 13:34:43 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: changed Integer relational operators to not do a
	toInt() (instead we use a simple typecast).

Mon Mar 15 20:23:07 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.5.beta1 released.
	* lib/dict.c: changed to use setCObjectValueObj and cObjectValueObj.
	* lib/dict.h: doc fixes for CObject.
	* lib/dict.inl: added setCObjectValueObj and cObjectValueObj.  Now, the
	address pointed by the CObject is the LAST instance variable (including
	indexed ones), not always the SECOND (which could still be a fixed
	one).  For currently defined CObject subclasses this was not a problem,
	but it could have been a serious one if a CObject subclass declared
	additional instance variables.
	* lib/prims.inl: changed to use setCObjectValueObj and cObjectValueObj.

Sat Mar 13 12:16:09 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: was crashing if a call-out to a non-existent function
	was attempted.
	* lib/comp.c: fixed a strange bug I'm not sure I understood well. It
	seems that, if an error occurred in a method with literals, and if an
	immediately following method had literals, the literal array
	contained bogus data and GST would lose.  I don't think it was there
	before my March 3rd change...

Thu Mar 11 18:28:51 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/lib.c: added --silent as a synonim of --quiet and -q.

Wed Mar 3 14:32:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: added stack depth tracing (variables and macros
	containing stackDepth).  Made makeNewMethod public, to avoid lots of
	duplicate code for the C and Smalltalk compiler.
	* lib/prims.inl: added primitive 79, which maps to makeNewMethod.
	* lib/interp.c: added support for mixed size contexts. Added
	resetFakeContexts.
	* lib/interp.c: the change above unveiled lots of bugs - especially
	uninitialized pointers here and there. In particular: a) GST would
	core dump when you did a send to super from a class without a
	superclass; b) prepareExecutionEnvironment set the stack pointer of
	the context to 0 instead of -1 so markAnOOPInternal would try to
	mark an additional stack slot.
	* lib/oop.c: In minorGCFlip, call resetFakeContexts at the end instead
	of using deallocFakeContext for every context.

Sun Feb 28 22:09:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: modified compileAssignments to use preferrably the
	`storeIndexed' bytecode. This is faster and also makes the task
	of an eventual bytecode optimizer a bit simpler.
	* lib/byte.c: added truncateByteCodes.  Moved optimizeByteCodes
	here and made it extern (it was a static in lib/comp.c), and added
	it some (working but currently not used) code.
	* lib/byte.h: added optimizeByteCodes and truncateByteCodes

Sat Feb 27 11:09:45 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/prims.inl: added primitive 101 (ProcessorScheduler>>
	isTimeoutProgrammed).
	* lib/dict.c: added DelayProcess and IdleProcess as
	Delay's class variables
	* lib/interp.c: in initProcessSystem, leave the processes the way
	they were unless we get here after a deadlock.

Fri Feb 26 12:51:28 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: changes to have an error-free compile with
	-pedantic.  Also fixed highestPriorityProcess to return the
	active process if it is not waiting on a semaphore (because
	`Processor yield' must not stop execution if the only
	runnable process is the active one).
	* lib/lex.c: Added support for -s command line option in
	isKernelFile.
	* lib/lib.c: Added -s command line option.
	* lib/oop.c: Removed arithmetics on void * in realizeOOPs.

Tue Feb 23 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.y: Added #'abcd' symbols (not in Smalltalk-80,
	but ANSI and common in many commercial Smalltalk
	implementations).

Mon Feb 22 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/lib.c: Moved some initializations *after* parsing the
	command line (obviously *before* loading user files),
	so that parameters on the cmdline can influence the
	initialization process.

Sun Feb 21 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Added printing of what is the erroneous method in
	sendMessageInternal.  Also renamed global SP/IP to outerSP and
	outerIP (which are then #defined to ip and sp in gst.h), so that
	there is no name collision between the local IP/SP and the global
	ones; and eliminating ipAddr/spAddr we get some more speed. But
	remember this when using GDB!!

Thu Feb 18 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Struggled to make the process system work as
	intended; it still has a few bugs but it mostly works (for
	example, philosophers now work).

Tue Feb 16 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/oop.c: Started switching to generational GC!! In short,
	minor GCs only take care of fake contexts and are faster 
	because no sweeping happens; major GCs don't bother of 
	fake contexts (they assume there are none) and deal with 
	removing real unused objects.

Mon Feb 15 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.h: Added bigLiteral bytecode.
	* lib/comp.c: Changed so that methods are normal objects - no
	more variable classes and variable byte classes at
	the same time. Now, the header does not include the
	number of literals, so I also added code to use the
	new 126 bytecode.
	* lib/interp.c: Changed so that methods are normal objects - no more
	variable classes and variable byte classes at the
	same time.
	* lib/interp.inl: Changed so that methods are normal objects - no more
	variable classes and variable byte classes at the
	same time.
	* lib/prims.inl: Now methods are normal objects - no more variable
	classes and variable byte classes at the same time.
	So I removed primitives 68/69/79.
	* lib/save.c: Changed so that methods are normal objects - no more
	variable classes and variable byte classes at the
	same time.

Sun Feb 14 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/oop.c: Experimentally moved markGlobalOOPs at the START
	of the marking phase, so that by the time the other
	objects in the root set are dealt with, many objects
	will have been marked. This might improve a bit GC
	locality of reference.
	* lib/save.c: Experimentally reorganized the global OOPs.
	smalltalkDictionary and the symbols at the END of
	the global OOP table, so that by the time they are
	marked other objects will have been dealt with and
	recursion will be more shallow; this might improve
	a bit GC locality of reference.

Sat Feb 13 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/sysdep.c: using setSignalHandler() inside signalAfter().

Fri Feb 12 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/sysdep.c: getCurDirName, now performs special error handling
	when getcwd is used (code stolen from the gettext
	library's source code, by David MacKenzie).

Tue Feb  9 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: Moved incubator here from oop.h so that it is public
	* lib/oop.h: Moved incubator to gst.h so that it is public (see
	comment in GST 1.1.5 - "it is likely that this
	interface will be moved..."

Mon Feb  8 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: print new bytecode 126 for many literals, > 64.
	* lib/cint.c: Removed code to print "function not registered"
	message - Smalltalk code handles that now.
	* lib/lib.c: CFuncs.st is now loaded *after* CObject and CType -
	a logical choice since C function declarations could
	use CTypes.  Added PkgLoader.

Sat Feb  6 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/prims.inl: Sped up nextInstance by avoiding to search in the
	unused OOPs.

Fri Feb  5 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Added callbacks #booleanRequired and #interrupt.
	Implemented bytecode 126 for many literals, > 64.
	* lib/prims.inl: Primitive 255 now does not blindly set inCCode to
	false if a C callout made a callin which in turn made
	a callout.

Thu Feb  4 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/lex.c: Modified so that a bang is not part of a binary op.
	It's just a one-char token like [ and #.  Needs
	fixing, though.

Wed Feb  3 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/callin.c: Changed calls to yyparse() to parseStream().
	* lib/comp.c: Changed calls to yyparse() to parseStream().
	* lib/interp.c: Changed calls to yyparse() to parseStream().
	* lib/gst.y: More attempts at simplifying things around:
	now an expression invoking methodsFor: can be
	as complex as desired. In addition I changed
	temporaries and primitive to have a default value,
	so that almost-duplicated rules (e.g. `statements',
	`temporaries primitive statements', `temporaries
	statements', `temporaries primitive') can be put
	into a single one. Alas this causes 4 shift/reduce
	conflicts (2 in state 0, 2 in state 6) but Bison
	gracefully handles them and it makes the grammar more
	readable IMO.
	* lib/lex.c: Moved lex debugging here.  In addition, now
	you can compile this with NO_PARSE so that no parsing
	occurs - only lexical analysis.  To accomplish this, the
	callers need to call a function in lib/lex.c (parseStream)
	instead of yyparse().
	* lib/lib.c: Updated lex debugging and moved it to lex.c

Tue Feb  2 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/alloc.c: Added custom allocator, currently used only under
	Win32.  See comment in the file.
	* lib/alloc.h: Added custom allocator, currently used only under
	Win32.  See comment in the file.
	* lib/sym.c: internCountedString: the symbol OOP is now read only.

Mon Feb  1 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/oop.c: fix in growMemory. Now it seems to work right -
	previously, it failed if thisContext was not a fake
	and the heap moved.

Fri Jan 29 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: Modified isSimpleReturn so that a "return literal[0]"
	method is optimized.
	* lib/comp.c: Modified isSimpleReturn (in byte.c) so that a "return
	literal[0]" method is optimized. The "primitive must
	be executed" case, which was previously identified by
	flags == 3, is now identified by primitiveIndex != 0.

Thu Jan 28 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: Moved regressionTesting to lib.c; it seems more
	logical to me.
	* lib/gst.h: fix in incrInt/decrInt: it was not converting the
	OOP to a long before adding 2 - so it was actually
	adding sizeof(OOP)*2 = 16!
	* lib/lib.c: to make -S work when -i was specified too.
	* lib/oop.c: nilOOP, trueOOP and falseOOP are now initialized in
	allocOOPTable(), not initOOPTable(). Actually I can't
	guess why they weren't there in the first place.
	* lib/prims.inl: Added check for already closed file in fileOp: (if
	fileStream->file = nilOOP, fail). Added flushPrim
	and getBytePrim.
	* lib/save.c: Removed experimentally the code that saves and
	restores nil, true, false and the characters:
	why can't we initialize them just like if we were
	initializing the system from scratch, without
	an image?
	* lib/sysdep.c: openFile, removed references to BINARY_MODE_NEEDED
	(I had to remove it from the configure script because
	it did not work correctly, at least under Cygnus'
	Win32 port.

Wed Jan 27 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Smalltalk dictionary is now created with a larger
	size than it used to be (see the definition of INITIAL_SMALLTALK_SIZE).
	* lib/interp.c: Made the method cache an array of a struct instead of
	five different arrays.  A "return literal" method is
	optimized like "return self" and "return inst. var".

Tue Jan 26 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: Removed code for evaluating (parse last statement as
	return) - not needed since Smalltalk code implements
	evaluate: Also changed references to findVariable to
	prevent assignments into arguments.
	* lib/gst.y: Removed code to parse last statement as return -
	not needed since Smalltalk code implements evaluate:
	* lib/lex.c: Modified to have a variable indicating the name of
	the log file.
	* lib/lib.c: Changed -v to exit after the output, like
	--version. Added -l and -L to log to a file. Added
	long options.
	* lib/sym.c: Modified findVariable and localVarIndex so that
	assignments to arguments are detected.

Mon Jan 25 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.inl: Spiffed it up with a few register clauses.
	Also removed modulus operator (%) when possible.
	This increased performance (especially in message
	sends) only by 5%, but it was so easy I could not
	but do it!

Sun Jan 24 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/alloc.c: Added this banner.
	* lib/alloc.h: created.
	* lib/lex.c: Fixed lineStamp() so that the format is consistent
	with GCC and other GNU programs: for example,
	"Integer.st:115: parse error")

Fri Jan 22 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: Moved SIG_ARG_TYPE from sysdep.c here.  Added paranoic
	checking of memset arguments when bzero is used.
	* lib/interp.c: Moved SIG_ARG_TYPE to gst.h
	* lib/sysdep.c: Moved SIG_ARG_TYPE to gst.h

Mon Jan 18 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.inl: Fixed bug in large integers.  I was not considering
	that the product of the low-order 15 bits could exceed 15 bits!

Sat Jan 16 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.h: Added byteStreamClass.
	* lib/interp.c: Yesterday I removed maxSize instance variable from
	WriteStream, so I had to remove it from the FileStream
	struct, either.
	* lib/lib.c: Added ByteStream.st.
	* lib/save.c: Added byteStreamClass.

Fri Jan 15 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Removed maxSize instance variable from WriteStream.
	Fixed missing isPipe parameter in addSTDIOObject.
	Added ByteStream.  Added CShortSize global.

Wed Jan 13 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: Added getArgc and getArgv
	* lib/lib.c: Added ability to get argc/argv from Smalltalk code.
	* lib/sysdep.c: Fixed a small & invisible error, a 'start of comment'
	misplaced for a 'end of comment' (note by Paolo Bonzini  (bonzini@gnu.org):
	congratulations for your sharp eye!!)

Mon Jan 11 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Yeah! Removed bitfields from InstanceSpec!!
	* lib/dict.h: Yeah! Removed bitfields from InstanceSpec!!
	* lib/dict.inl: Yeah! Removed bitfields from InstanceSpec!!
	* lib/gst.h: Yeah! Removed bitfields from InstanceSpec!!
	* lib/prims.inl: Yeah! Removed bitfields from InstanceSpec!!

Sun Jan 10 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Good!!  First change in 1999!!  Optimized out send to
	super.  I renamed sendMessage to sendMessageInternal
	and created two macros (sendMessage and sendToSuper)
	in interp.inl
	* lib/interp.h: Good!!  First change in 1999!!  Optimized out send to
	super.  I renamed sendMessage to sendMessageInternal
	and created two macros (sendMessage and sendToSuper)
	in interp.inl
	* lib/interp.inl: Good!!  First change in 1999!!  Optimized out send to
	super.  I renamed sendMessage to sendMessageInternal
	in interp.c and created two macros (sendMessage and
	sendToSuper) here.

Wed Dec  9 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: Added my_stat for portability
	* lib/oop.c: Moved the code to nil out weak references *before*
	sweeping is done.  This is needed so that finalize
	methods which refer to weak objects already see nils.

Thu Dec  3 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/prims.inl: added ability to create subclasses of CompiledMethod
	(for now, cannot add instance variables)

Sat Nov 28 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/comp.c: The method cache was not properly updated:
	test 1 to: 5 do: [ :i | Object compile: 'foo ^',
	i printString. (nil foo) printNl] now I'm using
	invalidateMethodCache instead of updateMethodCache
	(see interp.c).
	* lib/interp.c: fix: since updateMethodCache did not always work
	I replaced it with invalidateMethodCache, which
	is not as gentle but works (anyway compiles are
	not so frequent and it takes nothing to rebuild a
	good cache).  Also, thisContext's ip and sp (in
	sendMessage and sendBlockValue) are now updated
	*after* thisContextOOP is set to the newly created
	context.  The previous implementation caused mess if
	allocFakeContext() triggered a GC.

Fri Nov 27 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Added the Table class variable to Character.
	* lib/gst.h: Added finalization.
	* lib/oop.c: Added finalization.  Also added lastUsedOOP which
	is used to shorten the loops on the OOP table at GC
	time It was needed because the OOP table was scanned
	three times: once to mark dependents of finalizable
	objects, once to reverse pointers (prepareForSweep),
	once to scan for objects to be finalized.  Now the
	whole GC is on average 50% faster than it used to be
	BEFORE having to add all these cycles.
	* lib/oop.inl: created
	* lib/prims.inl: added finalization primitives 256-257
	* lib/sym.c: Added finalizeSymbol.
	* lib/sym.h: Added finalizeSymbol

Thu Nov 26 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.inl: created

Wed Nov 25 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Moved many routines to dict.inl for speed.  Changed
	BlockClosure to a byte-subclass to save eight bytes.
	* lib/dict.h: Moved most things to gst.h, added dict.inl
	* lib/dict.inl: created
	* lib/interp.c: Added primitive 104 (String hash function), inlined
	many things around.
	* lib/oop.c: Changed the way the marking system works.  Instead of
	two entry points (markAnOOP and markOOPRange) both
	relying on markAnOOPInternal and passing parameters
	to it through the copy stack, I have two macros
	(maybeMarkOOP and markOOPRange) which pass parameters
	to markAnOOPInternal through function arguments.
	markAnOOPInternal does its job calling itself
	recursively, doing everything on the stack without
	expensive mallocs.  This makes the code neater, since
	the whole marking system resides in a single function.
	* lib/prims.inl: created from interp.c
	* lib/sym.c: Modified hashString to be more effective.

Tue Nov 24 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/lib.c: Added ContextPart.st, changed to try loading .stinit
	and .stpre from the current directory if the HOME
	environment variable is not found (fix for Win32).

Wed Nov 11 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Fixed bug in asObject primitive.  Was erroneously
	using oopAt(arg1-1) instead of oopAt(arg1).

Tue Nov 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/lex.c: Fixed so that _ *inside* an identifier is OK.

Sun Nov  8 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/byte.c: Added notNilSymbol and isNilSymbol.
	* lib/byte.h: Added notNilSymbol and isNilSymbol
	* lib/interp.c: Fixed bugs in returnWithValue (they had been there
	since 18 Oct...): contexts were returned to the free
	fake list even if they were not fake anymore (which
	happened if you did a snapshot).  Sooner or later, a
	normal object contended the same heap space with these
	contexts, wreaking havoc on the image. Also turned
	noParentContext to a macro and added notNil/isNil as
	bytecodes 206 and 207; these are optimized out to gain
	speed in some operations (e.g. Sets and Dictionaries).
	* lib/save.c: Added notNilSymbol and isNilSymbol
	* lib/sym.c: Added notNilSymbol and isNilSymbol.
	* lib/sym.h: Added notNilSymbol and isNilSymbol

Sun Nov  1 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/callin.c: Added vmsgSend.  Moved mstMalloc and mstGetCData here.

Mon Oct 26 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gstpub.h: Added vmsgSend.

Sun Oct 18 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Changed fake OOPs so that they have entries in the
	real OOP table.  This allows me to never realize
	the fake contexts unless a snapshot is being done.
	Less GC = more speed!!
	* lib/oop.c: Fake OOPs are now in the main OOP table.  Changed
	setOOPObject to a macro for SPEED!!
	* lib/oop.h: Added freeOOP(), realizeAllOOPs()

Fri Oct 16 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/cint.c: Added stringOut return type (frees string)

Thu Oct 15 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Added type 9 for CObjects and Memory (smalltalk OOP)

Mon Oct 12 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Added BlockClosure.  Changed BlockContext to reflect
	new architecture.  Changed Float to a variable
	byte class.
	* lib/interp.c: Added support for blocks as closures (partly I wrote
	it, part I stole it from Steve Byrne  (sbb@gnu.org)'s never made public
	1.1.6 version).  Started adding support for fake
	block contexts (see 1   Jan  91)

Sat Oct 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Added support for read-only objects (prims 233-234)

Sat Sep 26 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Fixed allocCObject.  Added IdentitySet.

Fri Sep 25 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Added a few register clauses.  Also changed
	implementation of "send ==" so it doesn't actually do
	the message sends, since == should not be overridden.
	* lib/lib.c: Added ValueAdapt.st, File.st, Directory.st,
	IdentitySet.st
	* lib/oop.c: Added a free list to OOP table.  This yielded, in
	general, good performance boosts, up to ten-fold for
	snippets that heavily allocate objects!! (on average,
	the number of bytecodes per second doubled)
	* lib/oop.h: Added refreshOOPFreeList(), to be used by save.c

Fri Sep 18 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/gst.h: Started adding support for read-only objects.
	* lib/interp.c: Removed last vestiges of previous garbage
	collectors. Removing loops that were not optimized
	out by compilers caused a 30% performance increase
	(not joking!).  Y2K change...  Time>>secondClock was
	about to overflow.  Also fixed sendBlockValue to
	check argument count.
	* lib/oop.c: Removed all vestiges of previous GC algorithms.
	This was a pity because it was really instructive
	but I was not able to read anything before ;-).
	* lib/oop.h: Fixed incubator bug (incAddOOP not in braces),
	removed maybeMoveOOP and localMaybeMoveOOP.

Thu Sep 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Added LargeIntegers and Fractions.  Tried to make
	nilFill faster.
	* lib/lib.c: Added LargeInteger.st, removed changes.st since its
	changes are incorporated in Fraction.st

Wed Sep  9 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Started adding support for LargeIntegers!!!

Mon Sep  7 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: Added Behavior>>#flushCache (primitive 89,
	as in the Blue Book).  Added bounds checking to	spaceGrowRate:
	(between 0 and 500)

Sun Sep  6 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/interp.c: FileStream>>nextPutAll: primitive was giving access
	violations (!) if Integers were passed... definitely
	too greedy!  I've updated the Smalltalk code too, so
	that it handles the case, but anyway now the primitive
	fails.  On 3   Sep  98 I had broken Floats; fixed.

Thu Sep  3 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* lib/dict.c: Added extensions to Date, modified Collection and
	SequenceableCollection so they are not indexable.
	Removed LookupKey.
	* lib/interp.c: Switched to openFile; corrected bug in floating point
	arithmetic primitives which never failed.  basicPrint
	doesn't output new-line.  Also corrected so that,
	when aborting execution, dead contexts are ignored
	and don't cause "Block returning to non-existent
	method context" errors.
	* lib/lib.c: Modified to use openFile, added a few loaded modules.

Wed Sep  2 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	*** Began development of version 1.6
	* lib/save.c: Switched to using openFile to open files
	* lib/sysdep.c: Added openFile, support for Cygnus Win32 added. A
	note on this is important.  Reluctantly I used Win32
	functions here and there.  I was not happy about that,
	but since it's the only way to do some things in
	an environment that does not fully comply to POSIX,
	I had to.

Sat Dec 16 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/comp.c: Changed name to blockCopyColonTemporariesColonSymbol.
	* lib/sym.c: Changed name to blockCopyColonTemporariesColonSymbol.
	* lib/sym.h: Changed name to blockCopyColonTemporariesColonSymbol.

Sat Nov  4 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/oop.c: Fixed allocObj to have what I think is the *right*
	algorithm -- simple, grows when needed.

Thu Nov  2 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/oop.c: Fixed allocObj to properly grow when not enough
	space is required, and to terminate if the allocation
	cannot succeed.

Sun Oct 15 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/byte.h: Added pushOuterTempVariable and storeOuterTempVariable
	byte codes.
	* lib/sym.c: Converted to the new architecture; introduced the
	notion of scopes.
	* lib/sym.h: Converted to new architecture; introduced the notion
	of scopes.

Sat Oct 14 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/gst.y: Began adding block temporary syntax.
	* lib/tree.c: Added support for block node type for new
	architecture.
	* lib/tree.h: Added block node type for new architecture support.

Thu Sep 30 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	*** Version 1.1.5 released.

Thu Sep 16 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/interp.c: Moved lots of system dependent functions out to
	sysdep.
	* lib/sysdep.h: Added openPipe, closePipe, getOpenFileSize.

Sun Sep 10 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/interp.c: Switched to fileIsReadable sysdep routine.
	* lib/lib.c: Added -g command line flag to suppress printing of
	GC messages.
	* lib/oop.c: Added GC torture test.  Heh heh heh!
	* lib/sym.c: Added incubator usage.
	* lib/sysdep.c: Added fileIsReadable, also setSignalHandler, and
	initSysdep.

Sat Sep  9 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/callin.c: Added incubator usage.
	* lib/cint.c: Added incubator support for created objects.
	* lib/cint.c: Removed Sun Windows hacks from the file.
	* lib/interp.c: Added code to use the object incubator support.
	* lib/interp.c: Experimentally tried to next jmp_bufs so enable proper
	handling of reentering the interpreter from C callout
	code and then calling out to more C code.

Fri Sep  8 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/dict.c: Added incubator support for newly created objects.

Thu Sep  7 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/comp.c: Added usage of OOP incubator.
	* lib/oop.c: Added incubator support.
	* lib/oop.h: Added incubator support.

Wed Aug 30 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/gst.h: Merged in Visual C++ changes.
	* lib/oop.c: Merged NT changes back in.  Code now contains some
	unnecessary casting and unrolled expressions (*=
	becomes = *) to shut the Visual C++ compiler's
	warnings off.

Sat Aug 26 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/comp.c: Merged Brad Diller's changes for dealing with parsing
	specially in the browser.
	* lib/dict.c: Added kernel and image file paths as Smalltalk
	accessible variables.
	* lib/lib.h: Added kernelFileDefaultPath and imageFileDefaultPath
	as exported symbols.
	* lib/sysdep.c: Fixed to have the __cursigmask definition be
	conditional on HAVE_SIGHOLD.

Sun Aug 20 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/oop.c: Added growMemoryTo(); it's a variant of growTo which
	does not involve the garbage collector.
	* lib/oop.c: Fixed alignSize to not double align (we don't
	preserve that property during GC anymore anyway,
	and the floating point accessing functions in dict.c
	which were the initial reason for having it are now
	sensitive to whether aligned access to doubles is
	required by the hardware or not.
	* lib/oop.h: Added growMemoryTo().
	* lib/save.c: Switched to using growMemoryTo in loadFromFile so
	that if the saved image space is larger than the
	normal memory space, the space is grown to fit.

Wed Jul 26 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/cint.c: Fixed the makeDescriptor function to issue an error if
	it cannot find a named C function.  Already located
	some bugs in UnixStream.st which have been there
	since it's inception.

Sun Jul 23 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/comp.c: Removed apostrophes in comments -- OS/2 doesnt
	like them.  (Incredible!)
	* lib/dict.c: Added CIntSize so that C struct can understand
	int size.
	* lib/gst.h: Removed mstconfig.h!!! Code is now not conditional
	on the presence of config.h.
	* lib/interp.c: Merged in OS/2 diffs, and removed apostrophes from
	preprocessed-out code (OS/2's preprocessor doesn't
	understand backslash quoting.
	* lib/oop.c: Fixed #ifdefed out code to not have apostrophes
	(OS/2 doesn't understand).
	* lib/save.c: Removed extra stdio.h include

Thu Jul 13 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/comp.c: Removed HAVE_ALLOCA_H.
	* lib/save.c: Removed HAVE_ALLOCA_H include of alloca.h (done in
	gst.h now).
	* lib/sym.c: Removed HAVE_ALLOCA_H.

Tue Jul 11 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/cint.c: Added John Stanhope (jehu@vt.edu)'s changes for
	Objective-C calling (Thanks John!!!)
	* lib/gstpub.h: Added defineCFunc.
	* lib/save.c: Added John Stanhope (jehu@vt.edu)'s changes for
	Objective-C calling (Thanks John!!!)
	* lib/sym.c: Added John Stanhope (jehu@vt.edu)'s changes for
	Objective-C calling (Thanks John!!!)
	* lib/sym.h: Added John Stanhope (jehu@vt.edu)'s changes for
	Objective-C calling (Thanks John!!!)

Sun Jul  9 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/byte.c: Fixed to include proper headers.
	* lib/callin.c: Fixed to include correct header files.
	* lib/comp.c: Fixed to include proper headers and have explicit
	declarations.
	* lib/dict.c: Fixed to explictly declare functions and include
	proper files.
	* lib/interp.c: Fixed to have explicit function declarations and
	correct include files.
	* lib/lex.c: Fixed to include proper headers and have functions
	declared explictly.
	* lib/oop.h: Added lots of new externs.
	* lib/save.c: Fixed to have proper inclues and explicit function
	declarations.
	* lib/tree.c: Fixed to include correct files.

Sat Jul  8 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/lib.c: Fixed a bunch of declarations and includes so that
	functions are now explictly declared always.

Thu Jun 29 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/sym.c: Fixed pool dictionary allocation to not allocate a
	large number of immediately thrown away arrays.

Mon Jun 26 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/gst.h: Switched EMPTY_BYTES to be 8 byte into the word
	instead of the low bytes to make the low bytes unused
	for use with the mark/sweep GC.

Fri Jun 23 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/cint.h: switched guard prefix to GST
	* lib/comp.h: Switched to GST guard prefix
	* lib/dict.h: switched to GST guard prefix
	* lib/gst.h: Switched to GST header guard.
	* lib/gstpaths.h: Switched to GST header guard prefix.
	* lib/gstpub.h: Switched to GST header guard prefix.
	* lib/id.h: Switched to GST header guard prefix.
	* lib/interp.h: Switched to GST header guard prefix.
	* lib/lex.h: Switched to GST header guard prefix.
	* lib/lib.h: Switched to GST header guard prefix.
	* lib/oop.h: Switched to GST header guard prefix.
	* lib/save.h: Switched to GST header guard prefix.
	* lib/str.h: Switched to GST header guard prefix.
	* lib/sym.h: Switched to GST header guard prefix.
	* lib/sysdep.h: Switched to GST header guard prefix.
	* lib/tree.h: Switched to GST header guard prefix.

Thu Jun 15 12:34:56 1995  Brad Diller

	* lib/comp.c: Modified executeStatements() to
	support browser expression evaluation.  Added
	getByteCodeForSpecialSelector() to support some
	browser operations.
	* lib/comp.c: Store in memory the source code derived from .st
	files loaded outside the kernel directory.
	* lib/comp.h: Added getByteCodeForSpecialSelector() to support some
	browser operations.
	* lib/lex.c: Added isKernelFile() and getMethodSourceFromCurFile().
	These routines were provided to solve certain data
	integrity problem caused by accessing the source code
	indirectly from saved file information.
	* lib/lex.h: Added isKernelFile() and getMethodSourceFromCurFile().

Fri Jun  9 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/oop.c: Began switching to compacting mark & sweep gc.
	* lib/oop.h: Began the conversion to single GC space.

Tue Jun  6 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/byte.c: Switched to new file naming scheme.
	* lib/callin.c: Switched to new file naming scheme.
	* lib/cfuncs.c: Switched to new file naming scheme.
	* lib/cint.c: Switched to new file naming scheme.
	* lib/comp.c: Switched to new naming scheme.
	* lib/comp.h: Switched to new file naming scheme.
	* lib/dict.c: Switched to new file naming scheme.
	* lib/gstpub.h: Switched to new file naming scheme.
	* lib/id.c: Switched to new file naming scheme.
	* lib/interp.c: Switched to new file naming scheme.
	* lib/lex.c: Switched to new file naming scheme.
	* lib/lib.c: Switched to new naming scheme.
	* lib/lib.h: Switched to new file naming scheme.
	* lib/oop.c: Switched to new file naming scheme.
	* lib/save.c: Switched to new file naming scheme.
	* lib/str.c: Switched to new file naming scheme.
	* lib/sym.c: Switched to new file naming scheme.
	* lib/sysdep.c: Switched to new file naming scheme.
	* lib/tree.c: Switched to new file naming scheme.

Mon Jun  5 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstpub.h: Merged in Brad Diller's changes.

Wed May 31 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstcint.c: Fixed cFuncInfo to grow dynamically.
	* lib/mst.h: Boolean replaced with mst_Boolean, objectClass =>
	mst_objectClass, Object => mst_Object.  This thanks
	to the foresightful guys at the X consortium.
	Thanks guys for wantonly chewing up name space.
	* lib/mst.h: Removed the old sysVersionMajor etc definitions --
	they are now defined in configure.in.

Tue May 30 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstcomp.c: Replaced objectClass with mst_objectClass.  Boolean =>
	mst_Boolean.
	* lib/mstcomp.h: Boolean switched to mst_Boolean.
	* lib/mstdict.c: Replaced objectClass with mst_objectClass to avoid
	conflicts with X (grrr!).  Boolean replaced with
	mst_Boolean.  Object replaced with mst_Object.
	* lib/mstdict.h: Replaced objectClass with mst_objectClass to avoid
	conflicts with X.  Boolean => mst_Boolean. Object =>
	mst_Object.
	* lib/mstinterp.c: Replaced objectClass with mst_objectClass.  Boolean =>
	mst_Boolean.
	* lib/mstinterp.h: Boolean => mst_Boolean.
	* lib/mstlex.c: Boolean => mst_Boolean.
	* lib/mstlex.h: Boolean => mst_Boolean (darn X!).
	* lib/mstlib.c: Boolean => mst_Boolean.
	* lib/mstlib.h: Boolean renamed to mst_Boolean.
	* lib/mstoop.c: Boolean => mst_Boolean.
	* lib/mstoop.h: Boolean => mst_Boolean.  Object => mst_Object.
	* lib/mstsave.c: Boolean => mst_Boolean.  Object => mst_Object.
	* lib/mstsave.h: Boolean => mst_Boolean.
	* lib/mstsym.c: Boolean => mst_Boolean.
	* lib/msttree.h: Boolean => mst_Boolean.

Sun May 28 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Finally hacked floatNew to deal properly on
	architectures where double alignment requirements
	are different from those of long.
	* lib/mstsysdep.c: Added getdtablesize for those systems such as HP
	which do not have this useful function.
	* lib/mstsysdep.c: Fixed getCurDirName to selectively use getwd or getcwd
	depending on what is supported.

Mon May 15 12:34:56 1995  Brad Diller

	* lib/mstinterp.c: Added primitives 256-264 to support expression
	evaluation and other functions for the class browser.

Sun May  7 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Added more machine specific datatype constants (size
	and alignment).
	* lib/msttree.h: removed trailing comma from NodeType enum literals
	list -- some compilers are picky.

Sat Apr 29 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Added CDoubleAlignment as a 'global' value for the
	required alignment of C type 'double'.
	* lib/mstlib.c: Moved CType to after CObject in the load order to
	better reflect the type (and symbol definition)
	dependencies.

Fri Mar 31 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstcomp.c: Compiler now uses the initEmptyBytes macro to set
	the empty bytes of the byte code length of a method.
	* lib/mst.h: Adjusted EMPTY_BYTES related constants to vary with
	hardware architecture.
	* lib/mstinterp.c: Fixed branching backward to use signed arithmetic it
	was doing the computation as unsigned ints without
	sign extension when it was added ot a 64 bit pointer.
	* lib/mstoop.c: Added fflush(stdout) to some debugging funcs
	* lib/mstsym.c: Adjusted a reference to the empty bytes to use the
	new, architecture independent macro definitions.

Sun Mar 19 12:34:56 1995  Brad Diller

	* lib/mstcint.c: Conditionally enable GC of Smalltalk objects
	referenced in callouts.

Wed Mar 15 12:34:56 1995  Brad Diller

	* lib/mstdict.c: added mstMalloc mstGetCData.

Wed Mar  1 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstcomp.c: Fixed makeConstantOOP to handle NIL which is passed
	in from empty array literals.

Sat Jan 21 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstlex.c: Some changes for architectural independence (64 bit).

Fri Jan 20 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.h: Added 64 bit support.
	* lib/mst.h: More changes for DEC Alpha 64bit architecture.
	* lib/mstinterp.c: Adjusted for DEC Alpha 64bit architecture.
	* lib/mstinterp.h: Added padding for 64bit architectures.

Sat Jan 14 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* cxtnsn/dld.c: Changed the name from DLD to USE_DLD to avoid
	conflicts with symbols defined by the DLD package in the future.

Thu Jan  5 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Fixed a bug when copying a fake method context
	(ip wasn't being updated, and so was pointing to
	dead storage).

Mon Jan  2 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Fixed CType to use the new type model.
	* lib/mstdict.h: Switched to the new CType model.
	* lib/mstinterp.c: Removed primitives 147 & 148 -- they were obsolete
	anyway, and now with the new CType model they no
	longer function.

Sat Dec  3 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Added code stubs for asCData: primitives.

Wed Nov 16 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Finally tracked down some problems with prims 183-185
	-- they were using the wrong variable to access the
	contents of the cobject, and it was just luck that
	it worked on Linux.

Sat Oct  8 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstcomp.c: Fixed some bugs related to getting a GC during
	compilation (literals during compilation are part of
	the root set, etc.).
	* lib/mstinterp.c: Added SystemDictionary>>growTo: and moved a few
	builtins around.
	* lib/mstsym.c: Fixed the internCountedString bug by deferring OOP
	allocation until all instances have ben allocated.

Sun Oct  2 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstoop.c: Made sure to turn off the free bit in moveOOP (no
	sense in moving an object that's freed, and moveOOP
	will not be called on a truly freed object; this
	change "repairs the damage" in cases where there is
	an accidental freeing occurring.
	* lib/mstsym.c: Fixed a bug in internCountedString that occurs other
	places where there is the possibility of doing a
	garbage collection just after a newly allocated object
	which has not been added to a root-set-reachable
	object.  The GC sees that there are no references
	to the new object, and marks its oop free and does
	not copy the just allocated object into the new
	current semispace.  This problem can occur anywhere
	these conditions occur.  Given that allocOOP moves the
	object to the current space if it's not already there,
	for this case to really occur, you have to have done
	the allocOOP before you call the second instantiate
	or other allocation primitive.

Tue Sep 20 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Added empty statement to the tail of a case statement.

Thu Sep 15 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	*** Version 1.2.alpha1 released.

Sun Sep  4 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstcomp.c: Fixed some of the printing at the end of
	executeStatements to avoid dividing by zero.
	* lib/mstdict.c: switched out last bzero call.
	* lib/mst.h: More changes -- removed some old bcopy macro
	definitions, and switched more towards the autoconf
	based implementation.

Sat Sep  3 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/cfuncs.c: Created.
	* lib/cfuncs.c: This is the first file in the distribution to not
	start with "mst".  This is the precursor to having
	short file names so that primitive operating systems
	can deal with an advanced system like Smalltalk :-) :-) :-).
	* lib/mstcint.c: Factored out initUserCFuncs to enable easier extension
	by developers.
	* lib/mstcint.c: Yanked out DLD -- it's now in the parent directory.
	* lib/mst.h: Switched double size out, switched to use RETSIGTYPE,
	and WORDS_BIGENDIAN.
	* lib/mst.h: Switched to having version defines coming from the
	config.h file, and added the edit prefix string.

Wed Aug 31 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mst.h: Began switching to autoconf based approach.

Wed Aug 24 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mst.h: Added symbolic constants for max and min integer
	values representable in a Smalltalk Integer object.
	* lib/mstinterp.c: Fixed Float>>truncated to do range checking and fail
	if converting a number that is outside the range
	of integers.

Sun Aug 21 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstcomp.h: Switched to using low bit int marking.
	* lib/mstdict.h: switched to low order bit for int flagging.
	* lib/mst.h: Switched to low order bit for int flagging.

Sun Jul 10 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstlex.c: Reinstated the use of changes (it was dyked out)
	as an optional mechanism.

Sat Jul  9 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Fixed findKey to check all elements even when the
	dictionary is full.  Previously it would check all but
	the last one, which caused some bizarre compilation
	behavior (the last class declared didn't seem to be
	there as far as the compiler was concerned).

Wed Jun 22 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstcint.c: Added support for cObjectPtr type, to allow for
	passing CObject parameters by reference.  It is up
	to the client to ensure that the passed CObject type
	corresponds to the desired C datatype.

Mon Jun 20 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstcint.c: Fixed stringInfo to be local to the call stack,
	instead of using a static, to allow recursive
	invocations.

Sat Jun 11 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Added new-style CObject accessors functions, currently
	in the range 182 -- 189.
	* lib/mstsym.c: Added cObjectPtrSymbol for new call by value parameter
	passing mode.
	* lib/mstsym.h: Added cObjectPtrSymbol.

Sat Apr 30 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Added CPtr incrBy:

Sat Mar 19 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* lib/mstcallin.c: Added %t and %T for more direct control over
	types. Also, added typeNameToOOP for mapping string
	type names to actual CType subclass instances.

Sat Oct 16 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.h: Changed to have 9 priority levels, as part of the
	fix for ProcessorScheduler>>yield.

Sun Oct 10 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* lib/mstinterp.c: Doing some experimental hacks on the process system
	to try to recover from the case where there are no
	runnable processes.
	* lib/mstinterp.h: Fixed definition of initProcessSystem.

Sun Apr  4 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: made printAssociationKey more bullet-proof when passed
	a non-association.

Sun Nov 22 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Added isPipe member to FileStream.
	* lib/mstinterp.c: Fixed FileStream to have a buffer instance variable,
	and added knowledge of whether the file stream was
	a regular file or a pipe, so FileStream>>close could
	do the right thing.

Sat Jul 18 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: added byteArrayNew.
	* lib/mstdict.c: added countedStringNew.

Thu Jul 16 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: added freeCObject.

Mon May 25 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* lib/mstdict.c: Added support for Emacs caching class names.
	* lib/mstinterp.c: Made system interruptable when non-interactive
	(interrupts work, that is).

Sun Feb 23 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* lib/mstcint.c: Added support for reading and writing scalar types.

Wed Jan  1 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* lib/mstcallin.c: Fixed to auto-initialize Smalltalk when the public
	routines are invoked.
	* lib/mstpub.h: Created.
	* lib/mstlib.c: Converted to be callable as a library.
	* lib/mstlib.h: Renamed from mstmain.h
	* main.c: Created from old mstmain.c (now mstlib.c)

Tue Dec 31 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstcallin.c: Created.
	* mstcallin.h: Created.
	* mstlex.c: Began adding support for having a changes file and
	pointing methods to that instead of the actual source
	file (which can get out of sync, and cause recompiles
	to lose).
	* mstoop.c: Added registered oops to root set.
	* mstoop.c: oopTable now allocated from memory instead of being
	stored as part of the executable.

Sun Dec 29 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Added support for readline's conditional .inputrc
	definitions, keyed off of "Smalltalk".

Sun Dec 22 12:34:56 1991  P. Lecoanet

	* mstbyte.c: Fixed byteCodeLength failing to return 0

Sun Dec  8 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Changed oopValid to only check the FREE bit, instead
	of worrying about the even odd flags, which may not
	be valid.

Fri Nov 29 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Added fileNameOOP to hold full path name for files,
	so that all methods share the same file name string.
	Also, adjusted getCurFileName to return the full
	path name.

Thu Nov 28 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added SystemDictionary byteCodeCounter primitive.
	* mstsysdep.c: Added getCurDirName() for allowing compiler to record
	the full file name that is used.

Sun Nov 24 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.h: Context size increased to 64 (still not enough),
	to prevent inadvertent stomping of memory past the
	end of the stack.

Sat Nov  9 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Fixed new: to indicate failure when failure occurs.

Sat Nov  2 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Altered the logic in the primitive replace from code
	-- I don't think it was really wrong, but it wasn't
	as clear as it might have been.
	* mstinterp.c: Fixed instVarAt: to obey real stack conventions
	(was pushing instead of setting the stack top).

Sun Oct 20 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added support for user level control of memory space
	growth rate parameters.
	* mstoop.c: Support for growing now fully operational (and no,
	it hasn't taken me over a month to track down the
	problems; free time has been nil).  Also removed more
	vestiges of the incremental GC.

Sun Sep 15 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Fixed dictionaryAssociationAt: to not loop when the
	dictionary is full.  Thanks to Michael Richardson
	for the fix!
	* mstinterp.c: Added quitPrimitive: to allow for non-zero exit
	statuses.
	* mstoop.c: Added support for loading larger semispaces from
	saved images.

Sat Sep 14 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Switched to global version string.
	* mst.h: Added edit version support.
	* mstinterp.h: Increased number of literals to 256, number of
	temporaries to 64, and number of allowable primitives
	to 1024 (overkill?)
	* mstmain.c: Added edit version support.
	* mstmain.h: Added edit version support.
	* mstsave.c: Added support for edit version.

Thu Sep 12 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstmain.c: Fixed -I argument parsing code to properly gobble up
	the file name.

Sun Aug  4 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Removed more vestiges of the incremental GC, began
	switchover to automatically growing semi-spaces.

Fri Jul 19 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstcint.c: Started adding support for the DLD package.
	* mstmain.c: Started adding conditional support for the DLD
	package.

Sat Jul  6 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: added newString (create uninitialized string of a
	given length).

Fri Jul  5 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added primitive 248: `FileStream fileInLine: lineNum
	fileName: aString at: charPosInt'; this helps improve
	things for the emacs interface by making recorded
	information accurate, and making error locations also
	be accurate.
	* mstinterp.c: Added support for primitive 105, which is the basic
	fast support for doing replacement within strings.
	* mstlex.c: Added setStreamInfo so that stuff filed in from Emacs
	can have more accurate information such as the line
	number in the buffer instead of the line number in
	the temporary file.

Tue Jul  2 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Fixed handling of jump true and jump false opcodes:
	they now issue an error if invoked with non trueOOP
	or falseOOP.

Fri Apr 19 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Added skipCompilation boolean, for conditional
	compilation.
	* mstinterp.c: Added primitive to support conditional compilation.

Sat Apr 13 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Added Features global variable.  This allows for
	conditional execution based on operating system or
	machine architecture, and at some point, conditional
	compilation.

Mon Mar 25 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Added -> operator.

Sun Mar 24 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Float's class definition said that it was not
	pointers, not words, and not indexable.  When new
	instances were created, they were 2 BYTES large,
	instead of 2 words.  Changed to have the words flag
	* mstlex.c: Fixed lexing of foo:= to be seen as foo :=.
	* mstmain.c: Added loading of changes.st

Sat Mar 23 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Fixed a bug with process switching: you can't depend
	on objects gotten with oopToObj after a prepareToStore
	into the parent object: it may have moved, and you're
	storing into dead storage.
	* mstinterp.c: Improved speed another 50% by "inlining" many of the
	special selectors that the compiler uses.

Sun Mar 17 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added support for C-style interrupts (signals) and
	timed interrupts to help with time slicing.

Sat Feb 16 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Recursive calls to equalConstant had the arguments
	reversed.

Sun Jan 27 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Modified the definition of the inline-controlling
	macro so that inlining is always selected when compiling for
	debugging.
	* mstoop.h: Force ACCESSOR_DEBUGGING off when optimizing.

Tue Jan 22 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstcint.c: Added putenv().

Sat Jan  5 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Converted executePrimitiveOperation to do returns as
	soon as possible, to not use the failed variable,
	and to not do double switching on int and float
	operations.  This simple change increased performance
	from ~130K bytecodes/sec (SS1+ optim) to > 200k
	bytecodes/sec (simple code, builtins and primitives
	only, no real method invocation).
	* mstsysdep.c: Added getMilliTime().

Tue Jan  1 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Switched to not creating MethodContexts always...just
	use a cache of pre-made fake method contexts and only
	create real method contexts when someone will get a
	reference to one of the method contexts.

Mon Nov 26 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Fixed whileTrue: and whileFalse: to loop only if the
	value returned by the receiver is the expected one,
	instead of if it's the boolean not of the expected
	value.

Sat Nov 24 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstmain.c: Fixed to set quietExecution using || instead of |
	(HP doesn't like it otherwise).

Sat Nov 17 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcint.c: Added support for UnixStream primitives.
	* mstmain.c: Added UnixStream and IOCtl to kernel files.

Sat Nov 10 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Added support for retaining the latest compiled method
	so the interpreter can return it from the compile:
	primitive.
	* mstcomp.h: Added latestCompiledMethod, so that some of the
	compile methods can get the method that they just
	compiled and set its category.

Tue Nov  6 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstmain.c: Added the per-user pre-image file...this may turn
	into a kind of site defaults thing, but this is what
	I've wanted for a while.

Sat Oct 13 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Converted to use bit masks instead of bit fields,
	hoping to improve performance somewhat.

Tue Oct  2 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstmain.c: Fixed okToLoadBinary so that it returns false if
	there is a Smalltalk file found locally, but there
	is no image file locally (the stix problem).
	* mstmain.h: findImageFile was changed to return Boolean.

Fri Sep 21 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Fixed so that a block that contains no statements
	properly returns nil.

Tue Aug 21 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added support for subtypes of CObject to provide
	direct access to C data.

Sat Aug 11 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcint.c: Added knowledge of byteArrayOut type.

Fri Aug  3 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Added allocCObject.
	* mstinterp.c: Added support for primitive C object allocation
	routine.

Tue May 22 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	*** Version 1.1.1 released (I think. I added this on May 10th, 1999... --- pb)
	* mstmain.c: Improved on Doug's mapping with macro to improve
	readability.
	* mstmain.c: Short name stuff added, thanks to Doug McCallum.

Sun May 20 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Improved error handling...compiler errors set a flag,
	and execution does not occur if the expression to be
	executed has compilation errors.
	* mstinterp.c: Improved error handling when error: or
	doesNotUnderstand: occurs.  Also, added ^C handling
	to abort execution.

Thu May 17 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstsysdep.c: Added enableInterrupts and disableInterrupts.
	System V.3 code signal support from Doug McCallum
	(thanks, Doug!).

Wed May 16 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Added usage of emacsProcess.
	* mstsym.c: Changed usages of "entry" to "ent" to prevent
	collisions with C compilers which have this identifier
	as a reserved word.
	* mstsysdep.c: Created.
	* mstsysdep.h: Created.

Tue Apr 24 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Improved error handling for fopen/popen primitives.
	* mstlex.c: Error checking for integers too large.

Sat Apr 21 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Added toByteArray.
	* mstsym.c: Addded byteArraySymbol.

Fri Apr 20 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstbyte.c: Added initByteCodes to fix a robustness issue with
	the compiler.
	* mstcomp.c: Fixed compiler to reset the byte code system before
	using it.  The problem was if an error occurred, the
	old byte code stream was still in use, and further
	compilations were losing in a big way.
	* mstinterp.c: Make fileIn not close the stream that it's reading
	from; this is taken care of by the caller, and causes
	very strange behavior if we try to close it twice!
	* mstlex.c: Added the closeIt argument to popStream so that the
	closing behavior could be separated from the popping
	behavior (in particular, for fileIn).

Tue Apr 17 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstsave.c: Fixing binary save to save only to the maximum used
	OOP slot, instead of saving the entire OOP table. This
	should improve load time and decrease disk storage
	requirements.

Sun Apr  8 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Changed oopFree to oopValid to fix the bug with
	someInstance losing after GC's due to objects that
	have non-free OOP table entries, but point to freed
	objects.
	* mstoop.h: Changed oopFree to oopValid to better reflect the
	semantics.

Sat Apr  7 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added declaration tracing primitive.
	* mstinterp.c: Fixed fileIn: to check for existence of the file
	before trying to open it.  Returns failure if the
	file cannot be accessed.
	* mstlex.c: Character lexing routines (such as nextChar) now
	return ints to get around problems on implementations
	that don't sign extend characters by default.
	* mstoop.c: Increased mem space size to 4M.  This can be decreased
	as necessary.

Sun Mar 25 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Changed cache hit ratio reporting to check for divide
	by zero, and to cast the byte counter to double
	(it was casting to float and relying on promotion).
	* mstinterp.c: Minor change for AtariSt: decrease size of ASYNC
	queue size.
	* mstmain.c: ProcessorScheduler is too long of a name for the
	Atari; there are uniqueness problems.  Shortened to
	ProcScheduler.  Also, fixed quietExecution; wasn't
	set when reading from the terminal; should have been
	set to false (since the loading of the quiet things
	is over).

Sat Feb 24 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Update to change log: there are no longer any
	explicitly allocated OOPs due to the new symbol table
	structure; the September 20th, 1989 comment below is now a noop.

Thu Feb 15 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Added support for := as alternative assignment
	operator.

Sun Feb 11 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstsave.c: Changed the header to record the size of the oop
	table, since trying to load back into a system with
	a different sized oop table loses bigtime.

Sat Jan 13 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Added support for "thisContext" as a compiler built-in
	variable.
	* mstsym.c: Added thisContextSymbol.
	* mstsym.h: Added thisContextSymbol.

Sun Jan  7 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Added more commentary to classes, added new global
	Smalltalk variable: Bigendian, which allows code to
	be conditional based on the architecture type.

Thu Dec 28 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Compiled methods now record their exact number of
	byte codes.  Previously, if the byte codes didn't
	exactly fill to a word-boundary, there was no way
	to distinguish that case.  Now, with the advent of
	dumping byte codes from within Smalltalk, this has
	become a necessity.

Wed Dec 27 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Realloc literal vec wasn't reallocing in units of
	sizeof(OOP), so after a while, the literal vector
	wasn't big enough.  Typically most methods don't have
	a lot of literals, so this was not a problem.

Tue Dec 19 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Added suport for primitive filein (for use with
	autoload -- "12 gauge autoloader", A. Swartzenegger,
	The Terminator)
	* mstsym.c: Rebuilt symbol table.  Used to use the main OOP table
	as a symbol table, due to issues involving initial
	bootstrapping of the system.  Now using open hash
	table built of arrays and linked lists, so that no
	special precautions need be taken by the GC system
	or the image save/restore facility.

Sun Oct 15 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstpaths.h: Created.
	* mstmain.c: Added support for creating an "installed" version
	of Smalltalk.  There is now an include file that the
	installer can customize for his site that provides
	default locations to be checked for the kernel .st
	files and the binary image file, but these can be
	overidden in two ways: a) by a file of the same name
	in the user's current directory, or b) environment
	variables SMALLTALK_KERNEL and SMALLTALK_IMAGE.

Mon Oct  2 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Fixed a bug with compilation of cascaded messages. see
	HACK ALERT in the file.

Sat Sep 23 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mst.h: Modifications to support operation on a DECstation 3100.

Thu Sep 21 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Made compilation of methods from strings record the
	source string.

Wed Sep 20 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Added oop table slot GC'ing.  I'm not dealing with oop
	table slots that are explictly allocated; I believe
	that most OOP slots are not explicitly chosen and so
	not running the incremental reclaimer for that case
	shouldn't hurt us.

Wed Sep 13 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Various changes for garbage collector.
	* mst.h: Sigh!!! modified pushOOP and setStackTop to move
	the objects that they refer to to toSpace...good
	bye performance!

Tue Sep 12 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: Much of the garbage collector's operation depends on
	the fact that only 1 flip will occur between any two
	operations (such as a compilation, or a byte-code).
	The code would be much more complex if this were not
	the case, and I'm not sure that things would even be
	possible if this were not the case.  Anyway, there
	is code in this routine to check for that eventuality
	and to halt the system if it occurs.

Thu Sep  7 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Started adding garbage collection support.

Wed Sep  6 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstoop.c: started implementing the garbage collector (YAY!!!)

Sun Sep  3 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: added getCurFileName
	* mstlex.h: added getCurFileName

Sat Sep  2 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Began adding support for the method descriptor
	instance variable.
	* mstcomp.h: Moved common compiled method structure definition
	here, so that the interpeter could share.
	* mstcomp.h: added descriptor support
	* mstinterp.c: Process primitives in and working...starting to switch
	to compiled methods with descriptor instance variable
	in addition to header.

Wed Aug 30 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Fixed a bug in parseIdent which was parsing foo:2 note
	no space) not as foo: and 2, but as a mixed up token.

Wed Aug  9 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Conversion completed.  Performance now 40k
	bytecodes/sec; was 43k bytecodes/sec.

Tue Jul 25 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstsym.c: Changed undeclareName to take a parameter that
	controls whether the frame index is decremented
	or not.  It appears that each block gets its own,
	non-shared temporaries/arguments, so that if the
	block is used in a process, other blocks won't have
	strange things happening to their arguments.

Tue Jul 18 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Began conversion from stack based method contexts and
	blocks to more traditional method contexts and blocks.
	This change was done 1) to make call in from C easier,
	2) to make processs possible (they could have been
	implemented using stack based contexts, but somewhat
	space-wastefully), and 3) to conform with the more
	traditional definition of method contexts and block
	contexts.

Sat Jul  8 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Added prompt when input is a terminal.  This should
	help Emacs's shell mode determine what has been typed
	as input to the system.

Tue Jul  4 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstmain.c: Added support for user init files (in ~/.stinit),
	which are invoked on every startup.  Also, added
	support for initBlocks, which are blocks that are
	stored in the system and invoked on each startup
	(these could be used, for example, as an interim
	measure for declaring C callouts until the callout
	descriptor is converted to a Smalltalk object).

Sun Jun  4 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcint.c: Added Smalltalk data conversion type.

Mon May 29 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcint.c: Created.
	* mstcint.h: Created.
	* mstdict.c: Added the memory classes.  Added the FileStream about
	a week ago.

Fri May 26 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: added method cache!  Why didn't I spend the 1/2
	hour sooner?

Sun May 14 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstlex.h: Created.

Sat Apr 29 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Author changed from single to married.

Wed Apr  5 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Restructured Class and Metaclass creation.  Is now
	table driven, and metaclasses are created containing
	the proper information.
	* mstsave.c: Modified to reflect change in classes: now their name
	is a Smalltalk string; before, it was a C string that
	had to be saved specially.

Wed Mar 29 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Removed MethodDictionary as a separate type; it is
	an IdentityDictionary.

Sat Mar 11 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Smalltalk is now an instance of SystemDictionary.

Fri Mar 10 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstmain.c: Added support for automatically loading image file
	if it's newer than and of the system source files.

Sat Mar  4 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstmain.h: Created.
	* mstsave.c: Created.
	* mstsave.h: Created.

Tue Jan 24 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstlex.c: Added 2 chars of push back, because 3. needs to look
	ahead one more character to see if its 3.DIGIT or
	3. next statement.

Fri Jan 13 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstdict.c: Created.
	* mstdict.h: Created.
	* mstoop.c: Created.
	* mstoop.h: Created.

Sat Jan  7 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstinterp.c: Created.
	* mstinterp.h: Created.

Thu Jan  5 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstsym.c: Created.

Mon Jan  2 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstbyte.h: Created.
	* mstcomp.c: I guess it should be stated somewhere: you'll notice
	in the code that there are several places where I
	could have taken a more "functional" (i.e. LISP
	oriented call a function within a function call)
	approach.  I chose not to because it can make
	debugging easier, it doesn't slow down the code much,
	and may help the reader to understand better what's
	going on in the code.

Sun Jan  1 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* mstcomp.c: Created.
	* mstcomp.h: Created.
	* mstsym.h: Created.

Fri Dec 30 12:34:56 1988  Steve Byrne  (sbb@gnu.org)

	* msttree.c: Created.
	* msttree.h: Created.

Thu Dec 29 12:34:56 1988  Steve Byrne  (sbb@gnu.org)

	* mst.h: Created.

Tue Dec 27 12:34:56 1988  Steve Byrne  (sbb@gnu.org)

	* mstbyte.c: created.
	* mstid.c: Created.
	* mstid.h: created.
	* mstlex.c: Created.
	* mstmain.c: Created.
	* mststr.c: created.
	* mststr.h: created.


