"======================================================================
|
|   Smalltalk GUI wrapper for menus
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Gui subclass:  #Menu
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'
!

!Menu class methodsFor: 'initializing'!

new: view label: title
    | aMenu |
    aMenu := Menu new.
    aMenu blox: (BMenu new: (view menuBar) label: title).
    ^aMenu
! !

!Menu methodsFor: 'initializing'!

selectors: selectorsArray receiver: receiver argument: arg
    | selectors |
    selectors := selectorsArray deepCopy.
    selectorsArray with: selectors do: [:item :changed |
	(item size >= 2 and: [(item at: 2) numArgs = 1])
	    ifTrue: [ changed at: 3 put: arg ]
    ].
    blox callback: receiver using: selectors.
! !


Menu subclass:  #PopupMenu
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'
!

!PopupMenu class methodsFor: 'initializing'!

new: view label: title
    | aMenu |
    aMenu := Menu new.
    aMenu blox: (BPopupMenu new: (view blox) label: title).
    ^aMenu.
! !


