@echo off

Rem Batch file to configure GNU cpio for DJGPP v2.
echo Configuring GNU cpio for DJGPP v2...

Rem Find out where our sources are
set XSRC=.
if not "%XSRC%" == "." Goto SmallEnv
if "%1" == "" Goto FoundSrc
set XSRC=%1
if not "%XSRC%" == "%1" Goto SmallEnv

:FoundSrc
Rem Make sure they have something similar to DJGPP port of Sed installed
echo Checking for working Sed...
sed -n -e 's,Rem ,Rem ,w foo.txt' %XSRC%/configdj.bat
if not exist foo.txt Goto NoSed
del foo.txt
echo config.status > config.status

Rem Do not do this in one pipe since XSRC might be long enough to
Rem overflow the 126-character limit of DOS command line
echo Creating Makefile...
echo # Generated automatically from Makefile.in by configdj.bat > Makefile.tmp
sed -e 's,@srcdir@,%XSRC%,g' %XSRC%/Makefile.in >> Makefile.tmp
sed -f %XSRC%/configdj.sed Makefile.tmp > Makefile
if exist Makefile.tmp del Makefile.tmp

Rem install-sh looks like install-info under 8+3 DOS namespace,
Rem and INSTALL looks like install because of case-insensitivity
Rem This will bite them if they say "make install" or "make install-info"
Rem because Make will think these targets are up to date.
if exist install ren INSTALL INSTALL.txt
if exist install-info ren install-sh install-sh.sh

Rem We are done
echo Done.
Goto Exit

:NoSed
echo You need GNU Sed to configure cpio for DJGPP.
Goto Exit

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.

:Exit
