.TH DVILJK 1 "10 June 1996"
.ad b
.SH NAME
dvilj4, dvilj4l, dvilj2p, dvilj \- convert a TeX DVI file to PCL, for HP LaserJet printers
.SH SYNOPSIS
\f3dvilj\f1
[\f3\-\-D\f2number\f1]
[\f3\-c\f2copies\f1]
[\f3\-d\f2mode\f1]
[\f3\-D\f1]
[\f3\-E\f1]
[\f3\-e\f2outputfile\f1]
[\f3\-f\f2frompage\f1]
[\f3\-g\f1]
[\f3\-h\f2headerfile\f1]
[\f3\-l\f1]
[\f3\-M\f2flag\f1]
[\f3\-m\f2mag\f1]
[\f3\-p\f2pages\f1]
[\f3\-q\f1]
[\f3\-r\f1]
[\f3\-t\f2topage\f1]
[\f3\-s\f2pagesize\f1]
[\f3\-v\f1]
[\f3\-w\f1]
[\f3\-x\f2xoff(mm)\f1]
[\f3\-y\f2yoff(mm)\f1]
[\f3\-X\f2xoff(dots)\f1]
[\f3\-Y\f2yoff(dots)\f1]
[\f3\-z\f1]
[\f3\-\f1]
[\f2filename\f1]
.SH DESCRIPTION
Dvilj and siblings convert TeX-output .dvi files into PCL (the
Hewlett-Packard Printer Control Language) commands suitable for printing
on a HP LaserJet+, HP LaserJet IIP (using dvilj2p), HP LaserJet 4 (using
dvilj4), and fully compatible printers.
.PP
Dvilj4 also provides support for the builtin Intellifont and TrueType
fonts; TFM and VF files are provided in the distribution.
Virtual fonts are not supported directly by Dvilj, so you must run
.BR dvicopy (1)
first, or otherwise expand the virtual fonts
.PP
All programs are generated from one source file dvi2xx.c.
They are usually called via a shell script or as a line printer
filter. One such script, dvihp, is included in the distribution. It
provides command-line options similar to those of dvips(1).
.SH OPTIONS
.TP \w'-Dnumber'u+2n
\f3--D\f2number\f1
Debug according to the bits of \f2number\f1; see the Kpathsea manual for
values. Also turns on general verbosity.
.TP
\f3-c\f2number\f1
print each page \f2number\f1 times (including original)
.TP
\f3-d\f2number\f1
print in duplex mode. The option -d\f21\f1 means long edge binding,
-d\f22\f1 stands for short edge binding. This option is only
selectable from \fIdvilj2p\fP, and is known to work on the LaserJet IId,
LaserJet IIId, and LaserJet 4.
.TP
\f3-D\f1[-]
Double-sided printing - see below; -D\f21\f1 prints odd sides only,
-D\f22\f1 is for even pages, a trailing \f2-\f1 suppresses printing of
empty padding pages.
.TP
\f3-E\f1
Switch printer into econo mode (dvilj4 only).
.TP
\f3-e\f2outfile\f1
Send output to \f2outfile\f1 instead of the basename of dvi file
extended with `.lj'.
If \f2outfile\f1 is `-' (as in `-e-') the output is directed
to standard output and can be directly piped into a spooler.
.TP
\f3-f\f2pagenum\f1
Print pages with TeX page numbers greater than or equal to \f2pagenum\f1.
.TP
\f3-g\f1
``go'' mode: do not reset printer at start of job.
.TP
\f3-h\f2headerfile\f1
Copy \f2headerfile\f1 to output before translation of the DVI file.
Used to send arbitrary commands to the laserprinter.
.TP
\f3-l\f1
print output in landscape mode; supported
only by dvilj2p and dvilj4.
.TP
\f3-M\f2flag\f1
Do (not) call MakeTeXPK to generate fonts on demand.  \f3-M\f21\f1 and
\f3-M\f1 are equivalent. \f3-M\f20\f1 enables invoking MakeTeXPK. (This
is the same as dvips.)  The default behavior (i.e., if no
\f3-M\f1 option is given) is chosen at compile-time; as distributed,
MakeTeXPK is enabled. \f3-M\f1 is only valid if
dvi2xx was compiled with support for MakeTeXPK.
.TP
\f3-m\f2magnification\f1
Specify the magnification to use. The following are available:
.br
\f3-m#\f2usermag\f1  e.g., \f3#900\f1
.br
\f3-m0\f1  equivalent to \f3-m#1000\f1
.br
\f3-mh\f1  equivalent to \f3-m#1095\f1
.br
\f3-m1\f1  equivalent to \f3-m#1200\f1
.br
\f3-mq\f1  equivalent to \f3-m#1250\f1
.br
\f3-m2\f1  equivalent to \f3-m#1440\f1
.br
\f3-m3\f1  equivalent to \f3-m#1728\f1
.br
\f3-m4\f1  equivalent to \f3-m#2074\f1
.br
\f3-m5\f1  equivalent to \f3-m#2488\f1
.TP
\f3-p\f2pagecount\f1
print \f2pagecount\f1 pages after the starting page.
.TP
\f3-q\f1
Quiet operation: omit final statistics, etc.
.TP
\f3-r\f1
toggle page reversal; by default, pages are reversed.
.TP
\f3-s\f2pagesize \f1
Specify the page size:
.br
\f3-s1\f1:  executive         (7.25in x 10.5in)
.br
\f3-s2\f1:  letter             (8.5in x 11in)
.br
\f3-s3\f1:  legal              (8.5in x 14in)
.br
\f3-s26\f1: A4                 (210mm x 297mm)
.br
\f3-s80\f1: monarch          (3.875in x 7.5in)
.br
\f3-s81\f1: commercial-10    (4.125in x 9.5in)
.br
\f3-s90\f1: international DL   (110mm x 220mm)
.br
\f3-s91\f1: international C5   (162mm x 229mm)
.br
All values are from the LJ II technical reference manual.
If the -s commandline option is omitted, no clipping is performed
at the bottom of the page.
.TP
\f3-t\f2pagenum\f1
Print pages with TeX page numbers less than or equal to \f2pagenum\f1.
.TP
\f3-v\f1
Verbose mode: list fonts used, etc.
.TP
\f3-w\f1
Omit warnings.
.TP
\f3-x\f2offset\f1
global x-offset in mm on output page
relative to 1 inch/1 inch origin
.TP
\f3-y\f2offset\f1
global y-offset in mm on output page
relative to 1 inch/1 inch origin
.TP
\f3-X\f2offset\f1
global x-offset in dots on output page
(overrides 1 inch/1 inch origin)
.TP
\f3-Y\f2offset\f1
global y-offset in dots on output page
(overrides 1 inch/1 inch origin)
.TP
\f3-z\f1
print a test page with the page counter at end of job
.TP
\f3-\f1
Take input from standard input (must be seekable), write to standard output.
.PP
If no arguments are specified a brief usage message is displayed.
.SH \especial COMMANDS
TeX `\especial' commands that are implemented:
.TP \w'\f3\especial{hpfile=<filename>}\f1'u+2n
\f3\especial{file=<filename>}\f1
copy specified file to the printer; either vector- or bitmap-graphics PMP
commands
.TP
\f3\especial{hpfile=<filename>}\f1
Same as `file'.
.TP 0
others:
There are a few other special commands implented for the LJ-series,
which should only be used in connection with the distributed style
files (e.g., graybox.sty). They may change in forthcoming versions.
.PP
You can include Encapsulated PostScript (EPS) files in the PCL files output
by dvilj if you convert them to PCL first. The distribution includes a
script `epspcl' to do this (using Ghostscript, so your Ghostscript must
have the necessary LaserJet driver(s) compiled in).
.SH DOUBLE PAGE PRINTING
The command line option -D causes the printer to print
in doublepage mode, that is, roughly speaking, printing first
the even pages and then the odd pages of a document.
If -D is used to print both even and odd pages (-D is used
without the optional \f21\f1 or \f22\f1)
the following will happen after
half of the pages is printed:
\f3LJ:\f1
the printer stops, shows message "FEED" and switches
on manual feed led. The printer continues when either
the printed pages are fed into the manual page feeder,
or the operator pushes the continue button (after placing first
the printed pages into the paper tray).
.PP
If -D1 was specified only odd pages will be printed, -D2 can be used
for even pages. A trailing `-' (as in -D-, -D1- or -D2-) supresses
printing of empty pages which are generated for padding otherwise.
.PP
The driver allows the -D option for both print-directions (front-to-back
or back-to-front printing). It tries to be clever in certain cases:
when a document has an odd number of pages it inserts in the
right place an empty page
when a document starts with page 0 the driver inserts an empty
page after the 0-page
when a piece of a document is printed that starts with
an even page-number it prints this page at the backside
of the first page to ensure that the odd sides are always
on the frontside. The 0-page is treated like an odd page.
.PP
The doubleside option works for all LJs, not only for the
new D model with does doubleside-printing (actually, I don't
know whether it makes much sense on the new LJ II D at all).
.PP
Caveat on the doubleside-option: When it is used frequently
or on very large files, it might become necessary to clean
the printer much more frequently.
.PP
The command line option -pX can be used to abort printing
after the output of X pages (can lead to strange results together
with -D). I personally dislike this option. The secure way of
printing a part of a document is using -f (from) and -t (to).
.SH ENVIRONMENT
Dviljk uses the same environment variables and algorithms for finding
font files as TeX and its friends do.  See the documentation for the
Kpathsea library for details.  (Repeating it here is too cumbersome.)
.PP
DVILJFONTS, if set, overrides all other font paths.
.PP
DVILJMAKEPK, if set, overrides `MakeTeXPK' as the name of the command to
execute to create a PK file if one isn't found.
.PP
The DVILJSIZES variable may be set to indicate which sizes of fonts are
available.  It should consist of a list of numbers separated by colons.  If
the list begins with a colon, the system default sizes are used, as well.
Sizes are expressed in dots per inch; decimals may be used for ``pxl'' files:
for example, a 300 dots per inch file magnified by half a step comes out to
1643 dots per five inches, which should be encoded as 328.6.  \fIdvilj\fR
tries the actual size of the font before trying any of the given sizes.
.PP
KPATHSEA_DEBUG: Trace Kpathsea lookups; set to -1 for complete tracing.
.SH AUTHOR
Gustaf Neumann, Wirtschaftsuniversitaet Wien
.br
neumann@wu-wien.ac.at
.PP
dviljk changes by kb@mail.tug.org; email bug reports to tex\-k@mail.tug.org.
