/* keyboard.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
extern struct teffect effect;
/*---------------------------------------------------------------------------*/
/* global variables : declaration */
int lastkey;
tkeyparse **ptkeyparsetbl = NULL; /* pointer to current key parse table */
/*---------------------------------------------------------------------------*/
/* translates a key press event to an integer value */
/* returns regular keys in range 0..127 and extended keys in range 128..255 */
int key_int()
{
  int i;

  i = getch();
  if (i == 0)
    {
      i = getch();
      i += 128;
    }
  return i;
}
/*---------------------------------------------------------------------------*/
/* clear keyboard buffer */
void key_clear()
{
  while (kbhit())
    {
      getch();
    }
}
/*---------------------------------------------------------------------------*/
void key_parse()
{
  int i = 0;
  tkeyparse* ptk;
  void (*akey_handler)() = NULL;

  ptk = ptkeyparsetbl[i++];
  while (ptk)
    {
      if ((ptk->key == lastkey) || (ptk->key == -1))
	/* key found or chain through */
	{
	  akey_handler = ptk->key_handler;
	  break;
	}
      ptk = ptkeyparsetbl[i++];
    }
  if (lastkey == K_A) /* select different sub-effect */
    {
      if (effect.done)
	{
	  effect.done();
	}
      if (effect.init)
	{
	  effect.init();
	}
      lastkey = K_A;
    }
  if (lastkey == K_a) /* select different sub-effect */
    {
      if (effect.done)
	{
	  effect.done();
	}
      if (effect.init)
	{
	  effect.init();
	}
      lastkey = K_a;
    }
  if (akey_handler)
    {
      (*akey_handler)();
    }
}
/*---------------------------------------------------------------------------*/
void key_scan()
{
  if (kbhit())
    {
      lastkey = key_int();
      key_parse();
    }
}
