/* filter.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */

/* descriptions of the filters in michbeta.txt */
/* soften (medium), effect : 25 */
/* soften (a lot), effect : 25 */
/* soften (a little), effect : 154 */
/* sharpen (low), negative values give contrast, effect : 25 */
/* sharpen (medium), effect : 25 */
/* "soft" sharpen (weird), effect : 25 */
/* diagonal "shatter", effect : 4 */
/* horizontal blur, effect : 9 */
/* "fire" filter, effect : 4 */
/* vertical blur, effect : 9 */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define COUNT_MIN 1
#define COUNT_MAX 3000
#define COUNT_STEP 1

#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define EFF_MIN 1
#define EFF_MAX 255
#define EFF_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
int filter_num, loop_count, *filter_dyna;
BITMAP *destination, *scr_pbmp;

int count, delayy, eff;

static tkeyparse
  see_f11_0 = {K_0, keysee_f11_0}, /* filter.c specific */
  see_f11_1 = {K_1, keysee_f11_1},
  see_f11_2 = {K_2, keysee_f11_2},
  see_f11_3 = {K_3, keysee_f11_3},
  see_f11_4 = {K_4, keysee_f11_4},
  see_f11_5 = {K_5, keysee_f11_5},
  see_f11_6 = {K_6, keysee_f11_6},
  see_f11_7 = {K_7, keysee_f11_7},
  see_f11_8 = {K_8, keysee_f11_8},
  see_f11_9 = {K_9, keysee_f11_9},
  see_f11_C = {K_C, keysee_f11_C},
  see_f11_D = {K_D, keysee_f11_D},
  see_f11_E = {K_E, keysee_f11_E},
  see_f11_c = {K_c, keysee_f11_c},
  see_f11_d = {K_d, keysee_f11_d},
  see_f11_e = {K_e, keysee_f11_e}
;

tkeyparse* tkeyparsetbl_filter[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f11_0, /* filter.c specific */
  &see_f11_1,
  &see_f11_2,
  &see_f11_3,
  &see_f11_4,
  &see_f11_5,
  &see_f11_6,
  &see_f11_7,
  &see_f11_8,
  &see_f11_9,
  &see_f11_C,
  &see_f11_D,
  &see_f11_E,
  &see_f11_c,
  &see_f11_d,
  &see_f11_e,
  NULL
};

teffect eff_filter =
{
  filter_init,
  filter_effect,
  filter_loop_end,
  filter_done,
  tkeyparsetbl_filter,
  1
};
/*---------------------------------------------------------------------------*/
int filter_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_C:
    case K_D:
    case K_E:
    case K_c:
    case K_d:
    case K_e:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f11_0()
{
  keysee_f11_gen("f11_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_1()
{
  keysee_f11_gen("f11_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_2()
{
  keysee_f11_gen("f11_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_3()
{
  keysee_f11_gen("f11_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_4()
{
  keysee_f11_gen("f11_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_5()
{
  keysee_f11_gen("f11_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_6()
{
  keysee_f11_gen("f11_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_7()
{
  keysee_f11_gen("f11_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_8()
{
  keysee_f11_gen("f11_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_9()
{
  keysee_f11_gen("f11_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f11_C()
{
  paraint(&count, COUNT_MIN, COUNT_MAX, COUNT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f11_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f11_E()
{
  paraint(&eff, EFF_MIN, EFF_MAX, EFF_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f11_c()
{
  paraint(&count, COUNT_MIN, COUNT_MAX, COUNT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f11_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f11_e()
{
  paraint(&eff, EFF_MIN, EFF_MAX, EFF_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f11_gen(uchr s[256])
{
  int i;
  uchr s1[256];
  FILE *fp;

  filter_restore();
  fp = fopen(confname, "rt");
  if (!fp)
    {
      fp = fopenm(DEFNAME, "rt");
    }
  setfilept(fp, s, 0);
  fscanf(fp, "%s", s1); /* skip = */
  fscanf(fp, "%s", s1); /* 1st parameter == filter */
  fscanf(fp, "%s", s1); /* read count */
  count = atoi(s1);
  fscanf(fp, "%s", s1); /* read delayy */
  delayy = atoi(s1);
  fscanf(fp, "%s", s1); /* read effect */
  eff = atoi(s1);
  fscanf(fp, "%s", s1); /* read filter_num */
  filter_num = atoi(s1);
  filter_dyna = mallocm(filter_num * sizeof(int));
  for (i = 0; i < filter_num; i++) /* read filter dynamic array (matrix) */
    {
      fscanf(fp, "%s", s1);
      filter_dyna[i] = atoi(s1);
    }
  do_effect(&eff_filter);
  free(filter_dyna);
}
/*---------------------------------------------------------------------------*/
void filter_calc(int afilter[25])
{
  int final;
  int gridcounter, x, y, x2, y2;

  /* for each pixel in the image */
  for (y = 0; y < scr_h; y++)
    for (x = 0; x < scr_w; x++)
      {
	/* reset some values */
	final = 0;
	gridcounter = 0;
	/* and for each pixel around our "hot pixel" */
	for (y2 = -2; y2 <= 2; y2++)
	  for (x2 = -2; x2 <= 2; x2++)
	    {
	      /* add to our running total */
	      if (y + y2 < 0)
		{
		  gridcounter++;
		  continue;
		}
	      if (y + y2 > scr_h - 1)
		{
		  gridcounter++;
		  continue;
		}
	      if (x + x2 < 0)
		{
		  gridcounter++;
		  continue;
		}
	      if (x + x2 > scr_w - 1)
		{
		  gridcounter++;
		  continue;
		}
	      final += scr_pbmp->line[y + y2][x + x2] * afilter[gridcounter];
	      /* go to the next value on the filter grid */
	      gridcounter++;
	    }
	/* and put it back into the right range */
	final /= eff;
	destination->line[y][x] = final;
      }
  rest(delayy);
  blit(destination, screen, 0, 0, 0, 0, scr_w, scr_h);
  blit(destination, scr_pbmp, 0, 0, 0, 0, scr_w, scr_h);
}
/*---------------------------------------------------------------------------*/
void filter_done()
{
  destroy_bitmapm(destination);
  destroy_bitmapm(scr_pbmp);
}
/*---------------------------------------------------------------------------*/
void filter_effect()
{
  loop_count++;
  if (loop_count == count)
    {
      loop_count = 0;
      rest(delayy);
      filter_restore();
    }
  filter_calc(filter_dyna);
}
/*---------------------------------------------------------------------------*/
void filter_init()
{
  destination = create_bitmapm(scr_w, scr_h);
  loop_count = 0;
  rest(delayy);

  scr_pbmp = create_bitmap(scr_w, scr_h);
  blit(pbmp, scr_pbmp, 0, 0, 0, 0, scr_w, scr_h);

  lastkey = K_d;
}
/*---------------------------------------------------------------------------*/
void filter_restore()
{
  keysee_insert();
}
