/* dep.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */

/* this file holds routines which "dep"end on external libraries */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
#include "dep.h"
/*---------------------------------------------------------------------------*/
/* same as create_bitmap, but displays an appropriate message when it failed */
BITMAP *create_bitmapm(int width, int height)
{
  BITMAP *apbmp;

  if (!(apbmp = create_bitmap(width, height))) /* test if NULL */
    {
      printf("error:\n");
      printf("(create_bitmapm) !(apbmp = create_bitmap(width, height))\n");
      printf("width : %i\n", width);
      printf("height : %i\n", height);
      getch();
      exit(1);
    }
  return apbmp;
}
/*---------------------------------------------------------------------------*/
/* same as load_bitmap, but displays an appropriate message when it failed */
BITMAP* load_bitmapm(char *filename, RGB *pal)
{
  BITMAP *apbmp;

  if (!(apbmp = load_bitmap(filename, pal))) /* test if NULL */
    {
      printf("error:\n");
      printf("(load_bitmapm) !(apbmp = load_bitmap(filename, pal))\n");
      printf("filename : %s\n", filename);
      getch();
      exit(1);
    }
  return apbmp;
}
/*---------------------------------------------------------------------------*/
SAMPLE* load_samplem(char filename[256])
{
  SAMPLE *psample;

  psample = load_sample(filename);
  if (psample == NULL)
    {
      printf("error:\n");
      printf("(load_samplem) psample == NULL\n");
      printf("filename : %s\n", filename);
      getch();
      exit(1);
    }
  return psample;
}
/*---------------------------------------------------------------------------*/
/* same as install_sound, but displays an appropriate message when it failed */
int install_soundm(int digi_card, int midi_card, char *cfg_path)
{
  if (install_sound(digi_card, midi_card, cfg_path) != 0)
    {
      printf("error:\n");
      printf("(install_soundm) install_sound(digi_card, midi_card, cfg_path) != 0\n");
      printf("digi_card : %i\n", digi_card);
      printf("midi_card : %i\n", midi_card);
      printf("cfg_path : %s\n", cfg_path);
      getch();
      exit(1);
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
/* same as set_gfx_mode, but displays an appropriate message when it failed */
int set_gfx_modem(int card, int w, int h, int v_w, int v_h)
{
  if (set_gfx_mode(card, w, h, v_w, v_h) == -1) /* test on -1 */
    {
      printf("error:\n");
      printf("(set_gfx_modem) set_gfx_mode(card, w, h, v_w, v_h) == -1\n");
      printf("card : %i\n", card);
      printf("w : %i\n", w);
      printf("h : %i\n", h);
      printf("v_w : %i\n", v_w);
      printf("v_h : %i\n", v_h);
      getch();
      exit(1);
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
/* same as destroy_bitmap, but test if abmp really exists */
void destroy_bitmapm(BITMAP *abmp)
{
  if (abmp)
    {
      destroy_bitmap(abmp);
    }
}
/*---------------------------------------------------------------------------*/
void parafixed(fixed *v, fixed min, fixed max, fixed step, int di, int sl)
{
  if (di == 0) /* decrement */
    {
      if ((*v - step) >= min)
	{
	  *v -= step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = min;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = max;
	    }
	}
    }
  else if (di == 1) /* increment */
    {
      if ((*v + step) <= max)
	{
	  *v += step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = max;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = min;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void pbleed(int x, int y, BITMAP *apbmp, int adelay, int dropletwidth, int masked)
{
  int *counter, i, j, k, l, loopcheck, m;

  counter = mallocm(apbmp->w * sizeof(int));
  assert(counter);

  if (dropletwidth < 1)
    {
      dropletwidth = 1;
    }
  while (apbmp->w % dropletwidth)
    {
      dropletwidth--;
    }
  for (i = apbmp->w / dropletwidth; i--;)
    {
      counter[i] = 1;
    }
  do
    {
      loopcheck = TRUE;
      for (i = (apbmp->w / dropletwidth); i--;)
	{
	  j = random0tm(10) + 1;
	  if (j + counter[i] > apbmp->h)
	    {
	      j = apbmp->h - counter[i];
	    }
	  for (k = counter[i] - 1; k < counter[i] + j; k++)
	    {
	      for (l = dropletwidth; l--;)
		{
		  m = apbmp->line[k][i * dropletwidth + l];
		  if ((m) || (!masked))
		    {
		      putpixel(screen, i * dropletwidth + l + x, k + y, m);
		    }
		}
	    }
	  counter[i] += j;
	  if (counter[i] < apbmp->h)
	    {
	      loopcheck = FALSE;
	    }
	}
      delay(adelay);
    }
  while (!loopcheck);
  free(counter);
  counter = NULL;
}
/*---------------------------------------------------------------------------*/
void pdospiral(int count1, int count2, int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked)
{
  int i, j, k;

  for (i = 0; i < apbmp->w / spiralwidth; i++)
    {
      for (j = 0; j < apbmp->h / spiralwidth; j++)
	{
	  k = apbmp->line[j * spiralwidth + count1][i * spiralwidth + count2];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i * spiralwidth + count2 + x, j * spiralwidth + count1 + y, k);
	    }
	}
    }
  delay(adelay);
}
/*---------------------------------------------------------------------------*/
void poverwritezap(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int ax, i, j, k;

  for (i = 0; i < apbmp->w; i++)
    {
      for (j = apbmp->h; j--;)
	{
	  if (j % 2 == 0)
	    {
	      ax = i;
	    }
	  else
	    {
	      ax = apbmp->w - i - 1;
	    }
	  k = apbmp->line[j][ax];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, x + ax, y + j, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void ppushzap(int x, int y, BITMAP *apbmp, int adelay)
{
  int i, j;

  while (apbmp->w % adelay)
    {
      adelay--;
    }
  for (i = 1; i <= apbmp->w / adelay; i++)
    {
      for (j = 1; j <= apbmp->h / 2; j++)
	{
	  blit(screen, screen, x, y + j * 2 - 1, x + adelay, y + j * 2 - 1, apbmp->w - adelay,1);
	  blit(apbmp, screen, apbmp->w - (i * adelay), j * 2 - 1, x, y + j * 2 - 1, adelay, 1);
	}
      for (j = 1; j <= apbmp->h / 2; j++)
	{
	  blit(screen, screen, x + adelay, y + j * 2 - 2, x, y + j * 2 - 2, apbmp->w - adelay,1);
	  blit(apbmp, screen, (i - 1) * adelay, j * 2 - 2, x + apbmp->w - adelay, y + j * 2 - 2,
	       adelay, 1);
	}
    }
}
/*---------------------------------------------------------------------------*/
void pshake(int x, int y, BITMAP *apbmp, int maxshake, int numshake, int adelay, int masked)
{
  int i, xshake, yshake;
  BITMAP *pbmpbuffer, *pbmpoldscreen;

  pbmpbuffer = NULL;
  x -= maxshake;
  y -= maxshake;
  maxshake *= 2;
  pbmpoldscreen = create_bitmapm(apbmp->w + maxshake, apbmp->h + maxshake);
  blit(screen, pbmpoldscreen, x, y, 0, 0, pbmpoldscreen->w, pbmpoldscreen->h);
  if (masked)
    {
      pbmpbuffer = create_bitmapm(apbmp->w + maxshake, apbmp->h + maxshake);
    }
  maxshake--;
  xshake = (maxshake + 1) / 2; /* centre it */
  yshake = (maxshake + 1) / 2;
  for (i = numshake; i--;)
    {
      if (!i)
	{
	  xshake = (maxshake + 1) / 2; /* centre it again */
	  yshake = (maxshake + 1) / 2;
	}
      if (masked)
	{
	  blit(pbmpoldscreen, pbmpbuffer, 0, 0, 0, 0, pbmpoldscreen->w, pbmpoldscreen->h);
	  draw_sprite(pbmpbuffer, apbmp, xshake, yshake);
	  blit(pbmpbuffer, screen, 0, 0, x, y, pbmpbuffer->w, pbmpbuffer->h);
	}
      else
	{
	  blit(pbmpoldscreen, screen, 0, 0, x, y, pbmpoldscreen->w, pbmpoldscreen->h);
	  blit(apbmp, screen, 0, 0, x + xshake, y + yshake, apbmp->w, apbmp->h);
	}
      delay(adelay);
      xshake = random0tm(maxshake);
      yshake = random0tm(maxshake);
    }
  destroy_bitmapm(pbmpoldscreen);
  if (masked)
    {
      destroy_bitmapm(pbmpbuffer);
    }
}
/*---------------------------------------------------------------------------*/
void pspiralin(int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked)
{
  int i, j;

  while ((apbmp->w % spiralwidth) || (apbmp->h % spiralwidth))
    {
      spiralwidth--;
    }
  if (spiralwidth == 1)
    {
      blit(apbmp, screen, 0, 0, x, y, apbmp->w, apbmp->h);
    }
  for (i = 0; i < spiralwidth / 2; i++)
    {
      for (j = i; j < spiralwidth - i; j++)
	{
	  pdospiral(i, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = i; j < spiralwidth - i; j++)
	{
	  pdospiral(j, spiralwidth - i - 1, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(spiralwidth - i - 1, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(j, i, x, y, apbmp, spiralwidth, adelay, masked);
	}
    }
}
/*---------------------------------------------------------------------------*/
void pspiralout(int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked)
{
  int i, j;

  while ((apbmp->w % spiralwidth) || (apbmp->h % spiralwidth))
    {
      spiralwidth--;
    }
  if (spiralwidth == 1)
    {
      blit(apbmp, screen, 0, 0, x, y, apbmp->w, apbmp->h);
    }
  for (i = (spiralwidth / 2) - 1; i >= 0; i--)
    {
      for (j = i + 1; j < spiralwidth - i; j++)
	{
	  pdospiral(i, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = i; j < spiralwidth - i; j++)
	{
	  pdospiral(j, spiralwidth - i - 1, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(spiralwidth - i - 1, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(j, i, x, y, apbmp, spiralwidth, adelay, masked);
	}
    }
}
/*---------------------------------------------------------------------------*/
void pwipebottomtotop(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (j = apbmp->h; j--;)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipefromcentrehorizontally(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, jtarget, k, oddflag;

  jtarget = apbmp->w / 2;
  oddflag = 0;
  if (apbmp->w % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = jtarget; j--;)
    {
      for (i = apbmp->h; i--;)
	{
	  k = apbmp->line[i][j];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, j + x, i + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->h; i--;)
	    {
	      k = apbmp->line[i][apbmp->w - j - 1];
	      if ((k) || (!masked))
		{
		  putpixel(screen, apbmp->w - j - 1 + x, i + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipefromcentrevertically(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k, jtarget, oddflag;

  jtarget = apbmp->h / 2;
  oddflag = 0;
  if (apbmp->h % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = jtarget; j--;)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->w; i--;)
	    {
	      k = apbmp->line[apbmp->h - j - 1][i];
	      if ((k) || (!masked))
		{
		  putpixel(screen, i + x, apbmp->h - j - 1 + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipelefttoright(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (i = 0; i < apbmp->w; i++)
    {
      for (j = apbmp->h; j--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwiperighttoleft(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (i = apbmp->w; i--;)
    {
      for (j = apbmp->h; j--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipetocentrehorizontally(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k, jtarget, oddflag;

  jtarget = apbmp->w / 2;
  oddflag = 0;

  if (apbmp->w % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = 0; j < jtarget; j++)
    {
      for (i = apbmp->h; i--;)
	{
	  k = apbmp->line[i][j];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, j + x, i + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->h; i--;)
	    {
	      k = apbmp->line[i][apbmp->w - j - 1];
	      if ((k) || (!masked))
		{
		  putpixel(screen, apbmp->w - j - 1 + x, i + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipetocentrevertically(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, jtarget, k, oddflag;

  jtarget = apbmp->h / 2;
  oddflag = 0;

  if (apbmp->h % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = 0; j < jtarget; j++)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->w; i--;)
	    {
	      k = apbmp->line[apbmp->h - j - 1][i];
	      if ((k) || (!masked))
		{
		  putpixel(screen, i + x, apbmp->h - j - 1 + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipetoptobottom(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (j = 0; j < apbmp->h; j++)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
