// ProjectView.cpp : implementation file
//

#include "stdafx.h"
#include "DFE32.h"
#include "ProjectView.h"
#include "projectdoc.h"
#include "cdialectpage.h"
#include "optimizepage.h"
#include "otherpage.h"
#include "overallpage.h"
#include "warningpage.h"
#include "advancedsheet.h"
#include "projectlinkdialog.h"
#include "debugdialog.h"
#include "linkdialog.h"
#include "rundialog.h"
#include "extern.h"
#include "dfe32doc.h"
#include "childfrm.h"
#include "dfe32view.h"
#include "mainfrm.h"
#include <sys\stat.h>
#include <io.h>
#include <fcntl.h>
#include <direct.h>
#include "messageview.h"
#include "postmessage.h"
#include "fork.h"
#include "makedialog.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
UINT RebuildAllProc(LPVOID);
UINT BuildProc(LPVOID);
UINT MakeProc(LPVOID);
CString CToObj(CString, CString);
CString WorkingDir(CString);
CString MakeCommandLine(CString, int, int, int, int, int, int, int, int, int,
						CString);
void DoubleSlash(CString &);
typedef struct buildinfostruct
{
public:
	CString libs[500];
	CString files[500];
	int numfiles;
	int numlibs;
	int Ansi;
	int E;
	int GenDebug;
	int Language;
	int NoAsm;
	int Optimize;
	CString Other;
	CString Output;
	int S;
	int Traditional;
	int Warning;
	CString WorkingDir;
} BUILDINFO;
/////////////////////////////////////////////////////////////////////////////
// CProjectView

IMPLEMENT_DYNCREATE(CProjectView, CFormView)

CProjectView::CProjectView()
	: CFormView(CProjectView::IDD)
{
	//{{AFX_DATA_INIT(CProjectView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CProjectView::~CProjectView()
{
}

void CProjectView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProjectView)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProjectView, CFormView)
	//{{AFX_MSG_MAP(CProjectView)
	ON_COMMAND(ID_PROJECT_SETCOMPILEOPTIONS, OnProjectSetcompileoptions)
	ON_COMMAND(ID_PROJECT_SETLINKINGOPTIONS, OnProjectSetlinkingoptions)
	ON_COMMAND(ID_PROJECT_INSERTFILE, OnProjectInsertfile)
	ON_COMMAND(ID_PROJECT_REMOVEFILE, OnProjectRemovefile)
	ON_COMMAND(ID_PROJECT_REBUILDALL, OnProjectRebuildall)
	ON_COMMAND(ID_COMMANDS_DEBUG, OnCommandsDebug)
	ON_COMMAND(ID_COMMANDS_LINK, OnCommandsLink)
	ON_COMMAND(ID_COMMANDS_RUN, OnCommandsRun)
	ON_COMMAND(ID_PROJECT_BUILDPROJECT, OnProjectBuildproject)
	ON_LBN_DBLCLK(IDC_SOURCE_LIST, OnDblclkSourceList)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_PROJECT_EXPORTASMAKEFILE, OnProjectExportasmakefile)
	ON_COMMAND(ID_COMMANDS_MAKE, OnCommandsMake)
	ON_COMMAND(ID_PROJECT_EXPORTANDMAKE, OnProjectExportandmake)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProjectView diagnostics

#ifdef _DEBUG
void CProjectView::AssertValid() const
{
	CFormView::AssertValid();
}

void CProjectView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CProjectView message handlers

void CProjectView::OnProjectSetcompileoptions() 
{
	CAdvancedSheet sheet("Advanced Options");
	CProjectDoc *d = (CProjectDoc *)GetDocument();
	sheet.cdialectpage.m_Ansi = d->m_Ansi;
	sheet.cdialectpage.m_NoAsm = d->m_NoAsm;
	sheet.cdialectpage.m_Traditional = d->m_Traditional;
	sheet.optimizepage.m_Optimize = d->m_Optimize;
	sheet.otherpage.m_Other = d->m_Other;
	sheet.overallpage.m_E = d->m_E;
	sheet.overallpage.m_S = d->m_S;
	sheet.overallpage.m_GenDebug = d->m_GenDebug;
	sheet.overallpage.m_Language = d->m_Language;
	sheet.warningpage.m_Warning = d->m_Warning;
	if (sheet.DoModal() == IDOK)
	{
		d->m_Ansi = sheet.cdialectpage.m_Ansi;
		d->m_NoAsm = sheet.cdialectpage.m_NoAsm;
		d->m_Traditional = sheet.cdialectpage.m_Traditional;
		d->m_Optimize = sheet.optimizepage.m_Optimize;
		d->m_Other = sheet.otherpage.m_Other;
		d->m_E = sheet.overallpage.m_E;
		d->m_S = sheet.overallpage.m_S;
		d->m_GenDebug = sheet.overallpage.m_GenDebug;
		d->m_Language = sheet.overallpage.m_Language;
		d->m_Warning = sheet.warningpage.m_Warning;
		AfxMessageBox("Note: If you have changed the overall build options for this project, remember to rebuild all the sources to register the effect\n");
		d->SetModifiedFlag(TRUE);
	}
}

void CProjectView::OnProjectSetlinkingoptions() 
{
	CProjectLinkDialog dlg;
	int extenlength = 0;
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	int i;
	dlg.numlibs = doc->numlibs;
	for (i = 0; i < doc->numlibs; i++)
		dlg.libs[i] = doc->libs[i];
	if (doc->m_Output.IsEmpty())
		dlg.m_Output = doc->GetPathName();
	else
		dlg.m_Output = doc->m_Output;
		for(i=0; i < dlg.m_Output.GetLength(); i++)
		{
			if (dlg.m_Output.GetAt(i) == '.')
				extenlength = dlg.m_Output.GetLength() - (i + 1);
		}
		dlg.extension = dlg.m_Output.Right(extenlength);
	if (dlg.DoModal() == IDOK)
	{
		doc->numlibs = dlg.numlibs;
		for (i = 0; i < doc->numlibs; i++)
			doc->libs[i] = dlg.libs[i];
		doc->m_Output = dlg.m_Output;
		doc->SetModifiedFlag(TRUE);
	}
}

void CProjectView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: Add your specialized code here and/or call the base class
	int i;
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	CListBox *list = (CListBox*)GetDlgItem(IDC_SOURCE_LIST);
	list->ResetContent();
	for (i = 0; i < doc->numfiles; i++)
		list->AddString(doc->files[i]);
	CFormView::OnUpdate(pSender, lHint, pHint);
	
}

void CProjectView::OnProjectInsertfile() 
{
	// TODO: Add your command handler code here
	CString str;
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Source Files (*.*)|*.*||");
	CListBox *list = (CListBox*)GetDlgItem(IDC_SOURCE_LIST);
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	if (filedialog.DoModal() == IDOK)
	{
		str = filedialog.GetPathName();
		list->AddString(str);
		doc->numfiles++;
		doc->SetModifiedFlag(TRUE);
	}
	ListToFiles();
}

void CProjectView::OnProjectRemovefile() 
{
	// TODO: Add your command handler code here
	CListBox *list = (CListBox*)GetDlgItem(IDC_SOURCE_LIST);
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	if (list->GetCurSel() != LB_ERR)
	{
		list->DeleteString(list->GetCurSel());
		doc->numfiles--;
		doc->SetModifiedFlag(TRUE);
	}
	ListToFiles();
}

void CProjectView::ListToFiles(void)
{
	CListBox *list = (CListBox*)GetDlgItem(IDC_SOURCE_LIST);
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	CString str;
	int i;
	for (i = 0; i < doc->numfiles; i++)
	{
		list->GetText(i, str);
		doc->files[i] = str;
	}
}
void CProjectView::OnProjectRebuildall() 
{
	// TODO: Add your command handler code her
	BUILDINFO *info = new BUILDINFO;
	int i, extenlength;
	CProjectDoc *d = (CProjectDoc *)GetDocument();
	if (d->GetPathName().IsEmpty())
	{
		AfxMessageBox("Please save the project before continuing");
		return;
	}
	if (d->numfiles == 0)
	{
		AfxMessageBox("there are no files in the project");
		return;
	}
	for (i = 0; i < d->numfiles; i++)
		info->files[i] = d->files[i];
	for (i = 0; i < d->numlibs; i++)
		info->libs[i] = d->libs[i];
	info->numlibs = d->numlibs;
	info->numfiles = d->numfiles;
	info->Ansi = d->m_Ansi;
	info->E = d->m_E;
	info->GenDebug = d->m_GenDebug;
	info->Language = d->m_Language;
	info->NoAsm = d->m_NoAsm;
	info->Optimize = d->m_Optimize;
	info->Other = d->m_Other;
	if (d->m_Output.IsEmpty())
	{
		for(i=0; i < d->GetPathName().GetLength(); i++)
		{
			if (d->GetPathName().GetAt(i) == '.')
				extenlength = d->GetPathName().GetLength() - (i + 1);
		}
		CString str('x', (3 - extenlength));
		info->Output = d->GetPathName() + str;
		info->Output.SetAt(info->Output.GetLength() - 3, 'e');
		info->Output.SetAt(info->Output.GetLength() - 2, 'x');
		info->Output.SetAt(info->Output.GetLength() - 1, 'e');
	}
	else
		info->Output = d->m_Output;
	CMainFrame *frame;
	frame = (CMainFrame *)AfxGetMainWnd();
	frame->lastrun = info->Output;
	info->S = d->m_S;
	info->Traditional = d->m_Traditional;
	info->Warning = d->m_Warning;
	info->WorkingDir = d->GetPathName().Left(d->GetPathName().GetLength() - 
		d->GetTitle().GetLength());
	AfxBeginThread(RebuildAllProc, info);
}

void CProjectView::OnCommandsDebug() 
{
	// TODO: Add your command handler code here
	CDebugDialog dlg;
	dlg.DoModal();
}

void CProjectView::OnCommandsLink() 
{
	// TODO: Add your command handler code here
	int i;
	int extenlength = 0;
	CLinkDialog dialog;
	dialog.filename = GetDocument()->GetPathName();
	if (!dialog.filename.IsEmpty())
	{
		for(i=0; i < dialog.filename.GetLength(); i++)
		{
			if (dialog.filename.GetAt(i) == '.')
				extenlength = dialog.filename.GetLength() - (i + 1);
		}
		dialog.extension = dialog.filename.Right(extenlength);
	}
	dialog.DoModal();	
}

void CProjectView::OnCommandsRun() 
{
	// TODO: Add your command handler code here
	CRunDialog dlg;
	dlg.DoModal();
}

UINT RebuildAllProc(LPVOID buildinfo)
{
	HANDLE inp, out, err, threadhandle;
	char buffer[5000];
	DWORD number;
	BUILDINFO *info = (BUILDINFO *)buildinfo;
	int i;
	CString CommandLine;
	CString output, temp;
	if (clear)
		GlobalMessageView->Reset();
	output = "Beginning compilation of project...";
	PostOutput(output, TRUE);
	for (i = 0; i < info->numfiles; i++)
	{
		memset(buffer, '\0', 4000);
		CommandLine.Empty();
		CommandLine = gccpath;
		CommandLine += " -c ";
		CommandLine += info->files[i];
		CommandLine += " ";
		if (info->GenDebug == TRUE)
			CommandLine += "-g ";
		if (info->Ansi == TRUE)
			CommandLine += "-ansi ";
		if (info->NoAsm == TRUE)
			CommandLine += "-fno-asm ";
		if (info->Traditional == TRUE)
			CommandLine += "-traditional ";
		if (info->S == TRUE)
			CommandLine += "-S ";
		if (info->E == TRUE)
			CommandLine += "-E ";
		switch (info->Optimize)
		{
		case 1:
			CommandLine += "-O1 ";
			break;
		case 2:
			CommandLine += "-O2 ";
			break;
		case 3:
			CommandLine += "-O3 ";
			break;
		default:
			break;
		}
		switch (info->Language)
		{
		case 1:
			CommandLine += "-x c ";
			break;
		case 2:
			CommandLine += "-x objective-c ";
			break;
		case 3:
			CommandLine += "-x c++ ";
			break;
		case 4:
			CommandLine += "-x c-header ";
			break;
		case 5:
			CommandLine += "-x cpp-output ";
			break;
		case 6:
			CommandLine += "-x c++-cpp-output ";
			break;
		case 7:
			CommandLine += "-x assembler ";
			break;
		case 8:
			CommandLine += "-x assembler-with-cpp ";
			break;
		default:
			break;
		}
		switch (info->Warning)
		{
		case 1:
			CommandLine += "-w ";
			break;
		case 2:
			CommandLine += "-Wall ";
			break;
		case 3:
			CommandLine += "-W ";
			break;
		case 4:
			CommandLine += "-Werror ";
			break;
		default:
			break;
		}
		if (!info->Other.IsEmpty())
		{
			CommandLine += info->Other;
			CommandLine += " ";
		}
		output = "compiling ";
		output += info->files[i];
		output += " with command line of:";
		PostOutput(output, FALSE);
		output = CommandLine;
		PostOutput(output, FALSE);
		threadhandle = 
			ForkChildProcess(CommandLine.GetBuffer(20000),&inp,&out,&err, TRUE);
		WaitForSingleObject(threadhandle, INFINITE);
		PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
		if (number == 0)
		{
			output = "No warnings or errors recieved from gcc";
			PostOutput(output, TRUE);
		}
		else
		{
			output = "Errors:";
			PostOutput(output, TRUE);
			ReadFile(err, buffer, 4000, &number, NULL);
			temp = buffer;
			while (1)
			{
				if (temp.Find('\n') != -1)
				{
					output = temp.Left(temp.Find('\n') - 1);
					temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
					PostOutput(output, FALSE);
					if (temp.Find('\n') == -1)
					{
						PostOutput(temp, FALSE);
						break;
					}
				}
				else
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
		}
	}
	memset(buffer, '\0', 4000);
	struct _stat status;
	struct _stat status2;
	for (i = 0; i < info->numfiles; i++)
	{
		_stat(info->files[i].GetBuffer(500), &status);
		if (_stat(CToObj(info->files[i], info->WorkingDir).GetBuffer(500),
			&status2) == -1)
		{
			delete buildinfo;
			output = "Ending Compilation";
			PostOutput(output, TRUE);
			return 0;
		}
		if (status.st_mtime > status2.st_mtime)
		{
			delete buildinfo;
			output = "Ending Compilation";
			PostOutput(output, TRUE);
			return 0;
		}
	}
	CommandLine.Empty();
	CommandLine = gccpath;
	CommandLine += " -o ";
	CommandLine += info->Output;
	CommandLine += " ";
	for (i = 0; i < info->numfiles; i++)
	{
		CommandLine += CToObj(info->files[i], info->WorkingDir);
		CommandLine += " ";
	}
	for (i = 0; i < info->numlibs; i++)
	{
		CommandLine += "-l";
		CommandLine += info->libs[i];
		CommandLine += " ";
	}
	output = "Linking project with command line of:";
	PostOutput(output, FALSE);
	output = CommandLine;
	PostOutput(output, FALSE);
	threadhandle = 
		ForkChildProcess(CommandLine.GetBuffer(20000),&inp,&out,&err, TRUE);
	WaitForSingleObject(threadhandle, INFINITE);
	PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
	if (number == 0)
	{
		output = "No warnings or errors recieved from gcc";
		PostOutput(output, TRUE);
	}
	else
	{
		output = "Link errors:";
		PostOutput(output, TRUE);
		ReadFile(err, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	output = "Ending Compilation";
	PostOutput(output, TRUE);
	delete buildinfo;
	return 1;
}

CString CToObj(CString source, CString workingdir)
{
	int extenlength, filelength, i;
	CString str2;
	if (source.IsEmpty())
		return source;
	for(i=0; i < source.GetLength(); i++)
	{
		if (source.GetAt(i) == '.')
			extenlength = source.GetLength() - (i + 1);
	}
	CString str('x', source.GetLength() - extenlength + 1);
	for (i = 0; i < str.GetLength(); i++)
		str.SetAt(i, source.GetAt(i));
	str.SetAt(str.GetLength() - 1, 'o');
	for (i = 0; i < str.GetLength(); i++)
	{
		if (str.GetAt(i) == '\\' || str.GetAt(i) == ':')
			filelength = str.GetLength() - (i + 1);
	}
	str2 = str.Right(filelength);
	workingdir += str2;
	return workingdir;
}

void CProjectView::OnProjectBuildproject() 
{
	BUILDINFO *info = new BUILDINFO;
	int i, extenlength;
	CProjectDoc *d = (CProjectDoc *)GetDocument();
	if (d->GetPathName().IsEmpty())
	{
		AfxMessageBox("Please save the project before continuing");
		return;
	}
	if (d->numfiles == 0)
	{
		AfxMessageBox("there are no files in the project");
		return;
	}
	for (i = 0; i < d->numfiles; i++)
		info->files[i] = d->files[i];
	for (i = 0; i < d->numlibs; i++)
		info->libs[i] = d->libs[i];
	info->numlibs = d->numlibs;
	info->numfiles = d->numfiles;
	info->Ansi = d->m_Ansi;
	info->E = d->m_E;
	info->GenDebug = d->m_GenDebug;
	info->Language = d->m_Language;
	info->NoAsm = d->m_NoAsm;
	info->Optimize = d->m_Optimize;
	info->Other = d->m_Other;
	if (d->m_Output.IsEmpty())
	{
		for(i=0; i < d->GetPathName().GetLength(); i++)
		{
			if (d->GetPathName().GetAt(i) == '.')
				extenlength = d->GetPathName().GetLength() - (i + 1);
		}
		CString str('x', (3 - extenlength));
		info->Output = d->GetPathName() + str;
		info->Output.SetAt(info->Output.GetLength() - 3, 'e');
		info->Output.SetAt(info->Output.GetLength() - 2, 'x');
		info->Output.SetAt(info->Output.GetLength() - 1, 'e');
	}
	else
		info->Output = d->m_Output;
	CMainFrame *frame;
	frame = (CMainFrame *)AfxGetMainWnd();
	frame->lastrun = info->Output;
	info->S = d->m_S;
	info->Traditional = d->m_Traditional;
	info->Warning = d->m_Warning;
	info->WorkingDir = d->GetPathName().Left(d->GetPathName().GetLength() - 
		d->GetTitle().GetLength());
	AfxBeginThread(BuildProc, info);
}

UINT BuildProc(LPVOID buildinfo)
{
	struct _stat filestatus, filestatus2;
	int result;
	HANDLE inp, out, err, threadhandle;
	char buffer[5000];
	DWORD number;
	BUILDINFO *info = (BUILDINFO *)buildinfo;
	int i;
	BOOL outofdate = FALSE;
	CString CommandLine;
	CString output, temp;
	if (clear)
		GlobalMessageView->Reset();
	output = "Beginning compilation of project...";
	PostOutput(output, TRUE);
	for (i = 0; i < info->numfiles; i++)
	{
		_stat(info->files[i].GetBuffer(500), &filestatus);
		result = _stat(CToObj(info->files[i], info->WorkingDir).GetBuffer(500),
			&filestatus2);
		if (result == -1 || filestatus.st_mtime > filestatus2.st_mtime)
		{
			outofdate = TRUE;
			memset(buffer, '\0', 4000);
			CommandLine.Empty();
			CommandLine = gccpath;
			CommandLine += " -c ";
			CommandLine += info->files[i];
			CommandLine += " ";
			if (info->GenDebug == TRUE)
				CommandLine += "-g ";
			if (info->Ansi == TRUE)
				CommandLine += "-ansi ";
			if (info->NoAsm == TRUE)
				CommandLine += "-fno-asm ";
			if (info->Traditional == TRUE)
				CommandLine += "-traditional ";
			if (info->S == TRUE)
				CommandLine += "-S ";
			if (info->E == TRUE)
				CommandLine += "-E ";
			switch (info->Optimize)
			{
			case 1:
				CommandLine += "-O1 ";
				break;
			case 2:
				CommandLine += "-O2 ";
				break;
			case 3:
				CommandLine += "-O3 ";
				break;
			default:
				break;
			}
			switch (info->Language)
			{
			case 1:
				CommandLine += "-x c ";
				break;
			case 2:
				CommandLine += "-x objective-c ";
				break;
			case 3:
				CommandLine += "-x c++ ";
				break;
			case 4:
				CommandLine += "-x c-header ";
				break;
			case 5:
				CommandLine += "-x cpp-output ";
				break;
			case 6:
				CommandLine += "-x c++-cpp-output ";
				break;
			case 7:
				CommandLine += "-x assembler ";
				break;
			case 8:
				CommandLine += "-x assembler-with-cpp ";
				break;
			default:
				break;
			}
			switch (info->Warning)
			{
			case 1:
				CommandLine += "-w ";
				break;
			case 2:
				CommandLine += "-Wall ";
				break;
			case 3:
				CommandLine += "-W ";
				break;
			case 4:
				CommandLine += "-Werror ";
				break;
			default:
				break;
			}
			if (!info->Other.IsEmpty())
			{
				CommandLine += info->Other;
				CommandLine += " ";
			}
			output = "compiling ";
			output += info->files[i];
			output += " with command line of:";
			PostOutput(output, FALSE);
			output = CommandLine;
			PostOutput(output, FALSE);
			threadhandle = 
				ForkChildProcess(CommandLine.GetBuffer(20000),&inp,&out,&err,TRUE);
			WaitForSingleObject(threadhandle, INFINITE);
			PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
			if (number == 0)
			{
				output = "No warnings or errors recieved from gcc";
				PostOutput(output, TRUE);
			}
			else
			{
				output = "Errors:";
				PostOutput(output, TRUE);
				ReadFile(err, buffer, 4000, &number, NULL);
				temp = buffer;
				while (1)
				{
					if (temp.Find('\n') != -1)
					{
						output = temp.Left(temp.Find('\n') - 1);
						temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
						PostOutput(output, FALSE);
						if (temp.Find('\n') == -1)
						{
							PostOutput(temp, FALSE);
							break;
						}
					}
					else
					{
						PostOutput(temp, FALSE);
						break;
					}
				}
			}
		}
	}
	memset(buffer, '\0', 4000);
	struct _stat status;
	struct _stat status2;
	for (i = 0; i < info->numfiles; i++)
	{
		_stat(info->files[i].GetBuffer(500), &status);
		if (_stat(CToObj(info->files[i], info->WorkingDir).GetBuffer(500),
			&status2) == -1)
		{
			delete buildinfo;
			output = "Ending Compilation";
			PostOutput(output, TRUE);
			return 0;
		}
		if (status.st_mtime > status2.st_mtime)
		{
			delete buildinfo;
			output = "Ending Compilation";
			PostOutput(output, TRUE);
			return 0;
		}
	}
	CommandLine.Empty();
	CommandLine = gccpath;
	CommandLine += " -o ";
	CommandLine += info->Output;
	CommandLine += " ";
	for (i = 0; i < info->numfiles; i++)
	{
		CommandLine += CToObj(info->files[i], info->WorkingDir);
		CommandLine += " ";
	}
	for (i = 0; i < info->numlibs; i++)
	{
		CommandLine += "-l";
		CommandLine += info->libs[i];
		CommandLine += " ";
	}
	output = "Linking project with command line of:";
	PostOutput(output, FALSE);
	output = CommandLine;
	PostOutput(output, FALSE);
	threadhandle = 
		ForkChildProcess(CommandLine.GetBuffer(20000),&inp,&out,&err, TRUE);
	WaitForSingleObject(threadhandle, INFINITE);
	PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
	if (number == 0)
	{
		output = "No warnings or errors recieved from gcc";
		PostOutput(output, TRUE);
	}
	else
	{
		output = "Link errors:";
		PostOutput(output, TRUE);
		ReadFile(err, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	output = "Ending Compilation";
	PostOutput(output, TRUE);
	delete buildinfo;
	return 1;
}

void CProjectView::OnDblclkSourceList() 
{
	CListBox *list = (CListBox *)GetDlgItem(IDC_SOURCE_LIST);
	int index = list->GetCurSel();
	CString szFile;
	list->GetText(index, szFile);
	AfxGetApp()->OpenDocumentFile(szFile);
}


void CProjectView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit(FALSE);
}

void CProjectView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	GetParentFrame()->ActivateFrame();
	CMenu menu;
	if (menu.LoadMenu(IDR_PROJECTPOP_MENU))
	{
		CMenu* pPopup = menu.GetSubMenu(0);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,point.x, point.y,
			AfxGetMainWnd());
	}	
}

void CProjectView::OnProjectExportasmakefile() 
{
	FILE *makefile;
	CString output;
	CString exename, preexename;
	CString file;
	CString CommandLine;
	CString temp1, temp2;
	int i;
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	CString filename(doc->GetPathName());
	if (filename.IsEmpty())
	{
		AfxMessageBox("Please save the project before continuing");
		return;
	}
	CString title(doc->GetTitle());
	filename = filename.Left(filename.GetLength() - 
		title.GetLength());
	filename += "Makefile";
	CMainFrame *frame;
	frame = (CMainFrame *)AfxGetMainWnd();
	frame->lastmake = filename;
	makefile = fopen(filename.GetBuffer(500), "w");
	if (makefile == NULL)
	{
		output = "Makefile could not be created";
		PostOutput(output, TRUE);
		return;
	}
	fprintf(makefile,"#   Makefile exported by DFE version 3.2\n");
	fprintf(makefile,"#   Copyright 1998 All Rights Reserved\n\n");
	// do the total .exe target
	if (doc->m_Output.IsEmpty())
	{
		exename = doc->GetPathName();
		exename.SetAt(exename.GetLength() - 3, 'e');
		exename.SetAt(exename.GetLength() - 2, 'x');
		exename.SetAt(exename.GetLength() - 1, 'e');
	}
	else
		exename = doc->m_Output;
	preexename = exename;
	DoubleSlash(exename);
	fprintf(makefile, "%s: ", exename.GetBuffer(500));
	for (i = 0; i < doc->numfiles; i++)
	{
		file = CToObj(doc->files[i], WorkingDir(doc->files[i]));
		DoubleSlash(file);
		fprintf(makefile, "%s ", file.GetBuffer(500)); 
	}
	fprintf(makefile, "\n");
	CommandLine = gccpath;
	CommandLine += " -o ";
	CommandLine += preexename;
	CommandLine += " ";
	for (i = 0; i < doc->numfiles; i++)
	{
		CommandLine += CToObj(doc->files[i], WorkingDir(doc->files[i]));
		CommandLine += " ";
	}
	for (i = 0; i < doc->numlibs; i++)
	{
		CommandLine += "-l";
		CommandLine += doc->libs[i];
		CommandLine += " ";
	}
	DoubleSlash(CommandLine);
	fprintf(makefile, "\t%s\n", CommandLine.GetBuffer(20000));
	// now for each file build the .o
	for (i = 0; i < doc->numfiles; i++)
	{
		temp1 = CToObj(doc->files[i], WorkingDir(doc->files[i]));
		temp2 = doc->files[i];
		DoubleSlash(temp1);
		DoubleSlash(temp2);
		fprintf(makefile, "%s: %s\n",temp1.GetBuffer(500),temp2.GetBuffer(500));
		file = MakeCommandLine(doc->files[i], doc->m_GenDebug, doc->m_Ansi,
			doc->m_NoAsm, doc->m_Traditional, doc->m_S, doc->m_E, 
			doc->m_Optimize, doc->m_Language, doc->m_Warning, doc->m_Other);
		DoubleSlash(file);
		fprintf(makefile, "\t%s\n", file.GetBuffer(500));
	}
	fclose(makefile);
	output = "Wrote file ";
	output += filename;
	output += " successfully";
	PostOutput(output, TRUE);
}

void CProjectView::OnCommandsMake() 
{
	CMakeDialog dlg;
	dlg.DoModal();
}

CString WorkingDir(CString str)
{
	int i;
	int lastslash = 0;
	CString val;
	for (i = 0; i < str.GetLength(); i++)
	{
		if (str.GetAt(i) == '\\' || str.GetAt(i) == ':')
			lastslash = i;
	}
	lastslash++;
	val = str.Left(lastslash);
	return val;
}

CString MakeCommandLine(CString file, int GenDebug, int Ansi, int NoAsm,
						int Traditional, int S, int E, int Optimize,
						int Language, int Warning, CString Other)
{
	CString CommandLine;
	CommandLine = gccpath;
	CommandLine += " -c ";
	CommandLine += file;
	CommandLine += " ";
	if (GenDebug == TRUE)
		CommandLine += "-g ";
	if (Ansi == TRUE)
		CommandLine += "-ansi ";
	if (NoAsm == TRUE)
		CommandLine += "-fno-asm ";
	if (Traditional == TRUE)
		CommandLine += "-traditional ";
	if (S == TRUE)
		CommandLine += "-S ";
	if (E == TRUE)
		CommandLine += "-E ";
	switch (Optimize)
	{
	case 1:
		CommandLine += "-O1 ";
		break;
	case 2:
		CommandLine += "-O2 ";
		break;
	case 3:
		CommandLine += "-O3 ";
		break;
	default:
		break;
	}
	switch (Language)
	{
	case 1:
		CommandLine += "-x c ";
		break;
	case 2:
		CommandLine += "-x objective-c ";
		break;
	case 3:
		CommandLine += "-x c++ ";
		break;
	case 4:
		CommandLine += "-x c-header ";
		break;
	case 5:
		CommandLine += "-x cpp-output ";
		break;
	case 6:
		CommandLine += "-x c++-cpp-output ";
		break;
	case 7:
		CommandLine += "-x assembler ";
		break;
	case 8:
		CommandLine += "-x assembler-with-cpp ";
		break;
	default:
		break;
	}
	switch (Warning)
	{
	case 1:
		CommandLine += "-w ";
		break;
	case 2:
		CommandLine += "-Wall ";
		break;
	case 3:
		CommandLine += "-W ";
		break;
	case 4:
		CommandLine += "-Werror ";
		break;
	default:
		break;
	}
	if (!Other.IsEmpty())
	{
		CommandLine += Other;
		CommandLine += " ";
	}
	return CommandLine;
}

void DoubleSlash(CString &string)
{
	int i;
	for (i = 0; i < string.GetLength(); i++)
	{
		if (string.GetAt(i) == '\\')
			string.SetAt(i, '/');
	}
}

void CProjectView::OnProjectExportandmake() 
{
	FILE *makefile;
	CString output;
	CString exename, preexename;
	CString file;
	CString CommandLine;
	CString temp1, temp2;
	int i;
	CProjectDoc *doc = (CProjectDoc *)GetDocument();
	CString filename(doc->GetPathName());
	if (filename.IsEmpty())
	{
		AfxMessageBox("Please save the project before continuing");
		return;
	}
	CString title(doc->GetTitle());
	filename = filename.Left(filename.GetLength() - 
		title.GetLength());
	filename += "Makefile";
	CMainFrame *frame;
	frame = (CMainFrame *)AfxGetMainWnd();
	frame->lastmake = filename;
	makefile = fopen(filename.GetBuffer(500), "w");
	if (makefile == NULL)
	{
		output = "Makefile could not be created";
		PostOutput(output, TRUE);
		return;
	}
	fprintf(makefile,"#   Makefile exported by DFE version 3.2\n");
	fprintf(makefile,"#   Copyright 1998 All Rights Reserved\n\n");
	// do the total .exe target
	if (doc->m_Output.IsEmpty())
	{
		exename = doc->GetPathName();
		exename.SetAt(exename.GetLength() - 3, 'e');
		exename.SetAt(exename.GetLength() - 2, 'x');
		exename.SetAt(exename.GetLength() - 1, 'e');
	}
	else
		exename = doc->m_Output;
	preexename = exename;
	DoubleSlash(exename);
	fprintf(makefile, "%s: ", exename.GetBuffer(500));
	for (i = 0; i < doc->numfiles; i++)
	{
		file = CToObj(doc->files[i], WorkingDir(doc->files[i]));
		DoubleSlash(file);
		fprintf(makefile, "%s ", file.GetBuffer(500)); 
	}
	fprintf(makefile, "\n");
	CommandLine = gccpath;
	CommandLine += " -o ";
	CommandLine += preexename;
	CommandLine += " ";
	for (i = 0; i < doc->numfiles; i++)
	{
		CommandLine += CToObj(doc->files[i], WorkingDir(doc->files[i]));
		CommandLine += " ";
	}
	for (i = 0; i < doc->numlibs; i++)
	{
		CommandLine += "-l";
		CommandLine += doc->libs[i];
		CommandLine += " ";
	}
	DoubleSlash(CommandLine);
	fprintf(makefile, "\t%s\n", CommandLine.GetBuffer(20000));
	// now for each file build the .o
	for (i = 0; i < doc->numfiles; i++)
	{
		temp1 = CToObj(doc->files[i], WorkingDir(doc->files[i]));
		temp2 = doc->files[i];
		DoubleSlash(temp1);
		DoubleSlash(temp2);
		fprintf(makefile, "%s: %s\n",temp1.GetBuffer(500),temp2.GetBuffer(500));
		file = MakeCommandLine(doc->files[i], doc->m_GenDebug, doc->m_Ansi,
			doc->m_NoAsm, doc->m_Traditional, doc->m_S, doc->m_E, 
			doc->m_Optimize, doc->m_Language, doc->m_Warning, doc->m_Other);
		DoubleSlash(file);
		fprintf(makefile, "\t%s\n", file.GetBuffer(500));
	}
	fclose(makefile);
	if (clear)
		GlobalMessageView->Reset();
	output = "Wrote file ";
	output += filename;
	output += " successfully";
	PostOutput(output, TRUE);
	// now make the damn file
	CString *makedir = new CString; 
	*makedir = WorkingDir(doc->GetPathName());
	AfxBeginThread(MakeProc, makedir);
}

UINT MakeProc(LPVOID makedir)
{
	CString *dir = (CString *)makedir;
	_chdir(dir->GetBuffer(500));
	CString output, temp;
	char buffer[5000];
	memset(buffer, '\0', 4000);
	HANDLE threadhandle, inp, out, err;
	DWORD number;
	threadhandle = 
		ForkChildProcess(NULL,&inp,&out,&err, FALSE);
	WaitForSingleObject(threadhandle, INFINITE);
	PeekNamedPipe(out,NULL,NULL,NULL,&number,NULL);
	if (number != 0)
	{
		output = "Output from make:";
		PostOutput(output, TRUE);
		ReadFile(out, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	memset(buffer, '\0', 4000);
	PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
	if (number == 0)
	{
		output = "No errors recieved from make";
		PostOutput(output, TRUE);
	}
	else
	{
		output = "Errors recieved from make:";
		PostOutput(output, TRUE);
		ReadFile(err, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	output = "Ending make";
	PostOutput(output, TRUE);
	delete makedir;
	return TRUE; 
}