// DFE32View.cpp : implementation of the CDFE32View class
//

#include "stdafx.h"
#include "DFE32.h"

#include "DFE32Doc.h"
#include "DFE32View.h"
#include "gotolinedialog.h"
#include "linkdialog.h"
#include "rundialog.h"
#include "debugdialog.h"
#include "sourcebuilddialog.h"
#include "extern.h"
#include "messageview.h"
#include "postmessage.h"
#include "fork.h"
#include "makedialog.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDFE32View

IMPLEMENT_DYNCREATE(CDFE32View, CEditView)

BEGIN_MESSAGE_MAP(CDFE32View, CEditView)
	//{{AFX_MSG_MAP(CDFE32View)
	ON_WM_CHAR()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_POPUP_DELETE, OnPopupDelete)
	ON_COMMAND(ID_POPUP_SELECTALL, OnPopupSelectall)
	ON_COMMAND(ID_POPUP_INSERTSTATEMENT_IF, OnPopupInsertstatementIf)
	ON_COMMAND(ID_POPUP_INSERTSTATEMENT_IFELSE, OnPopupInsertstatementIfelse)
	ON_COMMAND(ID_POPUP_INSERTSTATEMENT_WHILE, OnPopupInsertstatementWhile)
	ON_COMMAND(ID_POPUP_INSERTSTATEMENT_DOWHILE, OnPopupInsertstatementDowhile)
	ON_COMMAND(ID_POPUP_INSERTSTATEMENT_FOR, OnPopupInsertstatementFor)
	ON_COMMAND(ID_POPUP_INSERTSTATEMENT_SWITCH, OnPopupInsertstatementSwitch)
	ON_COMMAND(ID_POPUP_COMMENT, OnPopupComment)
	ON_COMMAND(ID_POPUP_GOTOLINE, OnPopupGotoline)
	ON_COMMAND(ID_SEARCH_FIND, OnSearchFind)
	ON_COMMAND(ID_SEARCH_FINDANDREPLACE, OnSearchFindandreplace)
	ON_COMMAND(ID_COMMANDS_LINK, OnCommandsLink)
	ON_COMMAND(ID_COMMANDS_RUN, OnCommandsRun)
	ON_COMMAND(ID_COMMANDS_MAKE, OnCommandsMake)
	ON_COMMAND(ID_COMMANDS_DEBUG, OnCommandsDebug)
	ON_COMMAND(ID_SOURCE_BUILDSOURCE, OnSourceBuildsource)
	ON_COMMAND(ID_SOURCE_QUICKCOMPILETOOBJECT, OnSourceQuickcompiletoobject)
	ON_COMMAND(ID_EDIT_INSERTDATETIME, OnEditInsertdatetime)
	ON_COMMAND(ID_EDIT_INSERTDATE, OnEditInsertdate)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CEditView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDFE32View construction/destruction

CDFE32View::CDFE32View()
{
		m_Ansi = FALSE;
		m_NoAsm = FALSE;
		m_Aout = 1;
		m_Traditional = FALSE;
		m_Optimize = 0;
		m_S = FALSE;
		m_E = FALSE;
		m_Language = 0;
		m_Warning = 0;
		m_Other.Empty();
		numlibs = 0;
		m_GenDebug = debugdefault;
}

CDFE32View::~CDFE32View()
{
}

BOOL CDFE32View::PreCreateWindow(CREATESTRUCT& cs)
{
	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CDFE32View drawing

void CDFE32View::OnDraw(CDC* pDC)
{
	CDFE32Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

}

/////////////////////////////////////////////////////////////////////////////
// CDFE32View printing

BOOL CDFE32View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default CEditView preparation
	return CEditView::OnPreparePrinting(pInfo);
}

void CDFE32View::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView begin printing.
	CEditView::OnBeginPrinting(pDC, pInfo);
}

void CDFE32View::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView end printing
	CEditView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CDFE32View diagnostics

#ifdef _DEBUG
void CDFE32View::AssertValid() const
{
	CEditView::AssertValid();
}

void CDFE32View::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CDFE32Doc* CDFE32View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDFE32Doc)));
	return (CDFE32Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDFE32View message handlers

void CDFE32View::OnInitialUpdate() 
{
	CEditView::OnInitialUpdate();

	if (currfont->GetSafeHandle() == NULL)
	{
		CFont font;
		font.CreateStockObject(ANSI_FIXED_FONT);
		SetFont(&font);
	}
	else
	{
		SetFont(currfont);
	}
	SetTabStops(16);
}

void CDFE32View::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CEditView::OnChar(nChar, nRepCnt, nFlags);
	// just some code to make the auto-indenting work
	if (indent == TRUE)
	{
		int start, end;
		int currline;
		CString lastchar;
		CString firstchar;
		CEdit &edit = GetEditCtrl();
		currline = edit.LineFromChar();
		if (13 == nChar) // if the user pressed enter, its time to party
		{
			edit.GetSel(start, end);
			edit.SetSel(start - 3, start - 2);
			GetSelectedText(lastchar);
			edit.SetSel(edit.LineIndex(currline - 1),
			edit.LineIndex(currline - 1) + 1);
			GetSelectedText(firstchar);
			edit.SetSel(start, end);
			if (!lastchar.Compare(";") || !lastchar.Compare("}") ||
				!lastchar.Compare(" ") || !lastchar.Compare("\t") ||
				!lastchar.Compare("\n") ||  !lastchar.Compare("") ||
				!firstchar.Compare("#") || !firstchar.Compare("/"))
				SetTabsCurr(GetTabsIn(currline - 1));
			else
				SetTabsCurr(GetTabsIn(currline - 1) + 1);
		}
		if (125 == nChar || 123 == nChar) // { or }
			SetTabsCurr(GetTabsIn(currline) - 1);
	}
}

void CDFE32View::SetTabsCurr(int nooftabs)
{
	CEdit &edit = GetEditCtrl();
	int start, end;
	int tabsinline, subtabs;
	int currline = edit.LineFromChar();
	tabsinline = GetTabsIn(currline);
	if (nooftabs < 0)
		return;
	if (tabsinline == nooftabs)
		return;
	if (nooftabs > tabsinline)
	{
		edit.GetSel(start, end);
		edit.SetSel(edit.LineIndex(currline),edit.LineIndex(currline));
		CString str('\t',nooftabs - tabsinline);
		edit.ReplaceSel(str.GetBuffer(256));
		edit.SetSel(start+(nooftabs-tabsinline), end + (nooftabs-tabsinline));
	}
	else
	{
		edit.GetSel(start, end);
		subtabs = tabsinline - nooftabs;
		edit.SetSel(edit.LineIndex(currline), 
		edit.LineIndex(currline) + subtabs);
		edit.ReplaceSel("");
		edit.SetSel(start - subtabs, end - subtabs);
	}	
}

int CDFE32View::GetTabsIn(int lineno)
{
	CEdit &edit = GetEditCtrl();
	CString text;
	int start, end;
	int sel;
	int numtabs = 0;
	edit.GetSel(start, end);
	sel = edit.LineIndex(lineno);
	while (1)
	{
	edit.SetSel(sel + numtabs, sel + numtabs + 1);
	GetSelectedText(text);
	if (!text.Compare("\t"))
		numtabs++;
	else
		break;
	}
	edit.SetSel(start, end);
	return numtabs;
}

void CDFE32View::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	GetParentFrame()->ActivateFrame();
	CMenu menu;
	if (menu.LoadMenu(IDR_POPUP_MENU))
	{
		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,point.x, point.y,
			AfxGetMainWnd());
	}
}

void CDFE32View::OnPopupDelete() 
{
	GetEditCtrl().ReplaceSel("");
}

void CDFE32View::OnPopupSelectall() 
{
	GetEditCtrl().SetSel(0,-1);
}

void CDFE32View::OnPopupInsertstatementIf() 
{
	CEdit &edit = GetEditCtrl();
	int currtabs = GetTabsIn(edit.LineFromChar());
	int place;
	int start, end;
	CString str('\t', currtabs);
	CString replaceStr("if ()\r\n" + str + "{\r\n" + str + "\t\r\n" + str
		+ "}\r\n" + str);
	edit.ReplaceSel(replaceStr);
	edit.GetSel(start, end);
	place = start - (12 + currtabs * 4);
	edit.SetSel(place, place);
}

void CDFE32View::OnPopupInsertstatementIfelse() 
{
	CEdit &edit = GetEditCtrl();
	int currtabs = GetTabsIn(edit.LineFromChar());
	int place;
	int start, end;
	CString str('\t', currtabs);
	CString replaceStr("if ()\r\n" + str + "{\r\n" + str + "\t\r\n" + str
		+ "}\r\n" + str + "else\r\n" + str + "{\r\n" + str + "\t\r\n" + str
		+ "}\r\n" + str);
	edit.ReplaceSel(replaceStr);
	edit.GetSel(start, end);
	place = start - (27 + currtabs * 8);
	edit.SetSel(place, place);
}

void CDFE32View::OnPopupInsertstatementWhile() 
{
	CEdit &edit = GetEditCtrl();
	int currtabs = GetTabsIn(edit.LineFromChar());
	int place;
	int start, end;
	CString str('\t', currtabs);
	CString replaceStr("while ()\r\n" + str + "{\r\n" + str + "\t\r\n" + str
		+ "}\r\n" + str);
	edit.ReplaceSel(replaceStr);
	edit.GetSel(start, end);
	place = start - (12 + currtabs * 4);
	edit.SetSel(place, place);
}

void CDFE32View::OnPopupInsertstatementDowhile() 
{
	CEdit &edit = GetEditCtrl();
	int currtabs = GetTabsIn(edit.LineFromChar());
	int place;
	int start, end;
	CString str('\t', currtabs);
	CString replaceStr("do\r\n" + str + "{\r\n" + str + "\t\r\n" + str
		+ "} while ();\r\n" + str);
	edit.ReplaceSel(replaceStr);
	edit.GetSel(start, end);
	place = start - (4 + currtabs);
	edit.SetSel(place, place);
}

void CDFE32View::OnPopupInsertstatementFor() 
{
	CEdit &edit = GetEditCtrl();
	int currtabs = GetTabsIn(edit.LineFromChar());
	int place;
	int start, end;
	CString str('\t', currtabs);
	CString replaceStr("for (;;)\r\n" + str + "{\r\n" + str + "\t\r\n" + str
		+ "}\r\n" + str);
	edit.ReplaceSel(replaceStr);
	edit.GetSel(start, end);
	place = start - (14 + currtabs * 4);
	edit.SetSel(place, place);
}

void CDFE32View::OnPopupInsertstatementSwitch() 
{
	CEdit &edit = GetEditCtrl();
	int currtabs = GetTabsIn(edit.LineFromChar());
	int place;
	int start, end;
	CString str('\t', currtabs);
	CString replaceStr("switch ()\r\n" + str + "{\r\n" + str + "case :\r\n"
		+ str + "\r\n" + str + "default :\r\n\r\n" + str + "}\r\n" + str);
	edit.ReplaceSel(replaceStr);
	edit.GetSel(start, end);
	place = start - (32 + currtabs * 6);
	edit.SetSel(place, place);
}

void CDFE32View::OnPopupComment() 
{
	int start, end;
	CEdit &edit = GetEditCtrl();
	edit.GetSel(start, end);
	if (start == end)
		return;
	edit.SetSel(end, end);
	edit.ReplaceSel("*/");
	edit.SetSel(start, start);
	edit.ReplaceSel("/*");
}

void CDFE32View::OnPopupGotoline() 
{
	CGotolineDialog dlg;
	CEdit &edit = GetEditCtrl();
	int lineno;
	if (dlg.DoModal() == IDOK)
	{
		lineno = atoi(dlg.m_Edit.GetBuffer(256));
		if (edit.LineIndex(lineno < 0))
		{
			edit.SetSel(edit.LineIndex(0), edit.LineIndex(0));
		}
		else if (edit.LineIndex(lineno) == -1)
		{
			edit.SetSel(edit.LineIndex(edit.GetLineCount() - 1), 
				edit.LineIndex(edit.GetLineCount() - 1));
		}
		else
			edit.SetSel(edit.LineIndex(lineno - 1), edit.LineIndex(lineno - 1));
	}
}


void CDFE32View::OnSearchFind() 
{
	CFindReplaceDialog *dlg = new CFindReplaceDialog;
	dlg->Create(TRUE, NULL, NULL, FR_DOWN,(CWnd *)this);
}

void CDFE32View::OnSearchFindandreplace() 
{
	CFindReplaceDialog *dlg = new CFindReplaceDialog;
	dlg->Create(FALSE, NULL, NULL, FR_DOWN,(CWnd *)this);	
}

void CDFE32View::OnCommandsLink() 
{
	int i;
	int extenlength = 0;
	CLinkDialog dialog;
	dialog.filename = GetDocument()->GetPathName();
	if (!dialog.filename.IsEmpty())
	{
		for(i=0; i < dialog.filename.GetLength(); i++)
		{
			if (dialog.filename.GetAt(i) == '.')
				extenlength = dialog.filename.GetLength() - (i + 1);
		}
		dialog.extension = dialog.filename.Right(extenlength);
	}
	dialog.DoModal();
}

void CDFE32View::OnCommandsRun() 
{
	CRunDialog dlg;
	dlg.DoModal();
}

void CDFE32View::OnCommandsMake() 
{
	CMakeDialog dlg;
	dlg.DoModal();
}

void CDFE32View::OnCommandsDebug() 
{
	CDebugDialog dlg;
	dlg.DoModal();
}

void CDFE32View::OnSourceBuildsource() 
{
	int i;
	int extenlength = 0;
	CSourceBuildDialog dlg;
	dlg.filename = GetDocument()->GetPathName();
	dlg.m_Aout = m_Aout;
	dlg.m_GenDebug = m_GenDebug;
	dlg.numlibs = numlibs;
	for (i = 0; i < numlibs; i ++)
		dlg.libs[i] = libs[i];
	dlg.m_Ansi = m_Ansi;
	dlg.m_E = m_E;
	dlg.m_Language = m_Language;
	dlg.m_NoAsm = m_NoAsm;
	dlg.m_Optimize = m_Optimize;
	dlg.m_Other = m_Other;
	dlg.m_S = m_S;
	dlg.m_Traditional = m_Traditional;
	dlg.m_Warning = m_Warning;
	if (!dlg.filename.IsEmpty())
	{
		if (GetDocument()->IsModified())
		{
			GetDocument()->CanCloseFrame(GetParentFrame());
		}
		for(i=0; i < dlg.filename.GetLength(); i++)
		{
			if (dlg.filename.GetAt(i) == '.')
				extenlength = dlg.filename.GetLength() - (i + 1);
		}
		dlg.extension = dlg.filename.Right(extenlength);
		if (dlg.DoModal() == IDOK)
		{
			m_Aout = dlg.m_Aout;
			m_GenDebug = dlg.m_GenDebug;
			numlibs = dlg.numlibs;
			for (i = 0; i < numlibs; i ++)
				libs[i] = dlg.libs[i];
			m_Ansi = dlg.m_Ansi;
			m_E = dlg.m_E;
			m_Language = dlg.m_Language;
			m_NoAsm = dlg.m_NoAsm;
			m_Optimize = dlg.m_Optimize;
			m_Other = dlg.m_Other;
			m_S = dlg.m_S;
			m_Traditional = dlg.m_Traditional;
			m_Warning = dlg.m_Warning;
		}
	}
	else
		AfxMessageBox("Please save the file before Continuing");	
}

void CDFE32View::OnSourceQuickcompiletoobject() 
{
	HANDLE in, out, err, thread;
	DWORD number;
	CString output, temp;
	char buffer[5000];
	memset(buffer, '\0', 4500);
	if (!GetDocument()->GetPathName().IsEmpty())
	{
		if (GetDocument()->IsModified())
		{
			GetDocument()->CanCloseFrame(GetParentFrame());
		}
		CString str(gccpath);
		str += " ";
		str +=	GetDocument()->GetPathName();
		str += " -c ";
		if (m_GenDebug == TRUE)
			str += "-g ";
		if (m_Ansi == TRUE)
			str += "-ansi ";
		if (m_NoAsm == TRUE)
			str += "-fno-asm ";
		if (m_Traditional == TRUE)
			str += "-traditional ";
		switch (m_Optimize)
		{
		case 1:
			str += "-O1 ";
			break;
		case 2:
			str += "-O2 ";
			break;
		case 3:
			str += "-O3 ";
			break;
		default:
			break;
		}
		if (!m_Other.IsEmpty())
		{
			str += m_Other;
			str += " ";
		}
		if (m_S == TRUE)
			str += "-S ";
		if (m_E == TRUE)
			str += "-E ";
		switch (m_Language)
		{
		case 1:
			str += "-x c ";
			break;
		case 2:
			str += "-x objective-c ";
			break;
		case 3:
			str += "-x c++ ";
			break;
		case 4:
			str += "-x c-header ";
			break;
		case 5:
			str += "-x cpp-output ";
			break;
		case 6:
			str += "-x c++-cpp-output ";
			break;
		case 7:
			str += "-x assembler ";
			break;
		case 8:
			str += "-x assembler-with-cpp ";
			break;
		default:
			break;
		}
		switch (m_Warning)
		{
		case 1:
			str += "-w ";
			break;
		case 2:
			str += "-Wall ";
			break;
		case 3:
			str += "-W ";
			break;
		case 4:
			str += "-Werror ";
			break;
		default:
			break;
		}
		if (clear)
			GlobalMessageView->Reset();
		output = "Compiling ";
		output += GetDocument()->GetPathName();
		output += " with command line of:";
		PostOutput(output, FALSE);
		output = str;
		PostOutput(output, TRUE);
		thread = ForkChildProcess(str.GetBuffer(500), &in, &out, &err, TRUE);
		WaitForSingleObject(thread, INFINITE);
		PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
		if (number == 0)
		{
			output = "No warnings or errors recieved from gcc";
			PostOutput(output, TRUE);
		}
		else
		{
			output = "Errors:";
			PostOutput(output, TRUE);
			ReadFile(err, buffer, 4000, &number, NULL);
			temp = buffer;
			while (1)
			{
				if (temp.Find('\n') != -1)
				{
					output = temp.Left(temp.Find('\n') - 1);
					temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
					PostOutput(output, FALSE);
					if (temp.Find('\n') == -1)
					{
						PostOutput(temp, FALSE);
						break;
					}
				}
				else
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
		}
	}
	else
		AfxMessageBox("Please save the file before Continuing");	
}

void CDFE32View::OnEditInsertdatetime() 
{
	CTime t = CTime::GetCurrentTime();
	CEdit &edit = GetEditCtrl();
	edit.ReplaceSel(t.Format("%#x, %#I:%M %p"));
}

void CDFE32View::OnEditInsertdate() 
{
	CTime t = CTime::GetCurrentTime();
	CEdit &edit = GetEditCtrl();
	edit.ReplaceSel(t.Format("%#x"));	
}
