/* $Id: mksimm.c,v 1.2 2002/06/23 20:28:31 richdawe Exp $ */

/*
 *  mksimm.c - Make def_simm.c
 *  Copyright (C) 1999-2002 by Richard Dawe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

const char simtel_mirrors_copyright[] =
"/*\n"
" *  def_simm.c - Simtel.NET mirrors list for pakke\n"
" *  Copyright (C) 2002 by Richard Dawe\n"
" *\n"
" *  This program is free software; you can redistribute it and/or modify\n"
" *  it under the terms of the GNU General Public License as published by\n"
" *  the Free Software Foundation; either version 2 of the License, or\n"
" *  (at your option) any later version.\n"
" *\n"
" *  This program is distributed in the hope that it will be useful,\n"
" *  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
" *  GNU General Public License for more details.\n"
" *\n"
" *  You should have received a copy of the GNU General Public License\n"
" *  along with this program; if not, write to the Free Software\n"
" *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
" */\n";

/* ---------
 * - chomp -
 * --------- */

/* New-line removal, taken from ../libpakke/util.c */
void
chomp (char *str)
{
  char *p = NULL;
  if (str == NULL) return;
  for (p = str + strlen(str) - 1; (*p == '\n') || (*p == '\r'); p--) {
    *p = '\0';
  }
}

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  char *simtelrc_file;
  FILE *fp = NULL;
  char buf[1024];

  /* Get the simtelrc filename */
  if (argc < 2)
    return(EXIT_FAILURE);

  simtelrc_file = argv[1];

  /* Start the header */
  printf("%s\n"	 
	 "#include \"common.h\"\n\n"
	 "#include <string.h>\n\n"
	 "const char *simtel_mirrors[] = {\n",
	 simtel_mirrors_copyright);

  fp = fopen(simtelrc_file, "rt");
  if (fp == NULL)
    return(EXIT_FAILURE);

  while (fgets(buf, sizeof(buf), fp) != NULL) {
    chomp(buf);
    if (strlen(buf) == 0)
      continue;
    printf("\"%s\",\n", buf);
  }

  fclose(fp);

  printf("NULL\n};\n");

  return(EXIT_SUCCESS);
}
