/* Various Thresholds of MPFR, not exported.  -*- mode: C -*-

Copyright 2005, 2006, 2007, 2008, 2009, 2010, 2011 Free Software Foundation, Inc.

This file is part of the GNU MPFR Library.

The GNU MPFR Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The GNU MPFR Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MPFR Library; see the file COPYING.LESSER.  If not, see
http://www.gnu.org/licenses/ or write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA. */

#ifndef __MPFR_IMPL_H__
# error "MPFR Internal not included"
#endif

/* Note: the different macros used here are those defined by gcc,
   for example with gcc -dM -E -xc /dev/null
   As of gcc 4.2, you can also use: -march=native or -mtune=native */

/*****************************
 * Threshold for Pentium 4   *
 *****************************/
#if defined (__tune_pentium4__)

/* Generated by MPFR's tuneup.c, 2009-02-09, gcc 4.3 */
/* crumble.loria.fr with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,18,19,19,24,26,0,0,24,26,28,27,26,28, \
 30,32,32,32,30,30,34,34,32,34,34,36,32,34,36,34, \
 35,0,0,36,35,0,36,48,0,0,48,48,51,0,48,52, \
 51,0,52,52,51,55,52,56,55,0,56,60,59,59,60,64, \
 63,63,64,64,67,67,68,72,63,71,72,60,67,67,60,72, \
 63,61,64,64,63,71,68,68,71,67,68,68,67,71,68,72, \
 68,68,72,72,76,76,68,68,72,72,70,103,104,71,72,96, \
 103,94,95,104,96,96,94,103,104,104,96,96,103,103,104,104, \
 120,120,103,103,104,104,120,111,103,112,104,104,120,120,109,103, \
 119,119,120,120,127,112,128,128,120,120,136,127,128,128,120,126, \
 121,129,126,134,135,135,136,120,113,113,114,118,127,127,136,120, \
 121,125,126,118,119,119,120,136,121,153,122,122,127,119,120,128, \
 165,153,162,134,163,159,136,136,153,153,134,158,135,135,136,136, \
 153,153,162,158,159,159,156,152,153,189,158,186,187,163,156,168, \
 189,159,165,165,176,176,172,172,183,173,164,174,165,165,176,176, \
 177,177,183,188,189,189,180,185,176,186,177,177,193,188,189,189, \
 200,200,201,201,177,207,188,198,199,189,200,200,186,201,207,207, \
 213,203,189,189,200,210,201,196,212,207,208,213,189,199,200,200, \
 203,209,216,204,199,223,206,200,213,225,208,208,203,203,216,204, \
 205,205,224,212,213,213,184,208,209,203,198,210,199,187,206,200, \
 201,189,208,208,203,185,216,198,187,199,200,212,213,213,202,208, \
 203,197,198,198,199,211,212,212,285,213,280,274,227,275,288,204, \
 284,284,278,285,307,216,273,308,309,309,275,219,213,311,305,284, \
 306,306,307,307,308,308,309,309,303,303,311,311,284,312,285,285, \
 307,286,287,308,309,309,303,303,304,332,305,305,306,299,328,300, \
 308,301,309,309,303,310,311,311,333,305,285,285,307,314,308,308, \
 321,305,354,322,331,355,332,308,309,333,334,334,303,303,304,312, \
 305,305,306,306,307,307,308,308,309,309,302,302,375,311,312,360, \
 353,305,330,354,307,355,380,308,357,309,358,358,359,311,312,312, \
 345,329,378,354,331,355,356,356,357,357,374,334,375,311,336,384, \
 356,329,330,357,331,358,404,332,369,333,334,334,335,353,354,354, \
 355,382,356,347,357,357,358,358,377,359,405,333,352,379,353,353, \
 354,354,355,355,356,356,357,357,358,376,359,377,369,360,379,370, \
 380,380,354,372,355,382,383,401,357,357,376,358,377,377,405,378, \
 379,379,380,380,381,381,402,402,353,403,404,404,405,405,376,376, \
 377,357,368,358,379,379,360,400,401,381,372,452,373,383,454,384, \
 405,405,456,356,357,357,358,378,379,379,490,370,381,381,492,402, \
 463,403,404,404,405,405,456,456,527,357,448,448,489,449,400,450, \
 453,453,454,454,455,455,456,456,468,490,491,491,492,404,405,482, \
 472,450,451,462,463,463,464,453,465,465,455,455,456,489,490,490, \
 491,491,492,492,405,526,483,527,484,484,452,452,486,453,454,454, \
 455,477,456,522,490,490,491,524,481,492,526,482,483,527,495,517, \
 521,533,522,474,499,523,524,524,489,489,490,526,527,527,528,528, \
 529,529,518,554,495,483,496,472,521,557,486,522,535,535,524,512, \
 525,561,526,526,491,527,528,528,529,517,518,554,531,519,544,520, \
 521,521,558,546,559,535,560,536,489,573,490,514,491,563,492,492, \
 528,489,555,555,491,491,492,596,597,545,546,546,560,599,600,600, \
 523,562,563,511,564,525,526,630,553,527,528,528,607,555,595,543, \
 544,531,532,571,559,559,599,560,535,535,562,562,563,537,564,564, \
 565,630,514,631,528,632,555,542,634,595,557,557,597,558,559,559, \
 571,599,530,530,559,545,546,616,561,547,548,534,633,563,564,564, \
 607,537,594,636,567,539,624,554,555,555,598,598,557,557,558,572, \
 559,559,560,574,603,561,562,632,563,563,578,592,593,607,580,608, \
 553,609,624,596,597,597,598,612,627,585,600,614,573,629,616,602, \
 599,599,585,585,616,616,587,632,603,603,634,634,635,605,636,621, \
 622,607,623,593,609,609,625,610,611,626,612,597,628,598,599,599, \
 600,630,631,616,602,632,633,603,634,634,635,635,636,636,607,637, \
 668,608,609,609,610,610,611,611,597,657,628,628,629,629,630,630, \
 609,625,562,626,627,563,564,628,629,629,630,630,631,599,664,632, \
 681,633,634,634,635,635,620,636,621,621,622,622,623,639,672,592, \
 609,641,594,594,595,627,596,564,629,597,598,598,631,599,600,600, \
 601,681,618,634,603,635,636,636,557,621,622,606,623,623,608,608 \

#define MPFR_SQRHIGH_TAB  \
 -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,7,7,8,8, \
 9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,26,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,38,39,39,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,46,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,68,63,63,64,64, \
 65,68,66,69,67,67,71,68,69,75,76,76,71,71,72,72, \
 73,82,74,80,78,75,76,76,77,83,78,81,82,79,80,80, \
 81,81,82,85,83,83,84,84,85,85,86,86,87,87,88,88, \
 89,92,90,93,94,91,92,92,93,93,94,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,105,106,106,107,107,108,112,109,109,110,118,111,111,112,112, \
 113,113,114,122,123,115,116,116,117,117,118,118,119,119,120,120, \
 121,121,122,122,123,123,124,124,125,125,126,126,127,127,128,128, \
 129,154,135,130,131,131,132,132,133,133,134,134,135,140,151,136, \
 142,137,138,143,144,154,155,150,151,156,152,142,153,158,144,144, \
 165,145,146,146,152,162,148,148,149,149,150,150,151,171,152,152, \
 153,153,154,154,155,155,156,156,157,157,158,158,159,159,160,160, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168, \
 169,169,170,170,171,183,172,172,173,173,174,174,175,187,194,182, \
 183,177,178,178,179,179,180,180,181,181,182,182,195,183,184,184, \
 185,197,186,186,187,187,188,188,189,189,190,190,191,191,192,204, \
 207,200,201,208,209,195,196,203,204,197,198,198,199,199,200,200, \
 201,215,216,230,217,210,211,218,212,205,206,206,207,207,208,208, \
 209,230,231,231,232,225,226,226,227,227,228,242,222,257,216,216, \
 217,245,246,218,219,240,241,234,235,235,236,264,230,258,224,224, \
 225,225,226,226,227,227,228,260,261,229,230,270,247,231,232,232, \
 233,233,234,234,235,235,236,236,237,237,238,238,239,239,240,240, \
 241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,252,253,253,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,265,266,266,267,267,268,268,269,269,279,270,271,271,272,272, \
 273,273,274,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,294,285,286,286,287,287,288,288, \
 289,289,290,290,291,291,292,292,293,293,294,294,295,295,296,296, \
 297,297,298,298,299,299,300,300,301,301,302,302,303,303,304,304, \
 305,305,306,306,307,307,308,308,309,309,310,310,311,311,312,312, \
 313,313,314,314,315,315,316,316,317,317,318,318,319,319,320,320, \
 321,321,322,322,323,323,324,324,325,325,326,337,349,338,328,328, \
 329,329,330,330,331,331,332,332,333,333,334,334,335,335,336,336, \
 337,337,338,360,339,339,340,340,341,341,342,342,343,354,355,344, \
 345,345,368,368,369,369,359,348,393,382,383,361,362,362,363,363, \
 365,365,366,390,367,391,380,404,357,393,406,382,383,395,396,396, \
 385,409,386,410,387,399,388,412,413,401,390,366,367,403,404,416, \
 417,405,382,406,407,407,408,408,409,409,410,410,435,411,412,412, \
 413,413,414,378,439,427,428,392,393,441,442,430,479,455,444,432, \
 437,385,451,386,465,439,427,388,389,454,455,455,404,417,444,444, \
 393,393,394,446,460,460,461,487,410,475,398,476,477,464,400,465, \
 401,492,402,402,403,403,404,404,405,405,406,419,407,407,408,408, \
 409,409,410,410,411,411,412,412,413,413,414,414,415,415,416,416, \
 417,417,418,418,419,419,420,420,421,421,422,422,423,423,424,508, \
 425,425,426,426,427,427,428,428,429,429,430,430,431,431,432,432, \
 433,433,434,434,435,435,436,436,437,437,438,536,439,439,440,440, \
 441,441,442,442,443,443,444,444,445,445,446,446,447,447,448,476, \
 449,449,450,450,451,451,482,452,453,453,454,454,455,455,456,456, \
 457,457,458,458,459,459,460,460,461,461,462,462,463,463,464,464, \
 465,465,466,466,467,467,468,468,469,469,470,470,471,471,472,472, \
 473,473,474,474,475,475,476,476,477,477,478,478,479,479,480,480, \
 481,481,482,482,483,483,484,484,485,485,486,486,487,487,488,488, \
 489,489,490,490,491,491,492,492,493,493,494,494,495,495,496,496, \
 497,497,498,498,499,499,500,500,501,501,502,502,503,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,512 \

#define MPFR_MUL_THRESHOLD 8 /* limbs */
#define MPFR_EXP_2_THRESHOLD 519 /* bits */
#define MPFR_EXP_THRESHOLD 6533 /* bits */

/****************************
 * Threshold for Core 2     *
 ****************************/
#elif defined (__tune_core2__) && !defined (__i386) /* 64-bit Core 2 */

/* Generated by MPFR's tuneup.c, 2009-12-18, gcc 4.4.2 */
/* tarte.loria.fr with gmp-4.3.1 */

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,-1,-1,0,0,0,0,0,0,0,0,0,8,0, \
 9,10,10,10,11,12,12,12,13,14,15,16,18,18,18,18, \
 19,24,22,22,26,26,26,26,28,26,24,28,32,24,24,32, \
 26,34,26,30,30,28,36,40,38,40,40,32,34,34,39,36, \
 39,43,44,40,47,47,48,48,43,51,48,48,47,51,48,52, \
 55,55,48,48,55,59,60,52,51,51,52,64,51,53,56,56, \
 63,59,64,56,61,61,68,64,69,69,68,78,81,69,72,74, \
 69,75,74,74,69,81,78,78,81,81,78,78,81,81,78,90, \
 86,80,90,90,88,91,83,86,90,90,85,88,89,86,84,90, \
 100,91,92,89,90,90,88,85,104,98,99,90,109,115,92,116, \
 117,117,115,103,104,116,111,93,112,112,116,113,114,114,115,109, \
 110,128,129,117,109,115,116,116,129,129,112,112,128,134,129,129, \
 141,129,138,138,139,127,128,128,141,141,134,134,139,135,132,140, \
 141,141,134,134,135,139,140,140,141,141,162,162,151,151,140,140, \
 141,141,158,146,151,151,156,188,141,153,166,162,187,155,172,188, \
 161,181,186,158,159,171,164,164,165,165,170,182,179,179,184,180, \
 179,179,175,185,186,186,187,187,188,188,179,184,185,185,176,176, \
 187,182,188,188,204,179,180,200,186,186,187,212,218,188,204,184, \
 180,185,216,186,217,202,208,208,214,204,215,215,216,216,212,212, \
 218,218,219,204,215,215,216,216,217,217,218,188,214,219,220,220, \
 203,251,204,204,205,235,236,218,219,219,220,214,215,251,252,252, \
 217,217,218,236,219,219,220,220,233,269,252,252,235,259,272,260, \
 249,267,256,250,251,251,252,234,271,271,272,272,243,243,250,250, \
 251,251,270,252,271,271,272,272,243,249,250,250,251,251,252,270, \
 263,305,320,320,307,272,294,308,267,316,296,268,269,318,319,305, \
 320,271,272,272,294,294,295,316,317,282,318,318,305,312,313,306, \
 307,307,308,294,295,295,296,296,304,304,305,305,306,306,307,307, \
 308,308,316,316,317,317,318,318,319,305,320,320,307,314,315,308, \
 361,305,306,314,307,307,324,356,317,341,318,318,343,319,320,320, \
 361,305,362,306,347,315,340,332,365,365,366,366,367,319,368,320, \
 353,353,346,346,363,355,356,356,341,365,366,358,359,367,368,360, \
 353,353,354,362,363,363,348,348,341,365,358,366,343,343,368,368, \
 320,392,366,366,367,367,368,341,342,342,343,343,362,344,390,390, \
 391,355,392,356,366,366,367,367,368,368,360,342,343,343,344,416, \
 354,363,364,355,356,356,366,366,439,439,368,431,459,387,415,343, \
 344,416,363,462,355,364,392,437,366,366,367,367,368,359,360,450, \
 439,459,390,440,391,451,462,462,463,463,414,414,415,455,406,416, \
 457,447,458,438,439,439,440,440,391,461,462,462,463,413,414,464, \
 455,455,416,456,407,457,438,438,439,459,440,410,461,451,452,462, \
 463,433,464,444,415,415,416,416,507,457,438,508,459,439,440,440, \
 464,464,443,454,444,444,456,511,512,435,458,524,437,536,460,416, \
 439,461,440,451,452,452,464,464,509,509,510,510,511,456,457,512, \
 524,458,459,459,460,460,461,560,462,539,452,452,464,464,509,509, \
 510,499,500,555,512,512,557,524,525,525,537,559,560,549,440,539, \
 557,521,510,558,559,511,512,536,537,525,454,538,539,527,528,504, \
 505,505,530,554,555,531,532,532,509,521,546,510,511,511,512,512, \
 537,537,538,526,539,539,552,528,553,529,530,530,543,531,532,532, \
 521,545,558,510,511,559,560,560,537,513,526,550,551,551,528,552, \
 554,554,555,555,530,543,544,531,545,558,533,559,560,560,509,509, \
 510,510,511,511,655,655,539,656,527,605,541,541,542,555,556,556, \
 531,544,545,545,559,533,534,547,548,600,549,549,550,550,551,551, \
 552,604,605,605,554,554,555,555,556,556,648,635,636,545,546,559, \
 557,557,642,656,559,629,630,560,617,603,604,604,605,605,620,606, \
 607,607,650,608,651,553,554,652,653,653,654,654,627,641,656,656, \
 629,559,560,742,603,617,604,604,619,605,606,606,607,747,748,748, \
 651,651,652,624,625,639,626,682,627,655,628,642,699,699,672,630, \
 704,704,720,615,736,736,647,647,648,648,724,724,725,635,741,651, \
 652,652,653,653,654,654,655,655,656,656,747,732,688,748,644,629, \
 735,735,736,736,632,737,738,738,724,739,740,680,681,726,682,682, \
 683,683,744,684,700,700,746,746,747,747,748,748,734,704,720,720, \
 721,737,738,738,707,675,724,708,709,709,710,710,711,727,712,728, \
 745,713,682,746,747,683,684,684,717,733,734,734,735,735,736,736, \
 721,721,722,738,723,723,724,724,725,741,742,742,743,743,744,744, \
 745,729,746,746,747,731,732,732,653,717,718,718,719,719,720,736 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,-1,-1,-1,-1,-1,4,5,5,7,6,7,7,8,8, \
 9,9,10,10,11,11,12,12,13,14,14,16,17,16,17,16, \
 17,18,19,18,19,19,23,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,32,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,46,43,45,48,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 71,57,68,64,67,59,60,68,63,67,64,64,67,67,64,72, \
 68,68,72,72,67,76,68,68,69,69,70,70,71,71,72,72, \
 76,76,80,80,75,75,76,76,77,80,84,84,79,79,80,80, \
 84,81,88,82,83,95,96,96,88,91,92,92,87,99,91,88, \
 92,95,96,105,94,91,116,92,114,99,103,97,98,110,105,105, \
 105,109,110,114,111,111,104,104,105,105,102,102,135,135,104,104, \
 117,105,114,114,115,111,116,116,117,109,134,134,135,123,124,112, \
 129,117,138,114,115,127,132,116,141,129,122,118,119,139,140,120, \
 121,121,122,122,123,147,152,128,129,125,126,126,127,135,128,128, \
 129,129,140,135,136,131,132,132,133,138,149,134,135,145,146,141, \
 152,152,153,138,139,144,180,140,141,141,152,147,153,148,159,164, \
 155,180,171,171,162,172,188,158,159,179,180,180,171,166,172,172, \
 178,188,179,164,180,180,181,171,172,172,183,178,184,184,170,180, \
 203,185,186,180,187,163,164,188,195,171,184,196,203,203,180,204, \
 187,211,194,188,171,171,172,184,185,185,186,186,187,175,188,188, \
 195,177,184,184,179,179,180,180,181,187,188,182,183,183,184,184, \
 203,185,186,186,187,187,188,188,195,195,196,196,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,204,198,212,199,199,200,200, \
 201,201,202,202,203,203,204,204,205,282,283,206,228,284,208,208, \
 209,209,210,210,211,211,268,212,262,248,228,249,215,215,300,216, \
 217,252,218,274,275,268,220,283,256,284,250,264,244,251,252,252, \
 249,249,250,242,243,275,252,252,253,261,262,246,255,279,264,272, \
 281,265,250,274,267,251,300,300,277,261,262,262,255,263,256,264, \
 265,265,266,282,299,267,284,252,293,269,294,286,279,279,272,280, \
 297,281,298,298,299,283,284,300,293,269,270,294,287,255,256,296, \
 284,275,276,276,277,268,314,260,315,297,262,316,308,263,264,264, \
 265,265,266,266,267,294,313,268,305,278,279,297,280,280,281,281, \
 282,300,283,283,284,284,276,276,313,313,314,296,297,297,298,298, \
 299,299,300,300,364,283,284,284,294,294,295,304,296,314,315,315, \
 299,299,300,300,321,361,362,312,363,313,294,314,295,315,316,316, \
 297,297,298,298,299,299,300,300,331,341,312,302,303,303,364,414, \
 355,305,346,346,307,307,308,308,359,379,380,380,361,361,362,362, \
 313,363,364,364,315,315,416,356,327,347,348,368,319,319,320,380, \
 376,332,377,377,389,378,379,346,347,347,348,359,360,393,416,361, \
 362,329,396,385,364,331,332,409,355,410,345,356,346,368,380,391, \
 392,348,360,404,416,416,384,362,363,363,364,364,464,387,377,377, \
 378,411,379,346,347,457,458,348,393,393,394,460,406,439,440,429, \
 401,401,402,402,391,391,392,392,453,441,454,454,455,443,444,408, \
 445,457,458,458,459,363,364,364,461,389,402,414,463,415,380,380, \
 405,405,406,406,395,395,396,396,409,373,446,446,435,447,400,448, \
 377,413,462,414,451,415,416,416,405,393,406,430,431,407,432,456, \
 411,411,412,425,426,439,440,440,389,415,416,390,391,456,392,392, \
 458,432,446,459,460,395,500,448,436,462,463,463,464,464,400,439, \
 440,401,402,402,403,455,456,456,457,457,458,458,459,511,512,408, \
 461,461,410,436,437,411,412,412,413,452,453,414,545,454,416,416, \
 459,459,460,460,447,475,546,448,449,463,464,436,437,437,438,480, \
 523,495,510,440,483,553,428,512,555,555,458,458,543,459,460,460, \
 475,559,560,532,505,519,436,464,437,437,438,438,439,439,440,440, \
 441,441,442,484,499,443,444,444,445,529,544,516,545,559,546,532, \
 464,509,450,510,511,511,512,557,543,498,499,499,500,560,546,456, \
 457,547,548,458,459,534,460,460,461,461,462,582,463,463,464,464, \
 540,540,496,556,497,542,468,498,499,499,500,500,546,591,532,517, \
 518,548,534,534,535,595,476,476,552,582,478,523,524,554,480,525, \
 529,529,546,546,579,531,532,532,533,485,486,534,535,535,536,536, \
 537,537,506,490,555,491,492,540,509,509,558,590,591,591,560,560, \
 577,561,578,562,563,563,564,596,581,581,534,566,567,519,520,520, \
 521,537,538,506,507,571,524,508,605,541,558,558,607,511,512,512 \

#define MPFR_MUL_THRESHOLD 9 /* limbs */
#define MPFR_EXP_2_THRESHOLD 64 /* bits */
#define MPFR_EXP_THRESHOLD 11062 /* bits */
#define MPFR_SINCOS_THRESHOLD 25954 /* bits */

#elif defined (__tune_core2__) && defined (__i386) /* 32-bit Core 2,
      for example a 64-bit machine with gmp/mpfr compiled with ABI=32 */

/* Generated by MPFR's tuneup.c, 2007-12-21, gcc 4.1 */

#define MPFR_MULHIGH_TAB  \
 -1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28, \
 30,28,30,28,28,32,30,30,30,32,32,34,32,32,32,32, \
 33,35,44,40,35,41,40,42,41,47,48,48,47,51,56,48, \
 47,55,48,56,51,55,56,60,55,55,56,56,55,55,56,64, \
 63,59,60,64,59,59,64,64,63,63,60,68,63,67,60,64, \
 67,67,64,68,63,81,64,64,81,81,64,80,81,81,92,86, \
 86,80,81,81,79,91,86,92,93,84,85,85,86,86,87,87, \
 91,88,89,98,99,96,91,91,92,92,93,93,94,91,92,92, \
 99,99,103,97,98,98,96,93,121,115,104,116,93,99,121,127, \
 128,110,129,117,121,127,128,128,129,126,124,127,122,128,123,129, \
 129,129,134,138,139,139,140,140,129,141,122,138,139,139,128,128, \
 129,165,162,138,139,139,164,164,165,153,138,162,139,139,164,140, \
 165,165,150,146,139,163,164,164,141,177,158,162,151,151,160,156, \
 165,153,162,158,163,163,164,164,165,153,174,174,163,163,164,164, \
 164,164,165,165,176,176,172,177,168,163,189,189,165,165,176,176, \
 177,177,188,188,189,189,175,180,176,176,177,177,188,183,184,189, \
 180,180,191,201,192,177,188,188,189,199,200,200,201,201,212,212, \
 213,188,189,189,200,200,201,201,177,212,188,213,189,189,200,195, \
 239,239,240,240,199,199,212,212,213,201,232,196,215,197,240,240, \
 247,211,200,236,237,213,256,256,239,257,240,240,247,247,254,248, \
 237,255,256,238,257,257,240,240,253,247,272,272,237,237,256,256, \
 275,257,258,276,265,271,272,254,255,267,274,256,257,257,258,276, \
 256,249,257,285,258,258,266,294,267,267,275,275,276,276,291,270, \
 257,257,258,293,273,294,274,267,261,261,276,276,270,277,278,271, \
 293,293,294,294,267,267,268,275,276,276,284,284,292,271,272,293, \
 294,273,274,274,275,289,276,276,291,291,285,285,293,293,294,294, \
 321,305,290,290,291,275,276,348,285,293,294,310,311,303,312,288, \
 289,329,330,306,347,291,292,348,381,381,294,294,327,343,384,384, \
 345,337,306,346,347,307,308,340,341,381,366,366,343,383,384,384, \
 345,329,330,330,347,339,380,380,357,381,366,358,359,375,376,376, \
 383,383,366,366,340,367,368,359,360,360,361,379,362,362,417,381, \
 364,382,383,383,384,384,412,376,413,359,360,378,361,379,380,416, \
 417,381,382,418,419,365,384,384,412,412,413,377,378,378,379,379, \
 380,380,381,363,418,382,383,383,384,384,385,376,377,413,414,378, \
 379,379,380,380,381,381,382,382,383,363,364,414,415,365,366,366, \
 417,377,378,418,379,419,420,420,491,441,492,492,403,383,384,384, \
 415,415,386,416,417,417,418,418,419,419,420,490,491,491,492,492, \
 423,483,414,414,415,525,416,486,497,417,418,418,419,489,490,490, \
 486,420,487,421,488,455,456,423,424,490,491,491,492,492,471,471, \
 483,417,418,528,419,419,420,420,465,487,488,488,489,456,490,490, \
 491,491,492,492,526,493,527,494,484,528,419,452,453,486,487,454, \
 455,488,489,467,468,490,491,480,492,492,482,482,483,527,528,506, \
 521,485,522,498,487,487,488,524,525,489,490,490,491,491,492,528, \
 481,505,506,494,495,495,496,520,497,497,486,498,487,487,488,524, \
 489,489,490,526,527,491,492,492,529,529,506,518,519,483,496,484, \
 485,569,510,522,523,487,488,488,489,489,490,490,491,491,492,492, \
 528,528,490,490,491,491,492,492,506,506,507,507,521,521,535,522, \
 523,523,524,563,564,525,526,526,527,527,528,528,529,542,543,556, \
 570,557,571,558,533,533,534,560,535,522,523,536,537,563,564,525, \
 526,526,527,527,528,528,542,594,595,543,557,557,597,532,559,559, \
 557,557,558,558,559,531,546,560,561,547,548,562,563,563,564,564, \
 565,565,566,566,567,553,582,568,569,583,584,584,585,557,558,600, \
 559,573,560,588,533,561,590,562,563,563,564,564,593,579,594,566, \
 567,581,582,568,569,569,598,584,571,585,600,600,629,559,560,560, \
 599,599,600,600,601,586,587,602,603,603,634,604,605,635,636,636, \
 562,637,638,563,564,564,565,565,566,611,612,552,628,568,569,584, \
 585,600,631,616,617,632,633,633,634,634,635,635,636,606,592,712, \
 713,638,639,564,595,715,716,716,717,597,583,568,569,704,600,585, \
 625,593,594,770,771,595,596,708,597,597,598,694,695,599,600,712, \
 633,633,714,634,715,715,716,636,717,717,686,750,751,751,752,768, \
 753,753,754,770,771,771,756,708,709,709,710,742,743,711,712,760, \
 761,713,714,714,715,715,716,716,765,717,718,750,751,751,768,736 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,-1,-1,0,0,0,0,0,0,0,0,-1,-1,0,8, \
 9,9,10,10,11,12,12,13,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,42,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,74,66,66,67,67,68,68,69,78,70,70,74,71,72,72, \
 73,73,74,74,75,75,76,76,77,77,78,78,79,79,80,80, \
 81,84,82,82,83,83,84,84,85,85,92,92,87,87,88,88, \
 89,89,90,96,91,91,92,92,93,96,100,100,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,114,102,103,103,104,104, \
 105,105,114,106,107,123,108,108,117,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,132, \
 141,121,122,122,123,135,140,144,141,125,126,126,127,127,128,128, \
 129,129,130,135,131,131,132,132,133,158,134,134,135,135,136,136, \
 137,137,138,138,169,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,171,177,147,153,148,149,159,150,150,151,171,177,177, \
 153,153,154,159,180,165,156,156,157,177,183,168,159,159,170,165, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168, \
 169,169,170,170,171,171,172,172,173,173,174,174,175,175,176,176, \
 177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200, \
 201,201,202,202,203,210,225,204,205,205,206,206,207,207,208,208, \
 209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216, \
 217,217,218,218,219,219,220,220,221,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232, \
 233,249,234,234,235,235,236,236,237,237,238,238,239,239,240,240, \
 241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,252,253,253,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,283,266,284,285,267,268,268,269,269,270,270,271,271,272,272, \
 273,273,274,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,285,286,295,332,287,288,288, \
 289,309,320,320,321,291,292,292,293,293,294,324,295,295,296,296, \
 297,297,298,298,299,299,300,300,301,301,302,302,303,333,304,304, \
 345,305,306,306,307,307,348,338,339,309,310,310,311,311,312,312, \
 333,323,324,354,355,345,336,316,317,337,338,338,319,339,320,340, \
 365,365,344,333,323,345,346,324,325,347,348,348,349,327,328,328, \
 384,329,330,330,331,364,332,354,366,366,356,356,357,335,336,336, \
 337,337,338,338,339,383,384,340,341,341,342,342,343,343,344,344, \
 345,345,346,346,347,347,348,348,349,382,383,350,351,351,352,352, \
 353,353,402,354,355,355,356,356,357,357,358,358,359,419,420,420, \
 361,361,362,362,363,363,364,364,365,365,366,366,367,367,368,368, \
 369,369,370,370,371,371,372,372,373,373,374,374,375,375,376,376, \
 377,377,378,378,379,379,380,380,381,381,382,382,383,383,384,384, \
 385,385,399,490,387,387,388,388,389,389,390,390,391,391,392,392, \
 393,393,420,394,395,395,396,396,397,397,398,398,399,399,400,400, \
 401,401,402,402,507,507,508,404,405,509,510,510,407,407,408,473, \
 474,474,527,436,437,411,412,412,413,491,492,492,415,415,416,416, \
 417,417,418,418,419,419,420,420,421,463,492,492,521,479,480,424, \
 425,425,426,426,427,427,428,484,429,429,430,472,473,473,474,432, \
 433,433,434,504,491,491,492,436,437,507,508,508,481,467,468,468, \
 469,483,484,512,513,471,486,500,501,515,516,488,489,447,448,490, \
 509,509,510,510,481,526,527,512,513,528,544,544,545,455,456,456, \
 517,487,488,488,489,489,490,460,461,461,462,492,508,508,509,509, \
 510,510,511,526,527,467,468,528,544,469,470,515,546,531,517,472, \
 473,473,474,474,475,535,581,476,477,477,478,478,479,479,480,480, \
 481,481,482,482,483,547,548,484,485,485,486,566,535,487,488,488, \
 489,489,490,490,491,491,492,492,493,493,494,494,495,495,496,496, \
 497,561,498,578,579,579,580,580,581,501,502,598,599,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,512 \

#define MPFR_MUL_THRESHOLD 11 /* limbs */
#define MPFR_EXP_2_THRESHOLD 441 /* bits */
#define MPFR_EXP_THRESHOLD 9145 /* bits */

/****************************
 * Threshold for AMD 64     *
 ****************************/
#elif defined (__tune_k8__)

/* Generated by MPFR's tuneup.c, 2009-02-09, gcc 4.3 */
/* achille.loria.fr with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,68,68,0,67,66,66, \
 65,65,64,64,67,67,64,72,65,79,68,72,67,79,72,72, \
 80,80,81,72,76,82,77,77,84,84,88,88,83,83,81,84, \
 88,88,80,80,96,96,100,97,98,89,96,84,100,97,98,98, \
 96,96,100,100,98,98,93,93,100,97,101,98,96,99,121,121, \
 104,101,108,108,112,109,110,122,111,117,115,115,122,122,123,123, \
 117,117,122,122,123,123,128,128,129,129,126,126,135,131,128,128, \
 129,129,126,126,147,143,132,132,141,137,134,134,135,147,140,140, \
 141,141,146,146,147,147,144,140,149,141,146,146,147,147,152,144, \
 153,165,146,146,147,147,152,156,165,153,162,170,167,171,168,168, \
 159,159,170,170,171,166,167,172,168,168,189,189,200,170,171,171, \
 177,167,168,168,169,199,195,200,201,201,192,192,198,198,199,189, \
 195,195,201,201,207,207,188,188,189,199,195,200,201,201,202,197, \
 198,198,189,199,210,200,196,196,197,192,213,208,219,224,225,200, \
 233,227,228,204,211,211,212,206,237,213,202,220,203,239,204,240, \
 247,211,212,212,213,243,232,232,239,215,216,222,229,235,236,224, \
 225,225,226,226,227,245,246,234,241,223,248,224,225,249,226,226, \
 227,233,234,252,247,235,236,236,237,237,250,238,239,245,246,240, \
 249,249,236,236,237,251,252,252,253,253,254,254,297,241,242,249, \
 257,257,258,251,245,245,246,267,247,261,248,248,249,249,285,278, \
 258,258,259,273,281,281,282,261,276,297,270,270,271,271,272,272, \
 273,273,288,281,282,289,290,283,284,277,285,278,286,286,287,287, \
 289,281,282,290,291,291,284,284,293,301,302,310,311,303,304,312, \
 273,297,330,282,283,299,308,348,309,285,310,366,287,327,288,288, \
 297,297,330,338,339,339,348,348,349,349,302,366,335,335,344,312, \
 297,361,330,354,355,339,348,348,341,365,342,342,359,351,360,328, \
 329,365,357,357,358,349,350,341,342,351,352,361,362,380,363,363, \
 364,364,347,347,348,348,349,367,368,341,342,342,343,343,380,380, \
 345,345,346,346,347,347,348,357,358,385,386,359,360,360,361,361, \
 362,362,363,363,364,364,365,410,411,357,358,358,359,422,414,378, \
 379,369,410,380,381,381,432,362,363,423,434,434,425,435,436,366, \
 417,437,438,438,369,399,400,440,441,441,402,382,383,393,384,384, \
 445,405,406,436,437,417,418,418,409,429,410,390,411,431,402,432, \
 423,393,414,404,445,425,436,436,417,417,438,438,399,449,450,440, \
 431,420,421,443,433,433,434,445,435,435,414,414,426,426,427,427, \
 417,417,418,418,419,430,431,442,443,443,433,433,434,434,435,501, \
 425,447,470,459,416,427,428,450,429,429,430,474,486,464,432,432, \
 455,455,489,456,468,457,469,447,459,459,438,471,472,450,462,473, \
 497,509,510,486,463,487,452,452,501,489,490,454,467,491,492,456, \
 469,469,470,470,483,447,508,508,509,509,510,510,451,499,452,452, \
 513,501,526,490,491,455,456,492,493,505,506,470,495,483,484,472, \
 473,521,510,474,535,487,488,500,501,501,502,562,563,563,528,528, \
 528,528,581,490,491,491,492,492,506,493,494,520,495,495,561,587, \
 588,510,563,589,590,499,513,513,566,566,528,515,516,516,517,569, \
 583,583,571,597,598,585,599,586,600,600,510,575,576,563,525,564, \
 578,591,527,579,567,528,594,607,556,582,583,583,558,597,598,546, \
 571,585,586,600,601,545,588,546,589,561,562,562,591,591,578,592, \
 593,593,594,594,567,595,596,596,597,597,598,598,571,599,600,572, \
 573,573,574,574,575,589,618,590,563,633,634,578,593,579,580,580, \
 581,595,596,582,597,625,626,570,571,571,600,600,601,601,602,602, \
 599,599,600,600,601,616,602,602,618,618,589,634,590,605,621,591, \
 607,607,623,623,624,609,625,595,596,596,597,597,598,628,629,599, \
 645,645,616,631,632,632,633,708,634,604,605,680,681,636,652,607, \
 608,623,624,744,670,640,641,626,627,672,673,658,659,704,630,630, \
 625,705,674,642,643,675,676,708,709,709,710,742,679,743,744,696, \
 681,633,698,682,683,699,668,732,717,669,670,670,687,703,704,704, \
 657,689,674,690,707,675,676,708,709,709,710,710,695,727,728,744, \
 713,681,682,714,715,699,700,684,701,701,702,702,703,703,704,672 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,5,6,6,7,7,8,8, \
 9,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72, \
 73,73,74,74,75,75,76,76,77,77,78,78,79,79,80,80, \
 81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88, \
 89,89,90,90,91,91,92,92,93,93,94,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,105,106,106,107,107,108,108,109,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120, \
 121,121,122,122,123,123,124,124,125,125,126,126,127,127,128,128, \
 129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136, \
 137,137,138,138,139,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,146,147,147,148,158,159,149,150,150,151,151,152,152, \
 153,153,154,154,155,155,156,156,157,157,158,158,159,159,160,160, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,167,180,186, \
 199,169,170,170,171,171,172,172,173,209,198,198,205,175,176,176, \
 177,177,178,214,215,179,180,210,211,199,200,200,201,183,184,184, \
 185,185,216,186,187,211,212,212,213,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200, \
 201,201,202,202,203,203,204,204,205,205,206,206,207,207,208,208, \
 209,209,210,210,211,211,212,240,213,213,214,214,215,215,216,216, \
 217,217,218,218,219,219,248,248,249,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,264, \
 273,233,234,234,267,235,236,236,237,237,238,238,239,239,240,288, \
 273,241,242,242,243,243,244,284,261,277,278,270,271,247,248,248, \
 249,249,250,250,251,251,252,252,253,253,254,254,255,255,256,256, \
 257,284,258,294,295,259,260,260,261,261,262,262,263,263,264,264, \
 265,265,266,266,267,267,268,268,269,269,270,270,271,271,272,272, \
 273,273,274,274,320,320,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,285,286,286,287,287,288,288, \
 289,289,290,290,291,291,292,292,293,293,294,294,295,295,296,296, \
 297,297,298,298,299,299,300,300,301,301,302,302,303,303,304,304, \
 305,305,306,306,307,307,308,308,309,309,310,310,311,311,312,342, \
 333,313,314,314,315,315,316,316,317,317,318,318,319,319,320,320, \
 321,321,322,322,323,323,324,324,325,325,326,326,327,327,328,328, \
 329,329,330,330,331,331,332,332,333,333,334,334,335,335,336,336, \
 337,337,338,338,339,339,340,340,341,341,342,342,343,343,344,344, \
 345,345,346,401,402,402,348,414,349,349,350,350,351,351,352,418, \
 413,425,426,354,427,427,356,428,429,429,430,358,359,359,360,420, \
 361,361,362,422,423,363,364,436,437,401,402,366,367,415,416,416, \
 417,417,418,454,371,371,456,372,373,373,374,374,375,375,376,376, \
 377,377,378,378,379,379,380,380,381,381,382,382,383,383,384,384, \
 385,385,386,386,387,465,388,440,441,441,390,390,391,391,392,392, \
 393,393,394,446,447,395,396,396,397,397,398,437,438,464,465,400, \
 401,401,402,402,468,403,404,404,405,444,445,497,407,472,473,408, \
 409,409,501,410,411,411,451,438,465,465,414,492,493,415,416,416, \
 417,417,418,418,419,419,420,420,421,421,422,422,423,423,424,424, \
 425,425,426,426,427,427,428,428,429,429,486,430,431,431,432,432, \
 433,433,434,434,435,435,436,436,437,437,438,438,439,439,440,440, \
 441,441,442,498,499,443,444,528,445,445,446,446,447,447,448,448, \
 449,449,450,510,526,451,452,452,453,453,454,454,455,455,456,546, \
 487,457,458,458,459,459,460,460,461,461,462,462,463,463,464,464, \
 465,540,541,466,467,467,468,513,514,499,560,470,471,471,472,472, \
 473,473,474,474,475,535,536,476,477,582,553,478,479,599,600,585, \
 481,481,482,578,579,483,484,484,485,485,486,486,487,487,488,488, \
 489,489,490,490,491,603,620,492,493,589,590,494,495,495,496,496, \
 497,593,594,498,499,499,500,500,501,501,502,502,503,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,608 \

#define MPFR_MUL_THRESHOLD 6 /* limbs */
#define MPFR_EXP_2_THRESHOLD 595 /* bits */
#define MPFR_EXP_THRESHOLD 10606 /* bits */

/*****************************
 * Threshold for Athlon      *
 *****************************/
#elif defined (__tune_athlon__)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,-1,-1,0,-1,-1,0,0,0,0,10, \
 0,12,13,14,15,16,0,0,0,0,0,19,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32, \
 30,32,30,34,32,32,36,34,36,36,38,38,42,38,38,42, \
 40,38,42,46,42,42,42,44,44,44,44,44,48,50,46,46, \
 60,50,50,48,50,56,56,56,56,56,56,56,60,60,64,60, \
 64,64,60,60,60,72,64,64,68,72,76,72,76,72,72,76, \
 75,76,76,72,76,72,75,72,72,72,84,76,84,75,72,76, \
 84,80,76,84,84,76,76,76,76,88,84,88,80,84,83,96, \
 84,96,92,84,88,91,92,88,92,90,96,96,92,91,92,96, \
 96,120,95,100,112,120,100,119,112,120,120,112,119,112,119,119, \
 120,118,119,119,119,118,119,120,128,127,120,128,128,120,120,127, \
 120,128,128,128,128,120,128,127,120,128,128,127,128,127,144,136, \
 128,144,152,152,152,136,144,144,144,136,151,152,144,152,128,151, \
 144,152,144,144,151,144,150,150,136,151,152,143,143,143,142,168, \
 144,144,168,151,168,144,152,151,152,152,160,152,151,152,160,151, \
 152,151,152,167,152,152,166,152,167,160,168,204,160,160,168,168, \
 204,176,202,167,168,166,167,168,204,184,202,204,204,204,204,192, \
 184,192,204,202,202,216,204,227,202,204,216,203,203,204,203,227, \
 202,204,202,202,202,203,202,215,204,202,203,202,202,215,228,214, \
 226,214,228,214,228,215,228,216,226,214,228,225,226,228,226,226, \
 226,215,216,216,226,225,226,227,216,227,240,216,252,252,226,227, \
 228,239,227,250,227,226,227,227,252,238,228,239,252,227,228,228, \
 252,226,246,228,227,227,252,247,250,263,262,250,252,250,250,252, \
 250,288,288,250,250,250,251,264,264,271,287,276,250,288,252,286, \
 251,287,288,251,276,274,288,262,263,263,282,252,288,252,276,284, \
 287,274,264,274,288,275,275,274,274,288,276,264,273,286,274,276, \
 300,287,288,286,286,276,288,285,275,300,275,273,275,299,300,299, \
 279,336,336,286,287,284,360,359,336,335,288,360,333,359,334,335, \
 335,287,359,335,336,336,359,333,334,359,360,288,360,332,335,336, \
 335,336,336,333,336,335,336,359,334,334,335,360,336,334,356,357, \
 335,336,358,359,359,336,335,336,334,355,384,356,354,384,334,357, \
 336,359,384,359,360,356,384,382,336,383,384,384,354,355,383,384, \
 382,359,384,382,382,383,383,359,381,382,383,356,384,382,381,384, \
 357,384,358,357,358,358,380,383,382,382,383,360,360,381,382,360, \
 377,360,378,360,360,381,382,383,381,380,383,383,360,382,383,380, \
 383,383,384,381,379,360,381,381,382,431,380,380,378,380,384,381, \
 382,382,384,407,384,382,379,384,430,431,383,384,408,384,456,431, \
 431,455,431,428,384,454,455,403,432,383,407,430,430,456,408,427, \
 455,455,456,455,432,431,431,429,455,432,432,424,430,427,427,429, \
 452,454,426,455,456,431,430,454,452,454,431,456,431,428,455,430, \
 454,430,432,455,454,442,443,432,443,431,451,452,456,430,451,456, \
 444,455,449,456,432,454,449,454,502,432,448,504,450,503,503,453, \
 454,502,446,452,453,454,455,499,504,453,456,504,454,453,503,455, \
 456,456,500,478,502,454,456,499,478,454,480,499,501,496,502,455, \
 499,502,503,456,478,500,501,500,479,503,504,451,452,479,454,455, \
 502,503,504,504,454,499,503,501,454,503,456,503,504,501,455,502, \
 503,503,502,504,610,503,504,574,480,551,528,504,609,576,480,503, \
 496,502,503,552,551,552,551,503,504,503,610,608,609,610,611,608, \
 608,551,648,611,612,550,576,572,608,611,610,606,608,611,610,574, \
 575,576,606,607,606,606,608,606,606,575,576,604,604,604,608,609, \
 606,606,606,608,604,604,611,604,604,576,610,606,610,606,604,610, \
 606,612,604,608,610,609,604,608,606,647,612,610,604,606,648,610, \
 610,606,646,608,604,647,606,647,606,609,610,647,648,609,641,611, \
 643,611,643,648,643,640,646,611,644,644,645,611,642,646,611,612, \
 640,647,610,611,610,611,606,647,648,647,648,644,682,642,682,683, \
 610,611,680,678,642,681,682,647,682,612,682,648,611,665,680,683, \
 609,646,666,676,680,646,679,647,646,646,648,679,684,611,612,643, \
 684,645,646,647,683,647,608,645,682,647,682,646,610,648,682,610, \
 684,612,612,683,684,647,647,646,680,646,646,745,648,646,644,647, \
 648,647,678,646,647,683,642,682,682,684,646,645,642,647,646,677, \
 646,647,683,678,680,646,646,643,681,647,683,645,666,755,756,645, \
 643,647,646,647,647,648,674,755,756,674,647,643,680,682,684,680, \
 680,682,682,675,682,677,666,683,680,682,682,684,680,681,674,674 \

#define MPFR_MUL_THRESHOLD 19
#define MPFR_EXP_2_THRESHOLD 411 /* bits */
#define MPFR_EXP_THRESHOLD 45200 /* bits */

/**************************************
 * Threshold for PentiumPro/Pentium M *
 **************************************/
#elif defined (__tune_pentiumpro__) || defined (__tune_i686__) || defined (__i386) /* we consider all other 386's here */

/* Generated by MPFR's tuneup.c, 2009-02-09, gcc 4.3 */
/* toto.loria.fr (Pentium M) with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30, \
 30,30,28,30,30,30,30,30,30,34,34,34,32,32,44,38, \
 43,39,44,44,41,41,44,44,47,43,48,44,47,51,48,48, \
 47,55,48,48,55,51,56,52,51,55,60,56,55,55,60,60, \
 55,63,60,60,63,59,60,60,63,63,60,60,59,67,68,60, \
 63,67,60,68,75,81,68,68,81,81,78,86,81,81,84,80, \
 80,80,81,81,85,85,86,86,84,84,85,91,86,86,87,87, \
 85,91,92,92,93,99,91,97,98,86,93,93,97,91,92,92, \
 90,99,91,97,98,95,96,93,97,115,128,116,117,111,115,109, \
 128,128,129,129,121,115,128,116,126,129,127,121,140,128,129,129, \
 141,129,126,126,127,127,128,128,129,129,138,138,139,127,128,128, \
 129,153,134,150,139,139,140,140,141,141,134,162,139,147,140,144, \
 141,141,150,174,175,151,140,164,165,165,150,154,155,151,152,152, \
 153,165,150,162,163,151,152,176,177,165,158,162,171,163,164,164, \
 164,164,165,165,176,166,177,172,168,163,189,189,165,175,176,176, \
 177,177,183,188,179,189,180,180,186,176,177,177,183,188,189,189, \
 185,180,186,201,177,187,183,188,189,189,200,200,201,191,192,177, \
 188,198,189,204,195,200,201,201,212,192,188,188,189,194,200,200, \
 221,239,240,240,199,235,236,230,237,231,220,208,239,239,234,240, \
 229,247,236,230,231,231,238,238,239,239,240,240,247,265,248,236, \
 237,237,256,238,239,257,258,240,253,253,254,266,249,255,256,274, \
 275,275,276,276,247,253,254,272,267,273,256,256,257,257,276,258, \
 256,256,257,257,258,258,266,294,288,267,275,275,276,276,291,270, \
 257,271,293,272,294,294,260,267,261,275,276,276,291,270,271,285, \
 293,293,294,273,288,267,275,275,276,276,277,284,285,285,293,293, \
 273,294,274,274,275,289,276,290,291,277,292,285,293,293,294,294, \
 297,297,330,290,267,307,276,276,309,293,294,310,311,319,328,328, \
 329,289,330,290,283,283,348,292,293,381,294,382,327,343,384,384, \
 289,289,290,330,291,339,308,308,381,341,342,366,383,383,384,384, \
 345,345,378,378,379,323,324,380,381,381,382,366,375,383,384,376, \
 383,365,384,384,376,340,341,341,342,378,379,379,380,371,417,381, \
 382,382,383,383,384,384,376,376,377,377,378,378,379,379,380,380, \
 381,381,382,382,383,419,420,384,376,412,413,377,378,414,415,388, \
 416,416,417,381,382,382,419,419,384,384,412,385,386,395,396,378, \
 379,419,380,420,381,381,382,382,383,383,384,384,395,405,456,406, \
 417,417,418,418,419,419,420,420,381,491,492,492,383,413,414,384, \
 415,455,456,426,427,417,488,418,419,419,420,420,441,491,492,492, \
 383,413,434,454,455,415,416,416,417,417,418,418,459,429,490,420, \
 486,420,487,454,422,499,423,489,490,490,491,491,492,492,416,438, \
 450,527,528,528,419,485,453,420,432,465,455,455,456,456,479,479, \
 480,491,492,459,493,526,527,494,495,484,485,452,453,453,487,454, \
 455,499,489,456,490,490,480,491,492,481,482,526,527,527,528,528, \
 521,485,486,474,499,487,524,524,489,489,490,490,491,491,492,492, \
 505,505,506,482,483,459,520,472,497,485,498,498,499,535,488,524, \
 489,525,490,490,491,527,528,492,529,493,494,506,495,483,484,484, \
 485,521,522,486,487,487,488,488,489,489,490,562,563,491,492,492, \
 528,528,490,555,556,491,492,492,506,519,520,507,521,521,522,522, \
 523,523,524,524,525,564,552,500,501,527,528,528,529,542,556,530, \
 531,531,558,532,533,520,534,521,548,561,562,562,563,563,564,564, \
 526,526,527,527,528,528,542,555,556,530,531,557,558,558,598,559, \
 585,557,558,558,559,531,560,560,561,561,562,548,535,549,564,564, \
 579,537,580,552,567,567,582,568,569,597,556,584,585,571,600,572, \
 573,559,588,588,533,561,590,604,605,563,564,564,565,607,608,580, \
 567,609,582,582,597,597,528,598,599,571,558,600,559,559,560,602, \
 599,599,600,600,556,601,602,617,633,603,604,634,635,560,561,636, \
 562,562,563,563,564,564,580,715,716,596,717,717,553,568,569,569, \
 570,600,631,601,602,662,663,663,604,604,695,710,711,711,712,712, \
 713,713,714,714,715,715,596,656,657,657,583,598,599,599,600,600, \
 689,769,770,594,691,707,708,596,597,693,710,662,695,711,712,712, \
 713,697,698,714,715,699,716,716,717,717,750,702,719,751,720,704, \
 705,705,722,738,755,771,708,708,709,741,742,710,711,743,744,712, \
 713,761,714,714,715,715,716,716,717,717,766,750,751,751,736,736 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,-1,8,8, \
 9,9,10,12,11,11,12,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,42, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,65,66,66,67,67,68,68,69,84,70,70,74,71,72,72, \
 73,73,74,74,78,75,76,76,77,77,84,78,79,79,80,80, \
 81,84,88,82,83,83,84,84,85,85,92,92,87,87,88,88, \
 89,89,96,90,91,91,92,92,93,93,100,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,105,106,106,107,123,108,108,129,129,126,126,135,135,112,128, \
 129,129,134,134,123,135,128,140,141,129,134,134,135,135,140,132, \
 133,141,122,122,123,135,136,140,153,141,126,126,127,159,128,128, \
 129,129,135,135,141,131,132,132,133,133,134,134,135,135,136,136, \
 137,137,138,138,159,139,140,140,141,141,142,142,143,143,144,144, \
 145,165,146,146,147,147,148,148,149,149,150,150,151,171,152,152, \
 153,153,154,159,155,155,156,156,157,157,158,158,159,159,170,170, \
 161,161,162,162,163,163,188,164,165,165,166,166,167,167,168,186, \
 187,169,170,170,171,171,172,172,173,173,174,174,175,175,176,176, \
 177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200, \
 201,201,202,202,203,203,204,204,205,205,206,206,207,207,208,208, \
 209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216, \
 217,217,218,218,219,261,248,220,221,249,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,248,232, \
 233,233,234,234,235,235,236,236,261,285,270,238,239,239,240,248, \
 249,249,242,242,243,251,260,244,261,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,252,285,253,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,265,266,284,285,267,268,268,269,296,297,270,271,271,272,272, \
 273,273,274,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,321,295,286,287,287,288,288, \
 289,289,320,320,321,321,292,292,293,313,314,294,295,295,296,296, \
 297,297,298,298,309,299,300,300,301,301,302,332,333,333,304,384, \
 375,305,306,306,307,307,308,308,309,309,320,310,311,311,312,312, \
 313,363,394,384,375,375,316,376,357,317,348,348,369,319,320,320, \
 321,321,366,366,378,323,324,324,402,369,359,381,382,382,383,383, \
 373,384,396,374,375,375,387,365,366,399,389,400,401,390,391,402, \
 381,381,382,404,405,405,384,373,374,374,375,386,387,387,388,388, \
 378,378,390,401,391,391,403,414,404,382,383,383,395,395,396,418, \
 401,401,378,402,403,427,428,404,405,417,382,418,419,419,420,384, \
 409,421,422,410,423,423,436,436,437,401,402,366,427,463,464,368, \
 369,369,370,370,455,371,372,456,373,433,434,434,435,471,472,472, \
 473,377,474,378,379,451,380,380,381,381,382,382,383,383,384,384, \
 398,398,399,438,465,387,427,440,441,389,455,390,391,391,392,392, \
 393,393,394,420,395,395,396,396,397,397,398,398,399,399,400,400, \
 401,401,402,402,455,403,404,508,405,405,406,406,407,433,434,447, \
 474,435,436,410,411,411,412,412,413,413,414,492,415,454,455,416, \
 417,417,418,418,419,419,420,420,421,421,422,464,465,423,424,424, \
 425,425,426,426,427,455,456,484,485,429,430,472,473,431,432,432, \
 433,461,434,434,435,477,436,436,437,437,438,438,509,453,468,510, \
 441,441,512,456,471,527,528,472,543,445,544,446,447,447,448,504, \
 449,509,510,450,451,451,452,527,453,483,514,544,545,455,456,546, \
 502,517,518,518,504,519,535,460,461,551,552,507,508,463,464,509, \
 510,525,526,526,527,542,543,543,544,544,545,515,516,546,472,472, \
 473,563,474,474,475,535,551,476,477,582,478,553,479,479,480,480, \
 481,545,546,530,531,547,516,564,597,549,550,486,487,551,488,536, \
 537,489,490,490,491,491,492,492,493,493,494,494,495,495,496,496, \
 497,497,578,546,499,499,500,500,501,501,502,598,599,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,512 \

#define MPFR_MUL_THRESHOLD 10 /* limbs */
#define MPFR_EXP_2_THRESHOLD 32 /* bits */
#define MPFR_EXP_THRESHOLD 6268 /* bits */

/*****************************
 * Threshold for IA64        *
 *****************************/
#elif defined (__ia64) || defined (__itanium__) || defined (__tune_ia64__)

/* Generated by MPFR's tuneup.c, 2009-02-10, gcc 4.3 */
/* pipol13.inrialpes.fr (McKinley) with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,44,44,47,47,44,44, \
 45,51,48,48,49,49,48,48,55,51,56,52,51,51,52,60, \
 59,59,56,56,63,63,64,64,63,63,64,60,67,67,68,68, \
 67,67,64,64,71,71,72,72,71,71,72,90,75,73,76,76, \
 89,89,84,90,82,88,92,89,90,90,88,88,89,89,90,90, \
 88,88,89,98,90,99,97,94,98,95,96,96,94,103,104,104, \
 108,105,109,106,110,110,108,108,109,103,104,104,111,111,109,118, \
 116,116,120,120,121,124,128,116,117,123,124,121,125,125,126,141, \
 141,129,134,126,127,123,140,132,137,141,126,150,139,143,132,140, \
 141,141,146,146,135,139,140,140,141,141,146,138,139,147,152,140, \
 141,141,162,162,143,139,140,156,165,153,158,154,147,147,152,152, \
 153,153,150,162,155,155,156,152,153,153,174,170,171,171,156,156, \
 159,164,165,165,176,166,167,167,168,168,164,179,165,165,166,176, \
 177,177,188,188,189,174,180,180,176,171,177,192,173,183,189,189, \
 180,195,186,186,182,177,183,188,189,184,190,190,201,191,192,192, \
 188,203,204,199,200,200,201,201,192,207,208,213,204,189,210,210, \
 191,203,204,216,223,211,212,212,213,225,196,202,203,215,216,216, \
 217,211,212,236,237,267,208,220,233,263,264,228,259,223,260,260, \
 261,267,220,262,257,275,276,258,259,259,266,260,261,267,262,268, \
 263,263,264,270,271,283,272,266,267,267,268,262,269,263,264,276, \
 270,284,278,264,272,293,294,273,274,274,261,261,262,269,270,263, \
 264,264,265,265,266,287,267,267,303,275,269,262,312,270,285,285, \
 279,279,266,301,267,274,303,275,276,276,277,284,285,292,272,272, \
 294,294,330,288,289,303,276,290,291,284,285,285,286,279,287,287, \
 281,313,314,314,315,291,348,308,301,285,294,294,303,303,296,304, \
 305,305,306,330,307,307,308,292,309,309,294,326,311,311,312,328, \
 321,321,306,322,347,323,308,308,333,317,326,326,343,311,328,384, \
 329,337,338,330,315,323,348,348,357,341,342,374,343,343,312,368, \
 365,347,339,366,367,340,332,368,360,378,352,370,353,380,336,381, \
 346,328,365,383,348,366,358,358,350,359,387,369,361,379,344,407, \
 408,354,355,346,383,383,420,420,367,421,377,377,378,378,406,415, \
 398,416,372,372,418,418,419,419,411,384,385,412,413,395,414,414, \
 419,419,410,420,381,381,372,422,383,393,414,384,415,415,416,416, \
 427,417,408,418,419,419,420,420,391,391,442,392,453,413,414,454, \
 435,445,446,456,407,427,448,438,449,409,410,420,411,431,432,422, \
 423,453,434,414,415,425,436,446,427,417,418,468,489,419,420,420, \
 420,486,410,454,422,444,445,456,446,446,447,458,459,492,482,438, \
 439,417,418,418,452,452,453,420,432,454,444,444,445,445,479,446, \
 458,447,448,459,460,427,450,494,495,528,441,452,453,453,454,487, \
 488,488,456,500,501,490,491,480,492,492,526,449,450,483,484,484, \
 461,497,474,474,463,499,488,488,489,453,490,490,527,491,492,492, \
 529,505,506,482,471,495,508,484,485,497,498,498,523,487,488,524, \
 525,465,490,490,515,515,516,492,493,481,482,494,495,483,544,520, \
 509,485,546,486,535,499,512,488,525,489,490,526,527,527,528,492, \
 567,528,490,503,504,491,531,492,571,506,507,572,573,573,522,561, \
 562,510,524,524,538,525,500,565,527,514,515,528,516,555,569,556, \
 557,518,519,571,533,533,560,560,522,561,536,536,537,537,564,525, \
 526,552,527,566,567,580,607,542,543,543,596,596,545,558,559,559, \
 599,599,600,600,531,531,532,588,631,603,548,576,577,563,536,564, \
 565,593,594,566,567,567,582,582,555,555,598,556,557,571,572,558, \
 559,559,560,560,561,603,618,604,563,633,634,564,593,621,594,636, \
 567,567,568,554,555,597,598,598,599,571,572,600,629,629,588,630, \
 599,644,630,570,571,586,587,632,633,618,634,634,635,605,621,606, \
 607,592,593,593,594,594,595,595,596,626,627,627,628,643,569,644, \
 600,600,601,586,587,632,633,618,634,634,635,605,606,636,637,637, \
 638,593,594,669,670,625,641,596,672,582,643,598,644,644,600,585, \
 673,657,674,674,643,643,644,596,597,597,598,710,663,599,600,600, \
 633,681,698,602,603,619,620,796,797,797,798,798,623,671,672,640, \
 801,785,786,786,787,819,788,628,629,661,662,790,791,807,824,696, \
 681,777,714,698,699,795,796,796,781,717,798,798,815,735,704,816 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,7,8,8, \
 9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72, \
 73,73,74,74,75,75,76,76,77,77,78,78,79,79,80,80, \
 81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88, \
 89,89,90,90,91,91,92,92,93,93,94,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,105,106,106,107,107,108,108,109,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,137,117,118,118,119,119,120,120, \
 121,141,138,138,147,123,124,124,153,141,146,138,143,147,128,152, \
 144,129,130,130,131,151,152,132,153,138,144,159,165,135,136,136, \
 137,137,138,138,139,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152, \
 153,153,154,154,155,155,156,156,157,177,183,158,159,159,160,160, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168, \
 169,169,170,170,171,171,172,172,173,173,174,174,175,175,176,176, \
 177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200, \
 201,201,202,202,203,203,204,204,205,205,206,206,207,207,208,208, \
 209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216, \
 217,217,218,218,219,219,220,220,221,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232, \
 233,233,234,234,235,235,236,236,237,237,238,238,239,239,240,240, \
 241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,252,253,253,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,265,266,266,267,267,268,268,269,269,270,270,271,271,272,272, \
 273,273,274,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,285,286,286,287,287,288,288, \
 289,289,290,290,291,291,292,292,293,333,294,294,295,295,296,296, \
 297,297,298,308,309,299,300,300,301,301,302,302,303,303,304,304, \
 305,305,306,306,307,307,308,308,309,309,310,310,311,311,312,312, \
 313,353,354,314,315,315,316,316,317,317,318,318,319,319,320,320, \
 321,409,355,322,323,323,324,324,325,325,326,326,415,393,328,328, \
 329,329,407,330,331,342,354,420,432,410,334,411,335,335,336,336, \
 414,425,338,415,416,372,406,340,341,341,342,419,409,376,377,410, \
 411,411,379,412,424,347,348,348,437,382,416,394,395,351,429,418, \
 437,353,354,354,355,415,404,428,429,441,406,358,443,359,360,420, \
 409,421,446,362,411,411,364,424,413,413,366,366,367,415,416,452, \
 441,369,430,370,419,455,456,456,469,373,374,374,375,375,376,376, \
 377,377,378,378,379,379,380,464,381,381,466,454,455,455,456,456, \
 385,411,464,386,465,387,388,388,389,389,455,390,391,391,392,483, \
 393,393,394,472,473,421,422,474,423,410,411,437,438,490,452,426, \
 427,427,428,428,429,429,456,417,418,444,432,406,407,407,408,408, \
 409,409,410,410,411,411,464,438,413,413,414,414,415,415,416,416, \
 417,417,418,418,419,531,420,420,421,463,492,422,423,423,424,424, \
 425,425,426,426,427,427,428,428,429,429,430,430,431,487,488,474, \
 489,433,434,434,435,435,436,436,437,437,438,438,439,509,510,440, \
 441,441,442,498,499,527,528,444,445,515,516,502,503,517,504,490, \
 449,509,510,450,451,451,452,452,453,453,454,454,455,455,456,456, \
 457,457,458,503,504,459,460,460,461,461,462,462,463,463,464,464, \
 465,465,466,466,467,467,468,468,469,469,470,470,471,471,472,472, \
 473,473,474,474,565,520,536,476,477,537,478,523,479,479,480,540, \
 481,481,482,482,483,483,532,484,485,485,486,486,487,519,552,552, \
 569,489,490,554,491,491,492,492,493,573,494,494,495,495,496,496, \
 497,497,498,498,499,499,500,500,533,501,550,566,567,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,607,608,512 \

#define MPFR_MUL_THRESHOLD 6 /* limbs */
#define MPFR_EXP_2_THRESHOLD 455 /* bits */
#define MPFR_EXP_THRESHOLD 10001 /* bits */

/*********************
 * Threshold for ARM *
 *********************/
#elif defined (__arm__)

/* Generated by MPFR's tuneup.c, 2009-02-10, gcc 4.3 */
/* gcc50.fsffrance.org (armv5tel-unknown-linux-gnueabi) with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,80,0,0,72,72, \
 80,77,72,72,76,76,80,77,84,84,76,76,77,77,84,84, \
 76,76,80,80,84,84,76,76,80,80,84,84,79,79,80,80, \
 81,81,82,82,83,83,84,84,103,103,104,104,96,111,103,112, \
 104,104,111,111,112,112,128,128,120,120,127,127,119,119,111,111, \
 113,113,114,126,127,127,128,128,129,129,118,134,123,135,128,136, \
 137,137,134,134,127,127,128,128,141,137,142,142,143,143,144,144, \
 145,145,142,142,143,143,144,144,145,145,150,150,151,151,152,144, \
 149,149,158,150,159,159,160,160,161,153,158,154,159,159,160,160, \
 159,159,160,160,166,166,152,167,168,168,159,159,160,160,161,161, \
 167,167,163,163,164,159,150,160,161,166,167,162,168,158,159,159, \
 160,155,156,156,162,157,158,158,159,159,160,160,166,161,162,167, \
 168,168,159,159,160,160,206,206,207,167,168,168,224,224,210,205, \
 167,167,168,168,223,223,224,224,219,225,226,208,221,239,240,240, \
 223,205,224,224,225,207,208,256,239,209,222,222,253,223,224,224, \
 225,255,256,256,221,221,222,222,223,223,224,224,255,255,232,256, \
 233,233,234,234,223,253,254,254,243,249,250,250,239,233,240,288, \
 256,242,243,271,272,251,252,287,288,288,240,240,241,255,256,256, \
 257,257,258,272,252,252,253,253,254,254,255,255,256,256,271,257, \
 272,272,266,273,288,274,268,268,290,269,284,284,271,271,272,272, \
 280,280,288,281,282,282,290,304,333,298,271,299,307,286,287,287, \
 305,305,298,306,315,299,300,300,301,309,326,286,287,303,304,288, \
 289,305,330,330,331,331,332,324,333,333,286,286,287,335,336,336, \
 353,329,330,330,331,331,332,332,333,357,302,342,359,351,352,328, \
 353,345,354,330,331,331,332,332,333,357,358,358,359,367,368,368, \
 329,356,357,330,331,331,332,377,378,378,379,379,380,380,372,381, \
 355,382,383,356,357,384,367,403,404,404,405,405,379,352,353,362, \
 363,363,373,382,383,374,402,384,403,403,404,404,405,378,379,352, \
 353,362,381,381,427,427,428,428,429,429,367,376,377,431,405,432, \
 429,379,380,380,381,381,402,402,403,453,404,384,405,375,406,406, \
 407,377,378,378,379,379,380,380,381,381,432,432,383,383,384,384, \
 385,425,426,396,407,477,408,408,419,399,400,380,381,401,402,392, \
 393,403,404,404,405,405,476,426,427,417,428,428,429,429,430,430, \
 409,420,421,476,477,477,401,401,402,402,403,403,426,426,427,405, \
 417,428,429,429,430,430,431,431,432,421,477,422,423,423,424,424, \
 425,425,426,459,471,449,428,428,429,429,430,452,453,475,465,454, \
 455,455,456,456,468,468,469,458,470,492,438,471,472,450,473,473, \
 449,449,450,450,451,451,452,452,453,453,454,478,479,467,468,456, \
 481,469,470,458,459,471,496,472,473,461,462,462,463,475,476,476, \
 477,477,478,466,467,467,468,468,469,469,470,482,483,483,484,496, \
 497,485,486,474,475,475,476,500,501,477,490,490,491,491,492,492, \
 463,476,477,477,478,478,479,492,480,493,494,481,495,495,483,483, \
 497,497,498,498,499,473,474,474,475,488,489,463,464,464,465,465, \
 466,453,467,467,468,494,495,482,483,470,471,497,498,498,499,499, \
 500,474,475,475,476,463,464,490,491,491,492,492,493,480,481,572, \
 501,473,474,474,475,475,476,476,477,477,478,478,479,479,620,480, \
 481,495,496,496,497,595,596,498,499,499,612,486,613,669,614,600, \
 489,615,616,672,477,477,618,618,619,619,620,620,607,621,664,622, \
 623,623,624,624,625,611,612,668,669,669,614,614,615,671,672,616, \
 614,644,645,645,616,616,647,617,618,618,619,664,650,665,666,651, \
 667,667,668,668,669,654,655,655,656,656,657,657,658,658,659,659, \
 660,645,646,661,662,617,648,648,619,649,650,665,666,711,712,667, \
 668,668,714,669,715,715,716,671,672,672,673,658,674,704,690,675, \
 657,657,658,658,659,691,708,708,693,709,710,710,711,711,712,712, \
 713,713,714,666,667,667,668,716,765,717,718,718,719,719,720,720, \
 737,705,690,722,723,755,756,740,725,757,758,710,759,759,712,712, \
 761,713,714,714,715,715,764,764,765,717,766,766,767,767,768,768 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72, \
 73,73,74,74,75,75,76,76,77,77,78,78,79,79,80,80, \
 81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88, \
 89,89,90,90,91,91,92,92,93,93,94,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,105,106,106,107,107,108,108,109,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120, \
 121,121,122,122,123,123,124,124,125,125,126,126,127,127,128,128, \
 129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136, \
 137,137,138,138,139,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152, \
 168,153,154,154,155,155,156,156,157,177,168,168,174,159,160,160, \
 161,173,174,168,175,163,164,164,165,183,184,184,167,167,168,168, \
 169,169,170,170,171,171,172,172,173,173,174,174,175,175,176,176, \
 177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200, \
 201,201,202,202,203,224,204,204,205,205,206,206,207,207,208,208, \
 209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216, \
 217,217,218,218,219,219,220,220,221,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232, \
 233,233,234,234,235,235,236,236,237,237,238,238,239,239,240,240, \
 241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,252,253,253,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,265,266,266,267,267,268,268,269,269,270,270,271,271,272,272, \
 273,273,274,274,275,302,303,276,304,277,278,296,279,288,316,280, \
 281,308,309,282,283,319,320,302,303,285,286,313,314,287,288,288, \
 329,289,320,310,311,321,312,312,313,313,334,324,325,325,326,326, \
 327,337,328,328,329,329,330,330,331,301,302,332,333,333,334,304, \
 305,305,306,306,357,337,338,328,349,349,350,350,351,351,352,352, \
 343,343,344,354,355,365,366,366,367,387,388,388,319,349,370,370, \
 365,354,355,355,356,378,379,368,369,380,381,392,393,393,328,328, \
 329,373,374,396,386,386,387,387,388,399,378,400,412,423,336,424, \
 403,403,393,371,372,405,406,406,396,407,408,397,398,409,410,432, \
 345,422,423,401,402,413,414,392,393,415,416,427,428,417,429,440, \
 437,401,402,438,439,451,452,452,453,417,418,430,431,431,432,432, \
 433,421,422,446,447,459,460,424,425,365,366,366,367,451,452,368, \
 369,429,430,454,455,443,444,456,457,445,446,482,483,375,376,376, \
 377,437,438,450,451,475,476,488,501,465,478,430,431,383,384,384, \
 385,385,386,503,504,491,440,388,389,389,390,507,391,391,392,392, \
 393,393,394,394,395,434,396,487,449,449,450,398,399,399,400,400, \
 401,401,402,402,403,403,404,404,405,405,445,458,459,446,460,408, \
 461,409,410,410,411,411,412,412,413,413,414,492,415,415,416,416, \
 417,417,418,418,419,489,420,420,421,421,422,422,423,423,424,480, \
 425,425,426,468,497,427,428,428,429,429,430,430,431,431,432,432, \
 433,433,434,434,435,435,436,436,437,437,438,438,439,439,440,440, \
 441,441,442,442,443,443,444,444,445,445,446,446,447,447,448,448, \
 449,449,450,450,451,451,452,452,453,453,454,454,455,455,456,456, \
 457,457,458,458,459,459,460,520,521,461,462,462,463,463,464,464, \
 465,465,466,511,512,467,468,468,469,469,470,470,471,471,472,472, \
 473,473,474,474,475,535,536,551,477,477,478,478,479,479,480,480, \
 481,481,482,482,483,483,484,484,485,485,486,486,487,487,488,488, \
 489,489,490,490,491,491,492,492,493,493,494,494,495,495,496,496, \
 497,497,498,498,499,499,500,500,501,501,502,502,503,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,512 \

#define MPFR_MUL_THRESHOLD 7 /* limbs */
#define MPFR_EXP_2_THRESHOLD 407 /* bits */
#define MPFR_EXP_THRESHOLD 4030 /* bits */

/*************************
 * Threshold for PowerPC *
 *************************/
#elif defined (__PPC64__)

/* Generated by MPFR's tuneup.c, 2009-02-18, gcc 4.1.2 */
/* gcc40.fsffrance.org (powerpc64-unknown-linux-gnu) with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 26,28,26,27,28,32,32,32,35,36,35,35,35,35,36,40, \
 39,39,44,40,39,39,40,40,43,43,44,44,43,43,44,48, \
 51,47,48,48,51,47,56,52,51,51,52,52,59,57,60,56, \
 57,63,56,64,63,63,72,64,71,71,72,72,71,69,72,72, \
 71,71,72,80,77,79,72,80,71,79,72,80,87,87,88,80, \
 80,80,87,87,79,79,80,80,84,105,88,82,92,104,93,87, \
 88,88,104,104,105,105,103,88,104,104,105,102,103,103,101,104, \
 105,105,103,100,101,104,105,105,112,103,104,104,105,111,112,109, \
 116,116,117,117,127,124,116,116,117,117,124,115,122,116,117,117, \
 117,125,122,122,123,123,128,128,129,129,126,138,127,131,132,128, \
 129,129,130,134,147,147,152,140,141,141,138,146,139,139,140,140, \
 141,141,146,146,147,147,144,144,153,141,158,146,147,163,164,152, \
 153,161,150,162,163,159,164,160,165,165,170,170,171,175,152,164, \
 174,164,175,180,156,171,172,177,188,158,159,189,165,165,171,211, \
 177,187,188,213,174,189,210,180,176,201,207,177,213,213,189,204, \
 205,205,206,211,212,207,188,213,189,189,210,210,211,206,212,212, \
 208,213,189,209,210,205,211,206,212,212,213,208,209,209,235,215, \
 209,209,210,216,211,211,212,212,213,213,220,214,209,227,216,216, \
 211,211,212,236,213,237,232,232,239,239,240,234,235,235,236,230, \
 237,237,232,232,233,233,234,234,235,235,236,236,237,237,238,238, \
 239,257,240,240,235,235,236,260,261,237,268,256,275,275,276,264, \
 235,249,257,264,237,237,252,259,309,260,261,254,311,311,312,312, \
 264,264,272,293,259,259,260,260,261,261,311,311,312,305,285,285, \
 293,272,308,301,309,309,261,310,276,276,305,312,299,348,307,300, \
 294,315,302,309,310,310,311,311,305,305,306,306,321,300,343,301, \
 313,321,330,306,315,347,308,332,341,357,342,310,343,343,312,312, \
 337,305,306,306,347,347,348,348,325,317,326,326,311,343,312,312, \
 321,321,346,346,339,347,348,348,357,357,342,366,335,343,384,384, \
 377,321,338,338,347,339,348,380,357,381,382,350,351,375,376,376, \
 347,347,348,348,340,340,341,341,342,342,343,343,344,344,345,381, \
 382,346,347,347,348,348,349,376,350,359,378,351,352,415,416,389, \
 345,345,346,346,347,383,384,384,376,412,377,377,378,378,379,379, \
 380,380,381,381,373,382,383,383,384,384,403,376,395,377,378,396, \
 419,419,380,400,381,381,382,382,383,383,404,374,375,375,376,376, \
 377,377,378,378,419,389,420,400,401,381,382,382,383,423,454,384, \
 405,415,416,456,387,427,398,418,419,399,420,420,401,441,402,422, \
 423,413,414,454,415,415,416,416,417,407,418,398,419,419,420,420, \
 420,420,443,454,444,455,456,456,457,435,447,436,437,415,438,416, \
 417,450,451,418,419,463,442,420,432,454,488,444,489,445,446,446, \
 458,458,459,459,427,438,461,439,451,440,419,452,486,453,454,454, \
 455,455,445,445,446,490,491,447,448,448,449,482,461,450,451,484, \
 461,461,474,450,451,487,464,488,489,489,466,478,479,491,492,456, \
 481,481,482,494,507,519,520,460,461,497,486,474,487,535,536,488, \
 513,525,454,526,455,527,528,528,469,505,482,494,519,519,496,508, \
 509,521,486,546,523,523,512,488,489,513,514,490,563,527,528,492, \
 515,502,555,542,491,556,557,492,558,519,520,559,495,534,561,535, \
 562,510,511,563,564,564,630,552,553,631,632,528,529,633,634,634, \
 635,635,636,636,520,520,560,534,535,561,627,562,537,550,629,564, \
 617,526,527,618,619,632,633,633,621,634,609,609,636,636,546,611, \
 557,627,628,614,573,629,630,630,603,631,562,632,619,619,634,634, \
 635,635,622,636,567,623,624,596,611,625,626,626,641,627,628,614, \
 643,643,630,616,617,617,618,618,619,633,634,620,635,621,622,622, \
 707,609,624,624,625,639,612,612,627,641,642,628,629,643,602,616, \
 614,629,630,615,616,616,617,707,708,633,634,634,635,620,621,636, \
 607,622,623,623,624,639,625,670,686,701,702,627,643,643,644,644, \
 630,705,706,706,707,632,633,633,709,619,620,710,711,636,697,652, \
 698,638,639,624,625,685,686,626,702,627,703,643,689,629,630,630, \
 705,705,690,690,691,707,708,708,629,677,630,630,631,631,632,632, \
 633,697,698,634,635,699,700,684,701,701,702,702,703,639,704,672, \
 705,641,706,690,707,707,708,708,709,693,710,710,775,695,712,712, \
 713,777,778,778,763,715,716,780,717,701,702,686,703,703,704,704 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,6,6,7,7,8,8, \
 9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,32,32,32,32,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 51,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,64,64,63,67,64,64,63,63,64,64, \
 65,65,66,66,67,67,68,68,69,69,70,76,71,71,72,72, \
 73,73,74,80,75,75,76,76,77,77,78,78,79,79,80,80, \
 81,81,82,82,83,83,84,84,85,85,86,92,102,87,88,88, \
 89,104,102,105,106,91,92,104,102,105,94,112,104,110,96,105, \
 105,105,102,114,123,107,108,120,117,117,122,122,123,103,104,120, \
 105,105,106,106,107,107,108,108,109,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,118,118,119,131,128,120, \
 121,129,122,122,123,135,140,124,125,125,126,126,127,127,128,128, \
 129,129,130,130,131,131,132,132,133,158,159,134,135,135,136,156, \
 137,147,138,138,139,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,146,147,147,148,188,189,149,150,150,151,191,187,192, \
 153,153,189,189,155,155,156,196,187,187,188,188,189,189,190,195, \
 191,161,162,204,163,187,188,194,189,189,190,190,191,209,192,216, \
 199,193,194,188,189,189,190,190,191,191,192,192,187,193,194,194, \
 195,201,202,196,197,197,198,210,199,199,206,212,213,213,184,184, \
 215,185,216,204,187,187,188,188,189,189,190,220,191,227,228,192, \
 193,193,194,194,195,237,224,224,225,225,240,198,213,199,200,200, \
 201,201,202,202,203,224,225,204,205,226,227,206,207,207,208,236, \
 237,209,210,210,211,260,240,240,248,213,214,214,215,215,216,216, \
 217,217,218,218,219,219,220,220,221,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,264,232, \
 249,233,234,266,267,235,236,268,237,237,302,238,239,239,240,240, \
 241,241,242,242,243,243,308,244,245,245,246,246,247,247,248,312, \
 249,249,250,250,251,251,252,324,285,309,254,254,327,295,272,312, \
 311,329,312,303,259,259,260,260,261,306,298,307,308,308,309,327, \
 328,310,311,293,294,285,304,268,269,305,306,315,316,307,308,326, \
 327,327,319,310,311,311,312,348,277,304,314,323,324,324,334,316, \
 317,308,309,336,319,328,329,320,312,366,286,286,359,332,333,342, \
 309,329,320,320,321,341,332,342,363,353,354,344,345,325,326,366, \
 297,337,338,328,329,339,350,350,351,351,362,352,353,373,374,344, \
 345,325,326,366,307,337,328,348,339,369,360,360,361,381,382,382, \
 333,373,314,364,315,315,346,336,337,377,378,368,369,319,320,380, \
 365,398,366,344,389,345,379,324,402,347,348,392,360,327,328,328, \
 329,329,330,374,375,375,387,365,366,366,356,389,390,357,380,369, \
 381,370,371,382,383,339,373,384,396,396,397,342,343,343,344,344, \
 345,345,346,346,347,347,348,348,393,415,416,350,351,351,407,385, \
 401,353,354,402,355,391,392,416,417,429,418,418,419,419,420,420, \
 445,409,362,362,363,363,364,436,365,437,438,366,427,415,416,416, \
 441,417,418,454,455,431,432,420,373,433,434,434,435,375,436,376, \
 377,377,378,402,415,379,380,380,381,381,382,382,383,383,384,384, \
 385,411,425,425,426,387,388,388,389,402,416,429,391,456,470,392, \
 432,393,394,446,447,395,396,474,397,397,398,398,399,399,400,400, \
 401,401,402,402,429,429,404,404,405,405,458,406,459,472,473,408, \
 474,409,410,410,411,411,412,412,413,413,414,414,415,454,455,455, \
 417,417,418,418,419,419,420,420,421,421,422,422,423,423,494,424, \
 425,425,426,510,567,427,428,428,429,429,556,430,431,431,432,558, \
 489,489,490,434,435,435,562,436,437,437,438,438,439,439,440,440, \
 441,567,568,456,569,569,570,584,585,445,446,558,573,447,448,560, \
 569,569,570,600,451,571,452,557,558,453,454,454,455,560,456,456, \
 562,457,458,563,564,564,595,580,581,461,462,582,583,598,599,599, \
 585,585,571,556,557,557,558,573,574,469,470,470,471,636,472,472, \
 473,563,564,564,550,580,581,581,582,567,568,598,599,584,585,585, \
 561,593,594,594,563,483,580,564,581,597,598,630,487,487,488,600, \
 601,601,602,618,635,571,572,572,557,573,574,558,591,591,608,592, \
 593,641,498,562,563,579,564,564,565,501,566,550,551,503,600,584, \
 585,617,618,506,635,603,604,572,573,573,574,622,591,575,576,592 \

#define MPFR_MUL_THRESHOLD 6 /* limbs */
#define MPFR_EXP_2_THRESHOLD 744 /* bits */
#define MPFR_EXP_THRESHOLD 11929 /* bits */

/*******************************
 * Threshold for Sparc 64 bits *
 *******************************/
#elif defined (__sparc_v9__)

/* Generated by MPFR's tuneup.c, 2009-02-20, gcc 4.1.2 */
/* gcc54.fsffrance.org (sparc64-unknown-linux-gnu) with gmp-4.2.4 */

#define MPFR_MULHIGH_TAB  \
 -1,-1,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,-1, \
 11,13,13,15,13,15,15,16,17,17,17,18,19,19,19,21, \
 21,19,23,21,23,24,25,25,26,27,26,30,25,27,27,34, \
 30,25,30,33,34,31,34,34,34,34,34,37,38,37,38,38, \
 39,39,42,40,43,41,42,42,45,43,50,46,45,45,46,48, \
 49,49,50,54,49,49,50,60,59,59,60,60,59,59,60,60, \
 67,67,60,68,61,65,68,66,67,67,68,68,69,75,76,68, \
 73,75,76,68,69,81,76,76,75,81,84,76,81,75,74,80, \
 98,92,96,84,76,97,80,83,84,99,76,85,92,110,99,96, \
 97,97,92,95,111,102,106,97,92,101,111,108,109,109,110,101, \
 99,99,100,109,110,110,108,108,112,109,110,110,111,111,109,118, \
 119,122,120,117,118,121,122,122,114,123,133,121,134,122,132,132, \
 129,133,134,126,135,123,132,140,125,137,138,126,135,147,140,144, \
 133,137,138,134,147,147,132,140,153,141,138,142,147,147,148,136, \
 137,177,138,138,159,147,152,156,177,177,174,146,175,159,176,168, \
 173,177,170,174,167,171,180,156,177,177,158,174,159,191,164,200, \
 159,174,180,180,176,201,172,177,173,178,179,199,180,180,176,201, \
 177,177,183,173,179,199,195,175,201,201,177,177,198,203,199,194, \
 200,200,201,201,177,197,198,193,189,199,200,225,201,191,197,192, \
 198,198,199,224,200,200,201,201,202,207,198,213,199,224,200,225, \
 221,203,228,204,223,223,218,224,201,225,208,220,221,245,228,228, \
 241,223,218,224,225,237,220,220,221,227,228,252,229,235,236,224, \
 243,225,226,250,293,293,228,276,229,289,248,272,249,237,244,280, \
 269,227,282,282,271,271,272,266,243,249,250,292,293,293,288,288, \
 256,291,285,285,293,286,294,287,288,281,303,289,283,276,270,277, \
 285,278,279,272,294,294,302,288,296,289,283,290,291,284,278,278, \
 293,286,294,294,288,288,310,275,325,283,312,284,313,292,293,314, \
 301,315,330,316,282,324,325,276,291,291,348,292,286,300,301,294, \
 337,313,330,314,315,323,324,292,325,357,366,350,311,303,344,320, \
 321,329,330,330,339,363,292,348,293,333,294,294,327,295,320,328, \
 329,329,322,322,371,331,316,324,333,325,334,366,327,311,312,312, \
 313,353,362,346,355,355,372,348,341,349,366,342,327,351,360,328, \
 329,329,330,357,331,358,332,350,324,333,325,352,380,371,363,363, \
 391,373,365,365,339,366,349,358,359,395,333,378,370,343,344,371, \
 354,363,364,364,365,365,411,366,358,349,404,350,360,360,361,388, \
 362,380,390,381,400,382,401,392,402,375,376,403,395,368,378,378, \
 369,379,380,380,381,411,372,402,453,443,394,374,425,435,436,426, \
 427,427,438,438,399,409,400,420,431,401,432,432,413,393,424,414, \
 425,375,406,436,387,397,418,418,399,419,390,430,401,401,442,432, \
 433,393,394,474,405,435,436,426,437,437,388,438,429,449,400,440, \
 486,409,443,476,411,477,423,434,468,446,425,458,459,437,471,526, \
 450,450,473,528,441,474,519,442,432,410,477,433,478,434,435,435, \
 436,502,481,437,471,449,483,516,473,528,518,452,453,519,454,520, \
 433,532,533,434,479,512,513,513,525,459,427,438,516,516,517,528, \
 437,437,474,474,511,523,512,524,525,525,514,502,539,527,480,528, \
 517,529,506,518,519,531,520,520,533,521,522,498,499,487,500,524, \
 525,525,526,490,527,539,504,600,493,589,518,518,507,483,544,496, \
 521,593,474,522,535,511,524,524,585,597,526,514,599,587,564,528, \
 580,580,594,594,569,582,596,596,532,519,585,533,534,599,561,600, \
 523,588,524,524,590,564,591,526,579,527,528,515,516,529,608,595, \
 570,596,597,597,598,598,599,521,535,587,588,523,524,602,577,590, \
 526,578,540,605,671,593,594,594,608,582,557,609,597,558,585,598, \
 599,599,600,586,587,601,602,532,589,589,590,576,661,535,578,578, \
 593,579,566,594,581,581,554,596,611,597,570,626,599,599,614,600, \
 573,671,588,574,603,589,590,590,591,605,606,662,663,579,594,608, \
 609,595,680,652,597,667,598,598,599,599,600,600,573,587,672,588, \
 584,659,600,600,601,616,602,602,618,588,619,664,605,590,591,591, \
 592,652,593,608,609,669,595,595,596,581,672,597,613,673,599,629, \
 690,600,601,616,617,662,663,663,739,679,650,635,621,681,622,652, \
 668,623,609,669,655,670,671,671,657,672,733,658,644,674,600,660, \
 641,657,722,658,675,723,660,676,661,677,678,710,663,743,664,680, \
 649,665,714,730,699,747,684,636,685,605,654,670,671,671,752,672, \
 721,673,658,706,675,659,676,676,677,597,742,742,743,679,728,744, \
 681,665,666,730,651,747,652,668,669,685,750,670,735,687,736,752 \

#define MPFR_SQRHIGH_TAB  \
 -1,0,0,0,0,-1,0,-1,5,5,6,6,7,7,9,8, \
 9,9,10,10,12,12,13,12,13,13,14,14,15,16,17,18, \
 18,17,18,19,19,24,20,20,22,24,22,22,23,23,24,25, \
 25,25,26,26,28,30,28,28,29,29,30,32,31,31,32,33, \
 33,33,36,36,39,35,36,36,43,37,38,38,39,39,40,40, \
 41,41,44,42,43,47,50,44,45,47,52,46,47,47,48,48, \
 49,49,50,50,53,51,52,52,53,55,54,54,57,57,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,65,66,69,70,67,68,74,69,75,70,73,74,71,72,72, \
 73,73,80,77,75,75,76,76,86,92,78,81,82,79,80,80, \
 81,87,88,85,86,83,84,84,85,88,92,101,87,87,88,88, \
 89,89,90,90,91,91,92,92,93,102,97,94,101,95,96,117, \
 97,97,98,98,99,123,108,100,113,113,106,114,107,103,104,108, \
 125,105,122,114,123,107,124,108,129,109,114,110,111,111,112,112, \
 113,113,114,114,115,115,116,132,117,125,130,126,119,119,120,120, \
 121,121,122,130,131,123,124,124,149,137,126,126,143,143,132,144, \
 129,144,130,130,131,131,132,132,133,138,144,134,135,150,156,136, \
 137,137,138,138,139,144,150,140,141,141,142,142,143,143,144,159, \
 145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152, \
 153,178,184,154,155,155,166,171,157,177,158,178,159,174,160,160, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,197,180,198, \
 187,193,170,182,171,201,172,172,173,191,174,174,175,181,176,176, \
 177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,200,194,194,195,195,196,196,197,197,198,198,199,199,200,221, \
 222,229,230,237,224,203,204,218,219,205,206,206,207,207,208,208, \
 209,237,210,210,211,225,212,212,213,213,214,214,215,222,216,216, \
 217,245,218,246,240,219,241,234,228,221,222,222,223,223,259,231, \
 233,233,226,266,267,227,228,260,261,229,230,246,255,255,240,256, \
 233,233,234,234,235,235,236,236,237,245,238,262,239,239,240,240, \
 249,241,250,242,243,243,252,244,245,245,246,246,247,255,312,256, \
 249,249,250,250,315,267,268,300,261,293,294,294,295,303,304,304, \
 293,293,303,294,295,295,305,296,288,288,289,316,317,335,318,318, \
 319,319,275,293,294,303,268,295,269,296,306,297,271,316,272,272, \
 273,273,301,292,302,311,357,303,286,286,287,278,342,279,325,298, \
 326,353,336,318,328,319,320,311,303,303,313,304,305,332,315,297, \
 309,309,300,290,311,301,292,292,373,363,354,334,355,375,356,346, \
 297,327,348,328,319,299,310,330,301,301,322,312,313,373,334,324, \
 335,345,306,356,307,327,348,348,309,329,330,370,321,311,312,312, \
 313,343,354,354,355,345,336,346,317,387,348,318,319,339,340,340, \
 321,321,322,344,411,323,324,357,402,358,370,326,371,338,350,427, \
 373,362,341,330,375,342,409,332,333,366,389,334,357,335,402,336, \
 392,337,338,338,405,350,384,373,363,341,342,364,376,365,366,388, \
 389,356,357,346,347,358,370,348,349,382,383,372,351,384,385,352, \
 413,353,366,354,355,355,404,392,393,357,358,358,359,407,408,360, \
 421,397,398,398,399,363,364,364,365,449,390,366,379,367,368,368, \
 369,369,370,382,371,371,372,444,373,373,374,374,375,375,388,400, \
 377,377,378,378,427,379,380,380,381,381,382,382,383,383,384,384, \
 385,437,399,386,387,387,440,388,389,389,390,442,391,482,392,392, \
 445,445,407,420,408,395,396,474,397,410,398,476,399,399,400,413, \
 401,401,415,402,403,416,404,404,444,405,406,406,407,407,408,408, \
 409,409,410,410,411,411,412,412,413,413,414,414,415,519,468,416, \
 445,417,418,418,419,433,420,434,435,435,436,436,423,423,424,466, \
 425,425,426,426,427,427,428,498,499,429,430,430,431,431,474,432, \
 433,433,434,462,463,435,436,436,437,493,480,438,439,439,440,454, \
 497,441,442,442,443,443,444,444,459,445,446,446,447,447,462,448, \
 449,449,450,465,451,451,452,452,453,453,454,454,455,455,486,456, \
 517,457,518,458,459,459,460,460,461,461,462,462,463,463,464,464, \
 465,465,466,466,467,467,468,468,469,469,470,470,471,501,502,472, \
 473,473,474,474,475,520,521,476,477,477,478,478,509,479,480,480, \
 481,481,482,482,483,483,484,484,501,485,486,486,487,487,488,488, \
 489,489,490,490,491,491,492,492,493,493,494,494,559,495,528,512, \
 497,497,514,498,499,499,500,500,533,501,502,502,503,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,512 \

#define MPFR_MUL_THRESHOLD 16 /* limbs */
#define MPFR_EXP_2_THRESHOLD 64 /* bits */
#define MPFR_EXP_THRESHOLD 9331 /* bits */

/* __mips64? __mips? */
#endif

/*******************************
 * Default values of Threshold *
 *******************************/
#ifndef MPFR_MULHIGH_TAB
# define MPFR_MULHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_SQRHIGH_TAB
# define MPFR_SQRHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_MUL_THRESHOLD
# define MPFR_MUL_THRESHOLD 40
#endif
#ifndef MPFR_EXP_2_THRESHOLD
# define MPFR_EXP_2_THRESHOLD 100 /* bits */
#endif
#ifndef MPFR_EXP_THRESHOLD
# define MPFR_EXP_THRESHOLD 25000 /* bits */
#endif
#ifndef MPFR_SINCOS_THRESHOLD
# define MPFR_SINCOS_THRESHOLD 30000 /* bits */
#endif
