#!/bin/bash
#
# dodiff.sh
# Written by Richard Dawe <rich@phekda.freeserve.co.uk> 2003-06-08
#
# Generate a diff between unpatched and patched sources, with the ability
# to cope with renamed & added files.
#
# This version is for the port of GNU pth 1.3.7 to DJGPP.
#

SRCDIR=/dev/c/develop/ports/orig/pth-1.3.7
DSTDIR=/dev/c/develop/ports/gnu.dev/pth-1.3.7

# Files that have the same name under $srcdir as $dstdir
NORMAL="
PORTING
README
config.guess
config.sub
shtool
pth.h.in
pthread.h.in
pth_mctx.c
"

# Files that have been renamed in $dstdir compared with $srcdir
# Syntax: <old-name>:<new-name>
RENAMED="
"

# Files that are new in $dstdir
NEW="
"

# Parse command-line args
test=0

while [ $# -gt 0 ]; do
    # Test mode?
    if [ "$1" = "-n" ]; then
	test=1
	shift
	continue
    # Trace mode?
    elif [ "$1" = "-t" ]; then
	set -x
	shift
	continue
    # Assume the other options are for diff
    else
	break
    fi
done

DIFFOPTS="$@"
DIFF="diff $DIFFOPTS"

# Check that source directories exist
if [ ! -d $SRCDIR ]; then
    echo ERROR: $SRCDIR is not a directory
    exit 1
fi

if [ ! -d $DSTDIR ]; then
    echo ERROR: $DSTDIR is not a directory
    exit 1
fi

# Failure status for existence checks
failed=0

# Check that normal files exist
for i in $NORMAL; do
    if [ ! -r $SRCDIR/$i ]; then
	echo MISSING: $SRCDIR/$i
	failed=1
    fi

    if [ ! -r $DSTDIR/$i ]; then
	echo MISSING: $DSTDIR/$i
	failed=1
    fi
done

# Check that renamed files exist
for i in $RENAMED; do
    origname=`echo $i | cut -d : -f 1`
    newname=`echo $i | cut -d : -f 2`

    if [ ! -r $SRCDIR/$origname ]; then
	echo MISSING: $SRCDIR/$origname
	failed=1
    fi

    if [ ! -r $DSTDIR/$newname ]; then
	echo MISSING: $DSTDIR/$newname
	failed=1
    fi
done

# Check that new files exist
for i in $NEW; do
    if [ ! -r $DSTDIR/$i ]; then
	echo MISSING: $DSTDIR/$i
	failed=1
    fi
done

if [ "a$failed" != "a0" ]; then
    echo Files missing - aborting
    exit 1
fi

if [ "a$test" != "a0" ]; then
    echo Running in test mode - exiting
    exit 0
fi

# Diff the normal files
for i in $NORMAL; do
    $DIFF $SRCDIR/$i $DSTDIR/$i
done

# Diff the renamed files
for i in $RENAMED; do
    origname=`echo $i | cut -d : -f 1`
    newname=`echo $i | cut -d : -f 2`

    $DIFF $SRCDIR/$origname $DSTDIR/$newname
done

# Diff the new files
for i in $NEW; do
    $DIFF /dev/null $DSTDIR/$i
done
