/* zeitgeist-daemon.c generated by valac 0.38.8, the Vala compiler
 * generated from zeitgeist-daemon.vala, do not modify */

/* zeitgeist-daemon.vala
 *
 * Copyright © 2011 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist.h"
#include "zeitgeist-engine.h"
#include "zeitgeist-datamodel.h"
#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include <stdio.h>
#include <signal.h>
#include <locale.h>
#include "config.h"


#define ZEITGEIST_TYPE_REMOTE_DBUS (zeitgeist_remote_dbus_get_type ())
#define ZEITGEIST_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBus))
#define ZEITGEIST_IS_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS))
#define ZEITGEIST_REMOTE_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBusIface))

typedef struct _ZeitgeistRemoteDBus ZeitgeistRemoteDBus;
typedef struct _ZeitgeistRemoteDBusIface ZeitgeistRemoteDBusIface;

#define ZEITGEIST_TYPE_REMOTE_DBUS_PROXY (zeitgeist_remote_dbus_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteDBusProxy;
typedef GDBusProxyClass ZeitgeistRemoteDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZEITGEIST_TYPE_DAEMON (zeitgeist_daemon_get_type ())
#define ZEITGEIST_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon))
#define ZEITGEIST_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonClass))
#define ZEITGEIST_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DAEMON))
#define ZEITGEIST_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DAEMON))
#define ZEITGEIST_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonClass))

typedef struct _ZeitgeistDaemon ZeitgeistDaemon;
typedef struct _ZeitgeistDaemonClass ZeitgeistDaemonClass;
typedef struct _ZeitgeistDaemonPrivate ZeitgeistDaemonPrivate;
enum  {
	ZEITGEIST_DAEMON_0_PROPERTY,
	ZEITGEIST_DAEMON_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_daemon_properties[ZEITGEIST_DAEMON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistDaemonGetEventsData ZeitgeistDaemonGetEventsData;
typedef struct _ZeitgeistDaemonFindRelatedUrisData ZeitgeistDaemonFindRelatedUrisData;
typedef struct _ZeitgeistDaemonFindEventIdsData ZeitgeistDaemonFindEventIdsData;
typedef struct _ZeitgeistDaemonFindEventsData ZeitgeistDaemonFindEventsData;
typedef struct _ZeitgeistDaemonInsertEventsData ZeitgeistDaemonInsertEventsData;
typedef struct _ZeitgeistDaemonDeleteEventsData ZeitgeistDaemonDeleteEventsData;
typedef struct _ZeitgeistDaemonQuitData ZeitgeistDaemonQuitData;
typedef struct _ZeitgeistDaemonInstallMonitorData ZeitgeistDaemonInstallMonitorData;
typedef struct _ZeitgeistDaemonRemoveMonitorData ZeitgeistDaemonRemoveMonitorData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistRemoteDBusIface {
	GTypeInterface parent_iface;
	gboolean (*name_has_owner) (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
};

struct _ZeitgeistDaemon {
	GObject parent_instance;
	ZeitgeistDaemonPrivate * priv;
};

struct _ZeitgeistDaemonClass {
	GObjectClass parent_class;
};

struct _ZeitgeistDaemonPrivate {
	ZeitgeistRegisterExtensionFunc* builtins;
	gint builtins_length1;
	gint _builtins_size_;
	ZeitgeistEngine* engine;
	ZeitgeistMonitorManager* notifications;
	guint log_register_id;
	GDBusConnection* connection;
};

struct _ZeitgeistDaemonGetEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	guint32* event_ids;
	gint event_ids_length1;
	GCancellable* cancellable;
	char* sender;
	GVariant* result;
	GTimer* timer;
	GTimer* _tmp0_;
	GPtrArray* events;
	ZeitgeistEngine* _tmp1_;
	guint32* _tmp2_;
	gint _tmp2__length1;
	GPtrArray* _tmp3_;
	GTimer* _tmp4_;
	gdouble _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GVariant* _tmp9_;
	GPtrArray* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonFindRelatedUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	GVariant* time_range;
	GVariant* event_templates;
	GVariant* result_event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GCancellable* cancellable;
	char* sender;
	gchar** result;
	gint result_length1;
	ZeitgeistTimeRange* _tmp0_;
	GVariant* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GPtrArray* _tmp3_;
	GVariant* _tmp4_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	GVariant* _tmp7_;
	GPtrArray* _tmp8_;
	gchar** _tmp9_;
	ZeitgeistEngine* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gint _tmp14_;
	gchar** _tmp15_;
	gint _tmp9__length1;
	gint __tmp9__size_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonFindEventIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	GVariant* time_range;
	GVariant* event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GCancellable* cancellable;
	char* sender;
	guint32* result;
	gint result_length1;
	GTimer* timer;
	GTimer* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GVariant* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GPtrArray* _tmp4_;
	GVariant* _tmp5_;
	GPtrArray* _tmp6_;
	guint32* ids;
	ZeitgeistEngine* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	const char* _tmp11_;
	gint _tmp12_;
	guint32* _tmp13_;
	gint ids_length1;
	gint _ids_size_;
	GTimer* _tmp14_;
	gdouble _tmp15_;
	guint32* _tmp16_;
	gint _tmp16__length1;
	guint32* _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonFindEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	GVariant* time_range;
	GVariant* event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GCancellable* cancellable;
	char* sender;
	GVariant* result;
	GTimer* timer;
	GTimer* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GVariant* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GPtrArray* _tmp4_;
	GVariant* _tmp5_;
	GPtrArray* _tmp6_;
	GPtrArray* events;
	ZeitgeistEngine* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	const char* _tmp11_;
	GPtrArray* _tmp12_;
	GTimer* _tmp13_;
	gdouble _tmp14_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GVariant* _tmp18_;
	GPtrArray* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonInsertEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	GVariant* vevents;
	GCancellable* cancellable;
	char* sender;
	guint32* result;
	gint result_length1;
	GPtrArray* events;
	GVariant* _tmp0_;
	GPtrArray* _tmp1_;
	guint32* event_ids;
	ZeitgeistEngine* _tmp2_;
	GPtrArray* _tmp3_;
	const char* _tmp4_;
	gint _tmp5_;
	guint32* _tmp6_;
	gint event_ids_length1;
	gint _event_ids_size_;
	gint64 min_timestamp;
	gint64 max_timestamp;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GPtrArray* _tmp13_;
	gint _tmp14_;
	gconstpointer _tmp15_;
	gint64 _tmp16_;
	GPtrArray* _tmp17_;
	gint _tmp18_;
	gconstpointer _tmp19_;
	gint64 _tmp20_;
	gint64 _tmp21_;
	gint64 _tmp22_;
	gint64 _tmp23_;
	GPtrArray* _tmp24_;
	gint _tmp25_;
	gconstpointer _tmp26_;
	gint64 _tmp27_;
	gint64 _tmp28_;
	gint64 _tmp29_;
	gint64 _tmp30_;
	ZeitgeistMonitorManager* _tmp31_;
	gint64 _tmp32_;
	gint64 _tmp33_;
	ZeitgeistTimeRange* _tmp34_;
	ZeitgeistTimeRange* _tmp35_;
	GPtrArray* _tmp36_;
	guint32* _tmp37_;
	gint _tmp37__length1;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonDeleteEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	guint32* event_ids;
	gint event_ids_length1;
	GCancellable* cancellable;
	char* sender;
	GVariant* result;
	ZeitgeistTimeRange* time_range;
	ZeitgeistEngine* _tmp0_;
	guint32* _tmp1_;
	gint _tmp1__length1;
	const char* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistMonitorManager* _tmp5_;
	ZeitgeistTimeRange* _tmp6_;
	guint32* _tmp7_;
	gint _tmp7__length1;
	ZeitgeistTimeRange* _tmp8_;
	ZeitgeistTimeRange* _tmp9_;
	GVariant* _tmp10_;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonQuitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	GCancellable* cancellable;
};

struct _ZeitgeistDaemonInstallMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	char* monitor_path;
	GVariant* time_range;
	GVariant* event_templates;
	char* owner;
	const char* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GVariant* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GPtrArray* _tmp4_;
	GVariant* _tmp5_;
	GPtrArray* _tmp6_;
	ZeitgeistMonitorManager* _tmp7_;
	const char* _tmp8_;
	const char* _tmp9_;
	GError * _inner_error_;
};

struct _ZeitgeistDaemonRemoveMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDaemon* self;
	char* monitor_path;
	char* owner;
	const char* _tmp0_;
	ZeitgeistMonitorManager* _tmp1_;
	const char* _tmp2_;
	const char* _tmp3_;
};


static gpointer zeitgeist_daemon_parent_class = NULL;
static gboolean zeitgeist_daemon_show_version_info;
static gboolean zeitgeist_daemon_show_version_info = FALSE;
static gboolean zeitgeist_daemon_show_options;
static gboolean zeitgeist_daemon_show_options = FALSE;
static gboolean zeitgeist_daemon_no_datahub;
static gboolean zeitgeist_daemon_no_datahub = FALSE;
static gboolean zeitgeist_daemon_perform_vacuum;
static gboolean zeitgeist_daemon_perform_vacuum = FALSE;
static gboolean zeitgeist_daemon_replace_mode;
static gboolean zeitgeist_daemon_replace_mode = FALSE;
static gboolean zeitgeist_daemon_quit_daemon;
static gboolean zeitgeist_daemon_quit_daemon = FALSE;
static gchar* zeitgeist_daemon_log_level;
static gchar* zeitgeist_daemon_log_level = NULL;
static gchar* zeitgeist_daemon_log_file;
static gchar* zeitgeist_daemon_log_file = NULL;
static ZeitgeistDaemon* zeitgeist_daemon_instance;
static ZeitgeistDaemon* zeitgeist_daemon_instance = NULL;
static GMainLoop* zeitgeist_daemon_mainloop;
static GMainLoop* zeitgeist_daemon_mainloop = NULL;
static gboolean zeitgeist_daemon_name_acquired;
static gboolean zeitgeist_daemon_name_acquired = FALSE;
static ZeitgeistRemoteLogIface * zeitgeist_daemon_zeitgeist_remote_log_parent_iface = NULL;

GType zeitgeist_remote_dbus_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_dbus_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_dbus_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface);
static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data);
GType zeitgeist_daemon_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonPrivate))
ZeitgeistDaemon* zeitgeist_daemon_new (GError** error);
ZeitgeistDaemon* zeitgeist_daemon_construct (GType object_type, GError** error);
GType zeitgeist_data_source_registry_extension_init (GTypeModule* mod);
static GType _zeitgeist_data_source_registry_extension_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_blacklist_init (GTypeModule* mod);
static GType _zeitgeist_blacklist_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_histogram_init (GTypeModule* mod);
static GType _zeitgeist_histogram_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_storage_monitor_init (GTypeModule* mod);
static GType _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_fts_init (GTypeModule* mod);
static GType _zeitgeist_fts_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_benchmark_init (GTypeModule* mod);
static GType _zeitgeist_benchmark_init_zeitgeist_register_extension_func (GTypeModule* module);
static void zeitgeist_daemon_real_get_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_get_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_get_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_get_events_co (ZeitgeistDaemonGetEventsData* _data_);
static void zeitgeist_daemon_real_find_related_uris_data_free (gpointer _data);
static void zeitgeist_daemon_real_find_related_uris_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_find_related_uris (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_find_related_uris_co (ZeitgeistDaemonFindRelatedUrisData* _data_);
static void zeitgeist_daemon_real_find_event_ids_data_free (gpointer _data);
static void zeitgeist_daemon_real_find_event_ids_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_find_event_ids (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_find_event_ids_co (ZeitgeistDaemonFindEventIdsData* _data_);
static void zeitgeist_daemon_real_find_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_find_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_find_events (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_find_events_co (ZeitgeistDaemonFindEventsData* _data_);
static void zeitgeist_daemon_real_insert_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_insert_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_insert_events (ZeitgeistRemoteLog* base, GVariant* vevents, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_insert_events_co (ZeitgeistDaemonInsertEventsData* _data_);
static void zeitgeist_daemon_real_delete_events_data_free (gpointer _data);
static void zeitgeist_daemon_real_delete_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_delete_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_delete_events_co (ZeitgeistDaemonDeleteEventsData* _data_);
static void zeitgeist_daemon_real_quit_data_free (gpointer _data);
static void zeitgeist_daemon_real_quit_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_quit (ZeitgeistRemoteLog* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_quit_co (ZeitgeistDaemonQuitData* _data_);
static void zeitgeist_daemon_do_quit (ZeitgeistDaemon* self);
static void zeitgeist_daemon_real_install_monitor_data_free (gpointer _data);
static void zeitgeist_daemon_real_install_monitor_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_install_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_install_monitor_co (ZeitgeistDaemonInstallMonitorData* _data_);
static void zeitgeist_daemon_real_remove_monitor_data_free (gpointer _data);
static void zeitgeist_daemon_real_remove_monitor_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_daemon_real_remove_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_daemon_real_remove_monitor_co (ZeitgeistDaemonRemoveMonitorData* _data_);
void zeitgeist_daemon_register_dbus_object (ZeitgeistDaemon* self, GDBusConnection* conn, GError** error);
void zeitgeist_daemon_unregister_dbus_object (ZeitgeistDaemon* self);
static gboolean zeitgeist_daemon_quit_running_instance (GDBusConnection* conn);
static void zeitgeist_daemon_name_acquired_callback (GDBusConnection* conn);
static void zeitgeist_daemon_name_lost_callback (GDBusConnection* conn);
static gboolean ____lambda4_ (void);
static gboolean _____lambda4__gsource_func (gpointer self);
static void zeitgeist_daemon_run (GError** error);
static void _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void zeitgeist_daemon_safe_exit (void);
static gint zeitgeist_daemon_vacuum (void);
static gint zeitgeist_daemon_main (gchar** args, int args_length1);
static void _zeitgeist_daemon_safe_exit_sighandler_t (gint signal);
static void zeitgeist_daemon_finalize (GObject * obj);
static void _vala_zeitgeist_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s"};
static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b"};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_dbus_dbus_method_info[] = {&_zeitgeist_remote_dbus_dbus_method_info_name_has_owner, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_zeitgeist_remote_dbus_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_dbus_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_dbus_dbus_interface_vtable = {zeitgeist_remote_dbus_dbus_interface_method_call, zeitgeist_remote_dbus_dbus_interface_get_property, zeitgeist_remote_dbus_dbus_interface_set_property};
static const GOptionEntry ZEITGEIST_DAEMON_options[10] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_show_version_info, "Print program's version number and exit", NULL}, {"no-datahub", (gchar) 0, 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_no_datahub, "Do not start zeitgeist-datahub automatically", NULL}, {"vacuum", (gchar) 0, 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_perform_vacuum, "Perform VACUUM on database and exit", NULL}, {"no-passive-loggers", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &zeitgeist_daemon_no_datahub, NULL, NULL}, {"replace", 'r', 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_replace_mode, "If another Zeitgeist instance is already running, replace it", NULL}, {"quit", 'q', 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_quit_daemon, "Quit running Zeitgeist daemon instance", NULL}, {"log-level", (gchar) 0, 0, G_OPTION_ARG_STRING, &zeitgeist_daemon_log_level, "How much information should be printed; possible values: " "DEBUG, INFO, WARNING, ERROR, CRITICAL", "LEVEL"}, {"log-file", (gchar) 0, 0, G_OPTION_ARG_STRING, &zeitgeist_daemon_log_file, "File to which the log output will be appended", NULL}, {"shell-completion", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &zeitgeist_daemon_show_options, NULL, NULL}, {NULL}};

gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ZEITGEIST_REMOTE_DBUS_GET_INTERFACE (self)->name_has_owner (self, name, error);
}


static void zeitgeist_remote_dbus_base_init (ZeitgeistRemoteDBusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType zeitgeist_remote_dbus_get_type (void) {
	static volatile gsize zeitgeist_remote_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_remote_dbus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteDBusIface), (GBaseInitFunc) zeitgeist_remote_dbus_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zeitgeist_remote_dbus_type_id;
		zeitgeist_remote_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistRemoteDBus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zeitgeist_remote_dbus_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_dbus_proxy_get_type);
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_dbus_dbus_interface_info));
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_dbus_register_object);
		g_once_init_leave (&zeitgeist_remote_dbus_type_id__volatile, zeitgeist_remote_dbus_type_id);
	}
	return zeitgeist_remote_dbus_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteDBusProxy, zeitgeist_remote_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_DBUS, zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init) )
static void zeitgeist_remote_dbus_proxy_class_init (ZeitgeistRemoteDBusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_dbus_proxy_g_signal;
}


static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void zeitgeist_remote_dbus_proxy_init (ZeitgeistRemoteDBusProxy* self) {
}


static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp2_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp1_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}


static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface) {
	iface->name_has_owner = zeitgeist_remote_dbus_proxy_name_has_owner;
}


static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	result = zeitgeist_remote_dbus_name_has_owner (self, name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (name);
}


static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "NameHasOwner") == 0) {
		_dbus_zeitgeist_remote_dbus_name_has_owner (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint zeitgeist_remote_dbus_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info), &_zeitgeist_remote_dbus_dbus_interface_vtable, data, _zeitgeist_remote_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static GType _zeitgeist_data_source_registry_extension_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_data_source_registry_extension_init (module);
	return result;
}


static GType _zeitgeist_blacklist_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_blacklist_init (module);
	return result;
}


static GType _zeitgeist_histogram_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_histogram_init (module);
	return result;
}


static GType _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_storage_monitor_init (module);
	return result;
}


static GType _zeitgeist_fts_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_fts_init (module);
	return result;
}


static GType _zeitgeist_benchmark_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_benchmark_init (module);
	return result;
}


ZeitgeistDaemon* zeitgeist_daemon_construct (GType object_type, GError** error) {
	ZeitgeistDaemon * self = NULL;
	ZeitgeistRegisterExtensionFunc* _tmp0_;
	ZeitgeistEngine* _tmp1_ = NULL;
	ZeitgeistRegisterExtensionFunc* _tmp2_;
	gint _tmp2__length1;
	ZeitgeistEngine* _tmp3_;
	ZeitgeistEngine* _tmp4_;
	ZeitgeistMonitorManager* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (ZeitgeistRegisterExtensionFunc, 6);
	_tmp0_[0] = _zeitgeist_data_source_registry_extension_init_zeitgeist_register_extension_func;
	_tmp0_[1] = _zeitgeist_blacklist_init_zeitgeist_register_extension_func;
	_tmp0_[2] = _zeitgeist_histogram_init_zeitgeist_register_extension_func;
	_tmp0_[3] = _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func;
	_tmp0_[4] = _zeitgeist_fts_init_zeitgeist_register_extension_func;
	_tmp0_[5] = _zeitgeist_benchmark_init_zeitgeist_register_extension_func;
	self->priv->builtins = (g_free (self->priv->builtins), NULL);
	self->priv->builtins = _tmp0_;
	self->priv->builtins_length1 = 6;
	self->priv->_builtins_size_ = self->priv->builtins_length1;
	_tmp2_ = self->priv->builtins;
	_tmp2__length1 = self->priv->builtins_length1;
	_tmp3_ = zeitgeist_engine_new_with_builtins (_tmp2_, _tmp2__length1, &_inner_error_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp4_;
	_tmp5_ = zeitgeist_monitor_manager_get_default ();
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp5_;
	_g_object_unref0 (_tmp1_);
	return self;
}


ZeitgeistDaemon* zeitgeist_daemon_new (GError** error) {
	return zeitgeist_daemon_construct (ZEITGEIST_TYPE_DAEMON, error);
}


static void zeitgeist_daemon_real_get_events_data_free (gpointer _data) {
	ZeitgeistDaemonGetEventsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonGetEventsData, _data_);
}


static void zeitgeist_daemon_real_get_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonGetEventsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_daemon_real_get_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonGetEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	guint32* _tmp1_;
	gint _tmp1__length1;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	const char* _tmp4_;
	char* _tmp5_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonGetEventsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_get_events_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_get_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = event_ids;
	_tmp1__length1 = event_ids_length1;
	_data_->event_ids = _tmp1_;
	_data_->event_ids_length1 = _tmp1__length1;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	_tmp4_ = sender;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp5_;
	zeitgeist_daemon_real_get_events_co (_data_);
}


static GVariant* zeitgeist_daemon_real_get_events_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	ZeitgeistDaemonGetEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gboolean zeitgeist_daemon_real_get_events_co (ZeitgeistDaemonGetEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->engine;
	_data_->_tmp2_ = _data_->event_ids;
	_data_->_tmp2__length1 = _data_->event_ids_length1;
	_data_->_tmp3_ = zeitgeist_db_reader_get_events ((ZeitgeistDbReader*) _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp2__length1, NULL, &_data_->_inner_error_);
	_data_->events = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->timer;
	_data_->_tmp5_ = g_timer_elapsed (_data_->_tmp4_, NULL);
	_data_->_tmp6_ = _data_->events;
	_data_->_tmp7_ = g_ptr_array_get_length (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	g_debug ("zeitgeist-daemon.vala:164: %s executed in %f seconds: got %i events", "Zeitgeist.Daemon.get_events", _data_->_tmp5_, _data_->_tmp8_);
	_data_->_tmp10_ = _data_->events;
	_data_->_tmp11_ = zeitgeist_events_to_variant_with_limit (_data_->_tmp10_, ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE, &_data_->_inner_error_);
	_data_->_tmp9_ = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->events);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->_tmp9_;
	_data_->_tmp9_ = NULL;
	_data_->result = _data_->_tmp12_;
	_g_variant_unref0 (_data_->_tmp9_);
	_g_ptr_array_unref0 (_data_->events);
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_find_related_uris_data_free (gpointer _data) {
	ZeitgeistDaemonFindRelatedUrisData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_variant_unref0 (_data_->result_event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonFindRelatedUrisData, _data_);
}


static void zeitgeist_daemon_real_find_related_uris_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonFindRelatedUrisData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void zeitgeist_daemon_real_find_related_uris (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonFindRelatedUrisData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	const char* _tmp12_;
	char* _tmp13_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonFindRelatedUrisData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_find_related_uris_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_find_related_uris_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_templates;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = result_event_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_g_variant_unref0 (_data_->result_event_templates);
	_data_->result_event_templates = _tmp6_;
	_tmp7_ = storage_state;
	_data_->storage_state = _tmp7_;
	_tmp8_ = num_events;
	_data_->num_events = _tmp8_;
	_tmp9_ = result_type;
	_data_->result_type = _tmp9_;
	_tmp10_ = cancellable;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp11_;
	_tmp12_ = sender;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp13_;
	zeitgeist_daemon_real_find_related_uris_co (_data_);
}


static gchar** zeitgeist_daemon_real_find_related_uris_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	ZeitgeistDaemonFindRelatedUrisData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_daemon_real_find_related_uris_co (ZeitgeistDaemonFindRelatedUrisData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->time_range;
	_data_->_tmp2_ = zeitgeist_time_range_new_from_variant (_data_->_tmp1_, &_data_->_inner_error_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->event_templates;
	_data_->_tmp5_ = zeitgeist_events_from_variant (_data_->_tmp4_, &_data_->_inner_error_);
	_data_->_tmp3_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->result_event_templates;
	_data_->_tmp8_ = zeitgeist_events_from_variant (_data_->_tmp7_, &_data_->_inner_error_);
	_data_->_tmp6_ = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->engine;
	_data_->_tmp11_ = _data_->storage_state;
	_data_->_tmp12_ = _data_->num_events;
	_data_->_tmp13_ = _data_->result_type;
	_data_->_tmp15_ = zeitgeist_db_reader_find_related_uris ((ZeitgeistDbReader*) _data_->_tmp10_, _data_->_tmp0_, _data_->_tmp3_, _data_->_tmp6_, _data_->_tmp11_, _data_->_tmp12_, _data_->_tmp13_, NULL, &_data_->_tmp14_, &_data_->_inner_error_);
	_data_->_tmp9_ = _data_->_tmp15_;
	_data_->_tmp9__length1 = _data_->_tmp14_;
	_data_->__tmp9__size_ = _data_->_tmp9__length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->_tmp6_);
		_g_ptr_array_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->_tmp9_;
	_data_->_tmp16__length1 = _data_->_tmp9__length1;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9__length1 = 0;
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp17__length1 = _data_->_tmp16__length1;
	_data_->result_length1 = _data_->_tmp17__length1;
	_data_->result = _data_->_tmp17_;
	_data_->_tmp9_ = (_vala_array_free (_data_->_tmp9_, _data_->_tmp9__length1, (GDestroyNotify) g_free), NULL);
	_g_ptr_array_unref0 (_data_->_tmp6_);
	_g_ptr_array_unref0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_find_event_ids_data_free (gpointer _data) {
	ZeitgeistDaemonFindEventIdsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonFindEventIdsData, _data_);
}


static void zeitgeist_daemon_real_find_event_ids_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonFindEventIdsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_find_event_ids (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonFindEventIdsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	const char* _tmp10_;
	char* _tmp11_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonFindEventIdsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_find_event_ids_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_find_event_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_templates;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = storage_state;
	_data_->storage_state = _tmp5_;
	_tmp6_ = num_events;
	_data_->num_events = _tmp6_;
	_tmp7_ = result_type;
	_data_->result_type = _tmp7_;
	_tmp8_ = cancellable;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp9_;
	_tmp10_ = sender;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp11_;
	zeitgeist_daemon_real_find_event_ids_co (_data_);
}


static guint32* zeitgeist_daemon_real_find_event_ids_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, int* result_length1, GError** error) {
	guint32* result;
	ZeitgeistDaemonFindEventIdsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_daemon_real_find_event_ids_co (ZeitgeistDaemonFindEventIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->time_range;
	_data_->_tmp3_ = zeitgeist_time_range_new_from_variant (_data_->_tmp2_, &_data_->_inner_error_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->event_templates;
	_data_->_tmp6_ = zeitgeist_events_from_variant (_data_->_tmp5_, &_data_->_inner_error_);
	_data_->_tmp4_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->engine;
	_data_->_tmp8_ = _data_->storage_state;
	_data_->_tmp9_ = _data_->num_events;
	_data_->_tmp10_ = _data_->result_type;
	_data_->_tmp11_ = _data_->sender;
	_data_->_tmp13_ = zeitgeist_db_reader_find_event_ids ((ZeitgeistDbReader*) _data_->_tmp7_, _data_->_tmp1_, _data_->_tmp4_, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, &_data_->_tmp12_, &_data_->_inner_error_);
	_data_->ids = _data_->_tmp13_;
	_data_->ids_length1 = _data_->_tmp12_;
	_data_->_ids_size_ = _data_->ids_length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->timer;
	_data_->_tmp15_ = g_timer_elapsed (_data_->_tmp14_, NULL);
	_data_->_tmp16_ = _data_->ids;
	_data_->_tmp16__length1 = _data_->ids_length1;
	g_debug ("zeitgeist-daemon.vala:193: %s executed in %f seconds: found %i event i" \
"ds", "Zeitgeist.Daemon.find_event_ids", _data_->_tmp15_, _data_->_tmp16__length1);
	_data_->_tmp17_ = _data_->ids;
	_data_->_tmp17__length1 = _data_->ids_length1;
	_data_->result_length1 = _data_->_tmp17__length1;
	_data_->result = _data_->_tmp17_;
	_g_ptr_array_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp1_);
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_find_events_data_free (gpointer _data) {
	ZeitgeistDaemonFindEventsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonFindEventsData, _data_);
}


static void zeitgeist_daemon_real_find_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonFindEventsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_find_events (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonFindEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	const char* _tmp10_;
	char* _tmp11_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonFindEventsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_find_events_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_find_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_templates;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = storage_state;
	_data_->storage_state = _tmp5_;
	_tmp6_ = num_events;
	_data_->num_events = _tmp6_;
	_tmp7_ = result_type;
	_data_->result_type = _tmp7_;
	_tmp8_ = cancellable;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp9_;
	_tmp10_ = sender;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp11_;
	zeitgeist_daemon_real_find_events_co (_data_);
}


static GVariant* zeitgeist_daemon_real_find_events_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	ZeitgeistDaemonFindEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_daemon_real_find_events_co (ZeitgeistDaemonFindEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->time_range;
	_data_->_tmp3_ = zeitgeist_time_range_new_from_variant (_data_->_tmp2_, &_data_->_inner_error_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->event_templates;
	_data_->_tmp6_ = zeitgeist_events_from_variant (_data_->_tmp5_, &_data_->_inner_error_);
	_data_->_tmp4_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->engine;
	_data_->_tmp8_ = _data_->storage_state;
	_data_->_tmp9_ = _data_->num_events;
	_data_->_tmp10_ = _data_->result_type;
	_data_->_tmp11_ = _data_->sender;
	_data_->_tmp12_ = zeitgeist_db_reader_find_events ((ZeitgeistDbReader*) _data_->_tmp7_, _data_->_tmp1_, _data_->_tmp4_, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error_);
	_data_->events = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->timer;
	_data_->_tmp14_ = g_timer_elapsed (_data_->_tmp13_, NULL);
	_data_->_tmp15_ = _data_->events;
	_data_->_tmp16_ = g_ptr_array_get_length (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	g_debug ("zeitgeist-daemon.vala:209: %s executed in %f seconds: found %i events", "Zeitgeist.Daemon.find_events", _data_->_tmp14_, _data_->_tmp17_);
	_data_->_tmp19_ = _data_->events;
	_data_->_tmp20_ = zeitgeist_events_to_variant_with_limit (_data_->_tmp19_, ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE, &_data_->_inner_error_);
	_data_->_tmp18_ = _data_->_tmp20_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->events);
		_g_ptr_array_unref0 (_data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->_tmp18_;
	_data_->_tmp18_ = NULL;
	_data_->result = _data_->_tmp21_;
	_g_variant_unref0 (_data_->_tmp18_);
	_g_ptr_array_unref0 (_data_->events);
	_g_ptr_array_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp1_);
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_insert_events_data_free (gpointer _data) {
	ZeitgeistDaemonInsertEventsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->vevents);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonInsertEventsData, _data_);
}


static void zeitgeist_daemon_real_insert_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonInsertEventsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_insert_events (ZeitgeistRemoteLog* base, GVariant* vevents, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonInsertEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	const char* _tmp5_;
	char* _tmp6_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonInsertEventsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_insert_events_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_insert_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = vevents;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_data_->vevents);
	_data_->vevents = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	_tmp5_ = sender;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp6_;
	zeitgeist_daemon_real_insert_events_co (_data_);
}


static guint32* zeitgeist_daemon_real_insert_events_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, int* result_length1, GError** error) {
	guint32* result;
	ZeitgeistDaemonInsertEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_daemon_real_insert_events_co (ZeitgeistDaemonInsertEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->vevents;
	_data_->_tmp1_ = zeitgeist_events_from_variant (_data_->_tmp0_, &_data_->_inner_error_);
	_data_->events = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->engine;
	_data_->_tmp3_ = _data_->events;
	_data_->_tmp4_ = _data_->sender;
	_data_->_tmp6_ = zeitgeist_engine_insert_events (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, &_data_->_tmp5_, &_data_->_inner_error_);
	_data_->event_ids = _data_->_tmp6_;
	_data_->event_ids_length1 = _data_->_tmp5_;
	_data_->_event_ids_size_ = _data_->event_ids_length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->min_timestamp = G_MAXINT64;
	_data_->max_timestamp = G_MININT64;
	{
		_data_->i = 0;
		{
			_data_->_tmp7_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp7_) {
					_data_->_tmp8_ = _data_->i;
					_data_->i = _data_->_tmp8_ + 1;
				}
				_data_->_tmp7_ = FALSE;
				_data_->_tmp9_ = _data_->i;
				_data_->_tmp10_ = _data_->events;
				_data_->_tmp11_ = g_ptr_array_get_length (_data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				if (!(_data_->_tmp9_ < _data_->_tmp12_)) {
					break;
				}
				_data_->_tmp13_ = _data_->events;
				_data_->_tmp14_ = _data_->i;
				_data_->_tmp15_ = g_ptr_array_index (_data_->_tmp13_, (guint) _data_->_tmp14_);
				if (((ZeitgeistEvent*) _data_->_tmp15_) == NULL) {
					continue;
				}
				_data_->_tmp16_ = _data_->min_timestamp;
				_data_->_tmp17_ = _data_->events;
				_data_->_tmp18_ = _data_->i;
				_data_->_tmp19_ = g_ptr_array_index (_data_->_tmp17_, (guint) _data_->_tmp18_);
				_data_->_tmp20_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _data_->_tmp19_);
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = MIN (_data_->_tmp16_, _data_->_tmp21_);
				_data_->min_timestamp = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->max_timestamp;
				_data_->_tmp24_ = _data_->events;
				_data_->_tmp25_ = _data_->i;
				_data_->_tmp26_ = g_ptr_array_index (_data_->_tmp24_, (guint) _data_->_tmp25_);
				_data_->_tmp27_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				_data_->_tmp29_ = MAX (_data_->_tmp23_, _data_->_tmp28_);
				_data_->max_timestamp = _data_->_tmp29_;
			}
		}
	}
	_data_->_tmp30_ = _data_->min_timestamp;
	if (_data_->_tmp30_ < G_MAXINT64) {
		_data_->_tmp31_ = _data_->self->priv->notifications;
		_data_->_tmp32_ = _data_->min_timestamp;
		_data_->_tmp33_ = _data_->max_timestamp;
		_data_->_tmp34_ = zeitgeist_time_range_new (_data_->_tmp32_, _data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = _data_->events;
		zeitgeist_monitor_manager_notify_insert (_data_->_tmp31_, _data_->_tmp35_, _data_->_tmp36_);
		_g_object_unref0 (_data_->_tmp35_);
	}
	_data_->_tmp37_ = _data_->event_ids;
	_data_->_tmp37__length1 = _data_->event_ids_length1;
	_data_->result_length1 = _data_->_tmp37__length1;
	_data_->result = _data_->_tmp37_;
	_g_ptr_array_unref0 (_data_->events);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_delete_events_data_free (gpointer _data) {
	ZeitgeistDaemonDeleteEventsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonDeleteEventsData, _data_);
}


static void zeitgeist_daemon_real_delete_events_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonDeleteEventsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_delete_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonDeleteEventsData* _data_;
	ZeitgeistDaemon* _tmp0_;
	guint32* _tmp1_;
	gint _tmp1__length1;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	const char* _tmp4_;
	char* _tmp5_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonDeleteEventsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_delete_events_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_delete_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = event_ids;
	_tmp1__length1 = event_ids_length1;
	_data_->event_ids = _tmp1_;
	_data_->event_ids_length1 = _tmp1__length1;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	_tmp4_ = sender;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp5_;
	zeitgeist_daemon_real_delete_events_co (_data_);
}


static GVariant* zeitgeist_daemon_real_delete_events_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	ZeitgeistDaemonDeleteEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_daemon_real_delete_events_co (ZeitgeistDaemonDeleteEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->engine;
	_data_->_tmp1_ = _data_->event_ids;
	_data_->_tmp1__length1 = _data_->event_ids_length1;
	_data_->_tmp2_ = _data_->sender;
	_data_->_tmp3_ = zeitgeist_engine_delete_events (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp1__length1, _data_->_tmp2_, &_data_->_inner_error_);
	_data_->time_range = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->time_range;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->notifications;
		_data_->_tmp6_ = _data_->time_range;
		_data_->_tmp7_ = _data_->event_ids;
		_data_->_tmp7__length1 = _data_->event_ids_length1;
		zeitgeist_monitor_manager_notify_delete (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp7__length1);
	} else {
		_data_->_tmp8_ = zeitgeist_time_range_new ((gint64) -1, (gint64) -1);
		_g_object_unref0 (_data_->time_range);
		_data_->time_range = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->time_range;
	_data_->_tmp10_ = zeitgeist_time_range_to_variant (_data_->_tmp9_);
	_data_->result = _data_->_tmp10_;
	_g_object_unref0 (_data_->time_range);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_quit_data_free (gpointer _data) {
	ZeitgeistDaemonQuitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonQuitData, _data_);
}


static void zeitgeist_daemon_real_quit_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonQuitData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_quit (ZeitgeistRemoteLog* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonQuitData* _data_;
	ZeitgeistDaemon* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonQuitData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_daemon_real_quit_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_quit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_daemon_real_quit_co (_data_);
}


static void zeitgeist_daemon_real_quit_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistDaemonQuitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean zeitgeist_daemon_real_quit_co (ZeitgeistDaemonQuitData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	zeitgeist_daemon_do_quit (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_do_quit (ZeitgeistDaemon* self) {
	ZeitgeistEngine* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	zeitgeist_db_reader_close ((ZeitgeistDbReader*) _tmp0_);
	_tmp1_ = zeitgeist_daemon_mainloop;
	g_main_loop_quit (_tmp1_);
}


static void zeitgeist_daemon_real_install_monitor_data_free (gpointer _data) {
	ZeitgeistDaemonInstallMonitorData* _data_;
	_data_ = _data;
	_g_free0 (_data_->monitor_path);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->event_templates);
	_g_free0 (_data_->owner);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonInstallMonitorData, _data_);
}


static void zeitgeist_daemon_real_install_monitor_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonInstallMonitorData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_install_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonInstallMonitorData* _data_;
	ZeitgeistDaemon* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const char* _tmp7_;
	char* _tmp8_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonInstallMonitorData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, zeitgeist_daemon_real_install_monitor_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_install_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = monitor_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->monitor_path);
	_data_->monitor_path = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp4_;
	_tmp5_ = event_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp6_;
	_tmp7_ = owner;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_data_->owner);
	_data_->owner = _tmp8_;
	zeitgeist_daemon_real_install_monitor_co (_data_);
}


static void zeitgeist_daemon_real_install_monitor_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistDaemonInstallMonitorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean zeitgeist_daemon_real_install_monitor_co (ZeitgeistDaemonInstallMonitorData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->owner;
	_vala_assert (_data_->_tmp0_ != NULL, "owner != null");
	_data_->_tmp2_ = _data_->time_range;
	_data_->_tmp3_ = zeitgeist_time_range_new_from_variant (_data_->_tmp2_, &_data_->_inner_error_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->event_templates;
	_data_->_tmp6_ = zeitgeist_events_from_variant (_data_->_tmp5_, &_data_->_inner_error_);
	_data_->_tmp4_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->_tmp1_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->notifications;
	_data_->_tmp8_ = _data_->owner;
	_data_->_tmp9_ = _data_->monitor_path;
	zeitgeist_monitor_manager_install_monitor (_data_->_tmp7_, _data_->_tmp8_, (const gchar*) _data_->_tmp9_, _data_->_tmp1_, _data_->_tmp4_);
	_g_ptr_array_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp1_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_daemon_real_remove_monitor_data_free (gpointer _data) {
	ZeitgeistDaemonRemoveMonitorData* _data_;
	_data_ = _data;
	_g_free0 (_data_->monitor_path);
	_g_free0 (_data_->owner);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDaemonRemoveMonitorData, _data_);
}


static void zeitgeist_daemon_real_remove_monitor_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ZeitgeistDaemonRemoveMonitorData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void zeitgeist_daemon_real_remove_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDaemon * self;
	ZeitgeistDaemonRemoveMonitorData* _data_;
	ZeitgeistDaemon* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	const char* _tmp3_;
	char* _tmp4_;
	self = (ZeitgeistDaemon*) base;
	_data_ = g_slice_new0 (ZeitgeistDaemonRemoveMonitorData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, zeitgeist_daemon_real_remove_monitor_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_daemon_real_remove_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = monitor_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->monitor_path);
	_data_->monitor_path = _tmp2_;
	_tmp3_ = owner;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->owner);
	_data_->owner = _tmp4_;
	zeitgeist_daemon_real_remove_monitor_co (_data_);
}


static void zeitgeist_daemon_real_remove_monitor_finish (ZeitgeistRemoteLog* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistDaemonRemoveMonitorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean zeitgeist_daemon_real_remove_monitor_co (ZeitgeistDaemonRemoveMonitorData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->owner;
	_vala_assert (_data_->_tmp0_ != NULL, "owner != null");
	_data_->_tmp1_ = _data_->self->priv->notifications;
	_data_->_tmp2_ = _data_->owner;
	_data_->_tmp3_ = _data_->monitor_path;
	zeitgeist_monitor_manager_remove_monitor (_data_->_tmp1_, _data_->_tmp2_, (const gchar*) _data_->_tmp3_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void zeitgeist_daemon_register_dbus_object (ZeitgeistDaemon* self, GDBusConnection* conn, GError** error) {
	GDBusConnection* _tmp0_;
	guint _tmp1_ = 0U;
	GDBusConnection* _tmp2_;
	guint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	_tmp0_ = conn;
	self->priv->connection = _tmp0_;
	_tmp2_ = conn;
	_tmp3_ = zeitgeist_remote_log_register_object ((ZeitgeistRemoteLog*) self, _tmp2_, ZEITGEIST_UTILS_ENGINE_DBUS_PATH, &_inner_error_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->log_register_id = _tmp1_;
}


void zeitgeist_daemon_unregister_dbus_object (ZeitgeistDaemon* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->log_register_id;
	if (_tmp0_ != ((guint) 0)) {
		GDBusConnection* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->connection;
		_tmp2_ = self->priv->log_register_id;
		g_dbus_connection_unregister_object (_tmp1_, _tmp2_);
		self->priv->log_register_id = (guint) 0;
	}
}


static gboolean zeitgeist_daemon_quit_running_instance (GDBusConnection* conn) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (conn != NULL, FALSE);
	{
		ZeitgeistRemoteLog* running_instance = NULL;
		GDBusConnection* _tmp0_;
		ZeitgeistRemoteLog* _tmp1_;
		_tmp0_ = conn;
		_tmp1_ = g_initable_new (ZEITGEIST_TYPE_REMOTE_LOG_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", ZEITGEIST_UTILS_ENGINE_DBUS_NAME, "g-connection", _tmp0_, "g-object-path", ZEITGEIST_UTILS_ENGINE_DBUS_PATH, "g-interface-name", "org.gnome.zeitgeist.Log", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_REMOTE_LOG, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		running_instance = (ZeitgeistRemoteLog*) _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		zeitgeist_remote_log_quit (running_instance, NULL, NULL, NULL);
		result = TRUE;
		_g_object_unref0 (running_instance);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("zeitgeist-daemon.vala:314: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp4_;
	}
	result = FALSE;
	return result;
}


static void zeitgeist_daemon_name_acquired_callback (GDBusConnection* conn) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	zeitgeist_daemon_name_acquired = TRUE;
	_tmp0_ = zeitgeist_daemon_no_datahub;
	if (!_tmp0_) {
		{
			g_spawn_command_line_async ("zeitgeist-datahub", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch1_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_spawn_error:
		{
			GError* err = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = err;
			_tmp2_ = _tmp1_->message;
			g_warning ("zeitgeist-daemon.vala:333: %s", _tmp2_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean ____lambda4_ (void) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = zeitgeist_daemon_name_acquired;
	if (!_tmp0_) {
		GMainLoop* _tmp1_;
		g_warning ("zeitgeist-daemon.vala:360: Timeout reached, unable to acquire name!");
		_tmp1_ = zeitgeist_daemon_mainloop;
		g_main_loop_quit (_tmp1_);
	}
	result = FALSE;
	return result;
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ ();
	return result;
}


static void zeitgeist_daemon_name_lost_callback (GDBusConnection* conn) {
	GDBusConnection* _tmp0_;
	_tmp0_ = conn;
	if (_tmp0_ == NULL) {
		GMainLoop* _tmp1_;
		_tmp1_ = zeitgeist_daemon_mainloop;
		g_main_loop_quit (_tmp1_);
	} else {
		gboolean _tmp2_ = FALSE;
		ZeitgeistDaemon* _tmp3_;
		_tmp3_ = zeitgeist_daemon_instance;
		if (_tmp3_ != NULL) {
			gboolean _tmp4_;
			_tmp4_ = zeitgeist_daemon_name_acquired;
			_tmp2_ = !_tmp4_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp5_;
			_tmp5_ = zeitgeist_daemon_replace_mode;
			if (!_tmp5_) {
			}
			g_debug ("zeitgeist-daemon.vala:352: Waiting 10 seconds to acquire name...");
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10000, _____lambda4__gsource_func, NULL, NULL);
		} else {
			gboolean _tmp6_ = FALSE;
			ZeitgeistDaemon* _tmp7_;
			_tmp7_ = zeitgeist_daemon_instance;
			if (_tmp7_ != NULL) {
				gboolean _tmp8_;
				_tmp8_ = zeitgeist_daemon_name_acquired;
				_tmp6_ = _tmp8_;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GMainLoop* _tmp9_;
				_tmp9_ = zeitgeist_daemon_mainloop;
				g_main_loop_quit (_tmp9_);
			}
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_daemon_name_acquired_callback (connection);
}


static void _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_daemon_name_lost_callback (connection);
}


static void zeitgeist_daemon_run (GError** error) {
	GDBusConnection* connection = NULL;
	gboolean name_owned = FALSE;
	gboolean _tmp10_;
	gboolean _tmp16_;
	guint owner_id = 0U;
	GDBusConnection* _tmp27_;
	guint _tmp28_;
	GMainLoop* _tmp29_;
	GMainLoop* _tmp30_;
	ZeitgeistDaemon* _tmp31_;
	GError * _inner_error_ = NULL;
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		ZeitgeistRemoteDBus* proxy = NULL;
		GDBusConnection* _tmp3_;
		ZeitgeistRemoteDBus* _tmp4_;
		gboolean _tmp5_ = FALSE;
		ZeitgeistRemoteDBus* _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (connection);
		connection = _tmp2_;
		_tmp3_ = connection;
		_tmp4_ = g_initable_new (ZEITGEIST_TYPE_REMOTE_DBUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.DBus", "g-connection", _tmp3_, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_REMOTE_DBUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		proxy = (ZeitgeistRemoteDBus*) _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = proxy;
		_tmp7_ = zeitgeist_remote_dbus_name_has_owner (_tmp6_, ZEITGEIST_UTILS_ENGINE_DBUS_NAME, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (proxy);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			goto __finally2;
		}
		name_owned = _tmp5_;
		_g_object_unref0 (proxy);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (err);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp10_ = name_owned;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		_tmp12_ = zeitgeist_daemon_replace_mode;
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp13_;
			_tmp13_ = zeitgeist_daemon_quit_daemon;
			_tmp11_ = _tmp13_;
		}
		if (_tmp11_) {
			GDBusConnection* _tmp14_;
			_tmp14_ = connection;
			zeitgeist_daemon_quit_running_instance (_tmp14_);
		} else {
			GError* _tmp15_;
			g_warning ("zeitgeist-daemon.vala:398: %s", "An existing instance was found. Please use " "--replace to stop it and start a new instance.");
			_tmp15_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE, "Zeitgeist is running already.");
			_inner_error_ = _tmp15_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (connection);
			return;
		}
	}
	_tmp16_ = zeitgeist_daemon_quit_daemon;
	if (_tmp16_) {
		_g_object_unref0 (connection);
		return;
	}
	{
		ZeitgeistDaemon* _tmp17_ = NULL;
		ZeitgeistDaemon* _tmp18_;
		ZeitgeistDaemon* _tmp19_;
		ZeitgeistDaemon* _tmp20_;
		GDBusConnection* _tmp21_;
		_tmp18_ = zeitgeist_daemon_new (&_inner_error_);
		_tmp17_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp19_ = _tmp17_;
		_tmp17_ = NULL;
		_g_object_unref0 (zeitgeist_daemon_instance);
		zeitgeist_daemon_instance = _tmp19_;
		_tmp20_ = zeitgeist_daemon_instance;
		_tmp21_ = connection;
		zeitgeist_daemon_register_dbus_object (_tmp20_, _tmp21_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp17_);
			goto __catch3_g_error;
		}
		_g_object_unref0 (_tmp17_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		GError* _tmp22_;
		GError* _tmp25_;
		GError* _tmp26_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = err;
		if (g_error_matches (_tmp22_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			const gchar* _tmp23_;
			_tmp23_ = zeitgeist_utils_get_database_file_path ();
			g_warning ("Could not access the database file.\n" "Please check the permissions of file %s.", _tmp23_);
		} else {
			GError* _tmp24_;
			_tmp24_ = err;
			if (g_error_matches (_tmp24_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
				g_warning ("zeitgeist-daemon.vala:424: %s", "It looks like another Zeitgeist instance " "is already running (the database is locked). " "If you want to start a new instance, use --replace.");
			}
		}
		_tmp25_ = err;
		_tmp26_ = _g_error_copy0 (_tmp25_);
		_inner_error_ = _tmp26_;
		_g_error_free0 (err);
		goto __finally3;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp27_ = connection;
	_tmp28_ = g_bus_own_name_on_connection_with_closures (_tmp27_, ZEITGEIST_UTILS_ENGINE_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((_zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	owner_id = _tmp28_;
	_tmp29_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (zeitgeist_daemon_mainloop);
	zeitgeist_daemon_mainloop = _tmp29_;
	_tmp30_ = zeitgeist_daemon_mainloop;
	g_main_loop_run (_tmp30_);
	_tmp31_ = zeitgeist_daemon_instance;
	if (_tmp31_ != NULL) {
		guint _tmp32_;
		ZeitgeistDaemon* _tmp33_;
		_tmp32_ = owner_id;
		g_bus_unown_name (_tmp32_);
		_tmp33_ = zeitgeist_daemon_instance;
		zeitgeist_daemon_unregister_dbus_object (_tmp33_);
		_g_object_unref0 (zeitgeist_daemon_instance);
		zeitgeist_daemon_instance = NULL;
		{
			GDBusConnection* _tmp34_;
			_tmp34_ = connection;
			g_dbus_connection_flush_sync (_tmp34_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp35_;
			const gchar* _tmp36_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp35_ = e;
			_tmp36_ = _tmp35_->message;
			g_warning ("zeitgeist-daemon.vala:453: %s", _tmp36_);
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (connection);
			return;
		}
	}
	_g_object_unref0 (connection);
}


static void zeitgeist_daemon_safe_exit (void) {
	ZeitgeistDaemon* _tmp0_;
	_tmp0_ = zeitgeist_daemon_instance;
	zeitgeist_daemon_do_quit (_tmp0_);
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar* * errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint zeitgeist_daemon_vacuum (void) {
	gint result = 0;
	sqlite3* database = NULL;
	gboolean _tmp0_;
	const gchar* db_path = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint rc = 0;
	const gchar* _tmp3_;
	sqlite3* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	FILE* _tmp10_;
	FILE* _tmp11_;
	sqlite3* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	FILE* _tmp18_;
	_tmp0_ = zeitgeist_utils_using_in_memory_database ();
	if (_tmp0_) {
		g_warning ("zeitgeist-daemon.vala:468: Using in-memory database, no VACUUM needed");
	}
	_tmp1_ = zeitgeist_utils_get_database_file_path ();
	db_path = _tmp1_;
	_tmp2_ = db_path;
	g_debug ("zeitgeist-daemon.vala:471: Opening database file at %s", _tmp2_);
	_tmp3_ = db_path;
	_tmp5_ = sqlite3_open_v2 (_tmp3_, &_tmp4_, SQLITE_OPEN_READWRITE, NULL);
	_sqlite3_close0 (database);
	database = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ != SQLITE_OK) {
		const gchar* _tmp7_;
		sqlite3* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = db_path;
		_tmp8_ = database;
		_tmp9_ = sqlite3_errmsg (_tmp8_);
		g_warning ("zeitgeist-daemon.vala:476: Failed to open database \"%s\" (%s)", _tmp7_, _tmp9_);
		result = rc;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp10_ = stdout;
	fprintf (_tmp10_, "Performing VACUUM operation... ");
	_tmp11_ = stdout;
	fflush (_tmp11_);
	_tmp12_ = database;
	_tmp13_ = _sqlite3_exec (_tmp12_, "VACUUM", NULL, NULL, NULL);
	rc = _tmp13_;
	_tmp14_ = rc;
	if (_tmp14_ != SQLITE_OK) {
		FILE* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = stdout;
		fprintf (_tmp15_, "FAIL\n");
		_tmp16_ = database;
		_tmp17_ = sqlite3_errmsg (_tmp16_);
		g_warning ("zeitgeist-daemon.vala:486: %s", _tmp17_);
		result = rc;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp18_ = stdout;
	fprintf (_tmp18_, "OK\n");
	result = 0;
	_sqlite3_close0 (database);
	return result;
}


static void _zeitgeist_daemon_safe_exit_sighandler_t (gint signal) {
	zeitgeist_daemon_safe_exit ();
}


static gint zeitgeist_daemon_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* opt_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GError * _inner_error_ = NULL;
	signal (SIGHUP, _zeitgeist_daemon_safe_exit_sighandler_t);
	signal (SIGINT, _zeitgeist_daemon_safe_exit_sighandler_t);
	signal (SIGTERM, _zeitgeist_daemon_safe_exit_sighandler_t);
	setlocale (LC_ALL, "");
	_tmp0_ = g_option_context_new (" - Zeitgeist daemon");
	opt_context = _tmp0_;
	_tmp1_ = opt_context;
	g_option_context_add_main_entries (_tmp1_, ZEITGEIST_DAEMON_options, NULL);
	{
		GOptionContext* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp5_;
		gboolean _tmp17_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp2_ = opt_context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp3_ = zeitgeist_daemon_show_version_info;
		if (_tmp3_) {
			FILE* _tmp4_;
			_tmp4_ = stdout;
			fprintf (_tmp4_, "%s", VERSION "\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp5_ = zeitgeist_daemon_show_options;
		if (_tmp5_) {
			FILE* _tmp16_;
			{
				GOptionEntry* entry_collection = NULL;
				gint entry_collection_length1 = 0;
				gint _entry_collection_size_ = 0;
				gint entry_it = 0;
				entry_collection = ZEITGEIST_DAEMON_options;
				entry_collection_length1 = G_N_ELEMENTS (ZEITGEIST_DAEMON_options);
				for (entry_it = 0; entry_it < G_N_ELEMENTS (ZEITGEIST_DAEMON_options); entry_it = entry_it + 1) {
					GOptionEntry* entry = NULL;
					entry = &entry_collection[entry_it];
					{
						GOptionEntry* _tmp6_;
						const gchar* _tmp7_;
						GOptionEntry* _tmp11_;
						gchar _tmp12_;
						_tmp6_ = entry;
						_tmp7_ = (*_tmp6_).long_name;
						if (_tmp7_ != NULL) {
							FILE* _tmp8_;
							GOptionEntry* _tmp9_;
							const gchar* _tmp10_;
							_tmp8_ = stdout;
							_tmp9_ = entry;
							_tmp10_ = (*_tmp9_).long_name;
							fprintf (_tmp8_, "--%s ", _tmp10_);
						}
						_tmp11_ = entry;
						_tmp12_ = (*_tmp11_).short_name;
						if (((gint) _tmp12_) != 0) {
							FILE* _tmp13_;
							GOptionEntry* _tmp14_;
							gchar _tmp15_;
							_tmp13_ = stdout;
							_tmp14_ = entry;
							_tmp15_ = (*_tmp14_).short_name;
							fprintf (_tmp13_, "-%c ", (gint) _tmp15_);
						}
					}
				}
			}
			_tmp16_ = stdout;
			fprintf (_tmp16_, "--help\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp17_ = zeitgeist_daemon_perform_vacuum;
		if (_tmp17_) {
			gint _tmp18_;
			_tmp18_ = zeitgeist_daemon_vacuum ();
			result = _tmp18_;
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp19_ = zeitgeist_daemon_log_level;
		_tmp20_ = zeitgeist_daemon_log_file;
		zeitgeist_logging_setup_logging (_tmp19_, _tmp20_);
		zeitgeist_daemon_run (&_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		GError* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = err;
		if (g_error_matches (_tmp21_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE)) {
			result = 10;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp22_ = err;
		if (g_error_matches (_tmp22_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			result = 21;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp23_ = err;
		if (g_error_matches (_tmp23_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
			result = 22;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp24_ = err;
		_tmp25_ = _tmp24_->message;
		g_warning ("zeitgeist-daemon.vala:546: %s", _tmp25_);
		result = 1;
		_g_error_free0 (err);
		_g_option_context_free0 (opt_context);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp26_ = 0;
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp26_;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	return result;
}


int main (int argc, char ** argv) {
	return zeitgeist_daemon_main (argv, argc);
}


static gchar** zeitgeist_daemon_real_get_extensions (ZeitgeistRemoteLog* base, int* result_length1) {
	gchar** result;
	ZeitgeistDaemon* self;
	gchar** ext = NULL;
	ZeitgeistEngine* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint ext_length1;
	gint _ext_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (ZeitgeistDaemon*) base;
	_tmp0_ = self->priv->engine;
	_tmp2_ = zeitgeist_engine_get_extension_names (_tmp0_, &_tmp1_);
	ext = _tmp2_;
	ext_length1 = _tmp1_;
	_ext_size_ = ext_length1;
	_tmp3_ = ext;
	_tmp3__length1 = ext_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static void zeitgeist_daemon_real_get_version (ZeitgeistRemoteLog* base, ZeitgeistVersionStruct * result) {
	ZeitgeistDaemon* self;
	ZeitgeistVersionStruct s = {0};
	gchar** ver = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint ver_length1;
	gint _ver_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (ZeitgeistDaemon*) base;
	memset (&s, 0, sizeof (ZeitgeistVersionStruct));
	_tmp1_ = _tmp0_ = g_strsplit (VERSION, ".", 0);
	ver = _tmp1_;
	ver_length1 = _vala_array_length (_tmp0_);
	_ver_size_ = ver_length1;
	_tmp2_ = ver;
	_tmp2__length1 = ver_length1;
	if (_tmp2__length1 >= 1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp11_ = 0;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp3_ = ver;
		_tmp3__length1 = ver_length1;
		_tmp4_ = _tmp3_[0];
		_tmp5_ = atoi (_tmp4_);
		s.major = _tmp5_;
		_tmp7_ = ver;
		_tmp7__length1 = ver_length1;
		if (_tmp7__length1 >= 2) {
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gint _tmp10_;
			_tmp8_ = ver;
			_tmp8__length1 = ver_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = atoi (_tmp9_);
			_tmp6_ = _tmp10_;
		} else {
			_tmp6_ = 0;
		}
		s.minor = _tmp6_;
		_tmp12_ = ver;
		_tmp12__length1 = ver_length1;
		if (_tmp12__length1 >= 3) {
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp13_ = ver;
			_tmp13__length1 = ver_length1;
			_tmp14_ = _tmp13_[2];
			_tmp15_ = atoi (_tmp14_);
			_tmp11_ = _tmp15_;
		} else {
			_tmp11_ = 0;
		}
		s.micro = _tmp11_;
	} else {
		g_warning ("zeitgeist-daemon.vala:125: Unable to parse version info `%s`!", VERSION);
		s.major = 1;
		s.minor = 0;
		s.micro = 0;
	}
	*result = s;
	ver = (_vala_array_free (ver, ver_length1, (GDestroyNotify) g_free), NULL);
	return;
}


static gchar* zeitgeist_daemon_real_get_datapath (ZeitgeistRemoteLog* base) {
	gchar* result;
	ZeitgeistDaemon* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ZeitgeistDaemon*) base;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void zeitgeist_daemon_class_init (ZeitgeistDaemonClass * klass) {
	gchar* _tmp0_;
	zeitgeist_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDaemonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_daemon_get_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_daemon_finalize;
	_tmp0_ = g_strdup ("");
	zeitgeist_daemon_log_level = _tmp0_;
}


static void zeitgeist_daemon_zeitgeist_remote_log_interface_init (ZeitgeistRemoteLogIface * iface) {
	zeitgeist_daemon_zeitgeist_remote_log_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_events = (void (*) (ZeitgeistRemoteLog *, guint32*, int, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_get_events;
	iface->get_events_finish = (GVariant* (*) (ZeitgeistRemoteLog *, GAsyncResult*, GError**)) zeitgeist_daemon_real_get_events_finish;
	iface->find_related_uris = (void (*) (ZeitgeistRemoteLog *, GVariant*, GVariant*, GVariant*, guint, guint, guint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_find_related_uris;
	iface->find_related_uris_finish = (gchar** (*) (ZeitgeistRemoteLog *, GAsyncResult*, int*, GError**)) zeitgeist_daemon_real_find_related_uris_finish;
	iface->find_event_ids = (void (*) (ZeitgeistRemoteLog *, GVariant*, GVariant*, guint, guint, guint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_find_event_ids;
	iface->find_event_ids_finish = (guint32* (*) (ZeitgeistRemoteLog *, GAsyncResult*, int*, GError**)) zeitgeist_daemon_real_find_event_ids_finish;
	iface->find_events = (void (*) (ZeitgeistRemoteLog *, GVariant*, GVariant*, guint, guint, guint, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_find_events;
	iface->find_events_finish = (GVariant* (*) (ZeitgeistRemoteLog *, GAsyncResult*, GError**)) zeitgeist_daemon_real_find_events_finish;
	iface->insert_events = (void (*) (ZeitgeistRemoteLog *, GVariant*, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_insert_events;
	iface->insert_events_finish = (guint32* (*) (ZeitgeistRemoteLog *, GAsyncResult*, int*, GError**)) zeitgeist_daemon_real_insert_events_finish;
	iface->delete_events = (void (*) (ZeitgeistRemoteLog *, guint32*, int, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_delete_events;
	iface->delete_events_finish = (GVariant* (*) (ZeitgeistRemoteLog *, GAsyncResult*, GError**)) zeitgeist_daemon_real_delete_events_finish;
	iface->quit = (void (*) (ZeitgeistRemoteLog *, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_quit;
	iface->quit_finish = (void (*) (ZeitgeistRemoteLog *, GAsyncResult*, GError**)) zeitgeist_daemon_real_quit_finish;
	iface->install_monitor = (void (*) (ZeitgeistRemoteLog *, const char*, GVariant*, GVariant*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_install_monitor;
	iface->install_monitor_finish = (void (*) (ZeitgeistRemoteLog *, GAsyncResult*, GError**)) zeitgeist_daemon_real_install_monitor_finish;
	iface->remove_monitor = (void (*) (ZeitgeistRemoteLog *, const char*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_daemon_real_remove_monitor;
	iface->remove_monitor_finish = (void (*) (ZeitgeistRemoteLog *, GAsyncResult*, GError**)) zeitgeist_daemon_real_remove_monitor_finish;
	iface->get_extensions = zeitgeist_daemon_real_get_extensions;
	iface->get_version = zeitgeist_daemon_real_get_version;
	iface->get_datapath = zeitgeist_daemon_real_get_datapath;
}


static void zeitgeist_daemon_instance_init (ZeitgeistDaemon * self) {
	ZeitgeistRegisterExtensionFunc* _tmp0_;
	self->priv = ZEITGEIST_DAEMON_GET_PRIVATE (self);
	_tmp0_ = g_new0 (ZeitgeistRegisterExtensionFunc, 0);
	self->priv->builtins = _tmp0_;
	self->priv->builtins_length1 = 0;
	self->priv->_builtins_size_ = self->priv->builtins_length1;
}


static void zeitgeist_daemon_finalize (GObject * obj) {
	ZeitgeistDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon);
	self->priv->builtins = (g_free (self->priv->builtins), NULL);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->notifications);
	G_OBJECT_CLASS (zeitgeist_daemon_parent_class)->finalize (obj);
}


GType zeitgeist_daemon_get_type (void) {
	static volatile gsize zeitgeist_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDaemon), 0, (GInstanceInitFunc) zeitgeist_daemon_instance_init, NULL };
		static const GInterfaceInfo zeitgeist_remote_log_info = { (GInterfaceInitFunc) zeitgeist_daemon_zeitgeist_remote_log_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zeitgeist_daemon_type_id;
		zeitgeist_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (zeitgeist_daemon_type_id, ZEITGEIST_TYPE_REMOTE_LOG, &zeitgeist_remote_log_info);
		g_once_init_leave (&zeitgeist_daemon_type_id__volatile, zeitgeist_daemon_type_id);
	}
	return zeitgeist_daemon_type_id__volatile;
}


static void _vala_zeitgeist_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



