/* log.c generated by valac 0.26.1, the Vala compiler
 * generated from log.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 * Copyright © 2013 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2013 Rico Tzschichholz <ricotz@ubuntu.com>
 *
 * Based upon a C implementation (© 2010-2012 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *  Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-internal.h"
#include "zeitgeist-datamodel.h"
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER (zeitgeist_queued_proxy_wrapper_get_type ())
#define ZEITGEIST_QUEUED_PROXY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, ZeitgeistQueuedProxyWrapper))
#define ZEITGEIST_QUEUED_PROXY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, ZeitgeistQueuedProxyWrapperClass))
#define ZEITGEIST_IS_QUEUED_PROXY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER))
#define ZEITGEIST_IS_QUEUED_PROXY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER))
#define ZEITGEIST_QUEUED_PROXY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, ZeitgeistQueuedProxyWrapperClass))

typedef struct _ZeitgeistQueuedProxyWrapper ZeitgeistQueuedProxyWrapper;
typedef struct _ZeitgeistQueuedProxyWrapperClass ZeitgeistQueuedProxyWrapperClass;
typedef struct _ZeitgeistQueuedProxyWrapperPrivate ZeitgeistQueuedProxyWrapperPrivate;

#define ZEITGEIST_TYPE_LOG (zeitgeist_log_get_type ())
#define ZEITGEIST_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_LOG, ZeitgeistLog))
#define ZEITGEIST_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_LOG, ZeitgeistLogClass))
#define ZEITGEIST_IS_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_LOG))
#define ZEITGEIST_IS_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_LOG))
#define ZEITGEIST_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_LOG, ZeitgeistLogClass))

typedef struct _ZeitgeistLog ZeitgeistLog;
typedef struct _ZeitgeistLogClass ZeitgeistLogClass;
typedef struct _ZeitgeistLogPrivate ZeitgeistLogPrivate;

#define ZEITGEIST_TYPE_REMOTE_LOG (zeitgeist_remote_log_get_type ())
#define ZEITGEIST_REMOTE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLog))
#define ZEITGEIST_IS_REMOTE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_LOG))
#define ZEITGEIST_REMOTE_LOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLogIface))

typedef struct _ZeitgeistRemoteLog ZeitgeistRemoteLog;
typedef struct _ZeitgeistRemoteLogIface ZeitgeistRemoteLogIface;

#define ZEITGEIST_TYPE_REMOTE_LOG_PROXY (zeitgeist_remote_log_proxy_get_type ())

#define ZEITGEIST_TYPE_VERSION_STRUCT (zeitgeist_version_struct_get_type ())
typedef struct _ZeitgeistVersionStruct ZeitgeistVersionStruct;

#define ZEITGEIST_TYPE_MONITOR (zeitgeist_monitor_get_type ())
#define ZEITGEIST_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor))
#define ZEITGEIST_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitorClass))
#define ZEITGEIST_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MONITOR))
#define ZEITGEIST_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitorClass))

typedef struct _ZeitgeistMonitor ZeitgeistMonitor;
typedef struct _ZeitgeistMonitorClass ZeitgeistMonitorClass;

#define ZEITGEIST_LOG_TYPE_DB_WORKER (zeitgeist_log_db_worker_get_type ())
#define ZEITGEIST_LOG_DB_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorker))
#define ZEITGEIST_LOG_DB_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorkerClass))
#define ZEITGEIST_LOG_IS_DB_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_LOG_TYPE_DB_WORKER))
#define ZEITGEIST_LOG_IS_DB_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_LOG_TYPE_DB_WORKER))
#define ZEITGEIST_LOG_DB_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorkerClass))

typedef struct _ZeitgeistLogDbWorker ZeitgeistLogDbWorker;
typedef struct _ZeitgeistLogDbWorkerClass ZeitgeistLogDbWorkerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _zeitgeist_log_db_worker_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_log_db_worker_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistLogInsertEventData ZeitgeistLogInsertEventData;
typedef struct _ZeitgeistLogInsertEventsData ZeitgeistLogInsertEventsData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _ZeitgeistLogFindEventsData ZeitgeistLogFindEventsData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ZeitgeistLogFindEventIdsData ZeitgeistLogFindEventIdsData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _ZeitgeistLogGetEventsData ZeitgeistLogGetEventsData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _ZeitgeistLogFindRelatedUrisData ZeitgeistLogFindRelatedUrisData;
typedef struct _ZeitgeistLogDeleteEventsData ZeitgeistLogDeleteEventsData;
typedef struct _ZeitgeistLogQuitData ZeitgeistLogQuitData;

#define ZEITGEIST_TYPE_REMOTE_MONITOR (zeitgeist_remote_monitor_get_type ())
#define ZEITGEIST_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitor))
#define ZEITGEIST_IS_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR))
#define ZEITGEIST_REMOTE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitorIface))

typedef struct _ZeitgeistRemoteMonitor ZeitgeistRemoteMonitor;
typedef struct _ZeitgeistRemoteMonitorIface ZeitgeistRemoteMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY (zeitgeist_remote_monitor_proxy_get_type ())
typedef struct _ZeitgeistLogReinstallMonitorData ZeitgeistLogReinstallMonitorData;
typedef struct _ZeitgeistLogDbWorkerPrivate ZeitgeistLogDbWorkerPrivate;
typedef struct _ZeitgeistLogParamSpecDbWorker ZeitgeistLogParamSpecDbWorker;

struct _ZeitgeistQueuedProxyWrapper {
	GObject parent_instance;
	ZeitgeistQueuedProxyWrapperPrivate * priv;
};

struct _ZeitgeistQueuedProxyWrapperClass {
	GObjectClass parent_class;
	void (*on_connection_established) (ZeitgeistQueuedProxyWrapper* self);
	void (*on_connection_lost) (ZeitgeistQueuedProxyWrapper* self);
};

struct _ZeitgeistLog {
	ZeitgeistQueuedProxyWrapper parent_instance;
	ZeitgeistLogPrivate * priv;
};

struct _ZeitgeistLogClass {
	ZeitgeistQueuedProxyWrapperClass parent_class;
};

struct _ZeitgeistVersionStruct {
	gint major;
	gint minor;
	gint micro;
};

struct _ZeitgeistRemoteLogIface {
	GTypeInterface parent_iface;
	void (*delete_events) (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*delete_events_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
	void (*find_event_ids) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32* (*find_event_ids_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*find_events) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*find_events_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
	void (*find_related_uris) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*find_related_uris_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*get_events) (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*get_events_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
	void (*insert_events) (ZeitgeistRemoteLog* self, GVariant* events, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32* (*insert_events_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*install_monitor) (ZeitgeistRemoteLog* self, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_monitor_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
	void (*remove_monitor) (ZeitgeistRemoteLog* self, const char* monitor_path, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_monitor_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
	void (*quit) (ZeitgeistRemoteLog* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*quit_finish) (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
	gchar** (*get_extensions) (ZeitgeistRemoteLog* self, int* result_length1);
	void (*get_version) (ZeitgeistRemoteLog* self, ZeitgeistVersionStruct* value);
	gchar* (*get_datapath) (ZeitgeistRemoteLog* self);
};

struct _ZeitgeistLogPrivate {
	ZeitgeistRemoteLog* proxy;
	GVariant* engine_version;
	GHashTable* monitors;
	ZeitgeistDbReader* dbreader;
	GThreadPool* threads;
	gboolean allow_direct_read;
};

struct _Block1Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GMainLoop* mainloop;
};

struct _ZeitgeistLogInsertEventData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	ZeitgeistEvent* event;
	GCancellable* cancellable;
	GArray* result;
	GPtrArray* events;
	GPtrArray* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	GArray* _tmp3_;
	GCancellable* _tmp4_;
	GArray* _tmp5_;
	GArray* _tmp6_;
	GError * _inner_error_;
};

struct _ZeitgeistLogInsertEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	GPtrArray* events;
	GCancellable* cancellable;
	GArray* result;
	GPtrArray* events_cp;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gconstpointer _tmp10_;
	ZeitgeistEvent* _tmp11_;
	guint32* ids;
	ZeitgeistRemoteLog* _tmp12_;
	GPtrArray* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GCancellable* _tmp16_;
	gint _tmp17_;
	guint32* _tmp18_;
	guint32* _tmp19_;
	gint _tmp19__length1;
	gint ids_length1;
	gint _ids_size_;
	GArray* _result_;
	GArray* _tmp20_;
	gint _vala1_i;
	gboolean _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	guint32* _tmp24_;
	gint _tmp24__length1;
	GArray* _tmp25_;
	guint32* _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
	guint32 _tmp28_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GPtrArray* event_templates_cp;
	ZeitgeistTimeRange* time_range;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	ZeitgeistSimpleResultSet* result_set;
	GError* _error_;
};

struct _ZeitgeistLogFindEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	ZeitgeistResultSet* result;
	Block2Data* _data2_;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistStorageState _tmp1_;
	guint32 _tmp2_;
	ZeitgeistResultType _tmp3_;
	GPtrArray* _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gconstpointer _tmp14_;
	ZeitgeistEvent* _tmp15_;
	ZeitgeistDbReader* _tmp16_;
	Block3Data* _data3_;
	GThreadFunc run;
	void* run_target;
	GDestroyNotify run_target_destroy_notify;
	GThreadPool* _tmp17_;
	GThreadFunc _tmp18_;
	void* _tmp18__target;
	ZeitgeistLogDbWorker* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	ZeitgeistSimpleResultSet* _tmp23_;
	ZeitgeistResultSet* _tmp24_;
	GVariant* _result_;
	ZeitgeistRemoteLog* _tmp25_;
	ZeitgeistTimeRange* _tmp26_;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	GPtrArray* _tmp29_;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	ZeitgeistStorageState _tmp32_;
	guint32 _tmp33_;
	ZeitgeistResultType _tmp34_;
	GCancellable* _tmp35_;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	GPtrArray* _tmp38_;
	GVariant* _tmp39_;
	GPtrArray* _tmp40_;
	ZeitgeistSimpleResultSet* _tmp41_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GPtrArray* event_templates_cp;
	ZeitgeistTimeRange* time_range;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	guint32* ids;
	gint ids_length1;
	gint _ids_size_;
	GError* _error_;
};

struct _ZeitgeistLogFindEventIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	guint32* result;
	gint result_length1;
	Block4Data* _data4_;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistStorageState _tmp1_;
	guint32 _tmp2_;
	ZeitgeistResultType _tmp3_;
	GPtrArray* _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gconstpointer _tmp14_;
	ZeitgeistEvent* _tmp15_;
	ZeitgeistDbReader* _tmp16_;
	Block5Data* _data5_;
	GThreadFunc run;
	void* run_target;
	GDestroyNotify run_target_destroy_notify;
	GThreadPool* _tmp17_;
	GThreadFunc _tmp18_;
	void* _tmp18__target;
	ZeitgeistLogDbWorker* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	guint32* _tmp23_;
	gint _tmp23__length1;
	guint32* _tmp24_;
	gint _tmp24__length1;
	guint32* _tmp25_;
	gint _tmp25__length1;
	guint32* _tmp26_;
	ZeitgeistRemoteLog* _tmp27_;
	ZeitgeistTimeRange* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	GPtrArray* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	ZeitgeistStorageState _tmp34_;
	guint32 _tmp35_;
	ZeitgeistResultType _tmp36_;
	GCancellable* _tmp37_;
	gint _tmp38_;
	guint32* _tmp39_;
	guint32* _tmp40_;
	gint _tmp40__length1;
	gint _tmp26__length1;
	gint __tmp26__size_;
	guint32* _tmp41_;
	gint _tmp41__length1;
	guint32* _tmp42_;
	gint _tmp42__length1;
	GError * _inner_error_;
};

struct _Block6Data {
	int _ref_count_;
	ZeitgeistLog* self;
	guint32* simple_event_ids;
	gint simple_event_ids_length1;
	gint _simple_event_ids_size_;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	ZeitgeistSimpleResultSet* result_set;
	GError* _error_;
};

struct _ZeitgeistLogGetEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	GArray* event_ids;
	GCancellable* cancellable;
	ZeitgeistResultSet* result;
	Block6Data* _data6_;
	GArray* _tmp0_;
	guint _tmp1_;
	guint32* _tmp2_;
	gint i;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GArray* _tmp6_;
	guint _tmp7_;
	guint32* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GArray* _tmp10_;
	gint _tmp11_;
	guint32 _tmp12_;
	guint32 _tmp13_;
	ZeitgeistDbReader* _tmp14_;
	Block7Data* _data7_;
	GThreadFunc run;
	void* run_target;
	GDestroyNotify run_target_destroy_notify;
	GThreadPool* _tmp15_;
	GThreadFunc _tmp16_;
	void* _tmp16__target;
	ZeitgeistLogDbWorker* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	ZeitgeistSimpleResultSet* _tmp21_;
	ZeitgeistResultSet* _tmp22_;
	GVariant* _result_;
	ZeitgeistRemoteLog* _tmp23_;
	guint32* _tmp24_;
	gint _tmp24__length1;
	GCancellable* _tmp25_;
	GVariant* _tmp26_;
	GPtrArray* _tmp27_;
	GVariant* _tmp28_;
	GPtrArray* _tmp29_;
	ZeitgeistSimpleResultSet* _tmp30_;
	GError * _inner_error_;
};

struct _Block8Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GPtrArray* events_cp;
	GPtrArray* results_cp;
	ZeitgeistTimeRange* time_range;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistRelevantResultType result_type;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	GError* _error_;
};

struct _ZeitgeistLogFindRelatedUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	GPtrArray* result_event_templates;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistRelevantResultType result_type;
	GCancellable* cancellable;
	gchar** result;
	gint result_length1;
	Block8Data* _data8_;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistStorageState _tmp1_;
	guint32 _tmp2_;
	ZeitgeistRelevantResultType _tmp3_;
	GPtrArray* _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gconstpointer _tmp14_;
	ZeitgeistEvent* _tmp15_;
	GPtrArray* _tmp16_;
	gint _vala1_i;
	gboolean _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GPtrArray* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GPtrArray* _tmp23_;
	GPtrArray* _tmp24_;
	gint _tmp25_;
	gconstpointer _tmp26_;
	ZeitgeistEvent* _tmp27_;
	ZeitgeistDbReader* _tmp28_;
	Block9Data* _data9_;
	GThreadFunc run;
	void* run_target;
	GDestroyNotify run_target_destroy_notify;
	GThreadPool* _tmp29_;
	GThreadFunc _tmp30_;
	void* _tmp30__target;
	ZeitgeistLogDbWorker* _tmp31_;
	GError* _tmp32_;
	GError* _tmp33_;
	GError* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar** _tmp38_;
	ZeitgeistRemoteLog* _tmp39_;
	ZeitgeistTimeRange* _tmp40_;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	GPtrArray* _tmp43_;
	GVariant* _tmp44_;
	GVariant* _tmp45_;
	GPtrArray* _tmp46_;
	GVariant* _tmp47_;
	GVariant* _tmp48_;
	ZeitgeistStorageState _tmp49_;
	guint32 _tmp50_;
	ZeitgeistRelevantResultType _tmp51_;
	GCancellable* _tmp52_;
	gint _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gint _tmp38__length1;
	gint __tmp38__size_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gchar** _tmp57_;
	gint _tmp57__length1;
	GError * _inner_error_;
};

struct _ZeitgeistLogDeleteEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	GArray* event_ids;
	GCancellable* cancellable;
	ZeitgeistTimeRange* result;
	guint32* _ids;
	GArray* _tmp0_;
	guint _tmp1_;
	guint32* _tmp2_;
	gint _ids_length1;
	gint __ids_size_;
	gint i;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GArray* _tmp6_;
	guint _tmp7_;
	guint32* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GArray* _tmp10_;
	gint _tmp11_;
	guint32 _tmp12_;
	guint32 _tmp13_;
	GVariant* time_range;
	ZeitgeistRemoteLog* _tmp14_;
	guint32* _tmp15_;
	gint _tmp15__length1;
	GCancellable* _tmp16_;
	GVariant* _tmp17_;
	ZeitgeistTimeRange* _tmp18_;
	GVariant* _tmp19_;
	ZeitgeistTimeRange* _tmp20_;
	ZeitgeistTimeRange* _tmp21_;
	GError * _inner_error_;
};

struct _ZeitgeistLogQuitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	GCancellable* cancellable;
	ZeitgeistRemoteLog* _tmp0_;
	GCancellable* _tmp1_;
	GError * _inner_error_;
};

struct _ZeitgeistRemoteMonitorIface {
	GTypeInterface parent_iface;
	void (*notify_insert) (ZeitgeistRemoteMonitor* self, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_insert_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
	void (*notify_delete) (ZeitgeistRemoteMonitor* self, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_delete_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
};

struct _ZeitgeistLogReinstallMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistLog* self;
	ZeitgeistMonitor* monitor;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GHashTable* _tmp2_;
	ZeitgeistMonitor* _tmp3_;
	gconstpointer _tmp4_;
	GDBusConnection* conn;
	ZeitgeistRemoteLog* _tmp5_;
	GDBusConnection* _tmp6_;
	GDBusConnection* _tmp7_;
	guint registration_id;
	GDBusConnection* _tmp8_;
	ZeitgeistMonitor* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	ZeitgeistMonitor* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GHashTable* _tmp15_;
	ZeitgeistMonitor* _tmp16_;
	ZeitgeistMonitor* _tmp17_;
	guint _tmp18_;
	GError* err;
	GError* _tmp19_;
	const gchar* _tmp20_;
	ZeitgeistRemoteLog* _tmp21_;
	ZeitgeistMonitor* _tmp22_;
	char* _tmp23_;
	char* _tmp24_;
	ZeitgeistMonitor* _tmp25_;
	ZeitgeistTimeRange* _tmp26_;
	ZeitgeistTimeRange* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	ZeitgeistMonitor* _tmp30_;
	GPtrArray* _tmp31_;
	GPtrArray* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	GError * _inner_error_;
};

struct _ZeitgeistLogDbWorker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistLogDbWorkerPrivate * priv;
};

struct _ZeitgeistLogDbWorkerClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistLogDbWorker *self);
};

struct _ZeitgeistLogDbWorkerPrivate {
	GThreadFunc func;
	gpointer func_target;
};

struct _ZeitgeistLogParamSpecDbWorker {
	GParamSpec parent_instance;
};


static gpointer zeitgeist_log_parent_class = NULL;
static ZeitgeistLog* zeitgeist_log_default_instance;
static ZeitgeistLog* zeitgeist_log_default_instance = NULL;
static gpointer zeitgeist_log_db_worker_parent_class = NULL;

GType zeitgeist_queued_proxy_wrapper_get_type (void) G_GNUC_CONST;
GType zeitgeist_log_get_type (void) G_GNUC_CONST;
GType zeitgeist_remote_log_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_log_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_version_struct_get_type (void) G_GNUC_CONST;
ZeitgeistVersionStruct* zeitgeist_version_struct_dup (const ZeitgeistVersionStruct* self);
void zeitgeist_version_struct_free (ZeitgeistVersionStruct* self);
GType zeitgeist_remote_log_get_type (void) G_GNUC_CONST;
GType zeitgeist_monitor_get_type (void) G_GNUC_CONST;
static gpointer zeitgeist_log_db_worker_ref (gpointer instance);
static void zeitgeist_log_db_worker_unref (gpointer instance);
static GParamSpec* zeitgeist_log_param_spec_db_worker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void zeitgeist_log_value_set_db_worker (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void zeitgeist_log_value_take_db_worker (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer zeitgeist_log_value_get_db_worker (const GValue* value) G_GNUC_UNUSED;
static GType zeitgeist_log_db_worker_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define ZEITGEIST_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_LOG, ZeitgeistLogPrivate))
enum  {
	ZEITGEIST_LOG_DUMMY_PROPERTY
};
ZeitgeistLog* zeitgeist_log_new (void);
ZeitgeistLog* zeitgeist_log_construct (GType object_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
ZeitgeistQueuedProxyWrapper* zeitgeist_queued_proxy_wrapper_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void __lambda9_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
void zeitgeist_queued_proxy_wrapper_proxy_acquired (ZeitgeistQueuedProxyWrapper* self, GObject* proxy);
void zeitgeist_queued_proxy_wrapper_proxy_unavailable (ZeitgeistQueuedProxyWrapper* self, GError* err);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
ZeitgeistLog* zeitgeist_log_get_default (void);
static void zeitgeist_log_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_log_reinstall_monitor (ZeitgeistLog* self, ZeitgeistMonitor* monitor, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void zeitgeist_log_reinstall_monitor_finish (ZeitgeistLog* self, GAsyncResult* _res_);
void zeitgeist_remote_log_get_version (ZeitgeistRemoteLog* self, ZeitgeistVersionStruct* result);
static GVariant* _variant_new2 (ZeitgeistVersionStruct value);
static void ___lambda10_ (ZeitgeistLog* self, ZeitgeistLogDbWorker* worker);
static void zeitgeist_log_db_worker_run (ZeitgeistLogDbWorker* self);
static void ____lambda10__gfunc (gpointer data, gpointer self);
gchar* zeitgeist_remote_log_get_datapath (ZeitgeistRemoteLog* self);
static void zeitgeist_log_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_log_insert_event_data_free (gpointer _data);
void zeitgeist_log_insert_event (ZeitgeistLog* self, ZeitgeistEvent* event, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GArray* zeitgeist_log_insert_event_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_log_insert_event_co (ZeitgeistLogInsertEventData* _data_);
void zeitgeist_log_insert_events (ZeitgeistLog* self, GPtrArray* events, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GArray* zeitgeist_log_insert_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_log_insert_event_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void zeitgeist_log_insert_events_data_free (gpointer _data);
static gboolean zeitgeist_log_insert_events_co (ZeitgeistLogInsertEventsData* _data_);
void zeitgeist_queued_proxy_wrapper_wait_for_proxy (ZeitgeistQueuedProxyWrapper* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish (ZeitgeistQueuedProxyWrapper* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_log_insert_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_insert_events (ZeitgeistRemoteLog* self, GVariant* events, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32* zeitgeist_remote_log_insert_events_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
void zeitgeist_log_insert_event_no_reply (ZeitgeistLog* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_log_insert_events_no_reply (ZeitgeistLog* self, GPtrArray* events, GError** error);
static void zeitgeist_log_find_events_data_free (gpointer _data);
void zeitgeist_log_find_events (ZeitgeistLog* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, ZeitgeistStorageState storage_state, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ZeitgeistResultSet* zeitgeist_log_find_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_log_find_events_co (ZeitgeistLogFindEventsData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void* ___lambda11_ (Block3Data* _data3_);
static gboolean _zeitgeist_log_find_events_co_gsource_func (gpointer self);
static gpointer ____lambda11__gthread_func (gpointer self);
static ZeitgeistLogDbWorker* zeitgeist_log_db_worker_new (GThreadFunc func, void* func_target);
static ZeitgeistLogDbWorker* zeitgeist_log_db_worker_construct (GType object_type, GThreadFunc func, void* func_target);
static void zeitgeist_log_find_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_find_events (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* zeitgeist_remote_log_find_events_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_log_find_event_ids_data_free (gpointer _data);
void zeitgeist_log_find_event_ids (ZeitgeistLog* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, ZeitgeistStorageState storage_state, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32* zeitgeist_log_find_event_ids_finish (ZeitgeistLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean zeitgeist_log_find_event_ids_co (ZeitgeistLogFindEventIdsData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void* ___lambda12_ (Block5Data* _data5_);
static gboolean _zeitgeist_log_find_event_ids_co_gsource_func (gpointer self);
static gpointer ____lambda12__gthread_func (gpointer self);
static guint32* _vala_array_dup1 (guint32* self, int length);
static void zeitgeist_log_find_event_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_find_event_ids (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32* zeitgeist_remote_log_find_event_ids_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void zeitgeist_log_get_events_data_free (gpointer _data);
void zeitgeist_log_get_events (ZeitgeistLog* self, GArray* event_ids, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ZeitgeistResultSet* zeitgeist_log_get_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_log_get_events_co (ZeitgeistLogGetEventsData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void* ___lambda13_ (Block7Data* _data7_);
static gboolean _zeitgeist_log_get_events_co_gsource_func (gpointer self);
static gpointer ____lambda13__gthread_func (gpointer self);
static void zeitgeist_log_get_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_get_events (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* zeitgeist_remote_log_get_events_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_log_find_related_uris_data_free (gpointer _data);
void zeitgeist_log_find_related_uris (ZeitgeistLog* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, ZeitgeistStorageState storage_state, guint32 num_events, ZeitgeistRelevantResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** zeitgeist_log_find_related_uris_finish (ZeitgeistLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean zeitgeist_log_find_related_uris_co (ZeitgeistLogFindRelatedUrisData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void* ___lambda14_ (Block9Data* _data9_);
static gboolean _zeitgeist_log_find_related_uris_co_gsource_func (gpointer self);
static gpointer ____lambda14__gthread_func (gpointer self);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void zeitgeist_log_find_related_uris_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_find_related_uris (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** zeitgeist_remote_log_find_related_uris_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void zeitgeist_log_delete_events_data_free (gpointer _data);
void zeitgeist_log_delete_events (ZeitgeistLog* self, GArray* event_ids, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ZeitgeistTimeRange* zeitgeist_log_delete_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_log_delete_events_co (ZeitgeistLogDeleteEventsData* _data_);
static void zeitgeist_log_delete_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_delete_events (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* zeitgeist_remote_log_delete_events_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_log_quit_data_free (gpointer _data);
void zeitgeist_log_quit (ZeitgeistLog* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_log_quit_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_log_quit_co (ZeitgeistLogQuitData* _data_);
static void zeitgeist_log_quit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_log_quit (ZeitgeistRemoteLog* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_log_quit_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
void zeitgeist_log_install_monitor (ZeitgeistLog* self, ZeitgeistMonitor* monitor, GError** error);
gboolean zeitgeist_queued_proxy_wrapper_get_is_connected (ZeitgeistQueuedProxyWrapper* self);
static void zeitgeist_log_reinstall_monitor_data_free (gpointer _data);
static gboolean zeitgeist_log_reinstall_monitor_co (ZeitgeistLogReinstallMonitorData* _data_);
char* zeitgeist_monitor_get_path (ZeitgeistMonitor* self);
GType zeitgeist_remote_monitor_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_monitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_monitor_get_type (void) G_GNUC_CONST;
void zeitgeist_remote_log_install_monitor (ZeitgeistRemoteLog* self, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_log_install_monitor_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
ZeitgeistTimeRange* zeitgeist_monitor_get_time_range (ZeitgeistMonitor* self);
GPtrArray* zeitgeist_monitor_get_templates (ZeitgeistMonitor* self);
void zeitgeist_log_remove_monitor (ZeitgeistLog* self, ZeitgeistMonitor* monitor, GError** error);
void zeitgeist_remote_log_remove_monitor (ZeitgeistRemoteLog* self, const char* monitor_path, const char* owner, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_log_remove_monitor_finish (ZeitgeistRemoteLog* self, GAsyncResult* _res_, GError** error);
void zeitgeist_log_get_version (ZeitgeistLog* self, gint* major, gint* minor, gint* micro);
gchar** zeitgeist_log_get_extensions (ZeitgeistLog* self, int* result_length1);
gchar** zeitgeist_remote_log_get_extensions (ZeitgeistRemoteLog* self, int* result_length1);
gchar* zeitgeist_log_datapath (ZeitgeistLog* self);
#define ZEITGEIST_LOG_DB_WORKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorkerPrivate))
enum  {
	ZEITGEIST_LOG_DB_WORKER_DUMMY_PROPERTY
};
static void zeitgeist_log_db_worker_finalize (ZeitgeistLogDbWorker* obj);
static void zeitgeist_log_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->mainloop);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void __lambda9_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	ZeitgeistLog* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		ZeitgeistRemoteLog* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		ZeitgeistRemoteLog* _tmp2_ = NULL;
		ZeitgeistRemoteLog* _tmp3_ = NULL;
		ZeitgeistRemoteLog* _tmp4_ = NULL;
		ZeitgeistRemoteLog* _tmp5_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (ZeitgeistRemoteLog*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch4_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp4_;
		_tmp5_ = self->priv->proxy;
		zeitgeist_queued_proxy_wrapper_proxy_acquired ((ZeitgeistQueuedProxyWrapper*) self, (GObject*) _tmp5_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("log.vala:102: Unable to connect to Zeitgeist: %s", _tmp7_);
		_tmp8_ = err;
		zeitgeist_queued_proxy_wrapper_proxy_unavailable ((ZeitgeistQueuedProxyWrapper*) self, _tmp8_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_main_loop_quit (_data1_->mainloop);
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda9_ (self, source_object, res);
	block1_data_unref (self);
}


ZeitgeistLog* zeitgeist_log_construct (GType object_type) {
	ZeitgeistLog * self = NULL;
	Block1Data* _data1_;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (ZeitgeistLog*) zeitgeist_queued_proxy_wrapper_construct (object_type);
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp2_;
	_tmp3_ = g_main_loop_new (NULL, FALSE);
	_data1_->mainloop = _tmp3_;
	_tmp4_ = zeitgeist_utils_log_may_read_directly ();
	self->priv->allow_direct_read = _tmp4_;
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_LOG_PROXY, 0, NULL, ___lambda9__gasync_ready_callback, block1_data_ref (_data1_), "g-flags", 0, "g-name", ZEITGEIST_UTILS_ENGINE_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", ZEITGEIST_UTILS_ENGINE_DBUS_PATH, "g-interface-name", "org.gnome.zeitgeist.Log", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_REMOTE_LOG, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	g_main_loop_run (_data1_->mainloop);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


ZeitgeistLog* zeitgeist_log_new (void) {
	return zeitgeist_log_construct (ZEITGEIST_TYPE_LOG);
}


/**
     * Get a unique instance of #ZeitgeistLog, that you can share in your
     * application without caring about memory management.
     *
     * See zeitgeist_log_new() for more information.
     *
     * @return ZeitgeistLog.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistLog* zeitgeist_log_get_default (void) {
	ZeitgeistLog* result = NULL;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistLog* _tmp2_ = NULL;
	ZeitgeistLog* _tmp3_ = NULL;
	_tmp0_ = zeitgeist_log_default_instance;
	if (_tmp0_ == NULL) {
		ZeitgeistLog* _tmp1_ = NULL;
		_tmp1_ = zeitgeist_log_new ();
		_g_object_unref0 (zeitgeist_log_default_instance);
		zeitgeist_log_default_instance = _tmp1_;
	}
	_tmp2_ = zeitgeist_log_default_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static GVariant* _variant_new2 (ZeitgeistVersionStruct value) {
	GVariantBuilder _tmp6_;
	g_variant_builder_init (&_tmp6_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp6_, g_variant_new_int32 (value.major));
	g_variant_builder_add_value (&_tmp6_, g_variant_new_int32 (value.minor));
	g_variant_builder_add_value (&_tmp6_, g_variant_new_int32 (value.micro));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp6_));
}


static void ___lambda10_ (ZeitgeistLog* self, ZeitgeistLogDbWorker* worker) {
	ZeitgeistLogDbWorker* _tmp0_ = NULL;
	g_return_if_fail (worker != NULL);
	_tmp0_ = worker;
	zeitgeist_log_db_worker_run (_tmp0_);
	_zeitgeist_log_db_worker_unref0 (worker);
}


static void ____lambda10__gfunc (gpointer data, gpointer self) {
	___lambda10_ ((ZeitgeistLog*) self, (ZeitgeistLogDbWorker*) data);
}


static void zeitgeist_log_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base) {
	ZeitgeistLog * self;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	ZeitgeistRemoteLog* _tmp3_ = NULL;
	ZeitgeistVersionStruct _tmp4_ = {0};
	ZeitgeistVersionStruct _tmp5_ = {0};
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistLog*) base;
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
		monitor_collection = _tmp1_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			ZeitgeistMonitor* monitor = NULL;
			monitor = (ZeitgeistMonitor*) monitor_it->data;
			{
				ZeitgeistMonitor* _tmp2_ = NULL;
				_tmp2_ = monitor;
				zeitgeist_log_reinstall_monitor (self, _tmp2_, NULL, NULL);
			}
		}
		_g_list_free0 (monitor_collection);
	}
	_tmp3_ = self->priv->proxy;
	zeitgeist_remote_log_get_version (_tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _variant_new2 (_tmp5_);
	_g_variant_unref0 (self->priv->engine_version);
	self->priv->engine_version = _tmp7_;
	_tmp8_ = self->priv->engine_version;
	_tmp9_ = g_variant_get_type_string (_tmp8_);
	g_warn_if_fail (g_strcmp0 (_tmp9_, "(iii)") == 0);
	{
		GThreadPool* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GThreadPool* _tmp12_ = NULL;
		GThreadPool* _tmp13_ = NULL;
		_tmp11_ = g_get_num_processors ();
		_tmp12_ = g_thread_pool_new (____lambda10__gfunc, self, (gint) _tmp11_, TRUE, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch5_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_thread_pool_free0 (self->priv->threads);
		self->priv->threads = _tmp13_;
		_g_thread_pool_free0 (_tmp10_);
	}
	goto __finally5;
	__catch5_g_thread_error:
	{
		GError* err = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = err;
		_tmp15_ = _tmp14_->message;
		g_warning ("log.vala:144: %s", _tmp15_);
		_g_thread_pool_free0 (self->priv->threads);
		self->priv->threads = NULL;
		_g_error_free0 (err);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = self->priv->allow_direct_read;
	if (_tmp19_) {
		GThreadPool* _tmp20_ = NULL;
		_tmp20_ = self->priv->threads;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ZeitgeistRemoteLog* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp21_ = self->priv->proxy;
		_tmp22_ = zeitgeist_remote_log_get_datapath (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp17_ = g_strcmp0 (_tmp24_, ":memory:") != 0;
		_g_free0 (_tmp24_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ZeitgeistRemoteLog* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		_tmp25_ = self->priv->proxy;
		_tmp26_ = zeitgeist_remote_log_get_datapath (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = g_file_test (_tmp28_, G_FILE_TEST_EXISTS);
		_tmp16_ = _tmp29_;
		_g_free0 (_tmp28_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ZeitgeistRemoteLog* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp30_ = self->priv->proxy;
		_tmp31_ = zeitgeist_remote_log_get_datapath (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		zeitgeist_utils_set_database_file_path (_tmp33_);
		_g_free0 (_tmp33_);
		{
			ZeitgeistDbReader* _tmp34_ = NULL;
			ZeitgeistDbReader* _tmp35_ = NULL;
			ZeitgeistDbReader* _tmp36_ = NULL;
			_tmp35_ = zeitgeist_db_reader_new (&_inner_error_);
			_tmp34_ = _tmp35_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch6_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp36_ = _tmp34_;
			_tmp34_ = NULL;
			_g_object_unref0 (self->priv->dbreader);
			self->priv->dbreader = _tmp36_;
			_g_object_unref0 (_tmp34_);
		}
		goto __finally6;
		__catch6_zeitgeist_engine_error:
		{
			GError* err = NULL;
			GError* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp37_ = err;
			_tmp38_ = _tmp37_->message;
			g_warning ("log.vala:155: %s", _tmp38_);
			_g_object_unref0 (self->priv->dbreader);
			self->priv->dbreader = NULL;
			_g_error_free0 (err);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		_g_object_unref0 (self->priv->dbreader);
		self->priv->dbreader = NULL;
	}
}


static void zeitgeist_log_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base) {
	ZeitgeistLog * self;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	self = (ZeitgeistLog*) base;
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
		monitor_collection = _tmp1_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			ZeitgeistMonitor* monitor = NULL;
			monitor = (ZeitgeistMonitor*) monitor_it->data;
			{
				GHashTable* _tmp2_ = NULL;
				ZeitgeistMonitor* _tmp3_ = NULL;
				ZeitgeistMonitor* _tmp4_ = NULL;
				_tmp2_ = self->priv->monitors;
				_tmp3_ = monitor;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				g_hash_table_replace (_tmp2_, _tmp4_, (gpointer) ((guintptr) ((guint) 0)));
			}
		}
		_g_list_free0 (monitor_collection);
	}
	_g_object_unref0 (self->priv->dbreader);
	self->priv->dbreader = NULL;
}


static void zeitgeist_log_insert_event_data_free (gpointer _data) {
	ZeitgeistLogInsertEventData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->event);
	_g_object_unref0 (_data_->cancellable);
	_g_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogInsertEventData, _data_);
}


void zeitgeist_log_insert_event (ZeitgeistLog* self, ZeitgeistEvent* event, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogInsertEventData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistEvent* _tmp1_ = NULL;
	ZeitgeistEvent* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogInsertEventData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_insert_event);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_insert_event_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = event;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->event);
	_data_->event = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_log_insert_event_co (_data_);
}


GArray* zeitgeist_log_insert_event_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error) {
	GArray* result;
	ZeitgeistLogInsertEventData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    *
    * @param event A {@link Event}
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static void zeitgeist_log_insert_event_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogInsertEventData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_insert_event_co (_data_);
}


static gboolean zeitgeist_log_insert_event_co (ZeitgeistLogInsertEventData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->event;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	g_ptr_array_add (_data_->events, _data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->cancellable;
	_data_->_state_ = 1;
	zeitgeist_log_insert_events (_data_->self, _data_->events, _data_->_tmp4_, zeitgeist_log_insert_event_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = zeitgeist_log_insert_events_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp3_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->events);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp3_;
	_data_->_tmp3_ = NULL;
	_data_->result = _data_->_tmp6_;
	_g_array_unref0 (_data_->_tmp3_);
	_g_ptr_array_unref0 (_data_->events);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_array_unref0 (_data_->_tmp3_);
	_g_ptr_array_unref0 (_data_->events);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_log_insert_events_data_free (gpointer _data) {
	ZeitgeistLogInsertEventsData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->events);
	_g_object_unref0 (_data_->cancellable);
	_g_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogInsertEventsData, _data_);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void zeitgeist_log_insert_events (ZeitgeistLog* self, GPtrArray* events, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogInsertEventsData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogInsertEventsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_insert_events);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_insert_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = events;
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	_g_ptr_array_unref0 (_data_->events);
	_data_->events = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_log_insert_events_co (_data_);
}


GArray* zeitgeist_log_insert_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error) {
	GArray* result;
	ZeitgeistLogInsertEventsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    *
    * @param events An {@link GLib.GenericArray} of {@link Event}
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void zeitgeist_log_insert_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogInsertEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_insert_events_co (_data_);
}


static gboolean zeitgeist_log_insert_events_co (ZeitgeistLogInsertEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = 0;
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = 0;
				_data_->_tmp3_ = _data_->i;
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->events;
				_data_->_tmp5_ = 0;
				_data_->_tmp5_ = g_ptr_array_get_length (_data_->_tmp4_);
				_data_->_tmp6_ = 0;
				_data_->_tmp6_ = _data_->_tmp5_;
				if (!(_data_->_tmp3_ < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = _data_->events_cp;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->events;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = _data_->i;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = g_ptr_array_index (_data_->_tmp8_, (guint) _data_->_tmp9_);
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp10_);
				g_ptr_array_add (_data_->_tmp7_, _data_->_tmp11_);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_insert_events_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->events_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->proxy;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->events_cp;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = zeitgeist_events_to_variant (_data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->cancellable;
	_data_->_tmp17_ = 0;
	_data_->_state_ = 2;
	zeitgeist_remote_log_insert_events (_data_->_tmp12_, _data_->_tmp15_, _data_->_tmp16_, NULL, zeitgeist_log_insert_events_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = zeitgeist_remote_log_insert_events_finish (_data_->_tmp12_, _data_->_res_, &_data_->_tmp17_, &_data_->_inner_error_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19__length1 = 0;
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp19__length1 = _data_->_tmp17_;
	_g_variant_unref0 (_data_->_tmp15_);
	_data_->ids_length1 = 0;
	_data_->_ids_size_ = 0;
	_data_->ids = _data_->_tmp19_;
	_data_->ids_length1 = _data_->_tmp19__length1;
	_data_->_ids_size_ = _data_->ids_length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->events_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_array_new (TRUE, TRUE, sizeof (guint32));
	_data_->_result_ = _data_->_tmp20_;
	{
		_data_->_vala1_i = 0;
		{
			_data_->_tmp21_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp21_) {
					_data_->_tmp22_ = 0;
					_data_->_tmp22_ = _data_->_vala1_i;
					_data_->_vala1_i = _data_->_tmp22_ + 1;
				}
				_data_->_tmp21_ = FALSE;
				_data_->_tmp23_ = 0;
				_data_->_tmp23_ = _data_->_vala1_i;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24__length1 = 0;
				_data_->_tmp24_ = _data_->ids;
				_data_->_tmp24__length1 = _data_->ids_length1;
				if (!(_data_->_tmp23_ < _data_->_tmp24__length1)) {
					break;
				}
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->_result_;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26__length1 = 0;
				_data_->_tmp26_ = _data_->ids;
				_data_->_tmp26__length1 = _data_->ids_length1;
				_data_->_tmp27_ = 0;
				_data_->_tmp27_ = _data_->_vala1_i;
				_data_->_tmp28_ = 0U;
				_data_->_tmp28_ = _data_->_tmp26_[_data_->_tmp27_];
				g_array_append_val (_data_->_tmp25_, _data_->_tmp28_);
			}
		}
	}
	_data_->result = _data_->_result_;
	_data_->ids = (g_free (_data_->ids), NULL);
	_g_ptr_array_unref0 (_data_->events_cp);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_array_unref0 (_data_->_result_);
	_data_->ids = (g_free (_data_->ids), NULL);
	_g_ptr_array_unref0 (_data_->events_cp);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    * This method is &quot;fire and forget&quot; and the caller will never know
    * whether the events was successfully inserted or not.
    *
    * This method is exactly equivalent to calling zeitgeist_log_insert_event()
    * with NULL set as @cancellable, @callback, and @user_data.
    *
    * @param event A {@link Event}
    */
void zeitgeist_log_insert_event_no_reply (ZeitgeistLog* self, ZeitgeistEvent* event, GError** error) {
	ZeitgeistEvent* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	zeitgeist_log_insert_event (self, _tmp0_, NULL, NULL, NULL);
}


/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    * This method is &quot;fire and forget&quot; and the caller will never know
    * whether the events was successfully inserted or not.
    *
    * This method is exactly equivalent to calling zeitgeist_log_insert_event()
    * with NULL set as @cancellable, @callback, and @user_data.
    *
    * @param events An {@link GLib.GenericArray} of {@link Event}
    */
void zeitgeist_log_insert_events_no_reply (ZeitgeistLog* self, GPtrArray* events, GError** error) {
	GPtrArray* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = events;
	zeitgeist_log_insert_events (self, _tmp0_, NULL, NULL, NULL);
}


static void zeitgeist_log_find_events_data_free (gpointer _data) {
	ZeitgeistLogFindEventsData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogFindEventsData, _data_);
}


void zeitgeist_log_find_events (ZeitgeistLog* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, ZeitgeistStorageState storage_state, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogFindEventsData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_ = NULL;
	ZeitgeistTimeRange* _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	ZeitgeistStorageState _tmp5_ = 0;
	guint32 _tmp6_ = 0U;
	ZeitgeistResultType _tmp7_ = 0;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogFindEventsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_find_events);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_find_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_templates;
	_tmp4_ = _g_ptr_array_ref0 (_tmp3_);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = storage_state;
	_data_->storage_state = _tmp5_;
	_tmp6_ = num_events;
	_data_->num_events = _tmp6_;
	_tmp7_ = result_type;
	_data_->result_type = _tmp7_;
	_tmp8_ = cancellable;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp9_;
	zeitgeist_log_find_events_co (_data_);
}


ZeitgeistResultSet* zeitgeist_log_find_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistResultSet* result;
	ZeitgeistLogFindEventsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
    * Send a query matching a collection of {@link Event} templates to the {@link Log}.
    * The query will match if an event matches any of the templates. If an event
    * template has more than one {@link Subject} the query will match if any one
    * of the {@link Subject}s templates match.
    *
    * The query will be done via an asynchronous DBus call and this method will
    * return immediately. The return value will be passed to callback as a list
    * of {@link Event}s. This list must be the sole argument for the callback.
    *
    * If you need to do a query yielding a large (or unpredictable) result set
    * and you only want to show some of the results at the same time (eg., by
    * paging them), consider using {@link find_event_ids}.
    *
    * In order to use this method there needs to be a mainloop runnning.
    * Both Qt and GLib mainloops are supported.
    *
    * @param time_range {@link TimeRange} A time range in which the events should be considered in
    * @param storage_state {@link StorageState} storage state
    * @param event_templates An {@link GLib.GenericArray} of {@link Event}
    * @param num_events int represteing the number of events that should be returned
    * @param result_type {@link ResultType} how the events should be grouped and sorted
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data2_->self;
		_g_ptr_array_unref0 (_data2_->event_templates_cp);
		_g_object_unref0 (_data2_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data3_->_data2_->self;
		_g_error_free0 (_data3_->_error_);
		_g_object_unref0 (_data3_->result_set);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _zeitgeist_log_find_events_co_gsource_func (gpointer self) {
	gboolean result;
	result = zeitgeist_log_find_events_co (self);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void* ___lambda11_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	ZeitgeistLog* self;
	void* result = NULL;
	GError * _inner_error_ = NULL;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	{
		GPtrArray* _result_ = NULL;
		ZeitgeistDbReader* _tmp0_ = NULL;
		ZeitgeistTimeRange* _tmp1_ = NULL;
		GPtrArray* _tmp2_ = NULL;
		ZeitgeistStorageState _tmp3_ = 0;
		guint32 _tmp4_ = 0U;
		ZeitgeistResultType _tmp5_ = 0;
		GPtrArray* _tmp6_ = NULL;
		ZeitgeistSimpleResultSet* _tmp7_ = NULL;
		_tmp0_ = self->priv->dbreader;
		_tmp1_ = _data2_->time_range;
		_tmp2_ = _data2_->event_templates_cp;
		_tmp3_ = _data2_->storage_state;
		_tmp4_ = _data2_->num_events;
		_tmp5_ = _data2_->result_type;
		_tmp6_ = zeitgeist_db_reader_find_events (_tmp0_, _tmp1_, _tmp2_, (guint) _tmp3_, (guint) _tmp4_, (guint) _tmp5_, NULL, &_inner_error_);
		_result_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch7_zeitgeist_engine_error;
			}
			{
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_events_co_gsource_func, _data2_->_async_data_, NULL);
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = zeitgeist_simple_result_set_new (_result_);
		_g_object_unref0 (_data3_->result_set);
		_data3_->result_set = _tmp7_;
		_g_ptr_array_unref0 (_result_);
	}
	goto __finally7;
	__catch7_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_g_error_free0 (_data3_->_error_);
		_data3_->_error_ = _tmp9_;
		_g_error_free0 (err);
	}
	__finally7:
	{
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_events_co_gsource_func, _data2_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	return result;
}


static gpointer ____lambda11__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda11_ (self);
	block3_data_unref (self);
	return result;
}


static void zeitgeist_log_find_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogFindEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_find_events_co (_data_);
}


static gboolean zeitgeist_log_find_events_co (ZeitgeistLogFindEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->time_range;
	_g_object_unref0 (_data_->_data2_->time_range);
	_data_->_data2_->time_range = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->storage_state;
	_data_->_data2_->storage_state = _data_->_tmp1_;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->num_events;
	_data_->_data2_->num_events = _data_->_tmp2_;
	_data_->_tmp3_ = 0;
	_data_->_tmp3_ = _data_->result_type;
	_data_->_data2_->result_type = _data_->_tmp3_;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data2_->event_templates_cp = _data_->_tmp4_;
	{
		_data_->i = 0;
		{
			_data_->_tmp5_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp5_) {
					_data_->_tmp6_ = 0;
					_data_->_tmp6_ = _data_->i;
					_data_->i = _data_->_tmp6_ + 1;
				}
				_data_->_tmp5_ = FALSE;
				_data_->_tmp7_ = 0;
				_data_->_tmp7_ = _data_->i;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->event_templates;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = g_ptr_array_get_length (_data_->_tmp8_);
				_data_->_tmp10_ = 0;
				_data_->_tmp10_ = _data_->_tmp9_;
				if (!(_data_->_tmp7_ < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->_data2_->event_templates_cp;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->event_templates;
				_data_->_tmp13_ = 0;
				_data_->_tmp13_ = _data_->i;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = g_ptr_array_index (_data_->_tmp12_, (guint) _data_->_tmp13_);
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp14_);
				g_ptr_array_add (_data_->_tmp11_, _data_->_tmp15_);
			}
		}
	}
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->self->priv->dbreader;
	if (_data_->_tmp16_ != NULL) {
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
		_data_->_data3_->result_set = NULL;
		_data_->_data3_->_error_ = NULL;
		_data_->run_target = NULL;
		_data_->run_target_destroy_notify = NULL;
		_data_->run = ____lambda11__gthread_func;
		_data_->run_target = block3_data_ref (_data_->_data3_);
		_data_->run_target_destroy_notify = block3_data_unref;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->self->priv->threads;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18__target = NULL;
		_data_->_tmp18_ = _data_->run;
		_data_->_tmp18__target = _data_->run_target;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = zeitgeist_log_db_worker_new (_data_->_tmp18_, _data_->_tmp18__target);
		g_thread_pool_push (_data_->_tmp17_, _data_->_tmp19_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_data3_->_error_;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_data3_->_error_;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _g_error_copy0 (_data_->_tmp21_);
			_data_->_inner_error_ = _data_->_tmp22_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_data3_->result_set;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _g_object_ref0 ((ZeitgeistResultSet*) _data_->_tmp23_);
		_data_->result = _data_->_tmp24_;
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_find_events_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->self->priv->proxy;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->_data2_->time_range;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = zeitgeist_time_range_to_variant (_data_->_tmp26_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->_data2_->event_templates_cp;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = zeitgeist_events_to_variant (_data_->_tmp29_);
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp32_ = 0;
	_data_->_tmp32_ = _data_->_data2_->storage_state;
	_data_->_tmp33_ = 0U;
	_data_->_tmp33_ = _data_->_data2_->num_events;
	_data_->_tmp34_ = 0;
	_data_->_tmp34_ = _data_->_data2_->result_type;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->cancellable;
	_data_->_state_ = 3;
	zeitgeist_remote_log_find_events (_data_->_tmp25_, _data_->_tmp28_, _data_->_tmp31_, (guint) _data_->_tmp32_, (guint) _data_->_tmp33_, (guint) _data_->_tmp34_, _data_->_tmp35_, NULL, zeitgeist_log_find_events_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = zeitgeist_remote_log_find_events_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_tmp36_;
	_g_variant_unref0 (_data_->_tmp31_);
	_g_variant_unref0 (_data_->_tmp28_);
	_data_->_result_ = _data_->_tmp37_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->_result_;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = zeitgeist_events_from_variant (_data_->_tmp39_, &_data_->_inner_error_);
	_data_->_tmp38_ = _data_->_tmp40_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_unref0 (_data_->_result_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = zeitgeist_simple_result_set_new (_data_->_tmp38_);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp41_;
	_g_ptr_array_unref0 (_data_->_tmp38_);
	_g_variant_unref0 (_data_->_result_);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_ptr_array_unref0 (_data_->_tmp38_);
	_g_variant_unref0 (_data_->_result_);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_log_find_event_ids_data_free (gpointer _data) {
	ZeitgeistLogFindEventIdsData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogFindEventIdsData, _data_);
}


void zeitgeist_log_find_event_ids (ZeitgeistLog* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, ZeitgeistStorageState storage_state, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogFindEventIdsData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_ = NULL;
	ZeitgeistTimeRange* _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	ZeitgeistStorageState _tmp5_ = 0;
	guint32 _tmp6_ = 0U;
	ZeitgeistResultType _tmp7_ = 0;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogFindEventIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_find_event_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_find_event_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_templates;
	_tmp4_ = _g_ptr_array_ref0 (_tmp3_);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = storage_state;
	_data_->storage_state = _tmp5_;
	_tmp6_ = num_events;
	_data_->num_events = _tmp6_;
	_tmp7_ = result_type;
	_data_->result_type = _tmp7_;
	_tmp8_ = cancellable;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp9_;
	zeitgeist_log_find_event_ids_co (_data_);
}


guint32* zeitgeist_log_find_event_ids_finish (ZeitgeistLog* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	guint32* result;
	ZeitgeistLogFindEventIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


/**
    * Send a query matching a collection of {@link Event} templates to the {@link Log}.
    * The query will match if an event matches any of the templates. If an event
    * template has more than one {@link Subject} the query will match if any one
    * of the {@link Subject}s templates match.
    *
    * The query will be done via an asynchronous DBus call and this method will
    * return immediately. The return value will be passed to callback as a list
    * of intergers represrting {@link Event} id's.
    * This list must be the sole argument for the callback.
    *
    * In order to use this method there needs to be a mainloop runnning.
    * Both Qt and GLib mainloops are supported.
    *
    * @param time_range {@link TimeRange} A time range in which the events should be considered in
    * @param storage_state {@link StorageState} storage state
    * @param event_templates An {@link GLib.GenericArray} of {@link Event}
    * @param num_events int represteing the number of events that should be returned
    * @param result_type {@link ResultType} how the events should be grouped and sorted
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data4_->self;
		_g_ptr_array_unref0 (_data4_->event_templates_cp);
		_g_object_unref0 (_data4_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data5_->_data4_->self;
		_g_error_free0 (_data5_->_error_);
		_data5_->ids = (g_free (_data5_->ids), NULL);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _zeitgeist_log_find_event_ids_co_gsource_func (gpointer self) {
	gboolean result;
	result = zeitgeist_log_find_event_ids_co (self);
	return result;
}


static void* ___lambda12_ (Block5Data* _data5_) {
	Block4Data* _data4_;
	ZeitgeistLog* self;
	void* result = NULL;
	GError * _inner_error_ = NULL;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	{
		guint32* _tmp0_ = NULL;
		ZeitgeistDbReader* _tmp1_ = NULL;
		ZeitgeistTimeRange* _tmp2_ = NULL;
		GPtrArray* _tmp3_ = NULL;
		ZeitgeistStorageState _tmp4_ = 0;
		guint32 _tmp5_ = 0U;
		ZeitgeistResultType _tmp6_ = 0;
		gint _tmp7_ = 0;
		guint32* _tmp8_ = NULL;
		gint _tmp0__length1 = 0;
		gint __tmp0__size_ = 0;
		guint32* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp1_ = self->priv->dbreader;
		_tmp2_ = _data4_->time_range;
		_tmp3_ = _data4_->event_templates_cp;
		_tmp4_ = _data4_->storage_state;
		_tmp5_ = _data4_->num_events;
		_tmp6_ = _data4_->result_type;
		_tmp8_ = zeitgeist_db_reader_find_event_ids (_tmp1_, _tmp2_, _tmp3_, (guint) _tmp4_, (guint) _tmp5_, (guint) _tmp6_, NULL, &_tmp7_, &_inner_error_);
		_tmp0_ = _tmp8_;
		_tmp0__length1 = _tmp7_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch8_zeitgeist_engine_error;
			}
			{
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_event_ids_co_gsource_func, _data4_->_async_data_, NULL);
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp0_;
		_tmp9__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_data5_->ids = (g_free (_data5_->ids), NULL);
		_data5_->ids = _tmp9_;
		_data5_->ids_length1 = _tmp9__length1;
		_data5_->_ids_size_ = _data5_->ids_length1;
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	goto __finally8;
	__catch8_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = err;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_g_error_free0 (_data5_->_error_);
		_data5_->_error_ = _tmp11_;
		_g_error_free0 (err);
	}
	__finally8:
	{
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_event_ids_co_gsource_func, _data4_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	return result;
}


static gpointer ____lambda12__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda12_ (self);
	block5_data_unref (self);
	return result;
}


static guint32* _vala_array_dup1 (guint32* self, int length) {
	return g_memdup (self, length * sizeof (guint32));
}


static void zeitgeist_log_find_event_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogFindEventIdsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_find_event_ids_co (_data_);
}


static gboolean zeitgeist_log_find_event_ids_co (ZeitgeistLogFindEventIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->time_range;
	_g_object_unref0 (_data_->_data4_->time_range);
	_data_->_data4_->time_range = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->storage_state;
	_data_->_data4_->storage_state = _data_->_tmp1_;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->num_events;
	_data_->_data4_->num_events = _data_->_tmp2_;
	_data_->_tmp3_ = 0;
	_data_->_tmp3_ = _data_->result_type;
	_data_->_data4_->result_type = _data_->_tmp3_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data4_->event_templates_cp = _data_->_tmp4_;
	{
		_data_->i = 0;
		{
			_data_->_tmp5_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp5_) {
					_data_->_tmp6_ = 0;
					_data_->_tmp6_ = _data_->i;
					_data_->i = _data_->_tmp6_ + 1;
				}
				_data_->_tmp5_ = FALSE;
				_data_->_tmp7_ = 0;
				_data_->_tmp7_ = _data_->i;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->event_templates;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = g_ptr_array_get_length (_data_->_tmp8_);
				_data_->_tmp10_ = 0;
				_data_->_tmp10_ = _data_->_tmp9_;
				if (!(_data_->_tmp7_ < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->_data4_->event_templates_cp;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->event_templates;
				_data_->_tmp13_ = 0;
				_data_->_tmp13_ = _data_->i;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = g_ptr_array_index (_data_->_tmp12_, (guint) _data_->_tmp13_);
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp14_);
				g_ptr_array_add (_data_->_tmp11_, _data_->_tmp15_);
			}
		}
	}
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->self->priv->dbreader;
	if (_data_->_tmp16_ != NULL) {
		_data_->_data5_ = g_slice_new0 (Block5Data);
		_data_->_data5_->_ref_count_ = 1;
		_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
		_data_->_data5_->ids = NULL;
		_data_->_data5_->ids_length1 = 0;
		_data_->_data5_->_ids_size_ = _data_->_data5_->ids_length1;
		_data_->_data5_->_error_ = NULL;
		_data_->run_target = NULL;
		_data_->run_target_destroy_notify = NULL;
		_data_->run = ____lambda12__gthread_func;
		_data_->run_target = block5_data_ref (_data_->_data5_);
		_data_->run_target_destroy_notify = block5_data_unref;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->self->priv->threads;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18__target = NULL;
		_data_->_tmp18_ = _data_->run;
		_data_->_tmp18__target = _data_->run_target;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = zeitgeist_log_db_worker_new (_data_->_tmp18_, _data_->_tmp18__target);
		g_thread_pool_push (_data_->_tmp17_, _data_->_tmp19_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_data5_->_error_;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_data5_->_error_;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _g_error_copy0 (_data_->_tmp21_);
			_data_->_inner_error_ = _data_->_tmp22_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = NULL;
		_data_->_tmp23__length1 = 0;
		_data_->_tmp23_ = _data_->_data5_->ids;
		_data_->_tmp23__length1 = _data_->_data5_->ids_length1;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24__length1 = 0;
		_data_->_tmp24_ = (_data_->_tmp23_ != NULL) ? _vala_array_dup1 (_data_->_tmp23_, _data_->_tmp23__length1) : ((gpointer) _data_->_tmp23_);
		_data_->_tmp24__length1 = _data_->_tmp23__length1;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25__length1 = 0;
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp25__length1 = _data_->_tmp24__length1;
		_data_->result_length1 = _data_->_tmp25__length1;
		_data_->result = _data_->_tmp25_;
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_find_event_ids_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->self->priv->proxy;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->_data4_->time_range;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = zeitgeist_time_range_to_variant (_data_->_tmp28_);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->_data4_->event_templates_cp;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = zeitgeist_events_to_variant (_data_->_tmp31_);
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = 0;
	_data_->_tmp34_ = _data_->_data4_->storage_state;
	_data_->_tmp35_ = 0U;
	_data_->_tmp35_ = _data_->_data4_->num_events;
	_data_->_tmp36_ = 0;
	_data_->_tmp36_ = _data_->_data4_->result_type;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->cancellable;
	_data_->_tmp38_ = 0;
	_data_->_state_ = 3;
	zeitgeist_remote_log_find_event_ids (_data_->_tmp27_, _data_->_tmp30_, _data_->_tmp33_, (guint) _data_->_tmp34_, (guint) _data_->_tmp35_, (guint) _data_->_tmp36_, _data_->_tmp37_, NULL, zeitgeist_log_find_event_ids_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = zeitgeist_remote_log_find_event_ids_finish (_data_->_tmp27_, _data_->_res_, &_data_->_tmp38_, &_data_->_inner_error_);
	_data_->_tmp40_ = NULL;
	_data_->_tmp40__length1 = 0;
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp40__length1 = _data_->_tmp38_;
	_g_variant_unref0 (_data_->_tmp33_);
	_g_variant_unref0 (_data_->_tmp30_);
	_data_->_tmp26__length1 = 0;
	_data_->__tmp26__size_ = 0;
	_data_->_tmp26_ = _data_->_tmp40_;
	_data_->_tmp26__length1 = _data_->_tmp40__length1;
	_data_->__tmp26__size_ = _data_->_tmp26__length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp41_ = NULL;
	_data_->_tmp41__length1 = 0;
	_data_->_tmp41_ = _data_->_tmp26_;
	_data_->_tmp41__length1 = _data_->_tmp26__length1;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26__length1 = 0;
	_data_->_tmp42_ = NULL;
	_data_->_tmp42__length1 = 0;
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp42__length1 = _data_->_tmp41__length1;
	_data_->result_length1 = _data_->_tmp42__length1;
	_data_->result = _data_->_tmp42_;
	_data_->_tmp26_ = (g_free (_data_->_tmp26_), NULL);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->_tmp26_ = (g_free (_data_->_tmp26_), NULL);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_log_get_events_data_free (gpointer _data) {
	ZeitgeistLogGetEventsData* _data_;
	_data_ = _data;
	_g_array_unref0 (_data_->event_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogGetEventsData, _data_);
}


static gpointer _g_array_ref0 (gpointer self) {
	return self ? g_array_ref (self) : NULL;
}


void zeitgeist_log_get_events (ZeitgeistLog* self, GArray* event_ids, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogGetEventsData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	GArray* _tmp1_ = NULL;
	GArray* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogGetEventsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_get_events);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_get_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = event_ids;
	_tmp2_ = _g_array_ref0 (_tmp1_);
	_g_array_unref0 (_data_->event_ids);
	_data_->event_ids = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_log_get_events_co (_data_);
}


ZeitgeistResultSet* zeitgeist_log_get_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistResultSet* result;
	ZeitgeistLogGetEventsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
    * Look up a collection of {@link Event} in the {@link Log} given a collection
    * of event ids. This is useful for looking up the event data for events found
    * with the find_event_ids_* family of functions.
    *
    * Each {@link Event} which is not found in the {@link Log} is represented by
    * NULL in the resulting collection. The query will be done via an asynchronous
    * DBus call and this method will return immediately. The returned events will
    * be passed to callback as a list of {@link Event}s, which must be the only
    * argument of the function.
    *
    * In order to use this method there needs to be a mainloop runnning.
    *
    * @param event_ids a {@link GLib.Array} of {@link Event} ids
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data6_->self;
		_data6_->simple_event_ids = (g_free (_data6_->simple_event_ids), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data7_->_data6_->self;
		_g_error_free0 (_data7_->_error_);
		_g_object_unref0 (_data7_->result_set);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean _zeitgeist_log_get_events_co_gsource_func (gpointer self) {
	gboolean result;
	result = zeitgeist_log_get_events_co (self);
	return result;
}


static void* ___lambda13_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	ZeitgeistLog* self;
	void* result = NULL;
	GError * _inner_error_ = NULL;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	{
		GPtrArray* _result_ = NULL;
		ZeitgeistDbReader* _tmp0_ = NULL;
		guint32* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		GPtrArray* _tmp2_ = NULL;
		ZeitgeistSimpleResultSet* _tmp3_ = NULL;
		_tmp0_ = self->priv->dbreader;
		_tmp1_ = _data6_->simple_event_ids;
		_tmp1__length1 = _data6_->simple_event_ids_length1;
		_tmp2_ = zeitgeist_db_reader_get_events (_tmp0_, _tmp1_, _tmp1__length1, NULL, &_inner_error_);
		_result_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch9_zeitgeist_engine_error;
			}
			{
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_get_events_co_gsource_func, _data6_->_async_data_, NULL);
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = zeitgeist_simple_result_set_new (_result_);
		_g_object_unref0 (_data7_->result_set);
		_data7_->result_set = _tmp3_;
		_g_ptr_array_unref0 (_result_);
	}
	goto __finally9;
	__catch9_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (_data7_->_error_);
		_data7_->_error_ = _tmp5_;
		_g_error_free0 (err);
	}
	__finally9:
	{
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_get_events_co_gsource_func, _data6_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	return result;
}


static gpointer ____lambda13__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda13_ (self);
	block7_data_unref (self);
	return result;
}


static void zeitgeist_log_get_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogGetEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_get_events_co (_data_);
}


static gboolean zeitgeist_log_get_events_co (ZeitgeistLogGetEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->event_ids;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = _data_->_tmp0_->len;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_new0 (guint32, _data_->_tmp1_);
	_data_->_data6_->simple_event_ids = _data_->_tmp2_;
	_data_->_data6_->simple_event_ids_length1 = _data_->_tmp1_;
	_data_->_data6_->_simple_event_ids_size_ = _data_->_data6_->simple_event_ids_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp3_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp3_) {
					_data_->_tmp4_ = 0;
					_data_->_tmp4_ = _data_->i;
					_data_->i = _data_->_tmp4_ + 1;
				}
				_data_->_tmp3_ = FALSE;
				_data_->_tmp5_ = 0;
				_data_->_tmp5_ = _data_->i;
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = _data_->event_ids;
				_data_->_tmp7_ = 0U;
				_data_->_tmp7_ = _data_->_tmp6_->len;
				if (!(((guint) _data_->_tmp5_) < _data_->_tmp7_)) {
					break;
				}
				_data_->_tmp8_ = NULL;
				_data_->_tmp8__length1 = 0;
				_data_->_tmp8_ = _data_->_data6_->simple_event_ids;
				_data_->_tmp8__length1 = _data_->_data6_->simple_event_ids_length1;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = _data_->i;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->event_ids;
				_data_->_tmp11_ = 0;
				_data_->_tmp11_ = _data_->i;
				_data_->_tmp12_ = 0U;
				_data_->_tmp12_ = g_array_index (_data_->_tmp10_, guint32, (guint) _data_->_tmp11_);
				_data_->_tmp8_[_data_->_tmp9_] = _data_->_tmp12_;
				_data_->_tmp13_ = 0U;
				_data_->_tmp13_ = _data_->_tmp8_[_data_->_tmp9_];
			}
		}
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->self->priv->dbreader;
	if (_data_->_tmp14_ != NULL) {
		_data_->_data7_ = g_slice_new0 (Block7Data);
		_data_->_data7_->_ref_count_ = 1;
		_data_->_data7_->_data6_ = block6_data_ref (_data_->_data6_);
		_data_->_data7_->result_set = NULL;
		_data_->_data7_->_error_ = NULL;
		_data_->run_target = NULL;
		_data_->run_target_destroy_notify = NULL;
		_data_->run = ____lambda13__gthread_func;
		_data_->run_target = block7_data_ref (_data_->_data7_);
		_data_->run_target_destroy_notify = block7_data_unref;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->priv->threads;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16__target = NULL;
		_data_->_tmp16_ = _data_->run;
		_data_->_tmp16__target = _data_->run_target;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = zeitgeist_log_db_worker_new (_data_->_tmp16_, _data_->_tmp16__target);
		g_thread_pool_push (_data_->_tmp15_, _data_->_tmp17_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block7_data_unref (_data_->_data7_);
			_data_->_data7_ = NULL;
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_data7_->_error_;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->_data7_->_error_;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _g_error_copy0 (_data_->_tmp19_);
			_data_->_inner_error_ = _data_->_tmp20_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block7_data_unref (_data_->_data7_);
			_data_->_data7_ = NULL;
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_data7_->result_set;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _g_object_ref0 ((ZeitgeistResultSet*) _data_->_tmp21_);
		_data_->result = _data_->_tmp22_;
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_get_events_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->self->priv->proxy;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24__length1 = 0;
	_data_->_tmp24_ = _data_->_data6_->simple_event_ids;
	_data_->_tmp24__length1 = _data_->_data6_->simple_event_ids_length1;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->cancellable;
	_data_->_state_ = 3;
	zeitgeist_remote_log_get_events (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp24__length1, _data_->_tmp25_, NULL, zeitgeist_log_get_events_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = zeitgeist_remote_log_get_events_finish (_data_->_tmp23_, _data_->_res_, &_data_->_inner_error_);
	_data_->_result_ = _data_->_tmp26_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->_result_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = zeitgeist_events_from_variant (_data_->_tmp28_, &_data_->_inner_error_);
	_data_->_tmp27_ = _data_->_tmp29_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_unref0 (_data_->_result_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = zeitgeist_simple_result_set_new (_data_->_tmp27_);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp30_;
	_g_ptr_array_unref0 (_data_->_tmp27_);
	_g_variant_unref0 (_data_->_result_);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_ptr_array_unref0 (_data_->_tmp27_);
	_g_variant_unref0 (_data_->_result_);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_log_find_related_uris_data_free (gpointer _data) {
	ZeitgeistLogFindRelatedUrisData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_ptr_array_unref0 (_data_->result_event_templates);
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogFindRelatedUrisData, _data_);
}


void zeitgeist_log_find_related_uris (ZeitgeistLog* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, ZeitgeistStorageState storage_state, guint32 num_events, ZeitgeistRelevantResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogFindRelatedUrisData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_ = NULL;
	ZeitgeistTimeRange* _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_ = NULL;
	ZeitgeistStorageState _tmp7_ = 0;
	guint32 _tmp8_ = 0U;
	ZeitgeistRelevantResultType _tmp9_ = 0;
	GCancellable* _tmp10_ = NULL;
	GCancellable* _tmp11_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogFindRelatedUrisData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_find_related_uris);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_find_related_uris_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_templates;
	_tmp4_ = _g_ptr_array_ref0 (_tmp3_);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = result_event_templates;
	_tmp6_ = _g_ptr_array_ref0 (_tmp5_);
	_g_ptr_array_unref0 (_data_->result_event_templates);
	_data_->result_event_templates = _tmp6_;
	_tmp7_ = storage_state;
	_data_->storage_state = _tmp7_;
	_tmp8_ = num_events;
	_data_->num_events = _tmp8_;
	_tmp9_ = result_type;
	_data_->result_type = _tmp9_;
	_tmp10_ = cancellable;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp11_;
	zeitgeist_log_find_related_uris_co (_data_);
}


gchar** zeitgeist_log_find_related_uris_finish (ZeitgeistLog* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	ZeitgeistLogFindRelatedUrisData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


/**
    * Get a list of URIs of subjects which frequently occur together with events
    * matching event_templates. Possibly restricting to time_range or to URIs
    * that occur as subject of events matching result_event_templates.
    *
    * @param time_range {@link TimeRange} A time range in which the events should be considered in
    * @param storage_state {@link StorageState} storage state
    * @param event_templates An {@link GLib.GenericArray} of {@link Event} describing the events to relate to
    * @param result_event_templates An {@link GLib.GenericArray} of {@link Event} desrcibing the result to be returned
    * @param num_events int represteing the number of events that should be returned
    * @param result_type {@link ResultType} how the events should be grouped and sorted
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data8_->self;
		_g_ptr_array_unref0 (_data8_->results_cp);
		_g_ptr_array_unref0 (_data8_->events_cp);
		_g_object_unref0 (_data8_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data9_->_data8_->self;
		_g_error_free0 (_data9_->_error_);
		_data9_->uris = (_vala_array_free (_data9_->uris, _data9_->uris_length1, (GDestroyNotify) g_free), NULL);
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean _zeitgeist_log_find_related_uris_co_gsource_func (gpointer self) {
	gboolean result;
	result = zeitgeist_log_find_related_uris_co (self);
	return result;
}


static void* ___lambda14_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	ZeitgeistLog* self;
	void* result = NULL;
	GError * _inner_error_ = NULL;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	{
		gchar** _tmp0_ = NULL;
		ZeitgeistDbReader* _tmp1_ = NULL;
		ZeitgeistTimeRange* _tmp2_ = NULL;
		GPtrArray* _tmp3_ = NULL;
		GPtrArray* _tmp4_ = NULL;
		ZeitgeistStorageState _tmp5_ = 0;
		guint32 _tmp6_ = 0U;
		ZeitgeistRelevantResultType _tmp7_ = 0;
		gint _tmp8_ = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp0__length1 = 0;
		gint __tmp0__size_ = 0;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp1_ = self->priv->dbreader;
		_tmp2_ = _data8_->time_range;
		_tmp3_ = _data8_->events_cp;
		_tmp4_ = _data8_->results_cp;
		_tmp5_ = _data8_->storage_state;
		_tmp6_ = _data8_->num_events;
		_tmp7_ = _data8_->result_type;
		_tmp9_ = zeitgeist_db_reader_find_related_uris (_tmp1_, _tmp2_, _tmp3_, _tmp4_, (guint) _tmp5_, (guint) _tmp6_, (guint) _tmp7_, NULL, &_tmp8_, &_inner_error_);
		_tmp0_ = _tmp9_;
		_tmp0__length1 = _tmp8_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch10_zeitgeist_engine_error;
			}
			{
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_related_uris_co_gsource_func, _data8_->_async_data_, NULL);
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp0_;
		_tmp10__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_data9_->uris = (_vala_array_free (_data9_->uris, _data9_->uris_length1, (GDestroyNotify) g_free), NULL);
		_data9_->uris = _tmp10_;
		_data9_->uris_length1 = _tmp10__length1;
		_data9_->_uris_size_ = _data9_->uris_length1;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally10;
	__catch10_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _g_error_copy0 (_tmp11_);
		_g_error_free0 (_data9_->_error_);
		_data9_->_error_ = _tmp12_;
		_g_error_free0 (err);
	}
	__finally10:
	{
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_related_uris_co_gsource_func, _data8_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	return result;
}


static gpointer ____lambda14__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda14_ (self);
	block9_data_unref (self);
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void zeitgeist_log_find_related_uris_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogFindRelatedUrisData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_find_related_uris_co (_data_);
}


static gboolean zeitgeist_log_find_related_uris_co (ZeitgeistLogFindRelatedUrisData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->time_range;
	_g_object_unref0 (_data_->_data8_->time_range);
	_data_->_data8_->time_range = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->storage_state;
	_data_->_data8_->storage_state = _data_->_tmp1_;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->num_events;
	_data_->_data8_->num_events = _data_->_tmp2_;
	_data_->_tmp3_ = 0;
	_data_->_tmp3_ = _data_->result_type;
	_data_->_data8_->result_type = _data_->_tmp3_;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data8_->events_cp = _data_->_tmp4_;
	{
		_data_->i = 0;
		{
			_data_->_tmp5_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp5_) {
					_data_->_tmp6_ = 0;
					_data_->_tmp6_ = _data_->i;
					_data_->i = _data_->_tmp6_ + 1;
				}
				_data_->_tmp5_ = FALSE;
				_data_->_tmp7_ = 0;
				_data_->_tmp7_ = _data_->i;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->event_templates;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = g_ptr_array_get_length (_data_->_tmp8_);
				_data_->_tmp10_ = 0;
				_data_->_tmp10_ = _data_->_tmp9_;
				if (!(_data_->_tmp7_ < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->_data8_->events_cp;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->event_templates;
				_data_->_tmp13_ = 0;
				_data_->_tmp13_ = _data_->i;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = g_ptr_array_index (_data_->_tmp12_, (guint) _data_->_tmp13_);
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp14_);
				g_ptr_array_add (_data_->_tmp11_, _data_->_tmp15_);
			}
		}
	}
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data8_->results_cp = _data_->_tmp16_;
	{
		_data_->_vala1_i = 0;
		{
			_data_->_tmp17_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp17_) {
					_data_->_tmp18_ = 0;
					_data_->_tmp18_ = _data_->_vala1_i;
					_data_->_vala1_i = _data_->_tmp18_ + 1;
				}
				_data_->_tmp17_ = FALSE;
				_data_->_tmp19_ = 0;
				_data_->_tmp19_ = _data_->_vala1_i;
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = _data_->result_event_templates;
				_data_->_tmp21_ = 0;
				_data_->_tmp21_ = g_ptr_array_get_length (_data_->_tmp20_);
				_data_->_tmp22_ = 0;
				_data_->_tmp22_ = _data_->_tmp21_;
				if (!(_data_->_tmp19_ < _data_->_tmp22_)) {
					break;
				}
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->_data8_->results_cp;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->result_event_templates;
				_data_->_tmp25_ = 0;
				_data_->_tmp25_ = _data_->_vala1_i;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = g_ptr_array_index (_data_->_tmp24_, (guint) _data_->_tmp25_);
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp26_);
				g_ptr_array_add (_data_->_tmp23_, _data_->_tmp27_);
			}
		}
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->self->priv->dbreader;
	if (_data_->_tmp28_ != NULL) {
		_data_->_data9_ = g_slice_new0 (Block9Data);
		_data_->_data9_->_ref_count_ = 1;
		_data_->_data9_->_data8_ = block8_data_ref (_data_->_data8_);
		_data_->_data9_->uris = NULL;
		_data_->_data9_->uris_length1 = 0;
		_data_->_data9_->_uris_size_ = _data_->_data9_->uris_length1;
		_data_->_data9_->_error_ = NULL;
		_data_->run_target = NULL;
		_data_->run_target_destroy_notify = NULL;
		_data_->run = ____lambda14__gthread_func;
		_data_->run_target = block9_data_ref (_data_->_data9_);
		_data_->run_target_destroy_notify = block9_data_unref;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->self->priv->threads;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30__target = NULL;
		_data_->_tmp30_ = _data_->run;
		_data_->_tmp30__target = _data_->run_target;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = zeitgeist_log_db_worker_new (_data_->_tmp30_, _data_->_tmp30__target);
		g_thread_pool_push (_data_->_tmp29_, _data_->_tmp31_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->_data9_->_error_;
		if (_data_->_tmp32_ != NULL) {
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = _data_->_data9_->_error_;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _g_error_copy0 (_data_->_tmp33_);
			_data_->_inner_error_ = _data_->_tmp34_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp35_ = NULL;
		_data_->_tmp35__length1 = 0;
		_data_->_tmp35_ = _data_->_data9_->uris;
		_data_->_tmp35__length1 = _data_->_data9_->uris_length1;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36__length1 = 0;
		_data_->_tmp36_ = (_data_->_tmp35_ != NULL) ? _vala_array_dup2 (_data_->_tmp35_, _data_->_tmp35__length1) : ((gpointer) _data_->_tmp35_);
		_data_->_tmp36__length1 = _data_->_tmp35__length1;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37__length1 = 0;
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp37__length1 = _data_->_tmp36__length1;
		_data_->result_length1 = _data_->_tmp37__length1;
		_data_->result = _data_->_tmp37_;
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_find_related_uris_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->self->priv->proxy;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->_data8_->time_range;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = zeitgeist_time_range_to_variant (_data_->_tmp40_);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = _data_->_data8_->events_cp;
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = zeitgeist_events_to_variant (_data_->_tmp43_);
	_data_->_tmp45_ = NULL;
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = NULL;
	_data_->_tmp46_ = _data_->_data8_->results_cp;
	_data_->_tmp47_ = NULL;
	_data_->_tmp47_ = zeitgeist_events_to_variant (_data_->_tmp46_);
	_data_->_tmp48_ = NULL;
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = 0;
	_data_->_tmp49_ = _data_->_data8_->storage_state;
	_data_->_tmp50_ = 0U;
	_data_->_tmp50_ = _data_->_data8_->num_events;
	_data_->_tmp51_ = 0;
	_data_->_tmp51_ = _data_->_data8_->result_type;
	_data_->_tmp52_ = NULL;
	_data_->_tmp52_ = _data_->cancellable;
	_data_->_tmp53_ = 0;
	_data_->_state_ = 3;
	zeitgeist_remote_log_find_related_uris (_data_->_tmp39_, _data_->_tmp42_, _data_->_tmp45_, _data_->_tmp48_, (guint) _data_->_tmp49_, (guint) _data_->_tmp50_, (guint) _data_->_tmp51_, _data_->_tmp52_, NULL, zeitgeist_log_find_related_uris_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp54_ = NULL;
	_data_->_tmp54_ = zeitgeist_remote_log_find_related_uris_finish (_data_->_tmp39_, _data_->_res_, &_data_->_tmp53_, &_data_->_inner_error_);
	_data_->_tmp55_ = NULL;
	_data_->_tmp55__length1 = 0;
	_data_->_tmp55_ = _data_->_tmp54_;
	_data_->_tmp55__length1 = _data_->_tmp53_;
	_g_variant_unref0 (_data_->_tmp48_);
	_g_variant_unref0 (_data_->_tmp45_);
	_g_variant_unref0 (_data_->_tmp42_);
	_data_->_tmp38__length1 = 0;
	_data_->__tmp38__size_ = 0;
	_data_->_tmp38_ = _data_->_tmp55_;
	_data_->_tmp38__length1 = _data_->_tmp55__length1;
	_data_->__tmp38__size_ = _data_->_tmp38__length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp56_ = NULL;
	_data_->_tmp56__length1 = 0;
	_data_->_tmp56_ = _data_->_tmp38_;
	_data_->_tmp56__length1 = _data_->_tmp38__length1;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38__length1 = 0;
	_data_->_tmp57_ = NULL;
	_data_->_tmp57__length1 = 0;
	_data_->_tmp57_ = _data_->_tmp56_;
	_data_->_tmp57__length1 = _data_->_tmp56__length1;
	_data_->result_length1 = _data_->_tmp57__length1;
	_data_->result = _data_->_tmp57_;
	_data_->_tmp38_ = (_vala_array_free (_data_->_tmp38_, _data_->_tmp38__length1, (GDestroyNotify) g_free), NULL);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->_tmp38_ = (_vala_array_free (_data_->_tmp38_, _data_->_tmp38__length1, (GDestroyNotify) g_free), NULL);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_log_delete_events_data_free (gpointer _data) {
	ZeitgeistLogDeleteEventsData* _data_;
	_data_ = _data;
	_g_array_unref0 (_data_->event_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogDeleteEventsData, _data_);
}


void zeitgeist_log_delete_events (ZeitgeistLog* self, GArray* event_ids, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogDeleteEventsData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	GArray* _tmp1_ = NULL;
	GArray* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogDeleteEventsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_delete_events);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_delete_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = event_ids;
	_tmp2_ = _g_array_ref0 (_tmp1_);
	_g_array_unref0 (_data_->event_ids);
	_data_->event_ids = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_log_delete_events_co (_data_);
}


ZeitgeistTimeRange* zeitgeist_log_delete_events_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistTimeRange* result;
	ZeitgeistLogDeleteEventsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
    * Delete a collection of events from the zeitgeist log given their event ids.
    *
    * The deletion will be done asynchronously, and this method returns immediately.
    *
    * @param event_ids Array<uint32>
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static void zeitgeist_log_delete_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogDeleteEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_delete_events_co (_data_);
}


static gboolean zeitgeist_log_delete_events_co (ZeitgeistLogDeleteEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->event_ids;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = _data_->_tmp0_->len;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_new0 (guint32, _data_->_tmp1_);
	_data_->_ids_length1 = 0;
	_data_->__ids_size_ = 0;
	_data_->_ids = _data_->_tmp2_;
	_data_->_ids_length1 = _data_->_tmp1_;
	_data_->__ids_size_ = _data_->_ids_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp3_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp3_) {
					_data_->_tmp4_ = 0;
					_data_->_tmp4_ = _data_->i;
					_data_->i = _data_->_tmp4_ + 1;
				}
				_data_->_tmp3_ = FALSE;
				_data_->_tmp5_ = 0;
				_data_->_tmp5_ = _data_->i;
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = _data_->event_ids;
				_data_->_tmp7_ = 0U;
				_data_->_tmp7_ = _data_->_tmp6_->len;
				if (!(((guint) _data_->_tmp5_) < _data_->_tmp7_)) {
					break;
				}
				_data_->_tmp8_ = NULL;
				_data_->_tmp8__length1 = 0;
				_data_->_tmp8_ = _data_->_ids;
				_data_->_tmp8__length1 = _data_->_ids_length1;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = _data_->i;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->event_ids;
				_data_->_tmp11_ = 0;
				_data_->_tmp11_ = _data_->i;
				_data_->_tmp12_ = 0U;
				_data_->_tmp12_ = g_array_index (_data_->_tmp10_, guint32, (guint) _data_->_tmp11_);
				_data_->_tmp8_[_data_->_tmp9_] = _data_->_tmp12_;
				_data_->_tmp13_ = 0U;
				_data_->_tmp13_ = _data_->_tmp8_[_data_->_tmp9_];
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_delete_events_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->_ids = (g_free (_data_->_ids), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->self->priv->proxy;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15__length1 = 0;
	_data_->_tmp15_ = _data_->_ids;
	_data_->_tmp15__length1 = _data_->_ids_length1;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->cancellable;
	_data_->_state_ = 2;
	zeitgeist_remote_log_delete_events (_data_->_tmp14_, _data_->_tmp15_, _data_->_tmp15__length1, _data_->_tmp16_, NULL, zeitgeist_log_delete_events_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = zeitgeist_remote_log_delete_events_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
	_data_->time_range = _data_->_tmp17_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->_ids = (g_free (_data_->_ids), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->time_range;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = zeitgeist_time_range_new_from_variant (_data_->_tmp19_, &_data_->_inner_error_);
	_data_->_tmp18_ = _data_->_tmp20_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_unref0 (_data_->time_range);
		_data_->_ids = (g_free (_data_->_ids), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->_tmp18_;
	_data_->_tmp18_ = NULL;
	_data_->result = _data_->_tmp21_;
	_g_object_unref0 (_data_->_tmp18_);
	_g_variant_unref0 (_data_->time_range);
	_data_->_ids = (g_free (_data_->_ids), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->_tmp18_);
	_g_variant_unref0 (_data_->time_range);
	_data_->_ids = (g_free (_data_->_ids), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_log_quit_data_free (gpointer _data) {
	ZeitgeistLogQuitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogQuitData, _data_);
}


void zeitgeist_log_quit (ZeitgeistLog* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogQuitData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogQuitData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_quit);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_quit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_log_quit_co (_data_);
}


void zeitgeist_log_quit_finish (ZeitgeistLog* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistLogQuitData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static void zeitgeist_log_quit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistLogQuitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_quit_co (_data_);
}


static gboolean zeitgeist_log_quit_co (ZeitgeistLogQuitData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_quit_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->proxy;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 2;
	zeitgeist_remote_log_quit (_data_->_tmp0_, _data_->_tmp1_, zeitgeist_log_quit_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_log_quit_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
    * Install a monitor in the Zeitgeist engine that calls back when events matching
    * event_templates are logged. The matching is done exactly as in the find_* family
    * of methods and in Event.matches_template. Furthermore matched events must also
    * have timestamps lying in time_range.
    *
    * To remove a monitor call remove_monitor() on the returned Monitor instance.
    *
    * @param monitor A {@link Monitor} to report back inserts and deletes
    */
void zeitgeist_log_install_monitor (ZeitgeistLog* self, ZeitgeistMonitor* monitor, GError** error) {
	GHashTable* _tmp0_ = NULL;
	ZeitgeistMonitor* _tmp1_ = NULL;
	ZeitgeistMonitor* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = monitor;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_hash_table_insert (_tmp0_, _tmp2_, (gpointer) ((guintptr) ((guint) 0)));
	_tmp3_ = zeitgeist_queued_proxy_wrapper_get_is_connected ((ZeitgeistQueuedProxyWrapper*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		ZeitgeistMonitor* _tmp5_ = NULL;
		_tmp5_ = monitor;
		zeitgeist_log_reinstall_monitor (self, _tmp5_, NULL, NULL);
	}
}


static void zeitgeist_log_reinstall_monitor_data_free (gpointer _data) {
	ZeitgeistLogReinstallMonitorData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->monitor);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogReinstallMonitorData, _data_);
}


static void zeitgeist_log_reinstall_monitor (ZeitgeistLog* self, ZeitgeistMonitor* monitor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistLogReinstallMonitorData* _data_;
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistMonitor* _tmp1_ = NULL;
	ZeitgeistMonitor* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistLogReinstallMonitorData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_log_reinstall_monitor);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_log_reinstall_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = monitor;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->monitor);
	_data_->monitor = _tmp2_;
	zeitgeist_log_reinstall_monitor_co (_data_);
}


static void zeitgeist_log_reinstall_monitor_finish (ZeitgeistLog* self, GAsyncResult* _res_) {
	ZeitgeistLogReinstallMonitorData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean zeitgeist_log_reinstall_monitor_co (ZeitgeistLogReinstallMonitorData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = zeitgeist_queued_proxy_wrapper_get_is_connected ((ZeitgeistQueuedProxyWrapper*) _data_->self);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->_tmp0_;
	g_return_val_if_fail (_data_->_tmp1_, FALSE);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->monitors;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->monitor;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_hash_table_lookup (_data_->_tmp2_, _data_->_tmp3_);
	if (((guint) ((guintptr) _data_->_tmp4_)) == ((guint) 0)) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->proxy;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_dbus_proxy_get_connection (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, G_TYPE_DBUS_PROXY, GDBusProxy));
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
		_data_->conn = _data_->_tmp7_;
		{
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->conn;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->monitor;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = zeitgeist_monitor_get_path (_data_->_tmp9_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->monitor;
			_data_->_tmp13_ = 0U;
			_data_->_tmp13_ = zeitgeist_remote_monitor_register_object ((ZeitgeistRemoteMonitor*) _data_->_tmp12_, _data_->_tmp8_, (const gchar*) _data_->_tmp11_, &_data_->_inner_error_);
			_data_->_tmp14_ = 0U;
			_data_->_tmp14_ = _data_->_tmp13_;
			_g_free0 (_data_->_tmp11_);
			_data_->registration_id = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == G_IO_ERROR) {
					goto __catch11_g_io_error;
				}
				_g_object_unref0 (_data_->conn);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->self->priv->monitors;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->monitor;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _g_object_ref0 (_data_->_tmp16_);
			_data_->_tmp18_ = 0U;
			_data_->_tmp18_ = _data_->registration_id;
			g_hash_table_replace (_data_->_tmp15_, _data_->_tmp17_, (gpointer) ((guintptr) _data_->_tmp18_));
		}
		goto __finally11;
		__catch11_g_io_error:
		{
			_data_->err = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->err;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_warning ("log.vala:557: Error installing monitor: %s", _data_->_tmp20_);
			_g_error_free0 (_data_->err);
			_g_object_unref0 (_data_->conn);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally11:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->conn);
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->self->priv->proxy;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->monitor;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = zeitgeist_monitor_get_path (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->monitor;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = zeitgeist_monitor_get_time_range (_data_->_tmp25_);
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = zeitgeist_time_range_to_variant (_data_->_tmp27_);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->monitor;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = zeitgeist_monitor_get_templates (_data_->_tmp30_);
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = zeitgeist_events_to_variant (_data_->_tmp32_);
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->_tmp33_;
	zeitgeist_remote_log_install_monitor (_data_->_tmp21_, _data_->_tmp24_, _data_->_tmp29_, _data_->_tmp34_, NULL, NULL, NULL);
	_g_variant_unref0 (_data_->_tmp34_);
	_g_ptr_array_unref0 (_data_->_tmp32_);
	_g_variant_unref0 (_data_->_tmp29_);
	_g_free0 (_data_->_tmp24_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
    * Remove a monitor from Zeitgeist engine that calls back when events matching event_templates are logged.
    *
    * @param monitor A {@link Monitor} to report back inserts and deletes
    */
void zeitgeist_log_remove_monitor (ZeitgeistLog* self, ZeitgeistMonitor* monitor, GError** error) {
	guint registration_id = 0U;
	GHashTable* _tmp9_ = NULL;
	ZeitgeistMonitor* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	GHashTable* _tmp18_ = NULL;
	ZeitgeistMonitor* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	{
		ZeitgeistRemoteLog* _tmp0_ = NULL;
		ZeitgeistMonitor* _tmp1_ = NULL;
		char* _tmp2_ = NULL;
		char* _tmp3_ = NULL;
		_tmp0_ = self->priv->proxy;
		_tmp1_ = monitor;
		_tmp2_ = zeitgeist_monitor_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		zeitgeist_remote_log_remove_monitor (_tmp0_, _tmp3_, NULL, NULL, NULL);
		_g_free0 (_tmp3_);
	}
	goto __finally12;
	__catch12_g_io_error:
	{
		GError* err = NULL;
		ZeitgeistMonitor* _tmp4_ = NULL;
		char* _tmp5_ = NULL;
		char* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = monitor;
		_tmp5_ = zeitgeist_monitor_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("Failed to remove monitor from Zeitgeist. Retracting" "%s from the bus nonetheless: %s", _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		_g_error_free0 (err);
		_g_object_unref0 (monitor);
		return;
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (monitor);
		return;
	}
	_tmp9_ = self->priv->monitors;
	_tmp10_ = monitor;
	_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
	registration_id = (guint) ((guintptr) _tmp11_);
	_tmp12_ = registration_id;
	if (_tmp12_ != ((guint) 0)) {
		GDBusConnection* connection = NULL;
		ZeitgeistRemoteLog* _tmp13_ = NULL;
		GDBusConnection* _tmp14_ = NULL;
		GDBusConnection* _tmp15_ = NULL;
		GDBusConnection* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		_tmp13_ = self->priv->proxy;
		_tmp14_ = g_dbus_proxy_get_connection (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, G_TYPE_DBUS_PROXY, GDBusProxy));
		_tmp15_ = _g_object_ref0 (_tmp14_);
		connection = _tmp15_;
		_tmp16_ = connection;
		_tmp17_ = registration_id;
		g_dbus_connection_unregister_object (_tmp16_, _tmp17_);
		_g_object_unref0 (connection);
	}
	_tmp18_ = self->priv->monitors;
	_tmp19_ = monitor;
	g_hash_table_remove (_tmp18_, _tmp19_);
	_g_object_unref0 (monitor);
}


/**
    * Gets version of currently running Zeitgeist daemon.
    *
    * This method will return the version of Zeitgeist daemon this instance is
    * connected to. If you call this method right after zeitgeist_log_new(),
    * only zeros will be returned, a valid version number will only be returned
    * once this instance successfully connected to the Zeitgeist daemon - ie.
    * the value of the "is-connected" property must be TRUE (you can connect
    * to the "notify::is-connected" signal otherwise).
    *
    * @param major Location for the major version
    * @param minor Location for the minor version
    * @param micro Location for the micro version
    */
void zeitgeist_log_get_version (ZeitgeistLog* self, gint* major, gint* minor, gint* micro) {
	gint _vala_major = 0;
	gint _vala_minor = 0;
	gint _vala_micro = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GVariant* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_micro = 0;
	_tmp0_ = _vala_micro;
	_vala_minor = _tmp0_;
	_tmp1_ = _vala_minor;
	_vala_major = _tmp1_;
	_tmp2_ = self->priv->engine_version;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_ = NULL;
		_tmp3_ = self->priv->engine_version;
		g_variant_get (_tmp3_, "(iii)", &_vala_major, &_vala_minor, &_vala_micro, NULL);
	}
	if (major) {
		*major = _vala_major;
	}
	if (minor) {
		*minor = _vala_minor;
	}
	if (micro) {
		*micro = _vala_micro;
	}
}


/**
    * Gets extensions of the running Zeitgeist daemon.
    *
    * @return array of extenstions names strings
    */
gchar** zeitgeist_log_get_extensions (ZeitgeistLog* self, int* result_length1) {
	gchar** result = NULL;
	ZeitgeistRemoteLog* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->proxy;
	_tmp1_ = zeitgeist_remote_log_get_extensions (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


/**
    * Gets datapath of the running Zeitgeist daemon.
    *
    * @return string datapath
    */
gchar* zeitgeist_log_datapath (ZeitgeistLog* self) {
	gchar* result = NULL;
	ZeitgeistRemoteLog* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->proxy;
	_tmp1_ = zeitgeist_remote_log_get_datapath (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static ZeitgeistLogDbWorker* zeitgeist_log_db_worker_construct (GType object_type, GThreadFunc func, void* func_target) {
	ZeitgeistLogDbWorker* self = NULL;
	GThreadFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = (ZeitgeistLogDbWorker*) g_type_create_instance (object_type);
	_tmp0_ = func;
	_tmp0__target = func_target;
	self->priv->func = _tmp0_;
	self->priv->func_target = _tmp0__target;
	return self;
}


static ZeitgeistLogDbWorker* zeitgeist_log_db_worker_new (GThreadFunc func, void* func_target) {
	return zeitgeist_log_db_worker_construct (ZEITGEIST_LOG_TYPE_DB_WORKER, func, func_target);
}


static void zeitgeist_log_db_worker_run (ZeitgeistLogDbWorker* self) {
	GThreadFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->func;
	_tmp0__target = self->priv->func_target;
	_tmp0_ (_tmp0__target);
}


static void zeitgeist_log_value_db_worker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void zeitgeist_log_value_db_worker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		zeitgeist_log_db_worker_unref (value->data[0].v_pointer);
	}
}


static void zeitgeist_log_value_db_worker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_log_db_worker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer zeitgeist_log_value_db_worker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* zeitgeist_log_value_db_worker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ZeitgeistLogDbWorker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_log_db_worker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* zeitgeist_log_value_db_worker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ZeitgeistLogDbWorker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_log_db_worker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* zeitgeist_log_param_spec_db_worker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ZeitgeistLogParamSpecDbWorker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_LOG_TYPE_DB_WORKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer zeitgeist_log_value_get_db_worker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_LOG_TYPE_DB_WORKER), NULL);
	return value->data[0].v_pointer;
}


static void zeitgeist_log_value_set_db_worker (GValue* value, gpointer v_object) {
	ZeitgeistLogDbWorker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_LOG_TYPE_DB_WORKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_LOG_TYPE_DB_WORKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_log_db_worker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_log_db_worker_unref (old);
	}
}


static void zeitgeist_log_value_take_db_worker (GValue* value, gpointer v_object) {
	ZeitgeistLogDbWorker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_LOG_TYPE_DB_WORKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_LOG_TYPE_DB_WORKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_log_db_worker_unref (old);
	}
}


static void zeitgeist_log_db_worker_class_init (ZeitgeistLogDbWorkerClass * klass) {
	zeitgeist_log_db_worker_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistLogDbWorkerClass *) klass)->finalize = zeitgeist_log_db_worker_finalize;
	g_type_class_add_private (klass, sizeof (ZeitgeistLogDbWorkerPrivate));
}


static void zeitgeist_log_db_worker_instance_init (ZeitgeistLogDbWorker * self) {
	self->priv = ZEITGEIST_LOG_DB_WORKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void zeitgeist_log_db_worker_finalize (ZeitgeistLogDbWorker* obj) {
	ZeitgeistLogDbWorker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorker);
	g_signal_handlers_destroy (self);
}


static GType zeitgeist_log_db_worker_get_type (void) {
	static volatile gsize zeitgeist_log_db_worker_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_log_db_worker_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { zeitgeist_log_value_db_worker_init, zeitgeist_log_value_db_worker_free_value, zeitgeist_log_value_db_worker_copy_value, zeitgeist_log_value_db_worker_peek_pointer, "p", zeitgeist_log_value_db_worker_collect_value, "p", zeitgeist_log_value_db_worker_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistLogDbWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_log_db_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistLogDbWorker), 0, (GInstanceInitFunc) zeitgeist_log_db_worker_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType zeitgeist_log_db_worker_type_id;
		zeitgeist_log_db_worker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistLogDbWorker", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&zeitgeist_log_db_worker_type_id__volatile, zeitgeist_log_db_worker_type_id);
	}
	return zeitgeist_log_db_worker_type_id__volatile;
}


static gpointer zeitgeist_log_db_worker_ref (gpointer instance) {
	ZeitgeistLogDbWorker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void zeitgeist_log_db_worker_unref (gpointer instance) {
	ZeitgeistLogDbWorker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_LOG_DB_WORKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void zeitgeist_log_class_init (ZeitgeistLogClass * klass) {
	zeitgeist_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistLogPrivate));
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_established = zeitgeist_log_real_on_connection_established;
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_lost = zeitgeist_log_real_on_connection_lost;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_log_finalize;
}


static void zeitgeist_log_instance_init (ZeitgeistLog * self) {
	self->priv = ZEITGEIST_LOG_GET_PRIVATE (self);
}


static void zeitgeist_log_finalize (GObject* obj) {
	ZeitgeistLog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_LOG, ZeitgeistLog);
	_g_object_unref0 (self->priv->proxy);
	_g_variant_unref0 (self->priv->engine_version);
	_g_hash_table_unref0 (self->priv->monitors);
	_g_object_unref0 (self->priv->dbreader);
	_g_thread_pool_free0 (self->priv->threads);
	G_OBJECT_CLASS (zeitgeist_log_parent_class)->finalize (obj);
}


/**
 * Primary access point for talking to the Zeitgeist daemon
 *
 * {@link Log} encapsulates the low level access to the Zeitgeist daemon.
 * You can use it to manage the log by inserting and deleting entries as well
 * as do queries on the logged data.
 *
 * It's important to realize that the #ZeitgeistLog class does not expose
 * any API that does synchronous communications with the message bus -
 * everything is asynchronous. To ease development some of the methods have
 * variants that are "fire and forget" ignoring the normal return value, so
 * that callbacks does not have to be set up.
 */
GType zeitgeist_log_get_type (void) {
	static volatile gsize zeitgeist_log_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_log_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistLog), 0, (GInstanceInitFunc) zeitgeist_log_instance_init, NULL };
		GType zeitgeist_log_type_id;
		zeitgeist_log_type_id = g_type_register_static (ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, "ZeitgeistLog", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_log_type_id__volatile, zeitgeist_log_type_id);
	}
	return zeitgeist_log_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



