/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTextTrack.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTextTrackCueListPrivate.h"
#include "WebKitDOMTextTrackCuePrivate.h"
#include "WebKitDOMTextTrackPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEXT_TRACK_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TEXT_TRACK, WebKitDOMTextTrackPrivate)

typedef struct _WebKitDOMTextTrackPrivate {
#if ENABLE(VIDEO_TRACK)
    RefPtr<WebCore::TextTrack> coreObject;
#endif // ENABLE(VIDEO_TRACK)
} WebKitDOMTextTrackPrivate;

#if ENABLE(VIDEO_TRACK)

namespace WebKit {

WebKitDOMTextTrack* kit(WebCore::TextTrack* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEXT_TRACK(ret);

    return wrapTextTrack(obj);
}

WebCore::TextTrack* core(WebKitDOMTextTrack* request)
{
    return request ? static_cast<WebCore::TextTrack*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTextTrack* wrapTextTrack(WebCore::TextTrack* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEXT_TRACK(g_object_new(WEBKIT_TYPE_DOM_TEXT_TRACK, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO_TRACK)

static void webkit_dom_text_track_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::TextTrack* coreTarget = static_cast<WebCore::TextTrack*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif // ENABLE(VIDEO_TRACK)
}

static gboolean webkit_dom_text_track_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::TextTrack* coreTarget = static_cast<WebCore::TextTrack*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return false;
#endif // ENABLE(VIDEO_TRACK)
}

static gboolean webkit_dom_text_track_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::TextTrack* coreTarget = static_cast<WebCore::TextTrack*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return false;
#endif // ENABLE(VIDEO_TRACK)
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_text_track_dispatch_event;
    iface->add_event_listener = webkit_dom_text_track_add_event_listener;
    iface->remove_event_listener = webkit_dom_text_track_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMTextTrack, webkit_dom_text_track, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_KIND,
    PROP_LABEL,
    PROP_LANGUAGE,
    PROP_MODE,
    PROP_CUES,
    PROP_ACTIVE_CUES,
};

static void webkit_dom_text_track_finalize(GObject* object)
{
    WebKitDOMTextTrackPrivate* priv = WEBKIT_DOM_TEXT_TRACK_GET_PRIVATE(object);
#if ENABLE(VIDEO_TRACK)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(VIDEO_TRACK)
    priv->~WebKitDOMTextTrackPrivate();
    G_OBJECT_CLASS(webkit_dom_text_track_parent_class)->finalize(object);
}

static void webkit_dom_text_track_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrack* self = WEBKIT_DOM_TEXT_TRACK(object);
    WebCore::TextTrack* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO_TRACK)
    switch (propertyId) {
    case PROP_MODE: {
#if ENABLE(VIDEO_TRACK)
        coreSelf->setMode(WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_text_track_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrack* self = WEBKIT_DOM_TEXT_TRACK(object);
    WebCore::TextTrack* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO_TRACK)
    switch (propertyId) {
    case PROP_KIND: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->kind()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_LABEL: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->label()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_LANGUAGE: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->language()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_MODE: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->mode()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_CUES: {
#if ENABLE(VIDEO_TRACK)
        RefPtr<WebCore::TextTrackCueList> ptr = coreSelf->cues();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_ACTIVE_CUES: {
#if ENABLE(VIDEO_TRACK)
        RefPtr<WebCore::TextTrackCueList> ptr = coreSelf->activeCues();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_text_track_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_text_track_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackPrivate* priv = WEBKIT_DOM_TEXT_TRACK_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TextTrack*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(VIDEO_TRACK)
    return object;
}

static void webkit_dom_text_track_class_init(WebKitDOMTextTrackClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTextTrackPrivate));
    gobjectClass->constructor = webkit_dom_text_track_constructor;
    gobjectClass->finalize = webkit_dom_text_track_finalize;
    gobjectClass->set_property = webkit_dom_text_track_set_property;
    gobjectClass->get_property = webkit_dom_text_track_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_KIND,
                                    g_param_spec_string("kind", /* name */
                                                           "text_track_kind", /* short description */
                                                           "read-only  gchar* TextTrack.kind", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABEL,
                                    g_param_spec_string("label", /* name */
                                                           "text_track_label", /* short description */
                                                           "read-only  gchar* TextTrack.label", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LANGUAGE,
                                    g_param_spec_string("language", /* name */
                                                           "text_track_language", /* short description */
                                                           "read-only  gchar* TextTrack.language", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MODE,
                                    g_param_spec_string("mode", /* name */
                                                           "text_track_mode", /* short description */
                                                           "read-write  gchar* TextTrack.mode", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CUES,
                                    g_param_spec_object("cues", /* name */
                                                           "text_track_cues", /* short description */
                                                           "read-only  WebKitDOMTextTrackCueList* TextTrack.cues", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_TEXT_TRACK_CUE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ACTIVE_CUES,
                                    g_param_spec_object("active-cues", /* name */
                                                           "text_track_active-cues", /* short description */
                                                           "read-only  WebKitDOMTextTrackCueList* TextTrack.active-cues", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_TEXT_TRACK_CUE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_text_track_init(WebKitDOMTextTrack* request)
{
    WebKitDOMTextTrackPrivate* priv = WEBKIT_DOM_TEXT_TRACK_GET_PRIVATE(request);
    new (priv) WebKitDOMTextTrackPrivate();
}

void
webkit_dom_text_track_add_cue(WebKitDOMTextTrack* self, WebKitDOMTextTrackCue* cue)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(cue));
    WebCore::TextTrack* item = WebKit::core(self);
    WebCore::TextTrackCue* convertedCue = WebKit::core(cue);
    item->addCue(convertedCue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_remove_cue(WebKitDOMTextTrack* self, WebKitDOMTextTrackCue* cue, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(cue));
    g_return_if_fail(!error || !*error);
    WebCore::TextTrack* item = WebKit::core(self);
    WebCore::TextTrackCue* convertedCue = WebKit::core(cue);
    WebCore::ExceptionCode ec = 0;
    item->removeCue(convertedCue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gboolean
webkit_dom_text_track_dispatch_event(WebKitDOMTextTrack* self, WebKitDOMEvent* evt, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(evt), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::TextTrack* item = WebKit::core(self);
    WebCore::Event* convertedEvt = WebKit::core(evt);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvt, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_get_kind(WebKitDOMTextTrack* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), 0);
    WebCore::TextTrack* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->kind());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_get_label(WebKitDOMTextTrack* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), 0);
    WebCore::TextTrack* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->label());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_get_language(WebKitDOMTextTrack* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), 0);
    WebCore::TextTrack* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->language());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_get_mode(WebKitDOMTextTrack* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), 0);
    WebCore::TextTrack* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->mode());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_set_mode(WebKitDOMTextTrack* self, const gchar* value)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self));
    g_return_if_fail(value);
    WebCore::TextTrack* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setMode(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

WebKitDOMTextTrackCueList*
webkit_dom_text_track_get_cues(WebKitDOMTextTrack* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), 0);
    WebCore::TextTrack* item = WebKit::core(self);
    RefPtr<WebCore::TextTrackCueList> gobjectResult = WTF::getPtr(item->cues());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

WebKitDOMTextTrackCueList*
webkit_dom_text_track_get_active_cues(WebKitDOMTextTrack* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK(self), 0);
    WebCore::TextTrack* item = WebKit::core(self);
    RefPtr<WebCore::TextTrackCueList> gobjectResult = WTF::getPtr(item->activeCues());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

