/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMCSSRule.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMCSSRulePrivate.h"
#include "WebKitDOMCSSStyleSheetPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_CSS_RULE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_CSS_RULE, WebKitDOMCSSRulePrivate)

typedef struct _WebKitDOMCSSRulePrivate {
    RefPtr<WebCore::CSSRule> coreObject;
} WebKitDOMCSSRulePrivate;

namespace WebKit {

WebKitDOMCSSRule* kit(WebCore::CSSRule* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_CSS_RULE(ret);

    return wrapCSSRule(obj);
}

WebCore::CSSRule* core(WebKitDOMCSSRule* request)
{
    return request ? static_cast<WebCore::CSSRule*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMCSSRule* wrapCSSRule(WebCore::CSSRule* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_CSS_RULE(g_object_new(WEBKIT_TYPE_DOM_CSS_RULE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMCSSRule, webkit_dom_css_rule, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TYPE,
    PROP_CSS_TEXT,
    PROP_PARENT_STYLE_SHEET,
    PROP_PARENT_RULE,
};

static void webkit_dom_css_rule_finalize(GObject* object)
{
    WebKitDOMCSSRulePrivate* priv = WEBKIT_DOM_CSS_RULE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMCSSRulePrivate();
    G_OBJECT_CLASS(webkit_dom_css_rule_parent_class)->finalize(object);
}

static void webkit_dom_css_rule_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMCSSRule* self = WEBKIT_DOM_CSS_RULE(object);
    WebCore::CSSRule* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CSS_TEXT: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setCssText(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_css_rule_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMCSSRule* self = WEBKIT_DOM_CSS_RULE(object);
    WebCore::CSSRule* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        g_value_set_uint(value, coreSelf->type());
        break;
    }
    case PROP_CSS_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->cssText()));
        break;
    }
    case PROP_PARENT_STYLE_SHEET: {
        RefPtr<WebCore::CSSStyleSheet> ptr = coreSelf->parentStyleSheet();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PARENT_RULE: {
        RefPtr<WebCore::CSSRule> ptr = coreSelf->parentRule();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_css_rule_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_css_rule_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMCSSRulePrivate* priv = WEBKIT_DOM_CSS_RULE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::CSSRule*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_css_rule_class_init(WebKitDOMCSSRuleClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMCSSRulePrivate));
    gobjectClass->constructor = webkit_dom_css_rule_constructor;
    gobjectClass->finalize = webkit_dom_css_rule_finalize;
    gobjectClass->set_property = webkit_dom_css_rule_set_property;
    gobjectClass->get_property = webkit_dom_css_rule_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_uint("type", /* name */
                                                           "css_rule_type", /* short description */
                                                           "read-only  gushort CSSRule.type", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CSS_TEXT,
                                    g_param_spec_string("css-text", /* name */
                                                           "css_rule_css-text", /* short description */
                                                           "read-write  gchar* CSSRule.css-text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PARENT_STYLE_SHEET,
                                    g_param_spec_object("parent-style-sheet", /* name */
                                                           "css_rule_parent-style-sheet", /* short description */
                                                           "read-only  WebKitDOMCSSStyleSheet* CSSRule.parent-style-sheet", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_CSS_STYLE_SHEET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PARENT_RULE,
                                    g_param_spec_object("parent-rule", /* name */
                                                           "css_rule_parent-rule", /* short description */
                                                           "read-only  WebKitDOMCSSRule* CSSRule.parent-rule", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_CSS_RULE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_css_rule_init(WebKitDOMCSSRule* request)
{
    WebKitDOMCSSRulePrivate* priv = WEBKIT_DOM_CSS_RULE_GET_PRIVATE(request);
    new (priv) WebKitDOMCSSRulePrivate();
}

gchar*
webkit_dom_css_rule_get_css_text(WebKitDOMCSSRule* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CSS_RULE(self), 0);
    WebCore::CSSRule* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->cssText());
    return result;
}

void
webkit_dom_css_rule_set_css_text(WebKitDOMCSSRule* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CSS_RULE(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::CSSRule* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setCssText(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMCSSStyleSheet*
webkit_dom_css_rule_get_parent_style_sheet(WebKitDOMCSSRule* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CSS_RULE(self), 0);
    WebCore::CSSRule* item = WebKit::core(self);
    RefPtr<WebCore::CSSStyleSheet> gobjectResult = WTF::getPtr(item->parentStyleSheet());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMCSSRule*
webkit_dom_css_rule_get_parent_rule(WebKitDOMCSSRule* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CSS_RULE(self), 0);
    WebCore::CSSRule* item = WebKit::core(self);
    RefPtr<WebCore::CSSRule> gobjectResult = WTF::getPtr(item->parentRule());
    return WebKit::kit(gobjectResult.get());
}

