/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimationEvent.h"

#include "JSDictionary.h"
#include "KURL.h"
#include "WebKitAnimationEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitAnimationEventTableValues[] =
{
    { "animationName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEventAnimationName), (intptr_t)0, NoIntrinsic },
    { "elapsedTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEventElapsedTime), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationEventTable = { 9, 7, JSWebKitAnimationEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitAnimationEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationEventConstructorTable = { 1, 0, JSWebKitAnimationEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSWebKitAnimationEventConstructor::constructJSWebKitAnimationEvent(ExecState* exec)
{
    JSWebKitAnimationEventConstructor* jsConstructor = jsCast<JSWebKitAnimationEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    WebKitAnimationEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillWebKitAnimationEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<WebKitAnimationEvent> event = WebKitAnimationEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillWebKitAnimationEventInit(WebKitAnimationEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("animationName", eventInit.animationName))
        return false;
    if (!dictionary.tryGetProperty("elapsedTime", eventInit.elapsedTime))
        return false;
    return true;
}

const ClassInfo JSWebKitAnimationEventConstructor::s_info = { "WebKitAnimationEventConstructor", &Base::s_info, &JSWebKitAnimationEventConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitAnimationEventConstructor) };

JSWebKitAnimationEventConstructor::JSWebKitAnimationEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitAnimationEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitAnimationEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSWebKitAnimationEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEventConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationEventConstructorTable, jsCast<JSWebKitAnimationEventConstructor*>(cell), propertyName, slot);
}

bool JSWebKitAnimationEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationEventConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationEventConstructorTable, jsCast<JSWebKitAnimationEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSWebKitAnimationEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSWebKitAnimationEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSWebKitAnimationEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationEventPrototypeTable = { 1, 0, JSWebKitAnimationEventPrototypeTableValues, 0 };
const ClassInfo JSWebKitAnimationEventPrototype::s_info = { "WebKitAnimationEventPrototype", &Base::s_info, &JSWebKitAnimationEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitAnimationEventPrototype) };

JSObject* JSWebKitAnimationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimationEvent>(exec, globalObject);
}

const ClassInfo JSWebKitAnimationEvent::s_info = { "WebKitAnimationEvent", &Base::s_info, &JSWebKitAnimationEventTable, 0 , CREATE_METHOD_TABLE(JSWebKitAnimationEvent) };

JSWebKitAnimationEvent::JSWebKitAnimationEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimationEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSWebKitAnimationEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitAnimationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitAnimationEventPrototype::create(exec->globalData(), globalObject, JSWebKitAnimationEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSWebKitAnimationEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitAnimationEvent* thisObject = jsCast<JSWebKitAnimationEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, thisObject, propertyName, slot);
}

bool JSWebKitAnimationEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitAnimationEvent* thisObject = jsCast<JSWebKitAnimationEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, thisObject, propertyName, descriptor);
}

JSValue jsWebKitAnimationEventAnimationName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimationEvent* castedThis = jsCast<JSWebKitAnimationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimationEvent* impl = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->animationName());
    return result;
}


JSValue jsWebKitAnimationEventElapsedTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimationEvent* castedThis = jsCast<JSWebKitAnimationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimationEvent* impl = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->elapsedTime());
    return result;
}


JSValue jsWebKitAnimationEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimationEvent* domObject = jsCast<JSWebKitAnimationEvent*>(asObject(slotBase));
    return JSWebKitAnimationEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebKitAnimationEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
